/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 09.02.18.
//


#include "testlayers.h"
#include <ops/declarable/CustomOperations.h>
#include <helpers/helper_hash.h>
#include <NDArray.h>
#include <array/NDArrayList.h>
#include <ops/declarable/generic/helpers/convolutions.h>


using namespace nd4j;
using namespace nd4j::graph;


class DeclarableOpsTests7 : public testing::Test {
public:

    DeclarableOpsTests7() {
        printf("\n");
        fflush(stdout);
    }
};


TEST_F(DeclarableOpsTests7, Test_CHOOSE_SCALAR_LARGE) {
    double inputData[150] = {
            0.00,  0.51,  0.68,  0.69,  0.86,  0.91,  0.96,  0.97,  0.97,  1.03,  1.13,  1.16,  1.16,  1.17,  1.19,  1.25,  1.25,  1.26,  1.27,  1.28,  1.29,  1.29,  1.29,  1.30,  1.31,  1.32,  1.33,  1.33,  1.35,  1.35,  1.36,  1.37,  1.38,  1.40,  1.41,  1.42,  1.43,  1.44,  1.44,  1.45,  1.45,  1.47,  1.47,  1.51,  1.51,  1.51,  1.52,  1.53,  1.56,  1.57,  1.58,  1.59,  1.61,  1.62,  1.63,  1.63,  1.64,  1.64,  1.66,  1.66,  1.67,  1.67,  1.70,  1.70,  1.70,  1.72,  1.72,  1.72,  1.72,  1.73,  1.74,  1.74,  1.76,  1.76,  1.77,  1.77,  1.80,  1.80,  1.81,  1.82,  1.83,  1.83,  1.84,  1.84,  1.84,  1.85,  1.85,  1.85,  1.86,  1.86,  1.87,  1.88,  1.89,  1.89,  1.89,  1.89,  1.89,  1.91,  1.91,  1.91,  1.92,  1.94,  1.95,  1.97,  1.98,  1.98,  1.98,  1.98,  1.98,  1.99,  2.00,  2.00,  2.01,  2.01,  2.02,  2.03,  2.03,  2.03,  2.04,  2.04,  2.05,  2.06,  2.07,  2.08,  2.08,  2.08,  2.08,  2.09,  2.09,  2.10,  2.10,  2.11,  2.11,  2.11,  2.12,  2.12,  2.13,  2.13,  2.14,  2.14,  2.14,  2.14,  2.15,  2.15,  2.16,  2.16,  2.16,  2.16,  2.16,  2.17
    };

    NDArray<double> x(inputData,'c',{1,149});
    nd4j::ops::choose<double> op;
    //greater than test
    auto result = op.execute({&x}, {0.0},{3});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(1);
    auto array = *z;
    ASSERT_EQ(148,array(0));
    //ASSERT_TRUE(exp.isSameShape(z));

    delete result;

}

TEST_F(DeclarableOpsTests7, Test_CHOOSE_SCALAR_ZERO) {
    std::vector<double> data;
    for(Nd4jLong i = 0; i < 4; i++) {
        data.push_back(i);
    }



    NDArray<double> x('c',{1,4},data);
    nd4j::ops::choose<double> op;
    //greater than test
    auto result = op.execute({&x}, {0.0},{3});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(1);
    auto array = *z;
    ASSERT_EQ(3,array(0));
    //ASSERT_TRUE(exp.isSameShape(z));

    delete result;

}


TEST_F(DeclarableOpsTests7, Test_CHOOSE_SCALAR) {
    std::vector<double> data;
    for(Nd4jLong i = 0; i < 4; i++) {
        data.push_back(i);
    }



    NDArray<double> x('c',{1,4},data);
    NDArray<double> scalar('c',{1,1},{0.0});
    nd4j::ops::choose<double> op;
    //greater than test
    auto result = op.execute({&x,&scalar}, {1.0},{3});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(0);
    ASSERT_EQ(4,z->lengthOf());
    //ASSERT_TRUE(exp.isSameShape(z));

    delete result;

}


TEST_F(DeclarableOpsTests7, Test_CHOOSE_SCALAR_LEFT) {
    std::vector<double> data;
    for(Nd4jLong i = 0; i < 4; i++) {
        data.push_back(i);
    }



    NDArray<double> x('c',{1,4},data);
    NDArray<double> scalar('c',{1,1},{0.0});
    nd4j::ops::choose<double> op;
    //greater than test
    auto result = op.execute({&scalar,&x}, {1.0},{3});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(0);
    ASSERT_EQ(4,z->lengthOf());
    //ASSERT_TRUE(exp.isSameShape(z));

    delete result;

}


TEST_F(DeclarableOpsTests7, Test_CHOOSE_ONLY_SCALAR) {
    std::vector<double> data;
    for(Nd4jLong i = 0; i < 4; i++) {
        data.push_back(i);
    }



    NDArray<double> x('c',{1,4},data);
    nd4j::ops::choose<double> op;
    //greater than test
    auto result = op.execute({&x}, {1.0},{3});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(0);
    ASSERT_EQ(4,z->lengthOf());
    //ASSERT_TRUE(exp.isSameShape(z));

    delete result;

}


TEST_F(DeclarableOpsTests7, Test_CHOOSE_ONLY_SCALAR_GTE) {
    std::vector<double> data;
    for(Nd4jLong i = 0; i < 4; i++) {
        data.push_back(i);
    }



    NDArray<double> x('c',{1,4},data);
    nd4j::ops::choose<double> op;
    //greater than test
    auto result = op.execute({&x}, {1.0},{5});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(0);
    ASSERT_EQ(4,z->lengthOf());
    //ASSERT_TRUE(exp.isSameShape(z));

    delete result;

}


TEST_F(DeclarableOpsTests7, TEST_WHERE) {
    std::vector<double> data;
    std::vector<double> mask;
    std::vector<double> put;
    std::vector<double> resultData;
    std::vector<double> assertion;
    for(Nd4jLong i = 0; i < 4; i++) {
        data.push_back(i);
        if(i >  1) {
            assertion.push_back(5.0);
            mask.push_back(1);
        }
        else {
            assertion.push_back(i);
            mask.push_back(0);
        }

        put.push_back(5.0);
        resultData.push_back(0.0);
    }




    NDArray<double> x('c',{1,4},data);
    NDArray<double> maskArr('c',{1,4},mask);
    NDArray<double> putArr('c',{1,4},put);
    NDArray<double> resultArr('c',{1,4},resultData);
    nd4j::ops::where_np<double> op;
    //greater than test
    //            Nd4jStatus execute(std::initializer_list<NDArray<T>*> inputs, std::initializer_list<NDArray<T>*> outputs , std::initializer_list<T> tArgs, std::initializer_list<int> iArgs, bool isInplace = false);

    auto result = op.execute({&maskArr,&x,&putArr},{&resultArr}, {},{3},false);
    // ASSERT_EQ(Status::OK(), result->status());
    for(int i = 0; i < 4; i++)
        ASSERT_EQ(assertion[i],resultArr(i));
    // auto z = result->at(0);
    //ASSERT_EQ(4,z->lengthOf());
    //ASSERT_TRUE(exp.isSameShape(z));


}

TEST_F(DeclarableOpsTests7,TEST_WHERE_MASK) {
    double x[300] = {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
    double z[300] = {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
    double mask[300] = {0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  0.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00,  1.00};
    double put[200] = {0.99666107,0.9867112,0.97686064,0.9671082,0.95745337,0.9478948,0.9384318,0.92906314,0.9197881,0.91060543,0.9015147,0.8925147,0.8836044,0.8747831,0.86605,0.85740393,0.8488442,0.84037,0.83198035,0.8236745,0.8154515,0.8073106,0.79925096,0.79127187,0.7833724,0.77555174,0.76780915,0.7601439,0.75255525,0.7450422,0.7376043,0.73024046,0.72295034,0.715733,0.7085876,0.7015135,0.69451016,0.68757665,0.6807124,0.6739167,0.66718876,0.66052806,0.6539338,0.6474054,0.6409421,0.6345435,0.6282087,0.6219371,0.6157281,0.60958105,0.6034956,0.59747064,0.5915059,0.5856007,0.57975453,0.5739667,0.5682366,0.5625637,0.5569475,0.5513874,0.54588276,0.540433,0.53503764,0.5296962,0.52440816,0.51917285,0.5139898,0.5088585,0.50377846,0.4987491,0.4937699,0.48884052,0.48396033,0.47912875,0.47434545,0.4696099,0.46492168,0.46028027,0.45568514,0.4511359,0.44663212,0.4421733,0.43775895,0.43338865,0.42906195,0.42477852,0.4205379,0.41633952,0.41218308,0.40806815,0.40399432,0.3999611,0.3959682,0.39201516,0.38810158,0.384227,0.38039115,0.37659356,0.37283397,0.3691119,0.36542687,0.36177874,0.35816705,0.3545914,0.35105142,0.34754673,0.34407702,0.34064204,0.33724132,0.3338745,0.33054137,0.3272415,0.32397458,0.32074028,0.3175382,0.31436813,0.31122974,0.3081226,0.30504647,0.30200112,0.2989862,0.29600134,0.29304633,0.2901207,0.28722438,0.28435695,0.2815181,0.27870762,0.27592525,0.27317056,0.27044344,0.26774356,0.26507056,0.2624243,0.25980446,0.25721073,0.25464293,0.25210077,0.249584,0.24709237,0.24462552,0.24218333,0.23976555,0.23737194,0.23500215,0.23265606,0.23033342,0.22803394,0.22575743,0.2235036,0.22127232,0.21906327,0.21687631,0.21471114,0.21256764,0.21044552,0.20834461,0.20626466,0.20420544,0.20216681,0.20014854,0.19815037,0.19617215,0.19421372,0.19227484,0.19035533,0.18845497,0.18657354,0.18471093,0.18286693,0.18104129,0.17923392,0.17744459,0.17567308,0.1739193,0.17218304,0.17046405,0.16876228,0.16707748,0.16540948,0.16375816,0.16212334,0.16050482,0.15890247,0.15731607,0.15574552,0.15419069,0.15265137,0.15112738,0.14961864,0.14812498,0.14664622,0.1451822,0.14373279,0.14229788,0.14087726,0.13947085,0.13807845,0.13669999,0.13533528};
    double assertion[300] = {1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,1.000000000000000000e+00,9.966611049434810354e-01,9.867111603284486332e-01,9.768605487739230320e-01,9.671082786103732953e-01,9.574533680683808834e-01,9.478948451798039354e-01,9.384317476799283186e-01,9.290631229105962285e-01,9.197880277243004610e-01,9.106055283892373620e-01,9.015147004953073528e-01,8.925146288610534828e-01,8.836044074415293492e-01,8.747831392370875037e-01,8.660499362030764647e-01,8.574039191604412302e-01,8.488442177072155204e-01,8.403699701308978698e-01,8.319803233217017979e-01,8.236744326866727306e-01,8.154514620646623468e-01,8.073105836421510251e-01,7.992509778699116163e-01,7.912718333805045523e-01,7.833723469065965173e-01,7.755517232000953554e-01,7.678091749520912224e-01,7.601439227135980969e-01,7.525551948170853267e-01,7.450422272987937689e-01,7.376042638218265335e-01,7.302405556000080011e-01,7.229503613225031211e-01,7.157329470791886639e-01,7.085875862867698771e-01,7.015135596156351072e-01,6.945101549174396149e-01,6.875766671534137009e-01,6.807123983233853703e-01,6.739166573955123196e-01,6.671887602367149173e-01,6.605280295438040739e-01,6.539337947752965619e-01,6.474053920839111242e-01,6.409421642497381555e-01,6.345434606140767375e-01,6.282086370139332576e-01,6.219370557171712832e-01,6.157280853583116942e-01,6.095811008749726367e-01,6.034954834449430816e-01,5.974706204238864338e-01,5.915059052836644238e-01,5.856007375512777280e-01,5.797545227484157682e-01,5.739666723316099173e-01,5.682366036329845604e-01,5.625637398015992385e-01,5.569475097453767676e-01,5.513873480736106725e-01,5.458826950400470501e-01,5.404329964865340896e-01,5.350377037872348085e-01,5.296962737933965659e-01,5.244081687786711354e-01,5.191728563849821176e-01,5.139898095689314772e-01,5.088585065487419845e-01,5.037784307517284565e-01,4.987490707622945774e-01,4.937699202704479151e-01,4.888404780208293054e-01,4.839602477622509946e-01,4.791287381977387683e-01,4.743454629350723484e-01,4.696099404378203390e-01,4.649216939768630041e-01,4.602802515824001017e-01,4.556851459964368911e-01,4.511359146257447605e-01,4.466320994952920342e-01,4.421732472021388527e-01,4.377589088697927955e-01,4.333886401030203062e-01,4.290620009431086457e-01,4.247785558235752101e-01,4.205378735263185508e-01,4.163395271382073215e-01,4.121830940081024908e-01,4.080681557043087104e-01,4.039942979724505667e-01,3.999611106937689398e-01,3.959681878438343627e-01,3.920151274516718853e-01,3.881015315592946102e-01,3.842270061816405180e-01,3.803911612669100828e-01,3.765936106572991271e-01,3.728339720501240850e-01,3.691118669593352886e-01,3.654269206774144463e-01,3.617787622376523182e-01,3.581670243768036999e-01,3.545913434981138868e-01,3.510513596347161203e-01,3.475467164133922426e-01,3.440770610186974499e-01,3.406420441574410929e-01,3.372413200235238606e-01,3.338745462631242389e-01,3.305413839402346898e-01,3.272414975025391692e-01,3.239745547476344245e-01,3.207402267895853032e-01,3.175381880258169032e-01,3.143681161043347383e-01,3.112296918912743071e-01,3.081225994387726264e-01,3.050465259531625062e-01,3.020011617634821843e-01,2.989862002903017069e-01,2.960013380148582840e-01,2.930462744485015647e-01,2.901207121024425017e-01,2.872243564578055852e-01,2.843569159359789489e-01,2.815181018692606840e-01,2.787076284717992514e-01,2.759252128108221624e-01,2.731705747781537075e-01,2.704434370620155681e-01,2.677435251191103149e-01,2.650705671469821278e-01,2.624242940566549609e-01,2.598044394455423789e-01,2.572107395706292876e-01,2.546429333219200064e-01,2.521007621961529055e-01,2.495839702707757235e-01,2.470923041781825646e-01,2.446255130802063582e-01,2.421833486428674187e-01,2.397655650113727777e-01,2.373719187853666479e-01,2.350021689944260528e-01,2.326560770738031469e-01,2.303334068404078172e-01,2.280339244690317291e-01,2.257573984688081292e-01,2.235035996599082919e-01,2.212723011504689752e-01,2.190632783137518302e-01,2.168763087655291855e-01,2.147111723416972873e-01,2.125676510761114746e-01,2.104455291786438698e-01,2.083445930134591173e-01,2.062646310775079761e-01,2.042054339792348794e-01,2.021667944174980747e-01,2.001485071607009836e-01,1.981503690261307848e-01,1.961721788595043592e-01,1.942137375147174327e-01,1.922748478337968081e-01,1.903553146270518526e-01,1.884549446534251604e-01,1.865735466010380594e-01,1.847109310679319050e-01,1.828669105430000552e-01,1.810412993871116094e-01,1.792339138144224131e-01,1.774445718738737465e-01,1.756730934308744496e-01,1.739193001491673995e-01,1.721830154728755669e-01,1.704640646087285105e-01,1.687622745084652875e-01,1.670774738514141378e-01,1.654094930272448083e-01,1.637581641188943782e-01,1.621233208856623365e-01,1.605047987464754966e-01,1.589024347633189727e-01,1.573160676248336609e-01,1.557455376300762306e-01,1.541906866724424563e-01,1.526513582237501165e-01,1.511273973184814046e-01,1.496186505381822129e-01,1.481249659960175158e-01,1.466461933214808777e-01,1.451821836452561187e-01,1.437327895842310799e-01,1.422978652266598532e-01,1.408772661174743090e-01,1.394708492437411185e-01,1.380784730202649913e-01,1.366999972753347725e-01,1.353352832366127023e-01};
    Nd4jLong threeHundredShapePointer[8] = {2,1,300,1,1,0,1,99};
    Nd4jLong twoHundredShapePointer[8] = {2,1,200,1,1,0,1,99};
    nd4j::ops::where_np<double> op;

    NDArray<double> xArr(x,threeHundredShapePointer);
    NDArray<double> maskArr(mask,threeHundredShapePointer);
    NDArray<double> putArr(put,twoHundredShapePointer);
    NDArray<double> resultArr(z,threeHundredShapePointer);
    resultArr.assign(0.0);
    NDArray<double> assertArr(assertion,threeHundredShapePointer);
    Nd4jStatus result = op.execute({&maskArr,&xArr,&putArr},{&resultArr},{},{},false);
    ASSERT_EQ(Status::OK(),result);
    ASSERT_TRUE (assertArr.equalsTo(&resultArr));



}

TEST_F(DeclarableOpsTests7, TEST_WHERE_SCALAR) {
    std::vector<double> data;
    std::vector<double> mask;
    std::vector<double> put;
    std::vector<double> resultData;
    std::vector<double> assertion;
    for(Nd4jLong i = 0; i < 4; i++) {
        data.push_back(i);
        if(i >  1) {
            assertion.push_back(5.0);
            mask.push_back(1);
        }
        else {
            assertion.push_back(i);
            mask.push_back(0);
        }

        resultData.push_back(0.0);
    }


    put.push_back(5.0);


    NDArray<double> x('c',{1,4},data);
    NDArray<double> maskArr('c',{1,4},mask);
    NDArray<double> putArr('c',{1,1},put);
    NDArray<double> resultArr('c',{1,4},resultData);
    nd4j::ops::where_np<double> op;
    //greater than test
    //            Nd4jStatus execute(std::initializer_list<NDArray<T>*> inputs, std::initializer_list<NDArray<T>*> outputs , std::initializer_list<T> tArgs, std::initializer_list<int> iArgs, bool isInplace = false);

    auto result = op.execute({&maskArr,&x,&putArr},{&resultArr}, {},{3},false);
    // ASSERT_EQ(Status::OK(), result->status());
    for(int i = 0; i < 4; i++)
        ASSERT_EQ(assertion[i],resultArr(i));
    // auto z = result->at(0);
    //ASSERT_EQ(4,z->lengthOf());
    //ASSERT_TRUE(exp.isSameShape(z));


}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestMatrixDiagPart_1) {
    NDArray<double> x('c', {2, 4, 4}, {1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 4.,5., 0., 0., 0., 0., 6., 0., 0., 0., 0., 7., 0., 0., 0., 0., 8.});

    NDArray<double> z('c', {2, 4}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0});

    nd4j::ops::matrix_diag_part<double> op;

    auto result = op.execute({&x}, {}, {});

    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(z.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestMatrixDiagPart_2) {
    NDArray<double> x('c', {2, 3, 4}, {1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0.,5., 0., 0., 0., 0., 6., 0., 0., 0., 0., 7., 0.});

    NDArray<double> z('c', {2, 3}, {1.0, 2.0, 3.0, 5.0, 6.0, 7.0});

    nd4j::ops::matrix_diag_part<double> op;

    auto result = op.execute({&x}, {}, {});

    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(z.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestMatrixDiag_1) {
    NDArray<double> z('c', {2, 4, 4}, {1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 4.,5., 0., 0., 0., 0., 6., 0., 0., 0., 0., 7., 0., 0., 0., 0., 8.});

    NDArray<double> x('c', {2, 4}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0});

    nd4j::ops::matrix_diag<double> op;

    auto result = op.execute({&x}, {}, {});

    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(z.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestMatrixDiag_2) {
    NDArray<double> z('c', {2, 3, 3}, {1., 0., 0., 0., 2., 0., 0., 0., 3.,5., 0., 0., 0., 6., 0.,0., 0., 7.});
    NDArray<double> x('c', {2, 3}, {1.0, 2.0, 3.0, 5.0, 6.0, 7.0});

    nd4j::ops::matrix_diag<double> op;

    auto result = op.execute({&x}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(z.equalsTo(result->at(0)));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRandomCrop_1) {
    NDArray<double> x('c', {2, 2, 4}, {1.8, 2.5,  4.,  9., 2.1, 2.4,  3.,  9.,2.1, 2.1, 0.7, 0.1,3., 4.2, 2.2, 1. });
    NDArray<double> shape({1.0, 2.0, 3.0});
    nd4j::ops::random_crop<double> op;

    auto result = op.execute({&x, &shape}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    //result->at(0)->printIndexedBuffer("Output");
//    ASSERT_TRUE(z.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRandomCrop_2) {
    NDArray<double> x('c', {2, 2, 4}, {1.8, 2.5,  4.,  9., 2.1, 2.4,  3.,  9.,2.1, 2.1, 0.7, 0.1,3., 4.2, 2.2, 1. });
    NDArray<double> shape({2.0, 2.0, 2.0});
    nd4j::ops::random_crop<double> op;

    auto result = op.execute({&x, &shape}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    //result->at(0)->printIndexedBuffer("Output");
//    ASSERT_TRUE(z.equalsTo(result->at(0)));

    delete result;
}

TEST_F(DeclarableOpsTests7, Test_DeConv2D_TF_1) {
    NDArray<float> input0('c', {4}, {12.f, 5.f, 5.f, 32.f});
    NDArray<float> input1('c', {2, 2, 32, 16});
    NDArray<float> input2('c', {12, 4, 4, 16});
    NDArray<float> exp('c', {12, 5, 5, 32});

    nd4j::ops::deconv2d_tf<float> op;
    auto result = op.execute({&input0, &input1, &input2}, {}, {2, 2, 1, 1, 0, 0, 1, 1, 0, 1});
    ASSERT_EQ(Status::OK(), result->status());

    ASSERT_EQ(exp, *result->at(0));

    delete result;
}

TEST_F(DeclarableOpsTests7, Test_DeConv2D_TF_2) {
    NDArray<double> input0('c', {4}, {3, 8, 8, 16});
    NDArray<double> input1('c', {7, 7, 16, 5}, {1.05293429,-0.89349967,0.31027254,1.22991478,-0.62926656,0.56918693,-1.60992694,1.10167944,-0.80843484,0.07521993,-1.15994942,0.76016301,-0.40056285,-1.16872537,-0.91384381,-0.36700436,1.82389200,-1.18200207,0.51612782,-0.92479187,-0.09307563,-0.55122334,1.23532486,-1.11124146,-0.05812126,0.68159896,0.69125599,-0.77127314,-0.10874277,0.86469102,-1.31614351,0.33354419,-1.71750402,0.17197680,-1.03965557,1.10570908,-1.19115615,1.05115080,0.18277600,1.08820546,-0.72191417,-0.10999311,1.56521320,-0.35433730,-1.11799145,0.34499285,0.64998639,-1.64371550,0.92592359,-0.47659501,0.49101439,-0.15613313,1.47486567,0.43576995,2.19538260,-0.83567709,-1.21846950,0.80400819,1.14637423,-1.01503456,-0.61992753,-0.47378838,0.86503726,0.27147385,0.37073180,-0.19951358,0.79167330,-0.33982825,0.18631981,-1.54715073,0.39967480,0.95067030,1.12508667,-0.86676019,-1.10341156,2.33141375,1.10972047,0.71407092,1.70640314,1.80666339,0.59465605,-0.39653218,-2.61163163,-1.15013492,-1.19908321,0.41783467,-0.22730024,0.31425011,-0.58562893,-0.10131568,-0.85047537,-2.59974790,1.22072542,-2.08812046,-0.19363593,-1.27664304,-0.02703438,1.08477545,-0.65506506,0.46040919,-0.13715318,-0.74945593,-0.69006950,-1.29617655,-0.15865716,1.38956285,0.90216327,-1.31185400,-0.15067385,-0.63093358,-0.05895613,0.26545224,0.29332840,0.42852548,0.72409540,0.12879130,1.43038857,0.68647617,2.19654775,0.51878077,-0.03769343,0.52877223,-0.21733910,1.13710785,-0.59003806,1.54624867,-0.64997369,-1.03239334,0.19708300,0.68658423,0.71048903,-1.55250466,-1.38636279,0.32385820,0.81226677,0.19209047,-0.23002781,-0.63631231,1.02101684,0.65428704,-0.17206922,1.09488952,1.03022420,-0.95567745,-0.07595373,-1.48606372,2.57174873,-1.75366247,1.12913883,0.97053039,-0.28552356,0.56511772,-0.79568213,0.07561764,-1.02085686,1.05770981,-1.25715709,0.42046708,-2.57390857,0.96947151,1.05215812,0.65624017,-1.29019403,0.64157075,-0.40509227,-0.65354455,0.42348680,-1.34107757,0.05931387,-0.54337227,0.95460182,1.59319806,-0.44433126,-0.33717924,0.79566282,0.50112695,-0.22244534,1.76904583,-0.89817202,1.82985342,0.17671813,0.80720717,1.32469308,0.39417782,-0.23720963,0.96796370,-1.02348757,-0.86615551,-1.58120525,-0.37634999,0.00905940,0.01880967,1.75771821,-0.64372772,0.36687651,0.15854552,-0.67599791,0.53726906,-1.20158446,-1.78549063,0.96476388,-0.66158366,-0.41681561,-0.97541636,2.35928202,0.32130197,1.06886065,1.38736427,-0.73718959,0.11215294,2.12865782,-0.37927702,0.55621815,-1.10108411,-0.02032263,0.29595461,1.58737493,1.24001300,-0.66748160,0.80729002,-0.10575818,-1.03175950,1.80755460,0.10825710,2.20666361,1.33633149,1.39290452,0.45211342,-0.07837920,2.08304930,-0.28387162,-0.70775616,0.43626297,0.53556961,0.06201901,-0.59255266,-0.11854446,2.10024118,0.37638292,-0.56178707,-0.25220188,-1.23731256,-1.30002999,0.34283713,0.30502397,-1.09233856,1.12430644,0.52273953,-0.68507338,-0.69913578,0.88440478,-0.76959240,1.07093310,-0.34802195,0.35683727,-0.76079178,-1.92807376,0.84499562,1.39131641,0.44825050,0.34567752,0.44607711,-1.00986362,-0.50038189,-0.09060892,-2.55645394,0.56416476,-0.83058155,-0.65931624,-0.73649710,0.59814465,-0.86736494,-0.32200798,-1.28087902,-0.76818323,0.86848933,-0.98678392,-1.30813944,-0.20255326,0.26557815,-0.31090519,-1.46331608,-0.62782109,0.59034890,1.63147473,-0.17727259,-0.37636510,1.27368402,0.19096918,-0.29936951,-1.99038267,0.54831523,0.48849005,-2.55680346,-0.63126534,1.21715927,1.22841084,-0.67416084,0.02927168,-0.36693662,0.63204330,0.13721083,0.28742912,0.19470036,0.74873924,-1.47602463,0.86264688,-0.23730527,-0.99978864,-1.17048764,-0.34996086,1.43019187,0.26224539,0.60689932,-0.75002515,-0.79823422,-1.37300086,-0.19951135,-0.12150808,-0.75272322,0.23755015,0.31270382,1.66539109,-1.04104745,0.79540199,-0.54042423,-0.54150617,0.43871084,0.24163951,-0.24517761,-0.66178995,-1.13064528,-0.84426326,0.56437236,0.09088907,-0.82823074,0.81753862,-1.74096012,-1.80599844,-0.60943592,1.36094582,-1.47762752,0.15931177,1.05569172,0.36751524,0.06497604,0.13536447,-1.57156146,0.22783801,-0.96910107,-1.24294984,-1.47147155,-1.04790676,0.64629447,-0.32266054,-0.55675793,-0.95612079,-0.23005411,-0.75229394,0.03050950,-1.72484553,-2.06055546,0.19892083,-0.13597751,0.65180075,0.27096850,0.08977254,0.57564765,-0.43227410,0.09541437,-0.00358280,0.65680492,0.04006556,0.57160908,0.43821687,1.96118212,0.42602235,-0.36731303,0.67200917,-0.56667900,0.44014785,0.06970236,-1.34415269,-1.13301528,-0.08848868,0.35615012,-0.06426942,-0.81406075,0.94097465,-0.54560357,-0.65877116,-1.29646838,-1.13109028,-1.64186084,-2.12723470,1.86027610,1.22621441,0.26098135,-0.05608099,0.21143445,-0.87244326,0.79408187,1.24279130,0.14458629,0.25532281,-1.24023473,2.42278886,0.00405578,-1.00119174,1.19856644,-1.37395728,-0.16656208,0.46858498,-0.00678801,-0.34960639,0.16614936,2.41560221,-0.53880709,0.91618651,-1.77009308,0.32911557,0.30216452,0.02881077,0.77705866,0.27061903,-0.07440855,-1.14010465,1.25383139,-1.58615100,1.04185510,0.15140508,-0.88059032,-0.33872122,-0.42526904,2.17365575,0.29308075,-2.24234557,-1.03164542,-0.09263755,0.08050421,-0.74946511,-0.64589006,-1.13416314,-0.64989561,0.16502371,-0.33831969,0.22832428,-0.08389475,-0.28009200,1.34536922,-0.19075738,0.36238208,0.83690089,0.26144615,0.04457319,-2.55585861,-0.01807522,1.68334866,-0.05795629,-0.21315987,-1.84039557,0.06512877,-1.77318645,-0.27637982,0.20439345,0.67558700,-0.77179354,-0.17902173,0.70381826,-0.40395790,-0.96492916,0.84138173,2.43879008,-0.32297835,-1.74370265,-0.10330839,-1.07465363,1.85030377,-0.59153467,0.99667048,-0.56753993,0.57383025,-1.90630126,1.24299097,0.22797665,0.30468231,-0.07360230,1.64654350,0.57195550,0.03227921,1.11005175,0.00088721,1.19266295,0.61323351,0.13754399,0.59900171,-0.75831634,1.11500823,0.99747783,-1.36923385,1.26563418,0.01253266,0.35483193,1.95143735,-2.02703261,-1.38265920,-0.02404256,2.02788448,-0.75144875,-0.58445263,0.26129767,0.60691077,-1.84661067,0.65872228,-0.58298993,0.33067298,-0.09431327,0.43333948,-1.52616286,-0.25961858,-1.65459549,-0.72950101,-0.89906919,-0.80081612,-1.32189929,-1.36574399,-0.35809481,0.36385000,0.31480747,-0.35797358,-1.04066050,0.07971872,-0.21176252,-0.76559299,-0.10352154,0.29248312,-1.75030553,0.68219930,0.56189102,-1.11212170,0.06501702,-0.07131009,1.23410738,0.29311740,-1.02052307,1.40220940,-1.00995779,0.57955760,0.22640309,0.74853230,-0.02586563,-0.33427954,1.70311153,-0.53405988,0.90975094,-0.46450076,0.19904344,0.28559047,0.23167793,-0.69065529,-0.17176504,-0.29301846,-0.85477978,-0.00267053,-0.28529504,-0.64201307,1.03479636,1.03805065,0.83270210,-0.09405448,2.50615931,0.62019676,0.31354564,-1.51599669,0.42848015,0.66263914,0.74651009,-1.13042867,-0.58933645,-0.35146511,0.06223279,0.28065836,0.66506970,0.16942430,-0.23316263,-0.87481076,1.21992230,1.48536301,-0.79667616,-0.75519305,1.40999961,-0.42802793,-0.20252463,0.30573779,-0.23319976,1.77525878,-1.80704832,2.71519923,-0.67500192,0.12268137,-0.13014549,-0.07479453,-1.51065743,1.04198146,0.96205556,-2.00525570,-0.37911776,0.89329720,-0.39495832,-0.03683375,-0.90928614,-1.56263304,0.45038295,-2.62184358,-0.45686841,-0.52536523,1.05351484,0.89982438,-0.63724512,3.21004057,-0.08608918,1.55209303,0.62688643,-0.59702635,1.85774517,0.38172096,-1.25640929,-2.59278178,0.85050315,-1.10080361,-1.26422560,-1.80045366,-0.34494889,0.68448657,1.25671864,-1.26594126,0.32244179,-0.51956522,-0.56212711,-0.95574015,0.71973872,0.46736258,-0.11772985,-1.52736545,0.19571695,0.73147154,0.87724912,-0.26265728,-2.60267401,0.19263546,0.18320183,0.11485019,-0.82999659,0.13582672,-0.08040185,0.28152901,-0.51421624,-2.32467175,0.19923948,0.64616692,0.29718629,0.32785949,-0.62266952,-0.98174316,1.23276305,0.58563638,1.28528512,-2.13718534,0.28842899,0.12676710,-1.72105229,0.15053287,2.19496536,1.28683448,-0.96318281,0.17043279,-0.05245409,-0.38710704,-0.30441490,-0.08249986,0.28423953,0.72963721,-1.49658203,0.99077344,-0.78913772,-1.12661564,-1.26294816,0.16517465,0.10124251,-0.77198768,-0.16342169,0.08615876,0.49711797,-0.66083062,0.76648003,1.04756033,1.46122825,-0.42798752,-2.29203916,0.30444992,0.58697921,1.22166932,0.09022947,-0.03920181,0.10444995,0.10361757,1.18224072,-0.76641631,0.90802073,1.41639423,1.55682337,1.28101575,-0.35396016,1.11443567,1.18218529,-0.06048089,0.85024464,-1.01789165,-0.69154263,0.06663221,0.68429029,0.12560424,0.37915874,-0.66829866,-0.64524972,-0.05568011,0.12230454,-0.35041061,0.62027830,-0.16739209,-0.72145337,0.46263054,-1.67837834,0.69413221,-0.57243419,0.37638462,-0.21446526,-0.89821470,0.60078722,-1.06706369,-1.26132309,0.35714921,2.39221811,-0.09376130,0.30760849,0.59180892,0.55815399,-0.32628775,1.28890121,-2.53237987,-0.98241091,1.10520673,-1.74751687,-0.90837651,-0.25220659,-0.56625104,-0.30691949,0.16058689,0.44309673,-1.09874964,-0.76747823,-0.33679363,-0.02535496,0.00990100,1.35318136,-0.70140815,0.50937581,0.55386209,-1.21721983,0.71376961,-0.18079315,-0.11077732,0.09292522,-0.57235324,0.62748206,0.42587611,0.64860481,-1.10635614,1.66414368,0.47505483,1.48602211,-0.59611166,-0.41932896,-0.96542233,-0.41756630,-1.02963889,-0.70070386,1.65803933,0.20138647,0.05895034,-1.46152759,-0.37278318,1.05535650,0.34437978,-1.13257408,0.17635690,0.09386671,0.37079874,1.47695887,-1.58420062,-0.26100200,0.44847637,0.88847303,-0.13877590,-0.64620668,-0.38019657,1.01608157,0.13357787,0.05137976,0.93498152,-0.62226880,0.80461699,-0.71682596,-0.88756353,0.40933055,-1.52167451,0.79756850,-0.17307425,0.62368619,-0.22466940,-1.72802913,0.59047443,-0.58020931,0.09096476,-0.07317388,0.44522321,-0.64880705,0.15684015,0.08708375,-0.41556796,1.11579072,-0.81733495,0.11643656,-0.73995101,0.93685871,1.57971406,0.67606360,0.70509088,-0.25283816,-0.00010609,-0.61884147,-0.86409342,0.95383751,-0.05895388,-1.45261180,0.45166013,-1.01434863,0.18496066,1.06517637,1.81127059,0.89470667,-0.13232610,0.46958798,0.13884509,0.57117194,0.29575035,-0.97884250,0.83291447,-0.59255791,-0.04354135,-0.19431923,0.30071029,-0.95421529,0.76359886,-0.47799742,0.68254346,1.19368529,-0.48935115,0.30357337,-0.50225669,-0.23370270,1.96702433,1.46558523,2.68482018,0.41622332,0.73697484,1.43430734,0.15387188,0.20875402,-2.49335337,-1.39674246,-0.22125854,-0.00424605,0.91416460,0.33384630,0.44703746,0.25610185,0.38966551,-0.01784045,1.66148460,0.36005461,0.95716912,-0.18246566,-0.15480693,0.38775176,-0.56969136,-0.29644895,-1.04565966,-1.00455630,0.30897698,-1.46885884,0.03657720,-0.49302089,1.34134722,0.01673754,1.22725964,0.55256772,0.63803208,-0.29041430,1.11455286,0.76329172,0.27073982,0.77173829,-1.79884446,-0.11889492,-1.92040312,-0.46382675,0.20078070,-0.98889589,1.46711135,-1.68280172,-0.52852470,0.66245162,0.29575166,1.34826505,-0.22362417,-0.14345661,-2.34815073,1.26572001,0.66505629,1.01141500,1.08030057,0.17036134,0.00168786,-0.37282917,0.69206375,1.07367527,-0.49708191,1.49504781,0.58224988,0.96593714,-1.07661915,0.25202179,0.25531644,0.42357162,-0.31236249,0.48383278,-0.06361829,0.24131298,-0.95695931,-0.12589653,0.36134180,3.20266032,-0.40879184,-0.66985190,1.51674330,0.34072638,1.15076303,-0.40199137,0.46223637,-0.48608047,0.99119538,-0.22506073,0.30968750,0.64210880,0.54640514,0.18607031,1.26293361,-0.77960914,0.79572529,1.01936150,2.27160740,-1.48034489,0.74466604,0.14863680,0.31102443,-1.15673816,-0.38609681,-2.65026069,-0.45524642,-0.74022961,2.74991131,0.00103815,-3.03303242,-0.41556966,-0.87103498,0.78306234,-0.88195556,-0.77297026,1.21203196,-1.09754920,-0.03556008,-0.31546223,0.72954375,0.25251788,0.11378583,0.50921023,0.30301905,-1.60631680,0.27152416,1.17342317,-0.70891970,-0.08392961,0.92137378,-0.10568139,-0.31653777,-0.28878728,1.22166574,1.12693942,-0.21325994,0.94010323,1.21796405,-0.68866694,2.30724216,0.28141466,0.83481526,-0.04885862,0.01675143,1.04355800,-0.81050140,1.51300573,0.53429186,-0.56439877,0.38572624,-0.05620475,0.67644542,0.72528905,0.05937041,-1.06315899,-0.51393986,0.46937627,-0.34699562,-0.64765716,-1.45512629,0.47739139,-0.88228017,-2.00791359,1.29929042,0.05482405,-0.66725296,-0.54735124,0.09972951,0.76675093,0.98748523,0.08900899,-0.78854066,1.47970486,-0.61667502,0.45625573,-0.21766303,-0.46250847,-0.07130960,0.64414692,0.12784545,0.26393634,1.07720757,-1.23938286,0.62483376,-0.55001754,-0.05358591,0.07322436,1.12003291,-1.00830650,-0.20486419,0.76664752,0.28850746,-0.04464776,-0.40146068,0.73262817,-1.12827921,-0.19989438,-1.15999687,1.37973154,0.78881019,-0.34762639,1.22088552,-1.64088547,0.63218033,0.45736769,0.05502866,2.22683382,-1.78935897,-1.49635041,0.83450896,1.67770112,1.33909333,1.51158953,0.28595078,-0.08593627,0.45812801,-0.15193029,1.14770603,-0.88920450,-1.96352005,-1.49894583,0.49629962,1.59872091,0.00903497,2.15563583,2.25149560,-2.01200557,2.56229877,-1.38850498,0.73552012,-0.39378855,0.52616280,-0.03685786,0.87403935,0.12163408,0.74297994,-0.30697080,0.38139752,0.49113834,-0.95485127,-0.99908817,0.71716321,0.04000283,-2.09645271,1.38789880,1.37198520,0.82493287,0.17114936,0.53696346,-0.19516060,-0.50377476,-0.91730285,-0.70113552,-0.02406530,0.84943396,-0.17428185,-1.09140801,-0.68156958,1.70756388,-1.00399911,0.03023832,-0.39023280,-1.89737976,1.14469039,-0.58337289,-0.60037899,-1.17490256,-1.56342828,0.48714057,0.62266618,-0.15967095,1.32789338,-1.25700688,-0.55633998,-0.83128709,-0.49346271,1.59561753,-0.24675299,0.38012561,0.91796309,-0.38522810,-0.65509188,0.94100451,-0.57324487,2.19070768,1.24058700,-0.75978851,-0.40460554,0.79189235,0.70192885,1.93569362,-0.03070199,0.77010989,0.58794290,0.51087004,0.22892070,0.35007235,1.56023848,-0.67453802,-0.18485607,0.64349502,-0.31489357,-1.95834625,0.06560058,2.30394220,1.18194163,-0.88034087,-1.05000436,-1.05471325,-0.98481798,0.49904808,0.16438948,-1.10297823,-1.39736509,0.01306054,-1.85160267,-0.87292641,-0.15418227,0.43412164,1.16518164,0.06273691,0.24659210,-0.08267246,1.28885782,0.73575675,-0.01019809,-0.08753663,-0.61827368,-0.40863234,2.12599611,-0.53620332,0.53789747,-0.66386080,-1.70461988,0.86608189,-1.11151052,0.14120635,1.18858743,-0.31760478,-0.73533046,0.20978074,-0.84074509,0.16523147,-1.03362834,0.59721231,0.21318658,0.23671274,1.75115061,0.25363782,-1.32541454,1.13056135,0.24652456,0.60381413,0.21478581,0.75044096,-0.63125616,-1.69889998,-0.02116571,1.46165359,1.03068244,0.63693464,0.67795700,1.20033514,-1.39205134,-0.61743122,0.56549704,0.65182322,-0.74250507,-1.61939359,1.14054918,-0.45725963,1.74519682,-0.66251940,-0.94811529,-1.60865819,-0.59968346,0.86309159,-1.91936195,-1.02646923,-1.50352538,0.58292735,0.05320299,1.53582895,0.01069612,0.15226212,-0.71840125,-1.36896348,2.14600968,0.96626586,-0.52014917,0.41001406,0.59478027,0.15282436,0.27790198,0.76614654,-0.38971323,-0.01839927,-1.57882118,0.61391610,-0.62133092,-0.03968323,-0.88467252,-1.24041140,2.07306671,-0.41776338,0.14537935,-0.91069067,1.67362070,4.72630215,-0.07395106,0.46280116,-0.40843824,0.70683080,-0.27510864,-0.63465804,-0.83630908,-0.44419941,0.60405648,-0.65039170,-1.02413189,1.05983019,1.73366308,0.73343736,-0.00895882,-1.00826013,0.17323074,0.73995626,0.24128854,0.94510227,0.25557515,0.02244723,-0.95197725,-0.16297856,-0.38497585,1.17993331,1.20282137,-1.31491220,0.44229278,-0.24349044,-0.01230415,1.37944865,0.48554277,-0.54510897,-0.10793537,0.41121426,-0.12889031,0.26434359,1.27966082,0.64518744,-0.15577169,-0.99864733,-0.61746484,2.01614976,1.56254935,1.86473298,-0.54662132,-0.22047071,-0.06118120,0.84799510,0.17009684,-1.30523121,0.64000309,0.36299205,-0.59620583,1.36372304,-0.05389515,-0.93849313,0.98043185,-0.39373067,-0.84898937,1.32077873,1.05988657,-1.35339200,0.23259017,0.63816410,-0.80297333,0.60017115,1.25715804,1.18894124,-0.62473553,1.05611980,0.02335166,1.07509828,0.25873449,-1.68341100,0.54547334,0.79288185,-0.93678916,0.19202201,-1.48575914,1.08649087,0.50851744,-0.45758674,-0.39734635,0.35637981,-1.63079453,-0.75910008,0.92640859,-0.55599529,-0.40276715,0.31307653,0.39907026,-1.18830419,0.71051043,0.14157933,-0.39581308,-1.64361024,-0.06161860,-0.25312796,1.10018682,0.56500763,0.80385065,0.35395023,0.81813669,0.27644628,0.65563256,1.73197234,0.68178749,0.76769936,0.44597456,0.67761195,0.67635447,-0.32315412,0.19330767,-0.25557944,1.91693723,0.38335562,0.07107610,-0.57384586,0.79184365,1.87835479,0.60902315,-0.94220877,0.79479855,-0.25656971,0.08739131,0.53384244,1.22159266,-0.39152125,-1.46373534,-0.02458516,1.62825716,-1.26112676,0.19967082,-0.71114451,0.27929229,0.65001321,-0.11868202,-0.55587751,0.78069001,0.57969242,-0.60274386,0.31650013,0.90339553,0.09453616,-0.37119162,-1.00320566,0.33299938,-0.48636708,0.26342997,-0.91914523,0.28682709,-1.24780893,-1.59254742,0.97176319,0.14744301,-0.53056234,-1.73221612,-0.67645556,0.98705006,0.79895812,-2.04333115,-0.60132772,-0.91653955,-0.28094748,0.47943443,0.38157779,-0.67648011,1.09093642,1.66012859,-0.29358891,-1.26773024,0.36747769,-1.10141146,0.82383633,-0.89772314,-0.47145563,0.63939518,-0.64430422,-0.48889321,-0.37680882,-1.06962025,-1.28689516,1.28365147,0.61859220,-0.84676331,1.38404000,1.21053445,-0.14871351,1.06349385,1.45878971,-0.47362664,1.40707004,1.25224137,0.87364739,0.92858213,0.00157326,1.45661485,-0.27318576,0.15482858,-1.07058907,-0.06903186,-0.74147576,-1.64111829,-0.67226541,-1.13458407,1.28511488,-0.41041154,2.09085560,0.45243183,-0.67437285,0.84960121,-1.49300814,-0.42961186,-2.35021853,0.57255560,-0.73903763,1.37607956,-2.44575167,1.25105727,1.38575912,-1.16299784,-0.13719854,-1.11507034,0.35796806,-0.64511567,-0.87903833,0.32833642,-0.87696886,0.02714214,0.30224666,-0.69118696,-1.23500824,0.76678628,-3.20508122,-0.24704689,0.49019828,-1.20862615,-0.03778638,-0.07273687,-0.11517122,-1.75857520,-1.64188445,1.21574795,0.57325113,1.14370298,-1.07824504,1.70653832,-0.03700557,-0.47645858,0.11065386,-1.03143036,-2.18094873,-0.94403434,-0.09335683,-0.44817665,1.39707148,-1.21947956,0.56575936,-0.69612634,-1.12361753,-0.17105591,1.15422392,0.02840637,0.09469353,-0.52859986,-2.08487725,1.28789508,-0.03740775,0.61196613,1.23405397,1.56595814,-0.65800631,2.02985072,-0.69446486,-0.88443804,-0.23448054,-0.43628734,-0.45888957,-0.21943338,1.78258693,1.75214970,0.71804136,0.49782532,0.37886053,-1.59176385,-1.74758542,-0.02820176,0.75398153,1.00119829,0.80881971,-0.53365272,-0.22720885,0.37476870,0.01005529,-1.23421800,-0.13431595,-1.01843679,1.87386346,-1.68539488,-1.04942071,-0.77322137,0.53964764,0.29278332,-0.58299130,-1.56022692,-0.79441273,0.49289709,0.44112054,1.07305002,0.54899335,1.13781393,0.77809113,0.81795985,0.16576190,0.32552773,-0.20250474,1.46543837,0.12731771,0.21013761,-1.34241438,0.44267517,0.93246883,0.08808212,0.92653406,-1.21083558,0.17247954,-0.70557106,0.04630012,0.48834828,0.89634645,0.46683592,-0.29553145,0.46363977,-0.48971879,-0.88603491,-0.12333342,0.37073737,0.92061806,0.54675460,-0.14716248,0.75578392,-0.98173791,-1.15983224,-0.58713156,0.07950903,-0.59016788,0.41622928,-0.32474482,0.42086437,0.23061797,0.62596649,-0.22615278,-2.14721417,1.01685894,-0.25976995,0.00739352,-1.31597066,0.39005190,-1.09549701,1.68375242,0.43331525,-0.37124026,0.22255214,0.59654880,-0.73840386,-1.20048976,0.12226126,0.12997478,1.04826224,0.03894836,-0.36289826,1.14466560,-1.18198848,-0.03713558,0.67677927,-0.42329931,-0.89409167,-0.77874780,0.58438253,-0.35176343,-1.53329861,-0.02995299,-0.40145162,-1.51052392,0.09194464,-1.13275242,-0.61983156,-0.40004560,-0.19893464,0.22134103,-0.03903082,1.14894116,-0.03476744,0.22520730,-0.55851930,0.76650429,-0.57863152,-1.34161711,-0.31498179,-1.19411755,1.70044947,-0.17428267,-0.35983825,-0.42613637,0.58165723,-0.77866900,-1.59727287,-0.61723864,1.51078022,0.32971445,-0.86441469,0.60552609,0.00208178,-0.47096625,-1.10479307,-1.21652532,-0.08211990,-1.43739200,-1.31684434,0.43312529,-0.76822090,1.88128507,-0.02179282,1.04971325,-1.55004108,1.25337446,0.11203052,-1.16048300,1.59467411,-1.29469275,1.14019871,1.20021439,1.84098923,0.05004879,0.73529941,2.05272865,-0.13080600,-0.08436690,-1.17919350,-0.66256678,-0.36727047,0.73840511,1.22293818,-0.00206342,-0.29839504,-0.00618613,1.04213119,1.21176076,-0.62886089,-0.02589060,0.96009409,-0.64478731,-1.16516542,0.57528079,1.04294407,-0.09774588,0.45935291,1.03263175,1.00633478,-1.82209253,-0.18035053,-0.28302726,-0.83813244,0.57593471,-0.03807700,1.60498738,0.16530658,-1.43083501,2.10824299,0.30279446,-0.03961089,-0.38900724,1.31272805,-0.56575215,0.57970244,-0.48305038,1.34114623,0.21859215,0.66399640,-1.52087069,-1.30717897,0.14394683,0.97648209,-0.71372712,-1.22574198,-0.27702177,0.04041927,0.02442212,2.19617033,-0.48566443,0.81463927,0.20383844,1.17562282,-0.33829874,-0.42141283,-0.96415234,-2.39141965,-1.04285860,-0.23004992,0.41186509,0.03811268,0.36818987,-0.71099734,-0.56749570,0.18486284,-0.44530040,2.14008284,-0.27467576,1.70690107,-1.40462613,0.24697532,-1.31629777,-2.20674944,-0.67868507,-1.15767133,-0.64391804,-1.79037917,0.58749497,-1.58303332,-0.69021022,1.64376318,-0.95393223,1.98415601,-0.10991055,0.02474386,0.23683345,-0.63420391,-0.57991928,0.83028817,-0.40033704,0.19212338,0.74640590,1.10264432,-1.65286255,0.92683482,-1.42252541,-0.74605089,2.14535880,0.12971123,-0.47971717,1.67546797,0.42268261,0.22648531,-0.42369929,0.77403021,-1.31818616,-0.67143595,-0.04311426,1.64128351,0.34776631,-0.39353722,-0.42765084,0.16170517,-0.54488391,-0.38428506,0.42097485,-0.55982012,-1.74543798,1.53704774,0.43562424,-0.30395737,0.31846946,0.39205357,0.57386035,-1.11912560,-1.39164317,-1.04337609,0.31629622,1.51927638,0.88745505,-0.40445471,0.25783861,1.88646257,0.36509129,-1.13266826,-0.45394278,-0.48400903,-1.22332740,0.38626808,-1.10049105,0.84138852,1.27863181,0.53942156,-0.67743856,-0.03896645,1.70393491,0.60997570,0.43368068,-0.13338457,-0.18920666,-0.29583672,-1.40738738,1.03876019,1.71253765,2.12821221,-0.96092403,0.93841934,-0.79030478,1.36427641,-1.39196694,0.08514920,0.16223004,0.71259701,0.20150672,0.25068361,-0.99952722,1.80129099,-1.28586197,-0.64957166,-0.94813949,-0.40161121,0.31977695,0.54932386,-0.67757767,1.88086259,0.92337233,-1.64887333,0.44333732,-0.19468001,0.12977587,0.21171951,0.27679422,0.49134475,-1.44429457,1.25617445,0.39978400,0.99869555,-1.61617446,1.61177349,0.70243025,-0.95748568,-0.61795151,-0.77302909,0.72967088,0.81964350,-0.71813750,0.90140164,-1.45950246,-0.79972702,0.40875742,0.00152073,-1.74491429,1.53776145,0.75769204,-0.22075878,-0.58385569,2.18884754,0.33597681,-1.66265559,1.03805876,-1.55245185,-0.03582226,-1.94542754,-0.76081425,-0.50471377,1.35763168,-0.39631784,-0.17134467,-0.82220149,-0.41021580,-0.00940776,-0.80176353,-0.19816744,1.22061026,-0.14486519,-0.71727395,-0.65721530,0.47020102,-0.70403302,-0.94795334,1.79884899,0.07779162,-1.50615680,0.04140327,-0.22001404,0.63735324,0.79237640,-2.25412822,-0.52519119,-0.87280381,-0.07100742,-0.94734806,-0.12286110,-0.13623615,-0.42595413,0.17547913,-0.81707209,0.36855817,-1.68186557,0.19312963,-0.66249490,-0.98283452,-0.33314428,0.40918943,0.88268638,-0.05390308,-0.22440539,-0.15879378,-0.34859571,-0.01013108,-0.30005428,-1.19408464,0.21789688,-1.07769871,0.81475031,-0.69555300,2.35201311,-0.40362412,0.93497628,1.13343573,0.92343372,0.26987928,0.46123627,0.22577702,1.26289701,-0.45956740,0.55994868,-0.58410591,0.13304594,-0.25806463,0.49044946,-0.82065403,-3.06672239,-0.27774641,0.68504512,-0.21386372,1.11427057,-0.73201770,0.51655543,1.77261138,0.72081727,0.11116749,0.16637769,-0.74987584,0.66579849,-0.75808716,0.20678560,-0.67698354,-0.82141948,0.61008269,0.66520184,0.44894725,0.73015076,-1.52517414,0.11714164,1.90452611,-1.30355322,0.12144456,1.18547559,-0.07349755,-2.28061509,0.83522540,0.78438890,2.19334102,0.90305614,-0.59345531,0.77925014,1.32338643,0.14068902,1.19032264,0.20666829,-0.76595837,0.74967057,2.86965609,0.55690205,-1.72530472,-0.83317834,-0.85842621,-0.29678273,1.80955839,-0.70496303,1.19106734,-0.92985237,-1.00617313,-0.56049556,-0.29382578,-2.04022193,-1.95356870,-0.42553005,-0.33369407,1.02115977,-1.45769477,-0.67720300,0.53819913,1.57643425,-0.47015440,-1.47861958,-0.00545934,-0.97836047,0.42680529,1.56110144,-1.49487829,-0.65198445,0.22720462,1.83036661,-0.47099793,-0.09915133,0.14923312,-1.16313052,0.67798084,-1.63665557,-0.38220280,0.01719763,0.30041245,0.43148938,-0.44021657,-1.25734651,0.02465564,-1.00845659,-0.28574651,0.01367745,0.77253437,-0.99399441,0.61445391,0.18343423,-0.50997210,0.41359940,0.77279282,0.83511519,0.27929801,0.70800692,-0.20278299,1.57884383,0.22650529,0.43347472,0.74003208,-0.71401161,-0.69829476,-1.56766701,-0.99254119,1.27301061,2.73726511,0.66089469,-1.95778012,-1.24642098,-0.63579029,-1.63168180,-0.66980726,0.81933254,0.61866677,1.40594471,0.05158535,0.00196500,-0.24592508,-0.50780547,-0.83905292,-0.10748957,0.04490763,0.27769178,-0.23227681,0.82108080,0.03562285,0.95483875,-1.49897683,0.67809856,0.35497451,-0.44021592,-1.67361462,-0.88895375,1.44293678,-0.85046643,-0.46437624,-1.87252641,0.26775804,-0.24535774,0.73365933,0.52253938,0.27947086,-0.58796054,0.59045380,1.93476331,-0.46775359,0.25238225,-1.26601815,-0.13324316,-0.71454948,-0.21610366,-1.49586582,1.04903507,0.22208478,0.25512528,-0.46157327,-0.41319233,-0.63846964,-0.25100923,0.81277549,-0.26959971,0.88737756,1.24578953,-0.91121447,-1.05756927,0.44390878,0.16672316,-1.22941923,0.89547867,-1.50212002,-1.69620168,0.53339505,-0.23656729,-1.69879091,0.01510374,0.08315694,-0.73196459,-1.60263407,-1.07601058,-0.76389569,-1.65307498,-0.61484390,-0.43546933,0.71318507,-0.16273083,0.64122051,-0.15406294,1.17673671,-0.91240519,0.71091145,2.40497613,1.26343656,0.71469337,0.20705548,0.81776261,0.36253929,-1.92106628,-0.09300470,-0.36648872,1.27732766,-0.39180157,-0.61186749,-1.03455031,-0.25079829,-0.61479062,-1.07094336,0.82218504,0.89934880,0.41308978,-0.59968555,0.37682834,-1.77388155,0.00294951,-0.66145372,-0.50789726,-0.85123241,-0.89909405,-1.89454281,-0.56692821,1.52272677,-0.11961794,0.27843913,-0.60582250,1.01871169,-0.36098275,-0.12242325,-0.67375034,-0.11204147,-2.62773919,-0.95901299,0.14040214,1.32364666,-1.35099924,-0.11077739,-0.79319423,0.75949597,-0.25485823,-0.90959758,-0.42373934,-1.29850340,0.85699379,-1.11882365,0.63470817,0.49696380,-0.07983235,-0.23903450,-0.22618714,-0.12117998,-0.09442677,1.55589819,-0.11996678,-1.72700179,0.54683149,-0.40804827,-0.50099218,0.34596699,-1.81841791,0.06385052,0.84428120,0.69901514,1.94559097,0.43251973,0.16794942,1.82829034,1.70959795,0.36130908,-0.94608402,-0.53498030,0.47781768,-0.24203247,1.25065851,0.51788396,-2.09381890,0.72973937,0.03281829,0.58632666,1.85737121,-0.49569523,0.45921183,1.87173629,0.22803484,1.66433418,-1.05872321,-1.13663685,0.12397861,-0.65112090,0.98152941,0.83739656,-0.18783289,1.84249437,-0.90706986,-0.80824369,-1.23854923,-0.86488134,-1.02627063,0.10976455,-0.61403006,1.27554715,0.14653525,-0.03953953,-0.08512071,-1.30043304,-0.02566035,0.12054887,0.00282162,0.48921332,-1.74398839,1.44554436,-1.35854721,0.69256759,0.34101671,2.50045252,0.49121150,-0.27115449,0.93974596,0.26258010,0.27151433,-0.87214381,-0.92580765,-1.03269923,0.20615758,-0.37822601,0.58983004,0.16426525,0.68218285,1.98158526,0.47492698,0.54224718,1.28722692,-1.76915324,-1.11240053,0.77428484,0.27184650,2.22473478,-0.05574624,0.39976570,-0.43911108,0.52805597,0.17340177,1.36057591,-0.35004014,1.72787797,0.68357420,1.25532615,-0.56752264,0.51840127,-0.21237844,-0.58821255,-0.85278064,1.90179110,-0.67447448,-0.36831430,-0.22930753,0.98231596,-0.07011599,-0.08560387,0.05998110,-0.02481356,-0.57335132,-0.44288307,-0.24468307,0.53321087,1.19609559,0.10664973,0.24379487,0.93687552,0.93615580,1.74319768,-0.68310338,1.32163060,0.61918712,-0.76501870,-0.54549301,1.74077415,-0.69977754,-0.66880983,-1.15981388,0.81571609,0.53788543,0.47898352,-0.02484704,-1.64646924,-0.69822907,0.27020717,0.05027051,1.75149667,0.01548872,0.32615909,2.55151844,-1.29172051,-0.36133784,0.98637396,0.14009331,-0.50038946,-0.92230296,0.17307127,1.05361068,-1.46784890,2.38960409,1.19413340,-1.33349669,1.59141159,-0.71811068,1.22429430,1.26947939,1.08177102,-1.18138707,-0.72775704,0.17282635,-0.40554270,-0.40341887,0.46564049,-1.02069795,-0.07653128,-0.13979210,-0.31195050,-1.72042310,1.37131393,0.63849634,0.75561279,1.81152904,0.26686314,1.32796574,0.56100166,0.70058894,-0.88962644,-0.04360984,-0.88249093,0.24311203,0.50410056,-2.22567797,0.94520348,-2.12467694,0.47282359,-0.71379906,-0.09857135,0.62374717,1.37182784,0.73380554,0.59745449,2.80427694,0.67253572,1.65335357,1.69891667,1.34585941,-0.79989213,1.44980943,-0.52013642,-0.46971673,-1.50070012,-0.25687039,-0.56916732,0.71065760,-1.31996286,0.96031237,0.13929774,1.49679291,-0.05966444,-0.58674580,-0.08278833,-0.93390942,0.42415768,-1.77889526,0.75336021,-0.72699982,-0.82880586,0.63955617,0.42771208,-0.42366457,-0.91581815,0.94750947,0.43123913,-0.99053741,0.70470595,-1.16662264,1.14847183,-0.83885664,0.46714026,-2.27748466,-1.23656678,0.14695056,-0.33159894,-0.52553117,-0.04391259,-0.29630372,0.25949728,0.96991086,-0.37714824,-0.28251833,0.16106486,1.38844633,-0.18713553,-1.30708838,0.48490265,0.29553881,-0.45505449,0.83341682,0.87346369,-0.63516861,0.66063565,0.93892503,-2.73996735,-0.81515318,-0.91458052,0.00978268,0.43472794,-0.08090764,1.37249672,0.76722521,-1.19154143,0.22046764,0.34916410,0.51383299,-0.56379753,-2.49949312,-0.74207872,-0.68400806,-0.09663232,-0.07199454,-1.05562651,-0.75028551,-0.87253797,0.69039482,0.45923674,-1.27515161,-0.04555376,-1.41501272,-0.83773375,-0.74807298,1.36646152,0.06317432,-1.32559633,1.89092779,1.24883330,-1.03608561,1.08677161,-0.99629849,-0.69947034,-0.85716367,-0.07947286,-0.25485426,-0.19732477,1.64581251,1.04618108,1.87186897,-0.18198362,-0.83807969,0.70462501,-3.18930101,0.74610996,-0.60935193,-0.49383929,-2.88986492,0.51707613,1.04620326,1.09837818,-1.19840038,-0.10391295,-0.20789115,-1.51052022,-0.31087330,0.22411564,-1.30506921,-1.52000105,-1.51593041,1.04321992,0.97611690,0.90424490,1.83324766,-0.08682299,0.47035542,1.70865905,-0.31108001,0.04115159,-1.36352801,-0.90797836,0.32128647,0.66191489,0.08681208,0.14993365,0.47110486,-0.31522670,-0.38906571,-0.08876022,-0.13106902,2.25685239,-0.62211353,-1.68553007,-0.23707703,0.69236159,-0.46686995,-0.27520603,0.26619941,1.48525345,1.61278927,0.49452963,1.20846486,-1.11853909,-0.30010033,-0.75471467,-1.69959772,-0.52042168,-0.43881389,-1.45240712,1.02122891,1.73639011,-0.03813924,-0.22239220,0.15797073,-0.64418089,-0.60228932,-0.83248150,-0.02042520,0.38137484,0.86056453,0.06410559,-0.62785137,-0.49916875,-2.53796315,-0.79168582,-0.69197005,-0.77175534,-0.28669405,-0.79764080,0.97218460,-0.10351621,-0.52759898,1.02840185,1.16363287,0.08351815,-0.61088538,0.59944046,1.54409397,-1.39842033,0.27917057,-0.27146137,1.46310735,0.03626106,0.15038440,-0.07894899,-1.42527366,1.69641745,1.48384345,-0.43328866,-0.54252565,-0.94416499,1.54436302,-0.81367069,-1.67925239,-0.17525831,0.27891046,-0.69066733,0.89911050,0.11606655,0.67450327,0.41538724,0.90886223,1.19786549,0.85810721,1.32862210,-0.83469814,-1.09682298,0.88092703,-0.97478902,-0.11664717,-0.07929394,-0.69581884,-0.16928329,-0.70731819,-0.40485084,-0.28954300,0.52882415,0.38769314,-1.38704026,1.15099049,-0.43566978,0.34459323,0.49520254,1.11130333,0.28783718,-0.53783375,-1.63577271,1.02222812,0.86302060,0.48346213,0.46627176,-1.30133855,-1.48477137,0.31219670,-1.21498191,0.89838904,0.87186617,-0.39968935,0.34930915,-0.32909471,-1.39364409,2.13006306,0.33270469,0.00215986,0.97776711,0.24908836,1.56164885,0.45157790,-1.55970144,0.27677536,0.07662498,-0.08262251,-0.17658773,0.65820259,2.01052690,-1.71946216,0.84686053,-1.23594892,1.40792072,-1.47772563,-0.36132276,-0.50405115,0.09009213,0.81659186,1.85574234,-0.64974433,0.63352364,1.01766217,-1.54804432,-0.42570522,-0.24763709,0.72822112,-0.93733686,0.68087620,-1.40644944,0.48672482,0.09725539,-0.64416331,-0.95747960,0.36771363,0.39155054,-0.71790671,-2.17222738,-0.08655047,-0.97842115,-0.22991380,0.52029115,-1.42072022,0.29576331,0.32391560,-1.00823236,1.67909145,1.16841447,-0.32307062,0.15756166,-0.97590631,-0.39429301,-0.03583352,0.17554663,0.57961231,-0.46873134,-0.23343173,-0.85060924,1.71745574,-0.04658702,0.63088381,-0.67581934,-1.53171062,-1.58800113,-1.17987096,-1.16737640,-0.87544650,-1.17138922,0.38979119,-2.39369726,-1.34747124,0.58450359,0.87791806,-0.04459394,0.97995293,-0.10354915,0.65324986,-0.17833626,-0.85849386,-0.42063358,0.19708554,0.10255250,-0.59539181,0.86194044,1.68610668,0.55275291,-0.43127069,-0.04218780,-0.08466262,0.31236625,-0.92824298,-0.09879152,0.32358822,1.04045570,0.35617545,0.09059231,1.19069445,1.96978688,0.63561743,0.15030998,-0.29879019,0.22774190,-1.01608860,1.03605175,0.47804731,-0.30450734,-0.61382371,0.45390254,-1.93547988,2.01267338,0.52447683,0.18379784,1.11913633,-1.24273467,0.15803322,1.72184098,-0.79349059,0.10258614,-1.53445125,0.02630571,0.81649125,0.91089755,-1.12968338,1.04016411,0.28999722,0.74863863,-0.61388236,0.01665530,1.43592548,0.68138391,0.11963340,-1.26123953,1.36340797,0.25696915,-0.58877039,1.42209792,0.55563360,-1.33329606,1.84695840,0.88433737,1.04359078,0.18906727,-0.03448994,1.17944050,0.86783957,0.44934425,-0.77892244,-1.76232874,-1.01689589,0.78943914,0.92141974,-1.00187087,-0.13809921,-0.90222073,1.10094714,-0.13657950,-0.44349849,-1.61441302,1.05724919,1.50337231,-0.05785890,-0.76958144,-0.51498759,0.69227600,-0.37975949,1.31949317,0.82049531,0.32868597,-0.31557772,-0.75534385,1.27303052,0.43453619,0.11296938,1.18182182,2.23387384,-0.86412978,-0.01599468,-0.70869064,-0.09221385,-1.23729551,0.79490280,0.03522846,-0.95069039,-1.73461652,0.72329187,1.40385795,-0.11585230,-0.78033113,0.07491048,-1.12873089,0.18476245,0.57568848,-0.28792691,1.35411644,-0.76956165,0.29571572,1.03178787,-0.38780826,0.31680650,0.69368076,-1.23856580,-0.49848995,0.14766994,1.02625990,3.03858209,-0.51030380,0.96796870,1.35078156,-1.07729447,0.84322494,0.54886484,1.31453705,-0.45792100,0.31196272,-0.15701357,0.83586836,-0.74952888,-1.17432022,-0.31002575,-1.02149463,-0.36117774,-1.22079086,0.03532525,0.00555908,-0.45891216,0.29636297,-0.68272704,0.41257843,0.37988129,0.01747893,0.82739186,1.52292180,-0.79456621,2.20275712,2.13212132,-0.81393015,-1.15712392,0.22488308,0.62776327,-0.85444915,0.44017896,0.05863331,-0.83198178,0.93063420,-0.16121253,0.12382501,-0.37826315,0.93118382,0.19507533,-0.58595538,1.46994352,0.13170272,-0.70031989,-0.12820166,0.30487457,0.84148771,-0.68807501,0.21187615,-0.67030680,-1.79136002,0.70810199,-1.20959783,-0.08468831,-0.06317700,1.35527098,-0.47018668,-0.91693246,0.14818805,-0.05405350,1.16875637,-0.17363262,-1.61833882,-0.32934523,-0.38346377,-0.62702698,0.34135151,0.48015586,-0.65263331,-0.04689486,0.01156854,0.37580970,-0.16174591,0.59627324,0.24351901,-0.87983090,1.57049024,1.25836349,-0.41464049,-0.62279183,0.09693756,-0.23850618,-0.49007827,0.22298151,0.10914832,-0.35192192,-1.27221346,1.10203624,-0.86399704,-0.47319838,-0.77105570,-1.68624854,0.81198281,0.82534081,0.75654501,1.47631240,-0.61000234,-0.58933264,0.54822850,-1.22829592,0.11107657,0.56449169,1.50693524,-0.59280968,-0.64286685,-0.20120731,0.27184448,1.55500400,-0.48919386,1.04044867,-0.87048137,-0.40569979,0.21908638,-0.51829034,-1.48748124,0.02990401,1.83462536,0.29885170,1.32370698,-1.30129600,2.43271399,0.22967771,-1.13014007,0.95529765,-0.83325785,0.43633386,0.85774118,0.78160155,0.58583075,1.18906367,-1.54354560,-0.68320692,0.01900371,-0.79777133,0.12851712,1.10176420,0.79418170,-1.41154039,0.36929929,1.12176800,1.23849642,-0.89377707,1.01390159,-0.50889206,-1.12554002,0.17932732,0.48949540,-0.54235244,-0.28146735,-1.39125514,0.13309635,-1.12864995,-1.29901242,-0.04266220,-1.98028529,-1.34869373,0.00038156,-0.92473024,1.48010647,-0.02754467,-0.26030368,0.93083733,0.27946711,0.64052200,-0.04220961,1.25002527,-1.07923257,0.19048618,0.08900311,-0.40813437,-0.73068553,0.52122378,0.68990833,-0.38749605,-1.09269309,-1.63480806,1.01789618,-0.61596102,0.81049860,1.30838764,-1.49213874,-0.77916288,-0.72660202,-0.92013240,-1.61726642,-0.11527207,0.35143322,-1.11646879,-1.45525432,-0.82892823,0.15512508,1.01891017,1.40162635,1.02494884,0.33882582,-0.78747398,-0.26009330,-0.38519114,0.79247451,0.02065756,-0.48030257,1.01167107,-1.74057114,-0.84549171,-0.15337363,-1.92544484,1.01270044,0.00762185,-0.16405612,1.61778915,0.93316060,-0.68960994,-1.13214970,-0.94695878,-0.28418848,0.17102109,-0.08787476,-1.83799696,-0.13761258,-0.18652774,1.46456254,0.34169790,-0.40697145,1.49663997,-0.99555492,-0.67775637,-0.51951116,1.35157657,-0.27099034,-0.46987835,2.28101230,0.59104478,0.75010139,1.01472175,0.25741309,-0.56074983,1.12267506,0.35336846,0.61733276,-1.63976014,-0.17700450,-0.25093642,-0.75599891,2.10956192,0.95155340,0.72049862,0.50492924,0.62067389,2.08688402,-0.73604703,0.63383341,-0.53528428,-2.11538506,-0.98173052,0.59560484,-0.26205051,-0.91948050,0.00593397,-0.11734286,-1.41261208,-0.83611172,-0.27682739,-0.20619918,-0.36557615,0.77194935,1.67695415,-1.39265156,0.04892010,-0.37773246,0.16124558,-0.18348448,-1.38248885,0.58459854,0.65064198,1.11349559,0.36708066,-0.15471332,0.14208725,-2.06860566,0.29629150,0.93084633,-0.47215626,0.60208917,0.95415461,1.03390312,-0.03639749,-0.23988228,1.27037442,0.95133096,0.33187470,-0.34527761,0.22134073,1.01799667,-0.81475645,-1.18869019,0.23314142,0.25180560,-1.23762786,1.25283313,0.16980635,0.40740708,0.59256923,0.16274920,-0.69713289,-0.16444311,-2.41602516,0.37952334,-0.05604568,-0.23772651,0.20581599,-0.54303211,1.71877348,0.83602583,-0.32586128,0.73609394,-1.73640239,0.07249248,0.31248692,1.77627432,0.97660398,-0.42095289,-0.18750280,-0.84246057,0.29762223,1.87054563,-1.46980762,-0.45306337,1.52366042,1.39061129,-0.04980387,-0.55382830,-0.96987218,-0.06910808,-0.41276473,-0.83891344,-0.92597574,0.60252470,0.21938549,-0.04451685,-1.00330937,-0.36955237,-1.52876902,0.27296364,-1.96721256,0.05291027,-0.91540521,0.48990685,-1.99560380,-0.68551093,-0.14532298,-1.56881595,-0.08319287,0.31003201,-1.42829597,-0.61810297,-0.03581250,0.77747720,1.25297558,-1.36239243,-1.13274276,-0.35045877,-2.34157228,0.04515179,-0.83044821,1.81353962,-1.36855912,0.39704823,0.16665934,-0.16654585,1.17806077,1.00086153,-1.25474250,-1.46876431,1.18021631,-0.32257929,2.12062597,0.86819613,-1.18048275,-1.69747460,-0.74092305,0.05086798,1.15339577,1.32972670,0.27247882,0.98499072,2.35597157,0.30179837,-0.66633248,0.13794266,-0.22753908,-0.22868259,-1.81792033,0.50151759,-0.79408127,-1.05343878,0.45727381,0.84800923,-1.73605800,-0.02032863,1.82778001,1.41025102,-0.81715560,0.25888795,-0.25075480,0.66256499,0.11993053,1.81336939,-0.06345166,-1.49658346,0.07531686,0.96972889,0.87405980,0.75830793,-0.13497087,-2.45855975,-0.65984958,0.93919373,-0.97305542,0.73477978,1.04337513,-1.22712576,-0.46385625,-1.20876372,-0.82760453,0.01455977,-1.05089867,-0.02801843,0.60899758,-0.82052249,-1.48932517,-0.98073828,-0.19311285,-0.25602359,0.50351876,-1.24557400,-0.82138073,-1.45966852,0.44991320,-0.75550151,-0.98550314,-1.21418869,-1.15771639,-1.72192061,-0.39616469,-0.55566746,-1.31880891,-0.08843257,1.00422776,0.35846478,0.46060917,0.77326930,1.60129988,-1.85124147,-0.30582917,1.30227256,1.81890345,-0.44084981,0.25315762,0.70259613,-0.94882858,1.97040296,0.71473581,-0.68193883,-0.36290962,1.16348684,0.15418798,1.07806778,0.40554729,0.10280909,-1.06474805,0.64398485,-0.63568884,-0.06108581,-1.03290677,1.02834034,1.15284693,0.14046004,1.86630619,0.46804786,-0.68397558,1.60733378,-1.64890087,-1.03819239,-1.19212389,-0.78382361,0.03925850,1.52259934,0.09540676,-0.21220762,0.55955195,-0.39845437,-2.14541650,0.49337825,-0.68574250,0.74040270,0.50783634,-1.60461199,-1.26806450,-0.12652303,-0.83992827,-0.15524681,0.40098447,0.23392735,-0.23262636,0.06525709,-0.35994548,-1.08432877,-0.21395946,-0.78357452,-0.57157278,0.71407390,0.86596155,-1.13723528,0.13460183,-1.20881450,0.71018457,0.68943661,-0.70428050,0.64600736,0.01990297,-0.10575775,-0.80263519,0.10618331,0.08865548,1.51651669,0.60851854,1.15161908,1.04919207,1.18359745,-0.04352076,-0.83643389,-0.07922365,0.10597949,-1.34984851,-1.91319740,0.71585363,-2.10845160,0.64385056,-0.54551518,-1.02039802,-1.62510490,1.65401149,-0.42711899,0.07970079,-0.21404363,0.30498922,1.07942021,0.63995659,-1.82114816,0.56396323,1.07084870,-2.00350380,0.53339815,0.18500003,1.15034151,-0.21436051,-0.99986565,-0.58812016,-0.07247020,0.78910017,0.48839527,0.98795873,0.10357288,-0.05604928,0.38977858,0.73745090,1.40838420,0.25967824,0.23588051,-0.03451392,1.04897523,-1.77121758,2.35625434,-0.67086869,-0.84005541,-0.85940343,-1.04449213,-0.65917015,-0.78713167,-0.95910054,0.38597879,-0.31879017,-0.86260867,-1.08593106,0.02802678,0.99484950,-0.55113328,2.60936737,-0.03388772,-0.47583574,-0.14021793,0.99019170,-1.22431207,0.78734446,-1.77037835,0.15018673,0.36423206,1.36447549,-1.61007094,0.51875496,-1.60788095,-1.73557448,-0.41414359,-0.93710536,0.38715765,0.04243837,-1.59682858,-1.10728157,1.88292623,-1.01428258,0.01074958,-1.88169158,-0.31616244,0.45334938,1.12449574,-1.16699445,-1.59505820,0.04126552,-0.89016622,0.45838884,0.71463561,0.14563711,0.30694655,0.67193079,0.61429602,1.00201404,-0.49295208,0.05997690,0.99491668,-0.73801446,-1.17185295,0.94778723,0.36106884,-0.43561545,0.04102699,0.52626407,0.08442099,-1.57626402,1.56855237,-1.65396678,1.74014664,-0.38219589,0.39305371,-0.31705827,-1.15742850,0.11669596,0.54043210,-0.52270615,-0.13375773,0.68094701,-1.84134769,-1.49383473,0.14632171,-0.54607725,-1.20867658,-1.28439069,-1.81734920,1.54257309,0.78347659,-0.24049839,1.69973648,0.99825776,0.99971974,-0.26055810,0.34143049,-0.44862366,0.11253342,-0.60932243,0.70383030,-1.87318194,0.21953633,0.82791799,1.64545465,-0.42693698,-0.64897031,-0.97996652,-1.06616282,0.52939081,-0.12541170,-0.57480675,0.73600835,0.35711968,-0.03528263,0.79997194,0.55742902,-0.28909785,0.64331138,-1.79893720,1.01572442,0.27111965,-0.51778597,0.12906317,0.76148927,1.51315522,0.41101140,0.38008851,0.66759896,-0.13804778,0.64854795,1.73474562,0.75999504,-0.73411214,-0.05406699,1.35664344,-0.25298578,-0.12696666,-0.42628938,0.61129904,1.55259824,-0.05820796,-0.38598019,-0.87325627,-0.55066222,-1.24557889,-0.26509118,-0.32103062,1.14031804,-0.75985742,0.70659167,-1.15016067,1.24906838,0.90396994,-0.16241251,0.43682271,-1.42695689,0.47134697,-1.66143429,0.08698819,-1.00775325,-2.24129725,-1.04226267,-0.98537570,-0.89938259,-1.80710697,-1.22866321,0.78125423,1.55150509,0.46235040,0.18444096,0.19313288,-2.20686269,-0.40341458,0.50321484,0.47339424,-0.81383848,-0.21972439,0.66612029,0.60239881,1.20443010,0.70015103,0.30632916,0.01489905,0.68129027,-0.89645082,-2.68969011,-0.96684915,1.66421318,0.74333072,-0.78321886,1.60063362,-1.27524030,-1.95856726,0.47504124,0.15398432,-0.20796098,-0.13449343,0.93458968,1.60390890,0.21798505,-0.27035928,-1.23248971,-1.25361061,1.34666133,1.07233441,0.88799530,-1.23687923,-0.40781614,-0.11916534,-0.88050151,-0.66422415,-2.61471510,0.78276747,2.42323995,-1.70715427,0.71550035,-0.60298312,0.70491880,0.46175584,0.80827898,-0.45108104,-0.98219043,-1.72823501,1.73190725,0.53906441,-1.50445580,-0.59250867,-0.07239901,0.44743437,-0.13740127,1.69935930,-1.00480616,-0.58191377,0.39853972,-0.60960841,-0.45473522,-0.76396072,-0.31872150,1.74509728,-0.59950751,0.89810580,-0.81400329,1.14280319,1.11165059,-1.31295311,-1.60784578,-0.87506992,-1.13461006,-2.09486437,-0.16449419,-0.37728927,0.47595578,-0.55342919,-0.17574213,2.21499181,1.14331865,-0.14938518,0.18935619,-0.33802557,0.52538890,0.82673949,1.16562462,1.24713838,0.98890215,-0.64991701,1.49886703,1.97769642,0.08059916,-1.60925281,-1.23822486,-1.40829837,0.51331180,-0.29928651,-1.04348791,-0.39911583,0.69380492,1.54516888,1.22791195,2.25008130,1.33348894,-0.21775827,-0.71937007,0.54982573,1.70691478,0.32459491,-0.57187974,-0.21614684,1.08274269,0.41384646,0.24497485,-1.43703413,0.89616930,0.82032162,-0.24598582,0.84271127,-0.81894702,-0.01828136,1.70397091,0.39505738,-0.51221430,-0.87979966,0.10795479,0.45194778,-0.76008922,1.23394477,-0.56798172,1.06459570,-0.44333413,-2.40399075,-0.37267187,1.42946172,0.95734519,1.86127949,-0.15217264,1.68742633,1.97638428,-0.44211119,-0.98393327,-0.54173928,-1.72017395,0.74697793,-1.77827263,-1.92299354,-0.17189410,-0.48633271,-2.21230388,-0.45906609,-0.53493047,0.37253976,-0.56951141,0.07728028,0.03530006,-1.18123293,1.94158125,-1.55930352,0.69334733,-1.95163214,-0.95800400,-0.01804711,-0.56747472,-0.99099451,-1.52853060,-0.98279524,-1.67307866,0.96121490,0.35654056,1.74034202,-1.44633865,-0.27781928,1.79457986,-0.41029963,-0.76871634,0.36555341,-0.77664107,0.19535238,-0.76185411,-0.19828433,-0.88820636,0.63885397,0.11346363,-2.50265074,0.16319332,-1.01288569,1.86605489,0.89761645,1.11795115,-0.00714116,-0.89034635,-0.76447034,-0.18822117,-0.48340848,-0.99788517,1.02172959,-0.39395007,0.72566581,-0.81438208,-0.71715081,0.96243578,-1.36424279,-1.13870537,1.17602491,0.16320205,0.71959788,1.66669416,0.55690295,-0.28912008,-1.19219172,0.23308393,-0.37963116,0.45347008,-0.42606446,1.30938649,1.25128853,0.57649273,0.34440875,-0.23893952,-1.06604803,0.31336102,0.75727910,0.46772480,-0.37650385,-0.06036821,1.03686309,0.46158856,-1.81028461,1.43393028,0.85494965,-2.34685564,-0.17571987,-0.45592231,-1.31190526,1.73194158,-0.11856517,0.07041293,0.25689471,-0.56000596,2.06649089,0.38954756,1.36627376,0.13905638,0.77370811,0.43944249,-0.08798827,0.07245751,-1.30234015,0.29710820,0.74389762,0.11971968,-0.07381748,1.32652700,1.34079397});
    NDArray<double> input2('c', {3, 4, 4, 5}, {0.98114507,0.96400015,0.58669623,0.60073098,0.75425418,0.44258752,0.76373084,0.96593234,0.34067846,0.57962620,0.77517051,0.97472977,0.79237527,0.68690428,0.21719366,0.79959206,0.84814187,0.22496814,0.08646965,0.31110474,0.79813162,0.19661444,0.57760099,0.72138960,0.15244268,0.87687051,0.11130344,0.01087698,0.34817841,0.54992017,0.23443850,0.31725614,0.59755220,0.20364695,0.00531392,0.23403114,0.07442912,0.83707647,0.89291743,0.09044587,0.69041462,0.29904183,0.61904680,0.85306847,0.34467042,0.95839152,0.54517124,0.29640937,0.94855959,0.95970016,0.94045145,0.95510301,0.34666505,0.34717010,0.69245678,0.71669175,0.59043738,0.64924132,0.06033522,0.60185199,0.04690073,0.59241154,0.40229547,0.23002481,0.45161195,0.73743778,0.93209113,0.37294358,0.50177744,0.15072501,0.26146917,0.05252146,0.04758931,0.76448288,0.85149045,0.08840467,0.07692576,0.33180160,0.27241259,0.74834620,0.56453640,0.23057286,0.68429752,0.11961551,0.39045977,0.44356094,0.77018807,0.07984410,0.47926806,0.26165759,0.18606064,0.89972877,0.17962874,0.47273120,0.64641705,0.61890443,0.58730015,0.25937832,0.35231561,0.10243882,0.17459193,0.95906995,0.09227025,0.30003223,0.41601210,0.38269713,0.84799751,0.59295173,0.76277990,0.68910424,0.37672606,0.40675461,0.94346058,0.91438505,0.84728183,0.64367667,0.74899979,0.60570691,0.16417363,0.68852426,0.85486889,0.22585792,0.86953176,0.07465519,0.93096301,0.38008822,0.38752587,0.44004038,0.13170612,0.94541045,0.89349973,0.69245307,0.94978877,0.98776658,0.79445884,0.30607409,0.58264961,0.37980538,0.41810784,0.48903038,0.51615888,0.57682794,0.82481897,0.78341080,0.48446465,0.17447931,0.71125424,0.30263851,0.70675352,0.03215584,0.92381065,0.22343694,0.08851149,0.91402490,0.70074717,0.30912192,0.37723206,0.97579397,0.23554587,0.95939133,0.41565709,0.01741416,0.58362787,0.22106662,0.89065537,0.31900249,0.41280911,0.67947610,0.04545590,0.15352812,0.85412524,0.84933222,0.80000225,0.93147073,0.70094105,0.69269875,0.95282194,0.65913582,0.79186874,0.59855248,0.39707430,0.95126239,0.15618217,0.33446689,0.98123758,0.84770758,0.98081012,0.54427413,0.18728519,0.89792955,0.53360126,0.72812986,0.13307744,0.51217443,0.66708084,0.29416915,0.31298995,0.39155037,0.29288291,0.87063305,0.61759154,0.73723332,0.37167635,0.82122716,0.22937430,0.76570536,0.47911792,0.02826214,0.94277323,0.59945469,0.19042060,0.68173155,0.82771295,0.95649538,0.40833101,0.90838542,0.55245881,0.49011012,0.36773444,0.34513527,0.42050683,0.16113964,0.30969388,0.27174174,0.12117655,0.35270175,0.81967867,0.63723136,0.84309389,0.71822576,0.84883484,0.32306117,0.08176457,0.56175486,0.34892198,0.09306929,0.85437582,0.13925577,0.48629188,0.29923539});
    NDArray<double> exp('c', {3, 8, 8, 16}, {5.98743296,-2.83037376,-0.87943113,1.41339970,1.32433391,-1.20299149,-0.02893090,2.05326009,1.19417048,5.58212376,3.28139353,1.19237995,-1.09431255,-2.55264497,3.11014652,6.81296825,-2.09029293,-4.32068443,-0.52808392,-1.97968531,-0.18673831,0.84605980,4.55825520,2.71503139,0.15210046,0.85310984,-3.82062817,2.76470995,3.69004202,-1.45017099,-2.59361267,-1.35094655,7.24145126,-5.25432396,0.19920218,-4.30596399,1.35318923,-3.88142037,3.67493343,2.25931478,2.87630725,1.66349852,6.21347952,0.94105923,-1.61742055,-2.35699606,0.12850338,1.79141688,-2.09535933,-6.35418081,-0.06303531,-4.38615131,0.48237842,0.26528549,3.38231516,3.76315165,-0.40254810,-0.23716694,-6.13381910,-0.41950428,-0.89680839,-1.46491277,-1.98541689,-0.99357355,5.58237648,-2.38937521,-0.00872564,-2.37138414,4.91117287,-4.51916361,0.97943687,2.91052818,-2.50362611,1.70252812,5.04137802,3.57108784,-1.87532270,-3.66677809,-2.38861251,5.55765152,-7.27571774,-1.68887305,-0.72266489,-4.42809057,-0.92118186,1.02381468,4.44284725,5.17150497,-0.42438728,2.02693963,-1.36484981,-1.47912180,0.26649538,-0.02091765,-2.86906910,-3.03046989,1.35122132,-3.21707630,2.21112418,0.24121630,3.96940088,-7.66105747,2.76352382,-0.99061489,-2.16720009,-1.63170409,1.12701774,-1.02415371,-0.90435314,-1.51372027,-0.76884907,0.39066136,-0.89562428,-2.03204703,1.28074932,-2.14551091,-2.36843777,0.46580017,0.75451565,-0.00336730,-1.06597757,3.27195978,-0.41307712,-0.10376054,-1.34102952,-2.22901654,2.31929803,1.40851438,-2.23774385,0.20417206,-1.12153268,-0.13188094,-3.96649432,2.10269976,0.49845099,6.18937683,-0.51783508,-0.48048639,-1.92970264,3.16670656,1.13355756,-0.07890664,1.31536257,-0.43924797,-0.04562932,-0.87974954,0.75411212,-2.39745235,-3.97132111,0.37202546,-2.40399146,-1.50796390,-3.08302689,0.23075986,-0.94316757,1.34948587,0.58591264,2.18529797,7.97652435,2.32798409,-4.09404373,0.89634895,0.77697754,-0.65091681,-7.05506849,5.86194515,2.51394033,4.69959354,0.20835471,3.18049693,-1.29682434,3.70832396,-0.48123091,-1.67904007,-1.35418940,1.58435583,-1.13851106,-1.19225955,0.59713769,-5.80462933,-7.45143986,-1.08658695,1.03244078,-1.75307107,-7.07100582,3.85825157,1.62127817,2.32572675,0.56171900,-0.80591971,3.98835945,0.15742642,-2.97832179,0.13821673,-0.72556758,-0.84936106,-7.28444147,3.94134307,0.80779338,7.47784615,8.23335075,4.80595016,-4.89574575,4.03362942,-6.67522192,-4.55204487,2.12511182,-2.70781207,-1.57226098,-3.08408356,-0.30812448,-5.32870674,-5.13238287,0.49605465,-0.55042171,0.46324944,-3.83545256,-0.12562510,-0.20978995,-0.13068712,-1.92144060,-1.68787408,5.45581436,-0.79583496,-2.38866687,-3.90546346,-0.47028148,-0.14319679,-3.37016582,2.00905991,-1.21345615,1.81376505,7.73004007,0.74310112,-4.64536428,3.78111577,-9.05182457,-0.10674095,1.53476238,0.63345337,-0.40907967,-1.44729769,-1.87145400,-2.46623540,1.07472968,0.77390999,-3.93438888,4.49174690,-0.96686655,1.92278123,0.30049133,-0.02388665,-1.99777114,-3.23885751,5.87784004,2.13776040,3.56758308,-3.37774134,-3.67526293,1.63700044,-1.69959962,-0.99112594,6.03103638,1.67399430,-1.28699589,7.16759014,12.63490295,3.62937450,-4.75982571,2.17861104,-2.03065681,4.30207729,-0.46797156,-2.96022511,-6.02702332,3.09229851,-1.39771092,-0.03471333,3.22175527,5.63565636,1.78195477,-0.63545251,-3.99497652,1.46043062,4.60050488,-2.96651959,-2.03159475,-1.52386189,-0.15129802,-3.90390921,-0.63852370,0.79210538,2.35288715,-5.55609035,5.36427498,-0.60248077,-0.26181316,5.04884720,8.53192806,5.05080223,-6.56371737,1.52260923,-7.13623667,6.49414349,2.33445597,-4.11490965,-6.44347477,-0.47079402,-0.63467920,2.60399365,1.05958164,3.66901422,-1.05657935,1.88611507,-6.37475634,2.01480770,3.36020517,-5.11001921,-0.46132171,2.16525555,4.21938848,-2.08346295,2.86168146,1.26987600,6.76066971,-7.84916353,4.11700916,0.47985530,-4.60113716,7.42062473,6.37472820,4.37820530,-7.12197018,0.01357239,-7.90392113,8.32131577,-0.87593079,-0.16994858,-5.86345863,-0.20697471,-1.37845206,1.63819647,1.59720242,-0.74357712,-1.88725603,-1.98357940,-8.57950306,-4.10104513,3.57231879,-2.89855957,-0.11263305,2.78033924,1.53078973,-2.93089223,0.73189604,3.20563078,3.92601013,-5.21916151,0.89163935,-0.42978728,-6.70888853,4.56477976,1.20105875,3.83393812,-6.27205181,4.05993128,-7.35513067,1.60660768,-1.21052051,1.58191252,-1.37899971,-1.20117283,2.93301678,1.06302834,1.38993621,-1.66884089,-3.34452581,1.04498529,-4.10412455,-4.03310585,1.61513603,-1.09388447,2.11451387,-0.94192362,-0.23287666,5.88265705,-0.83010495,-2.15317154,-0.60276151,-1.49265075,3.93397975,5.45194483,1.45161700,-2.57401872,-5.59288931,4.29170895,1.87151814,0.08362055,-0.28767288,1.17675185,0.85266006,1.30549634,-5.60830832,0.19398519,-0.83982587,1.75940764,-5.46077394,1.64495635,0.17102760,-0.54459631,-2.21975255,-0.37443402,-2.08474159,1.85959935,11.19680309,-0.18611598,-2.59765387,3.06330776,-1.52183700,-4.88415241,-0.75097847,2.58201051,7.40885210,3.58994508,1.62457407,3.12514591,-4.36833286,1.39830995,3.61003447,-0.63837433,-3.62661815,3.78898096,2.92802262,5.87374496,-4.38554621,-2.53411579,-2.87311554,-1.31391978,-4.26736879,3.45099425,1.58769250,1.73341393,-1.08842182,2.27120280,-1.78938174,-2.29940319,7.07046986,0.51426595,-6.22928905,5.28968811,2.31827855,-4.20915890,-1.27249205,5.92120600,3.19458675,7.09252501,3.96577907,6.41484213,-4.66009521,10.00181389,0.51108456,-4.62243366,-5.18351841,2.12961674,5.10694027,7.29412317,0.15912467,-3.38902974,-4.01918602,-2.17383957,0.13118666,0.27872476,-0.92317247,3.51440644,1.84171486,1.03378081,1.30569839,-2.09583759,9.03952980,-0.55187917,-2.04549074,1.08294606,-2.65263700,-2.93977118,1.88909876,0.96043622,1.76579499,3.14314699,5.86394691,7.36944389,-7.04524136,6.68673229,-5.52591467,-2.19745898,-4.32036924,0.52971321,2.26268244,6.91575766,-0.94590527,-3.98923349,-0.12266219,0.24294075,-1.07783222,1.87989080,-3.57109427,1.61553633,0.42486978,0.75852054,-6.19481468,-3.80570698,2.39946675,-1.93851781,-5.42234039,-6.34092760,-2.52374983,-1.85044456,3.92693520,0.40042299,4.69742584,5.40483189,-1.02398944,8.89605045,0.64680403,0.89943957,0.76993859,-1.88244629,1.90714884,3.10836840,-0.17064989,0.84892416,-6.94988108,1.92141032,-1.36458397,6.39284658,0.45201308,2.58823442,6.33375788,-4.76916075,-8.45738983,-0.48962492,2.40652561,4.56602001,-3.34420681,1.86862195,-7.01420689,-6.94657421,-2.47419310,-4.61693668,-0.18822384,-0.36949772,2.01374269,4.11018658,-5.11564064,8.04294395,2.88567662,-2.87645102,-1.23238611,-5.91409397,-0.62205851,1.38689423,-0.01120412,5.25955677,-1.98474956,-3.72012186,3.00445986,4.99141550,2.97457719,2.70827627,6.04544449,-0.20756161,-10.87035751,0.80454814,0.33568168,-2.48132324,-2.84452009,2.63126230,-3.99351716,-7.39294338,3.62798953,-8.65815926,2.65992808,-6.98126554,3.09881067,0.67735767,-1.15946686,5.63180256,-0.17694545,-8.59651184,3.75297594,-2.35913754,-0.20330384,5.49958467,1.00861740,1.42849684,0.00062013,-0.11073381,2.15207863,4.07368469,1.14344299,-1.27953362,6.64699316,-0.73672432,-8.55606937,-0.19439441,-4.14319754,-4.69964647,-5.86446047,2.87106085,-3.42714882,-5.00668287,6.22464132,-7.72335291,4.05667686,-5.72637177,6.35073948,-1.29593158,0.00813985,3.63368607,-1.05764008,-7.88486052,3.73919106,1.41835213,-1.04935634,0.65119827,0.03547254,1.88996327,1.58701086,-0.56215239,-0.80187100,4.55604362,-0.67249978,1.41084409,7.86281586,-2.38301182,-8.50535774,-3.82098866,-2.40856767,-5.33439016,-3.34747362,2.69389009,-1.64118791,4.52447939,0.04468334,-1.48768258,-0.69848812,-0.71123981,3.66259432,6.10314512,1.37305343,-0.62758982,-2.99383426,4.20510864,1.48497128,-0.08954811,2.43872309,-0.59880185,0.37431365,2.45458341,-3.28401661,-1.94629693,-1.93975246,-0.26385683,-0.45814323,-0.18108580,-3.74811840,-0.29739976,-2.24116230,-0.28150487,-2.24421668,3.46930790,8.35415077,0.05562943,-2.81079793,1.10388446,-2.82245207,-2.98102283,-1.08132946,1.19089699,8.00183105,6.35385323,3.72591257,4.59467506,-5.74890900,4.42238331,-3.36533451,0.18350232,3.05606651,1.18788099,2.87450886,0.27472210,-2.80111074,-0.66314960,-1.96376896,0.75167024,-4.72056293,1.10629988,-5.00775242,1.48246133,-3.91681528,-1.86573625,-6.17714882,-0.67820001,5.69730282,1.04399037,-4.93794823,3.09619617,2.18692017,-5.54232264,-3.10046840,-0.68972743,2.81824327,3.04334164,6.13203907,4.14081764,1.02573645,5.71970081,-6.01574707,-2.07346702,0.99554527,1.69641590,0.66776669,-0.80132431,-2.03513098,-3.42513680,-0.06704485,-1.87195873,-5.42428589,-0.20748445,-1.52408111,0.97084987,-0.48799962,-0.45379883,-0.26652339,-1.20720732,3.94169855,-3.18480229,-1.87440264,-1.18028760,0.52011997,-2.13437462,-4.52583313,1.69722807,-0.89371562,3.37972403,6.38838720,6.98663378,-4.05421400,6.89512825,-5.09085655,-2.16257906,-3.33272719,-3.01246452,0.37613097,1.80455804,-0.36456174,-5.32273912,-1.29978943,-0.53685790,-2.12896323,2.55506587,-2.57999182,3.40891910,1.36033249,0.83864629,-2.88629293,-7.36048365,5.61314154,1.32668555,-2.58041072,-3.71943092,1.60647738,-2.74816346,2.47269106,0.85507953,8.39183426,3.42624784,-0.01519036,5.68412066,2.51771593,1.03045523,-2.08733034,-2.44337177,0.81668580,1.30275154,2.99679208,-2.91957355,-1.71337795,3.34979844,1.51825011,5.20375061,2.27888370,1.38787699,4.23474550,-4.05878592,-4.85074377,-0.22794735,4.64402294,1.24391258,-2.04935098,1.26285601,-7.51862240,0.62138438,-1.95792389,-0.96587181,0.85141110,0.79354531,7.93766356,6.07677746,2.05947518,6.55480623,1.44032848,-0.70615625,-0.07896036,-5.08359432,-0.01047915,-1.89632201,2.57555676,3.83779287,0.42850614,1.80754125,-0.06942326,6.35997963,6.06101418,-0.97032297,5.71477222,-6.06671238,-3.46607208,-4.98306370,2.84659123,-2.11025190,-0.04609144,5.26831341,-9.56940651,-3.67193556,-1.71143103,-1.35221267,-4.26226807,-6.89146233,8.21761799,5.69823503,2.28137946,1.88911343,-1.44562483,-1.60295713,-0.52568185,-3.31892347,-2.81997776,0.35287106,2.98202395,-1.39432132,-2.70001364,-4.14169264,3.50194883,4.12610435,5.52755260,2.65859175,3.61353087,-0.83027136,-5.10652542,-4.48625374,2.06585884,-2.76383352,-0.64300913,8.19686604,0.96106279,2.45952058,2.47275925,-1.03288829,-0.64897656,-3.77937531,4.27940083,2.58320260,-0.57665241,1.87247813,-3.81604433,-0.24543774,-1.62118483,-0.73075479,-0.48533297,2.05016756,0.45561486,0.03316188,0.77791005,-1.56283605,2.36616826,5.58082104,-1.30925488,-1.06329608,2.17189479,-3.43008828,-4.71520567,-2.56184673,0.17508316,-3.25817418,-0.41749167,0.18119079,-0.73181152,3.99792433,-3.08002281,-0.99143314,-1.83520067,1.18565679,2.98040128,5.67814350,2.35128760,1.41600966,4.02718067,-0.08193968,0.64636409,1.35931289,2.37125754,1.75978124,3.90977740,1.50662971,-2.84089065,1.29824126,-3.38730979,-1.61005294,0.58292413,-0.03019404,-1.57986510,-0.56102908,-3.03128719,0.51644313,-2.01147819,0.98400700,3.00028515,0.74579155,-3.37098312,0.93339360,-1.29018497,-2.14695001,1.30411184,0.71501279,7.47793055,4.06516457,3.50772929,3.52762985,0.55643129,0.32272506,-4.30955982,2.49414706,2.07820845,-0.34377906,4.39805031,2.77561307,-3.91292810,2.43981409,0.18861845,-2.76658440,-4.97148752,3.25273705,-0.08929539,0.19818619,-5.83767605,-0.97381884,-5.68745661,-5.42433214,3.98769903,-0.40394354,-1.83387578,-0.80109525,1.47454357,-3.14899540,0.80130816,-2.26348829,4.06121159,6.13077354,5.31226397,2.94966197,-3.65217376,-1.08136678,-7.14119816,-0.85269439,-0.70365787,-0.81598872,3.62807679,3.08123684,-7.82739496,4.07951784,-0.14204243,-0.66969109,-5.07225513,2.88492823,0.47202343,0.72683257,-6.84280777,0.41807127,-5.09785986,-3.74514675,2.03936672,-1.06096244,-1.52409148,-0.97046643,2.27491093,-1.55597985,-1.29215479,-0.79737484,-0.01979581,7.65407991,5.54527044,4.04147148,-2.64274883,-1.89246953,-3.89547634,-1.06029689,-2.85982800,-1.41247237,1.55836034,3.38194537,-2.97655582,0.87510300,1.26282072,-1.77029657,-3.57144690,-4.19456863,0.53179169,-1.42221975,-3.09144497,-0.84294832,-5.02758694,-2.68011904,0.89156240,-0.34783912,4.64484835,-2.34453487,-1.28573155,0.09990287,0.01828218,-1.79960847,-1.06579173,1.08763921,0.43687880,3.24747229,3.83097172,1.07253766,-1.33810723,0.76530832,1.58660865,5.60743904,-3.54124737,-0.89264417,-3.83942485,-1.03707337,-1.61659896,1.65349591,1.72698796,4.96013832,0.78927267,-0.35563886,-3.48121166,3.79677629,2.59023166,2.74940348,-2.17589283,-5.91757107,2.43766379,-4.15906048,-1.74731481,-2.49113035,-0.57349741,-4.04455185,-1.46939647,2.21418452,0.09153593,2.23016739,7.91880608,4.04464149,0.07706618,-2.41892862,-2.19280314,7.61760712,-5.89153862,0.33551922,-1.70855618,-0.30561331,-0.14341974,-2.48878574,1.31269515,3.45388412,-0.02453184,-0.12132037,-4.27916241,1.25179088,4.09455204,-1.83801770,-1.86743176,-4.02864933,3.44515228,-4.39244986,-0.56988084,-1.69426417,2.18254852,-4.78135824,1.73193693,-2.27968478,-1.49523509,2.51696730,4.03677559,-2.03679037,1.32167840,-2.22570705,-2.74843621,6.29655170,-3.67230225,-1.86765468,-0.14842367,-1.21552539,-0.92038238,-0.51692355,1.08433771,-0.01929832,0.15660909,2.31432915,-3.86507082,-0.69797570,0.13505173,-1.50951028,-0.69980979,-1.51297045,3.63725281,0.13388813,2.73131752,-0.96528149,4.92000961,-5.92699385,1.69444644,-1.17121375,-2.33710480,1.35302818,1.39608085,1.68293881,0.94960749,1.89011908,-4.08865070,0.13722643,-1.62849212,-0.19044125,1.37906075,-3.92504406,-1.45033538,-0.42085981,3.38237071,-3.06508875,-1.39420545,1.13067436,0.92206454,0.49917889,-2.74508023,-2.19221997,1.77914095,0.10854459,-2.62178278,2.35042715,-0.15322030,-0.67014873,-1.75627899,2.64074945,2.76339936,2.67275214,-0.62736398,0.58251178,-4.64895678,5.50419283,2.53566456,-2.44196153,-0.07845879,-2.80389643,-0.64810950,-0.05813205,1.67155504,-2.69673729,-1.72486305,-0.53888649,1.86805439,-1.37128329,-5.37923479,-2.08133769,0.58187997,-1.39498150,0.21874082,4.33726025,6.29673958,0.72312093,-3.32683516,1.73482585,-0.00766110,-2.63785434,-0.13511759,4.07195950,0.94139838,3.15717316,1.53720927,1.87664819,-2.33655119,6.18176556,-2.73912525,-2.45279956,2.20392370,-0.56854641,0.98915887,-2.64472580,2.40633702,-4.93327999,-1.28942823,0.98247659,1.31774998,0.07669818,-5.91169453,-0.43135011,1.27404964,-0.59787154,-0.22716975,0.74409103,10.27316475,-2.29192710,-2.19403267,3.78925133,3.19553399,-4.42490482,-0.80781460,2.16568565,-2.54165983,2.54885101,4.18779039,1.73079813,-1.48891807,11.60153770,-0.98686743,-2.88813901,2.32898521,-0.36101711,2.34522438,0.29057693,1.39800644,-4.31848240,-3.21217132,0.11740226,-1.21613467,0.57248503,-4.44853830,1.54665899,3.14459944,1.76809108,0.26693153,0.86913753,9.47121620,-2.07677889,2.08578467,1.30181742,1.58683562,-3.52757788,-1.32763624,0.79821301,-2.19358301,1.17707348,6.01983643,4.11209440,-2.04209709,7.00413418,-1.84904683,-1.32542288,-0.01298118,0.70377320,0.27815005,2.07879829,-0.71606725,-4.94399881,-2.11898828,-0.39051518,-2.21034360,3.05337906,-1.56889665,1.97065282,2.61320901,-0.34063196,-0.57001418,-2.13183641,3.48879004,-0.12067288,0.48568326,-1.81424558,2.28868723,1.44802380,1.25918829,-1.76415455,5.35742331,3.50682044,4.71371317,5.89110756,8.51241302,4.07391453,-0.05887252,-0.18202400,2.27119660,6.78274727,-2.87470293,-5.14336634,0.76443815,2.04625130,-0.43199503,-1.01353514,2.42951298,2.35641170,0.32345510,-4.04195738,-4.77967072,0.26564783,6.11455107,-2.53868008,-3.11839914,-1.04203856,5.17195654,-4.15338612,-3.84149241,0.48130888,3.09706950,-4.18423653,5.26233864,3.55831861,3.75122595,8.14969349,6.80038738,4.68907356,-1.40135396,-3.19287133,-3.15895939,8.77363205,-4.48793411,-3.80537176,-2.40145254,-2.74341679,-2.02862644,5.33402443,9.25365734,2.50246119,0.32847846,-1.50564361,-4.26163197,-1.40994716,2.50708485,0.44500345,-0.62516934,4.09846306,5.29355669,-4.02224922,0.73442125,0.46648952,0.67028689,-6.30715466,6.56297970,3.80854273,-5.19078207,4.98839283,7.59161472,0.46010983,-2.10227895,0.29324162,-2.67019558,4.57838106,-3.02338457,-3.08647728,-2.00112700,-3.81710315,-0.08346784,1.69288683,5.68807268,3.29351830,0.54618967,1.83540761,-5.38810253,0.51326782,4.40081882,-4.03805828,0.49482727,-1.36024392,2.91845679,-2.00959015,2.47489738,-1.43354976,1.92024410,-6.55897284,1.79488957,-0.89570928,-6.13094234,-0.45504010,2.35239482,1.29039919,-4.78849840,-1.52545333,-6.50420475,2.99257326,-0.55620033,0.26807702,-2.52090979,-4.59419632,0.57965040,2.19423151,2.04760551,-0.57048106,-2.20812702,-0.04777686,1.38053393,-2.71448946,-1.06219673,-3.62008905,1.85719645,1.28355026,-2.76315832,1.65295160,-4.01645803,-3.10454416,-0.65713316,1.22384977,-0.70416176,4.45064926,1.31602776,2.06907344,2.48872757,4.25775290,3.50504255,-0.68262041,1.29799378,-1.01969171,2.98593879,0.12607655,0.37219539,-0.84196299,-3.80019331,-1.82315290,-0.38489276,-1.45200360,-4.00882292,0.61042011,-0.16738498,1.33787775,-2.26938057,1.03656030,8.89089870,-1.60370600,-5.38691807,5.72182989,2.72854710,-6.18535757,-3.13408709,2.79175353,5.18425512,9.46434212,2.40110517,1.11330092,-3.57366538,4.80967665,0.40691876,-3.65484858,0.92398167,2.53852940,3.17747331,2.14199781,-1.69107199,-1.91864693,-3.18452644,-2.42408276,-2.14332366,-1.35526609,-4.50732136,0.58234072,-1.81547785,0.57311213,1.10584176,-0.97226644,11.73174381,-2.00559855,-1.81175601,2.33131361,0.49264961,-0.42245382,-1.37528467,1.55768061,0.21152198,13.08896351,10.33674145,5.77929306,-6.19886398,5.67007637,-6.61288071,-2.58029866,-4.05192375,1.77221894,0.29821560,5.23508501,-5.09560966,-0.97536200,-5.17957878,1.02876794,-4.52072096,2.22126532,-4.81708670,0.44538212,-2.30738068,3.15900373,-4.99227905,0.82632786,9.65415478,-0.63819492,-3.25479436,-0.13276935,0.21337092,-2.22116399,-3.04922724,0.65568435,-0.10706246,4.58047390,7.80782652,5.49080181,-3.97114491,6.43327618,-6.54772758,-2.10962629,-0.79831678,-0.08316499,2.48658133,4.14070511,-0.59806836,-4.58636141,-0.31166920,0.31757897,-3.92562199,0.65357721,0.55871534,1.71843934,1.62395024,0.00695819,-4.56716251,-3.76420808,4.24979544,-0.86128616,0.23126510,-6.32968998,1.83346081,3.81335950,2.98407745,-1.80454743,6.61764765,-1.39372075,-0.86780751,7.24317265,2.24205112,1.05702817,0.55431479,-1.54557061,3.36389136,4.70898724,1.11327887,-3.78462076,-3.63381767,2.86510396,0.74203897,0.81488025,3.54250598,3.24824381,3.19000244,-0.58995843,-7.05670738,3.18306041,3.95191574,0.81820154,-1.91068232,-2.05426741,-1.05589008,-3.18377590,-1.86278260,-8.80374908,0.93416154,-4.60517359,8.38999462,5.26356745,-8.89992714,8.95298958,4.22590351,1.00351548,-6.90151119,-8.07641125,-4.82450199,8.02293015,4.11661243,0.95457208,-7.07843113,-4.30524826,5.02697992,5.21011686,0.80132771,3.23420191,3.82452774,-2.13171721,-7.88879967,1.31062031,1.90848613,-3.51572514,-3.75684500,3.62577081,-5.76075602,-2.79389215,0.32598805,-4.28981733,4.21048594,-3.84532523,3.19815183,-0.40756655,-2.19974327,6.25655174,3.42396951,-1.88986623,-1.92803884,-2.97344875,-0.09756154,5.24342251,-0.72513700,1.06113195,-1.30720282,4.69107103,0.58984971,2.33985567,1.46385121,3.16576266,6.77769995,-5.92685127,-12.61141014,-2.83663774,4.90253258,-6.32688522,-3.00096869,2.38634992,-7.21459866,-5.89208746,2.84085894,-1.21792030,6.70161343,-4.00450230,5.29881001,-1.45574808,0.77542424,1.38336325,-0.21572059,-3.38088870,2.33249640,0.68824625,-3.68440270,0.33481622,-0.39239681,0.14560902,1.61039007,-3.11967754,2.49372435,2.68783092,-1.17559779,0.95257235,4.35451412,-0.56818569,-7.32110357,-7.58534050,-2.10573673,-3.34446383,-0.32183546,-0.78525496,-1.76974547,5.19060802,-2.11319876,-3.41755080,-0.36864156,1.32680905,0.45004874,6.17223930,-1.60707474,0.46096295,-3.88852644,1.84729624,-0.03412050,0.99224162,-2.05553341,3.47793245,-0.06305170,0.51314175,-2.91650558,-1.78121483,-2.85465693,0.24649808,-2.70376635,0.42334458,-1.13862336,-0.98409218,-0.96593523,2.22128963,0.53402066,3.33979344,8.57430458,2.34217858,-2.40062976,5.81624222,1.13290989,-5.06850052,-4.72865725,1.82859278,6.78569555,8.56885242,2.76462936,0.33891773,-2.81092787,0.79498398,-2.27208567,1.55182552,2.17166376,6.12517643,3.56859684,0.27685475,-1.38408327,-1.03533340,-3.46618199,0.79240030,-3.89390516,-0.55852515,-1.16367757,-0.07008934,-2.20105195,3.81210446,-0.66834474,0.43603873,10.92334938,2.48571420,-6.34997845,4.23135757,0.45045292,-4.13489866,-3.92324209,1.88537407,2.57159734,9.90973091,4.37453461,7.34546280,-2.51120615,11.12575245,-3.23452854,-2.49947500,1.39819741,-3.78950691,2.40617585,5.10036278,-3.55743456,-6.42888737,-2.51929998,-1.90880990,-1.81618094,1.60946512,-4.09737110,1.96408439,-1.90115595,2.44444203,-2.31254292,-4.01332951,8.65541840,-0.58626485,-4.02226830,0.43893200,-3.78272748,-5.46277428,0.01306701,0.61185312,0.24469066,1.30214953,5.87789631,8.75197792,-5.31634712,3.43556309,-5.90755081,0.54375106,-2.48162293,-3.51843548,2.55853295,5.06387186,-2.09662485,-3.00377345,-3.21781397,-0.14537808,-4.65453672,1.92747557,0.41553855,4.09379959,0.83387995,1.50868511,-6.54959488,-8.38881016,5.50689125,-2.88616610,-1.21597648,-0.23817590,1.50816703,-2.26873541,2.29862142,-1.61143053,5.97371244,4.71440220,-0.20635787,8.85926723,0.56064367,-1.04103339,-4.47060108,-2.63824081,3.06782055,-2.07702565,3.38269401,-1.59988797,-3.80122590,2.35341501,2.69095278,3.87612104,1.89984226,0.95496917,3.14841127,-5.84543085,-7.24945450,-2.65708590,2.87417006,0.97556210,-3.75203967,1.55287778,-7.43401051,-1.29005826,-3.40252638,-4.01049423,2.82721639,-1.21479535,8.54563904,7.39749908,-0.61361837,7.60177565,1.65812778,-0.83008504,-3.60961151,-7.69062138,-1.26275063,-4.17071676,5.28448200,4.04685593,-1.18231702,1.15276611,1.58620787,6.75060844,3.29332161,-0.67640316,5.78984785,-3.14913464,-6.41867924,-2.58316016,-2.04366302,2.01089478,-3.81723452,3.63843751,-5.13238430,-3.79432917,4.86581373,-1.06922054,3.95978498,-0.78166616,8.35650539,5.35834265,0.35594034,9.41657066,-0.84108615,-6.54425859,-3.44328952,-6.55536795,-0.08963367,-1.53906262,0.17658240,-0.13108420,-0.44371247,-0.78411150,2.64754868,9.66306782,1.70506203,-0.31588936,4.31715870,-6.16665173,-10.43371868,-3.72962189,4.35245228,-1.75867891,-4.20046234,8.62637043,1.45946813,-3.30153608,0.85179043,-2.66643381,3.01863337,-2.52916121,8.35405540,-0.37298933,-0.89473486,6.88681793,-4.46370125,-7.50776386,3.80255938,-3.55003357,1.43528831,-2.20383263,2.34999895,2.03803205,1.94830751,-1.85976326,0.97718471,5.53710842,-0.80560827,0.23925614,5.98795223,-2.03578377,-7.77835321,-2.79955530,-1.88185954,-2.49112058,-0.76095992,2.71161270,-0.55918610,0.83789903,-1.42063200,-0.61528748,-4.18273115,1.76384258,4.21265936,5.50964785,-0.93324339,3.83215356,1.52210593,-0.91594946,1.31148386,3.20160103,1.24493563,-0.72693497,1.84716725,3.09897518,-1.34605026,-1.17511916,-1.05526352,-1.08590937,-1.41319299,-3.75052118,-2.67095542,-0.76179552,-3.32081509,-1.04692316,-1.30194843,-1.98795474,5.01223469,0.21895903,-1.85535169,3.12362719,0.16198632,-3.86784005,-2.03062248,-0.15415624,8.22020721,4.83055592,4.50315666,4.19443417,0.42727345,-4.67786789,-5.18739986,2.53988838,3.19683266,1.80313504,1.94664574,0.59795094,-4.21626759,0.50492239,-0.41232634,-0.99224532,-3.94929314,1.74060190,-0.92474866,-1.00664830,-6.17397356,-1.33146775,-3.78111315,-4.91876888,2.50303864,-0.34890354,-1.25013232,0.38168997,-1.84135628,-4.46107960,-4.05920792,-2.61709857,0.71046209,9.80566883,6.34086990,2.73394704,-2.03342366,-2.21424174,-5.56514263,-4.74755144,-2.20672894,0.09010231,1.70423889,3.19200158,-6.99027634,1.14216340,0.05824995,-0.76996505,-6.51575899,-0.41109252,0.78229940,1.36170781,-5.65170193,1.12221193,-4.60430050,-4.40174437,4.01805925,0.10774946,-2.77991009,-0.18023163,0.02151692,-1.77023101,-1.86639869,-0.69443607,4.92290831,6.83520412,4.27372265,6.54272366,-7.59249687,-1.40776849,-3.52368808,1.01398587,-3.58802676,-0.35658866,1.14716864,3.75847244,-2.30159235,-0.72130895,-0.24564353,-1.77531350,-3.08677864,-0.73486501,-1.20357263,0.60789430,-3.46990204,-0.20668676,-5.46096087,-5.22016764,0.98259866,1.81012678,3.92534304,-2.94997001,1.65154219,2.27040243,0.99095678,0.09144652,-0.99103236,-1.11210847,0.78181303,2.38706732,2.96695375,-0.17279971,0.31143007,1.35465562,2.03586054,6.19515753,-3.14652419,-2.89027119,-3.26665854,-1.93043876,-0.46601450,1.07655203,1.74946189,4.02148342,0.69275337,0.50094581,-4.07613230,2.98369169,4.24537849,0.49480581,-2.02408123,-2.02068973,6.54505825,-5.19377470,-0.12596917,-0.70204186,-0.98308045,-3.19708824,1.63609934,1.35475993,0.16313422,4.13918924,7.69187021,3.72601676,-1.97790039,-1.16739464,-3.31835508,8.14553452,-1.78718984,1.21505618,-3.84255409,-3.21992350,0.07376552,-0.81223297,3.57002878,1.48521733,-0.45995998,0.30551746,-3.33944130,1.39538884,1.84758544,-0.21494150,-2.27316713,-4.37771225,6.48841667,-5.00251961,-0.45162797,-5.01056004,0.70199943,-4.60057783,-2.22394514,0.07777429,-1.49820781,3.47308421,6.13231564,1.18605387,-4.78924608,-3.49548388,-2.73382568,6.24617863,-2.74291611,-1.03833354,-2.20752788,-2.33219409,1.48633552,1.65796840,4.95045471,2.58479190,-0.90922785,0.71312457,-4.44465590,1.37020862,2.37683725,0.18805164,-3.28422308,-1.64939332,3.64181972,-3.75277281,3.67203593,-0.11204052,2.24140930,-3.90657187,2.56883717,-1.44016707,-2.83842611,-0.29104578,2.17757058,-0.71431804,1.36911654,0.85083604,-1.60110259,-1.97247636,-1.61163378,-0.81236130,-0.38993555,-3.03631902,-0.38213277,0.06394482,3.19348621,0.36771113,1.36763072,2.49159527,-0.39599860,-2.69996762,-0.97561121,-2.97563028,-0.49662948,-0.17564940,-2.79042959,0.72395414,2.07260203,-0.99439794,-2.20248008,-0.07389921,0.65536159,4.73054695,-0.63917702,0.58788192,-3.60156059,6.59609890,3.88419437,-3.38469863,-3.56237841,-2.03295064,0.07279694,3.71804547,0.79928309,-2.13411403,-1.13909864,-0.34193408,-1.00338125,-1.44231665,-5.39835978,-0.45086145,1.16064668,2.58335257,2.10072684,4.64244223,7.10090065,1.01974952,-4.44687223,2.99792576,1.10303724,-1.22736573,-3.91514421,3.07458854,2.18765211,3.34481716,2.46166849,2.99648619,-0.94046807,5.55028200,0.92199719,-0.83934361,-0.72042274,0.84869325,1.46914721,0.85937387,4.77306223,-4.06436539,-2.59847593,2.44828081,0.50484699,-2.71092367,-6.39010477,0.91778028,3.25469685,1.30310678,1.35258150,3.56171441,7.82435083,-2.51527429,-4.24328852,2.36876059,1.94595242,-2.59290171,-6.62389565,3.32567835,2.13659120,4.09299326,3.48293996,2.64965177,-3.19157362,13.37204266,-0.50297594,-4.57448196,3.95582604,-0.69038916,0.10098404,1.18737555,3.65761185,-5.69623756,-2.03357077,1.02868807,-1.38448596,-0.05690211,-8.48874187,0.56755424,1.45485961,0.66273880,0.06495565,1.79539490,8.46864319,-1.22696662,-1.87585378,-0.99768794,2.72801924,-0.66980243,-2.31924677,0.33271110,0.11666083,1.86980045,5.95332909,7.38583708,-2.80956483,6.79227638,-6.78070831,1.21884382,-1.40695429,0.90236962,-1.13695288,0.50760663,1.00955284,-5.39029121,0.24987072,2.24283314,-4.02145576,2.18057394,-3.35627747,1.26061773,1.30342579,0.11311233,-1.11199212,-4.06509686,5.82649660,-1.24059582,5.51652861,-1.90937877,1.10658336,-0.47065550,-2.39167786,-1.95931304,4.12717247,1.15396059,1.26015663,7.97836876,7.33633423,2.27785325,-2.83802366,-2.74850106,0.86126029,6.18781090,-1.43707538,-6.97134876,-3.25486469,-1.95214593,0.91066706,0.89637989,1.06481194,6.25791073,0.81779671,-1.08384395,-3.21191931,2.04216075,4.76030350,-2.37217665,-1.42571259,-6.35876131,4.62536526,-5.40060568,-3.14868999,-1.00587153,1.80662942,-7.03201485,6.08373499,0.99862772,2.21717811,4.06814623,6.02428913,5.33422756,-0.87013257,-2.22477579,-2.51505303,5.82925224,-0.82854009,-4.30698347,-1.75007713,2.08352375,-2.25235629,1.17517352,5.77717733,2.27472878,2.72778273,-1.95411634,-4.52602863,1.13983536,1.16340065,-2.02740526,-3.11290503,-1.94906235,1.54855204,-4.52984142,1.97465122,-1.79415476,4.03510094,-8.45349979,10.87430096,2.19863629,-5.39083815,5.86213875,6.25744534,6.52600002,-4.72149038,-1.75254321,-5.51459169,7.03155518,-2.01889277,-4.58441257,-3.61226106,0.42395937,-0.93263882,2.28703761,2.80611467,2.59498215,0.65989012,-1.51268566,-4.49465561,-4.70453882,5.44696808,-4.37603617,0.46670085,2.82488608,2.18854523,-2.04817152,1.19557285,1.53618634,4.44758606,-7.31593513,7.43966007,-3.55480957,-5.29834652,2.14622784,1.65194583,2.71262598,-4.86145496,0.79726243,-8.88541985,1.19627261,0.79660845,-1.98016644,1.03741014,-3.93128228,1.05535269,2.01378822,-0.46086323,-0.77754641,-1.43942690,0.49809402,-2.27861357,-3.29815221,0.38201320,-3.98481083,4.88261318,-0.44555628,-2.57224536,2.35001850,-2.65835261,-2.43422794,-2.97889376,1.07349825,1.88157082,4.74075413,0.60376728,-0.48894715,-1.15800071,4.68110943,-0.86976886,1.49192941,0.62665290,0.20652676,0.53916287,-1.45706177,0.66133004,1.34405875,-4.27689552,-0.20838106,-5.14266443,-1.29718637,-1.74506426,-0.86022055,-3.57553625,0.46880072,-1.25287139,3.28596354,11.33191013,1.23942876,-3.87616491,7.57880497,-0.22940339,-5.68512678,-1.94969654,5.85449600,3.75705457,4.24395847,1.60086083,2.62553668,-0.93964291,5.84753895,-0.79931092,0.48274064,2.07170033,3.02243996,2.63509989,-0.76043403,-1.64048159,-6.17683458,-3.09974527,-2.12773156,-0.89379883,2.82242465,-1.99981332,-0.08763933,0.01921120,-1.94142103,2.48067307,0.41083777,8.24922180,-1.84516132,-1.39224625,5.03956223,0.49562740,-5.28296328,-0.20005548,3.13672113,0.51187158,7.11563921,6.43059587,3.48430967,-5.37095928,8.03863049,-5.53923941,-2.16421175,-3.77641368,3.29633045,5.04030085,2.25945377,-3.04169011,-2.16198015,-2.49559617,-0.26252726,-6.99201345,2.87374353,-0.12568980,0.23314142,-1.32087135,4.39030552,-0.24638844,-4.37242651,14.09276772,1.23987353,-1.72249663,0.31124914,-2.13725138,-3.74915648,-1.87147236,0.47318631,1.13337576,3.00416899,8.82548523,4.80538750,-5.28486395,5.51870108,-5.15801477,0.95712411,-1.50416136,2.34657240,4.20726633,5.56757259,-3.30645251,-3.39945269,-2.68488026,-2.53525281,-3.15145874,2.74529529,-0.96283442,2.87778258,0.22186530,1.24905694,-7.07941198,-5.45916176,3.46988297,0.92430985,-0.98330998,-2.23672342,-3.03262734,0.73941302,0.98004431,0.83219361,7.17411804,4.27849865,0.14765590,8.61269569,9.04497051,1.53991723,-2.08305025,-4.34939337,0.63786775,2.60098696,0.02432060,-1.48516297,-4.06825686,5.12420368,-0.75312757,1.96927559,4.91575956,3.41533065,3.62557888,-4.35002136,-5.91343403,0.45026422,4.93286371,3.45830250,-4.39032364,-0.51697755,-7.41543341,-3.06703568,1.01196158,2.47106576,5.54014874,-4.65312243,8.61000633,8.25905323,-1.41497111,8.69221878,0.40090930,1.11325574,-1.67089832,-4.01080132,1.07925677,2.68086481,-0.73093414,-1.35081220,-7.85765076,-5.98989439,-0.04651213,4.63693142,2.07757711,-0.22652936,3.45525455,-0.69198442,-10.39761639,-2.02106953,4.77755499,-2.67665577,-1.72481167,4.49634743,-2.55717134,-4.55044937,0.46377492,-3.08933020,3.86891365,-2.79104614,8.36974335,0.86471701,-5.39342690,12.54906940,-0.41536295,-5.29502535,-3.94430566,-5.67391300,-4.65079165,2.22505951,-0.30000746,2.27855444,-4.81604433,-1.73440599,4.68784523,5.00208044,0.18863934,-1.74989462,3.17923450,-1.59773099,-12.59962940,-1.54495025,-0.00576371,1.79913878,-2.43449807,1.49516344,-3.90507102,1.68647158,4.50177765,-5.32286358,3.47539330,-2.90529680,1.61576962,0.83679676,-5.55615807,3.78939056,-4.46644831,-5.95550919,0.37808037,0.51334500,1.74658906,-0.82085419,-0.65387219,3.67790437,0.03758264,-2.42622781,1.83335185,4.73835945,-0.83536482,-0.03993917,3.78230667,-4.81265640,-8.26869011,-1.30363441,-2.09106350,-3.96769738,-1.89037073,0.38682747,0.05434489,5.72213697,0.55685395,-3.47729349,-1.11535001,2.09416127,5.08877802,5.72183466,1.29632664,0.16822398,-2.43180108,3.49967623,2.15753818,-0.26548505,3.24446392,-0.00599277,1.08215356,-0.23225522,-2.40723038,0.18496060,-3.70608735,-0.19918591,-1.64028871,0.80792952,-0.85334057,-2.52314138,-3.12099195,0.17949918,-0.82650864,2.32224989,9.56476116,-0.20134282,-0.48428559,2.86784410,0.07289505,-3.92880869,-2.11887884,0.59164631,6.31267452,7.49149418,2.88749456,2.40504885,-3.57608175,-1.48019314,-0.69410253,0.90275228,-0.34111357,2.19190216,3.39090061,3.39631820,-5.19105434,2.67546582,-2.56549048,-0.59797800,-4.21802664,0.63918972,-0.69969130,0.47496963,-4.30976725,0.16531238,-3.59595251,-0.76877379,11.79971790,-0.93276632,-1.48630571,8.04754066,2.09168458,-3.77018499,-4.19337654,0.26171905,1.99359691,8.96759701,8.39609814,6.19231987,-5.36037970,4.69818354,-4.22453928,-4.61665344,-2.52073431,1.34026706,2.80182385,2.56681514,-4.04676390,-3.01466990,-4.10480118,0.38737059,-0.37146521,-2.26529670,-1.72867084,0.93472683,-2.47562981,0.89871657,-1.67618203,-0.28950238,5.30124855,-0.14731219,-0.81319761,-1.11265934,0.11356127,-2.52802444,-1.93826056,1.06187987,1.48062325,4.28070498,5.69893932,9.26904392,-4.23773003,5.78582096,-6.18445301,-2.85200453,-5.30461454,-4.16009140,-0.07239690,4.11531162,-1.12266588,-1.50265646,0.47661865,-1.90043914,-6.48978710,1.71005368,0.18256521,-0.88272136,-0.51324779,-0.78045660,-5.21036625,-4.11805344,3.99454761,-1.04999924,-6.99629354,-5.02737141,0.94748145,-2.35882139,4.13982439,-1.41835535,7.56763077,3.97024012,-4.08156776,6.90305424,0.53571963,-2.22625160,-2.09144926,-4.98530245,-0.15102190,0.59995949,3.28562784,0.77991986,-3.08389306,3.34046674,0.41394949,5.10031366,2.99692893,0.17706826,2.85998058,-6.68330860,-6.72653008,-0.04071128,3.71085787,3.17834806,-4.88019037,6.74075413,-7.41782188,-5.22026348,-1.94595623,-3.61318684,1.85610664,1.08613706,6.41580677,1.46376514,-4.11524010,9.59146214,-2.92772651,-1.70753336,-1.51594138,-4.88185692,1.47331417,-2.23893595,4.98459148,1.29359996,-2.29221845,-0.99594390,3.05759239,6.86030054,2.40487719,3.28339863,7.72739315,-3.60563445,-9.73502827,-1.51672328,-0.08473521,-2.43673515,-3.26616001,3.63767886,-11.25394535,-5.17597103,-1.27523947,-7.82669783,0.67929745,-4.50530529,5.49323797,6.78993320,-2.28033876,4.61412525,2.55109429,-12.38607693,-0.63024014,-3.45992327,-0.84092742,-0.03252453,4.58635283,5.28213978,-1.28417206,-1.71185923,-0.26850975,8.28257561,4.47432184,2.72818279,8.42217731,-4.22216320,-8.95128918,-1.57179546,1.34253705,-5.47035217,-5.50866985,4.64156532,-6.11207914,-5.46734476,3.54298997,-2.79237103,-0.70766860,-3.62739944,3.22660995,-2.02262759,0.11224222,2.63832402,-0.91955596,-4.65958309,-0.29729855,-1.78957534,-0.40749407,0.51688713,0.83725226,0.30945438,1.20769620,-1.75219965,2.59689760,5.01501608,-1.59034789,0.58155286,3.75831509,-5.26110506,-8.65382767,-6.19066620,-0.61932850,-2.71863723,-0.87443137,3.40582991,-1.27868056,3.51236677,-2.07806540,-0.85076392,-1.14599180,1.16361260,1.86411846,5.86179352,0.69029891,-0.06060839,1.54649436,-0.60351688,1.51970077,0.04187265,1.64540339,2.75502157,2.46308279,1.69071770,-3.23827076,0.92096543,-3.09458661,-1.23823690,0.24035048,-0.74456501,-1.85476089,-0.32914662,-2.10325241,1.19795251,-2.05372071,1.02114081,2.56286955,0.42165697,-1.65826249,4.00724554,-2.18727994,-1.05848944,-0.52338278,-0.28714985,8.08780861,5.04444599,3.51866961,3.37445784,-1.96067202,-1.21509445,-3.96595931,-0.80801201,0.76944816,1.80147493,4.14419460,-0.12201095,-2.77788162,1.13284469,-2.05441403,-0.61129224,-2.69690657,1.91634214,-2.17146754,-0.22308528,-6.02561045,0.49161875,-6.74280357,-4.62689781,2.47910833,1.86534905,-3.24152899,-1.39898300,0.29427958,-2.16338181,0.90073711,1.75551236,4.42651892,8.34437466,5.50070190,5.68162251,1.65345454,-2.72315669,-5.43411493,-0.29380533,1.07508349,-1.73533511,2.56912184,3.62010550,-6.30422783,1.74158525,-1.22070909,-0.80982518,-4.14757967,4.29217434,0.70600843,-2.09282112,-5.09018898,-0.11623126,-5.99775553,-4.66743088,1.61512172,-1.30276895,-3.17103505,-0.26310229,-1.00843918,-0.77664804,-2.05240250,0.04728425,1.15720487,4.01001406,7.24615860,2.55452180,-5.76347876,0.34683830,-6.05540276,-4.70677900,-0.93182588,-4.37759733,2.93209839,1.63947964,-2.43563962,1.35213876,0.00670356,-0.02742785,-2.16460943,1.39449501,0.23929763,2.37476778,-4.17733765,-0.81475425,-6.15027046,-5.74441719,3.53978682,0.66798484});

    nd4j::ops::deconv2d_tf<double > op;
    auto result = op.execute({&input0, &input1, &input2}, {}, {7,7,  2,2,  0,0,  1,1,  1,1});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(0);

    ASSERT_TRUE(exp.isSameShape(z));
    ASSERT_TRUE(exp.equalsTo(z));

    //ASSERT_EQ(exp, *result->at(0));

    delete result;
}

TEST_F(DeclarableOpsTests7, Test_Conv2D_TF_1) {
    NDArray<double> input('c', {54, 1, 12, 12});
    NDArray<double> weights('c', {1, 2, 12, 2});

    nd4j::ops::conv2d<double> op;
    auto result = op.execute({&input, &weights}, {}, {-1,-1,  1,1,  0,0,  1,1,  1,1});
    ASSERT_EQ(Status::OK(), result->status());

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Dynamic_Stitch_119) {
    NDArray<float> indices0('c', {2}, {1.0f, 10.f});
    NDArray<float> indices1('c', {2, 3}, {0.f, 7.f, 9.f, 5.f, 8.f, 3.f});
    NDArray<float> indices2('c', {3, 1}, {6.f, 4.f, 2.f});
    NDArray<float> data0('c', {2,5,4}, {1.f, 2.f, 3.f, 4.f,5.f, 6.f, 7.f, 8.f,9.f, 10.f, 11.f, 12.f,13.f, 14.f, 15.f, 16.f,17.f, 18.f, 19.f, 20.f,21.f, 22.f, 23.f, 24.f,
                                        25.f, 26.f, 27.f, 28.f,29.f, 30.f, 31.f, 32.f,33.f, 34.f, 35.f, 36.f,37.f, 38.f, 39.f, 40.f});

    NDArray<float> data1('c', {2,3,5,4},{1.f, 2.f, 3.f, 4.f,5.f, 6.f, 7.f, 8.f,9.f, 10.f, 11.f, 12.f,13.f, 14.f, 15.f, 16.f,17.f, 18.f, 19.f, 20.f,21.f, 22.f, 23.f, 24.f,25.f, 26.f, 27.f, 28.f,
                                        29.f, 30.f, 31.f, 32.f,33.f, 34.f, 35.f, 36.f,37.f, 38.f, 39.f, 40.f,41.f, 42.f, 43.f, 44.f,45.f, 46.f, 47.f, 48.f,49.f, 50.f, 51.f, 52.f,53.f, 54.f, 55.f, 56.f,
                                        57.f, 58.f, 59.f, 60.f,61.f, 62.f, 63.f, 64.f,65.f, 66.f, 67.f, 68.f,69.f, 70.f, 71.f, 72.f,73.f, 74.f, 75.f, 76.f,77.f, 78.f, 79.f, 80.f,81.f, 82.f, 83.f, 84.f,
                                        85.f, 86.f, 87.f, 88.f,89.f, 90.f, 91.f, 92.f,93.f, 94.f, 95.f, 96.f,97.f, 98.f, 99.f, 100.f,101.f, 102.f, 103.f, 104.f,105.f, 106.f, 107.f, 108.f,109.f, 110.f, 111.f, 112.f,
                                        113.f, 114.f, 115.f, 116.f,117.f, 118.f, 119.f, 120.f});

    NDArray<float> data2('c', {3,1,5,4}, {1.f, 2.f, 3.f, 4.f,5.f, 6.f, 7.f, 8.f,9.f, 10.f, 11.f, 12.f,13.f, 14.f, 15.f, 16.f,17.f, 18.f, 19.f, 20.f,21.f, 22.f, 23.f, 24.f,
                                        25.f, 26.f, 27.f, 28.f,29.f, 30.f, 31.f, 32.f,33.f, 34.f, 35.f, 36.f,37.f, 38.f, 39.f, 40.f,41.f, 42.f, 43.f, 44.f,45.f, 46.f, 47.f, 48.f,
                                        49.f, 50.f, 51.f, 52.f,53.f, 54.f, 55.f, 56.f,57.f, 58.f, 59.f, 60.f});

    NDArray<float> exp('c', {11, 5, 4}, {1.f,   2.f,   3.f,   4.f,5.f,   6.f,   7.f,   8.f,9.f,  10.f,  11.f,  12.f,13.f,  14.f,  15.f,  16.f,17.f,  18.f,  19.f,  20.f,1.f,   2.f,   3.f,   4.f,
                                          5.f,   6.f,   7.f,   8.f,9.f,  10.f,  11.f,  12.f,13.f,  14.f,  15.f,  16.f,17.f,  18.f,  19.f,  20.f,41.f,  42.f,  43.f,  44.f,45.f,  46.f,  47.f,  48.f,
                                         49.f,  50.f,  51.f,  52.f,53.f,  54.f,  55.f,  56.f,57.f,  58.f,  59.f,  60.f,101.f, 102.f, 103.f, 104.f,105.f, 106.f, 107.f, 108.f,109.f, 110.f, 111.f, 112.f,
                                        113.f, 114.f, 115.f, 116.f,117.f, 118.f, 119.f, 120.f,21.f,  22.f,  23.f,  24.f,25.f,  26.f,  27.f,  28.f,29.f,  30.f,  31.f,  32.f,33.f,  34.f,  35.f,  36.f,
                                         37.f,  38.f,  39.f,  40.f,61.f,  62.f,  63.f,  64.f,65.f,  66.f,  67.f,  68.f,69.f,  70.f,  71.f,  72.f,73.f,  74.f,  75.f,  76.f,77.f,  78.f,  79.f,  80.f,
                                          1.f,   2.f,   3.f,   4.f,5.f,   6.f,   7.f,   8.f,9.f,  10.f,  11.f,  12.f,13.f,  14.f,  15.f,  16.f,17.f,  18.f,  19.f,  20.f,21.f,  22.f,  23.f,  24.f,
                                         25.f,  26.f,  27.f,  28.f,29.f,  30.f,  31.f,  32.f,33.f,  34.f,  35.f,  36.f,37.f,  38.f,  39.f,  40.f,81.f,  82.f,  83.f,  84.f,85.f,  86.f,  87.f,  88.f,
                                         89.f,  90.f,  91.f,  92.f,93.f,  94.f,  95.f,  96.f,97.f,  98.f,  99.f, 100.f,41.f,  42.f,  43.f,  44.f,45.f,  46.f,  47.f,  48.f,49.f,  50.f,  51.f,  52.f,
                                         53.f,  54.f,  55.f,  56.f,57.f,  58.f,  59.f,  60.f,21.f,  22.f,  23.f,  24.f,25.f,  26.f,  27.f,  28.f,29.f,  30.f,  31.f,  32.f,33.f,  34.f,  35.f,  36.f,37.f,  38.f,  39.f,  40.f});

    nd4j::ops::dynamic_stitch<float> op;
    auto result = op.execute({&indices0, &indices1, &indices2, &data0, &data1, &data2}, {}, {});
    ASSERT_EQ(Status::OK(), result->status());
//    result->at(0)->printIndexedBuffer("Output");
//    exp.printIndexedBuffer("Expect");
//    result->at(0)->printShapeInfo("Output shape");
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));
    delete result;
}
////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Dynamic_Stitch_Prof_1) {
    NDArray<float> indices0('c', {2}, {1.0f, 10.f});
    NDArray<float> indices1('c', {2, 3}, {0.f, 7.f, 9.f, 5.f, 8.f, 3.f});
    NDArray<float> indices2('c', {3, 1}, {6.f, 4.f, 2.f});
    NDArray<float> data0('c', {2,5,4}, {1.f, 2.f, 3.f, 4.f,5.f, 6.f, 7.f, 8.f,9.f, 10.f, 11.f, 12.f,13.f, 14.f, 15.f, 16.f,17.f, 18.f, 19.f, 20.f,21.f, 22.f, 23.f, 24.f,
                                        25.f, 26.f, 27.f, 28.f,29.f, 30.f, 31.f, 32.f,33.f, 34.f, 35.f, 36.f,37.f, 38.f, 39.f, 40.f});

    NDArray<float> data1('c', {2,3,5,4},{1.f, 2.f, 3.f, 4.f,5.f, 6.f, 7.f, 8.f,9.f, 10.f, 11.f, 12.f,13.f, 14.f, 15.f, 16.f,17.f, 18.f, 19.f, 20.f,21.f, 22.f, 23.f, 24.f,25.f, 26.f, 27.f, 28.f,
                                        29.f, 30.f, 31.f, 32.f,33.f, 34.f, 35.f, 36.f,37.f, 38.f, 39.f, 40.f,41.f, 42.f, 43.f, 44.f,45.f, 46.f, 47.f, 48.f,49.f, 50.f, 51.f, 52.f,53.f, 54.f, 55.f, 56.f,
                                        57.f, 58.f, 59.f, 60.f,61.f, 62.f, 63.f, 64.f,65.f, 66.f, 67.f, 68.f,69.f, 70.f, 71.f, 72.f,73.f, 74.f, 75.f, 76.f,77.f, 78.f, 79.f, 80.f,81.f, 82.f, 83.f, 84.f,
                                        85.f, 86.f, 87.f, 88.f,89.f, 90.f, 91.f, 92.f,93.f, 94.f, 95.f, 96.f,97.f, 98.f, 99.f, 100.f,101.f, 102.f, 103.f, 104.f,105.f, 106.f, 107.f, 108.f,109.f, 110.f, 111.f, 112.f,
                                        113.f, 114.f, 115.f, 116.f,117.f, 118.f, 119.f, 120.f});

    NDArray<float> data2('c', {3,1,5,4}, {1.f, 2.f, 3.f, 4.f,5.f, 6.f, 7.f, 8.f,9.f, 10.f, 11.f, 12.f,13.f, 14.f, 15.f, 16.f,17.f, 18.f, 19.f, 20.f,21.f, 22.f, 23.f, 24.f,
                                        25.f, 26.f, 27.f, 28.f,29.f, 30.f, 31.f, 32.f,33.f, 34.f, 35.f, 36.f,37.f, 38.f, 39.f, 40.f,41.f, 42.f, 43.f, 44.f,45.f, 46.f, 47.f, 48.f,
                                        49.f, 50.f, 51.f, 52.f,53.f, 54.f, 55.f, 56.f,57.f, 58.f, 59.f, 60.f});

    NDArray<float> exp('c', {11, 5, 4}, {1.f,   2.f,   3.f,   4.f,5.f,   6.f,   7.f,   8.f,9.f,  10.f,  11.f,  12.f,13.f,  14.f,  15.f,  16.f,17.f,  18.f,  19.f,  20.f,1.f,   2.f,   3.f,   4.f,
                                          5.f,   6.f,   7.f,   8.f,9.f,  10.f,  11.f,  12.f,13.f,  14.f,  15.f,  16.f,17.f,  18.f,  19.f,  20.f,41.f,  42.f,  43.f,  44.f,45.f,  46.f,  47.f,  48.f,
                                         49.f,  50.f,  51.f,  52.f,53.f,  54.f,  55.f,  56.f,57.f,  58.f,  59.f,  60.f,101.f, 102.f, 103.f, 104.f,105.f, 106.f, 107.f, 108.f,109.f, 110.f, 111.f, 112.f,
                                        113.f, 114.f, 115.f, 116.f,117.f, 118.f, 119.f, 120.f,21.f,  22.f,  23.f,  24.f,25.f,  26.f,  27.f,  28.f,29.f,  30.f,  31.f,  32.f,33.f,  34.f,  35.f,  36.f,
                                         37.f,  38.f,  39.f,  40.f,61.f,  62.f,  63.f,  64.f,65.f,  66.f,  67.f,  68.f,69.f,  70.f,  71.f,  72.f,73.f,  74.f,  75.f,  76.f,77.f,  78.f,  79.f,  80.f,
                                          1.f,   2.f,   3.f,   4.f,5.f,   6.f,   7.f,   8.f,9.f,  10.f,  11.f,  12.f,13.f,  14.f,  15.f,  16.f,17.f,  18.f,  19.f,  20.f,21.f,  22.f,  23.f,  24.f,
                                         25.f,  26.f,  27.f,  28.f,29.f,  30.f,  31.f,  32.f,33.f,  34.f,  35.f,  36.f,37.f,  38.f,  39.f,  40.f,81.f,  82.f,  83.f,  84.f,85.f,  86.f,  87.f,  88.f,
                                         89.f,  90.f,  91.f,  92.f,93.f,  94.f,  95.f,  96.f,97.f,  98.f,  99.f, 100.f,41.f,  42.f,  43.f,  44.f,45.f,  46.f,  47.f,  48.f,49.f,  50.f,  51.f,  52.f,
                                         53.f,  54.f,  55.f,  56.f,57.f,  58.f,  59.f,  60.f,21.f,  22.f,  23.f,  24.f,25.f,  26.f,  27.f,  28.f,29.f,  30.f,  31.f,  32.f,33.f,  34.f,  35.f,  36.f,37.f,  38.f,  39.f,  40.f});

    nd4j::ops::dynamic_stitch<float> op;
    auto result = op.execute({&indices0, &indices1, &indices2, &data0, &data1, &data2}, {}, {});
    ASSERT_EQ(Status::OK(), result->status());
//    result->at(0)->printIndexedBuffer("Output");
//    exp.printIndexedBuffer("Expect");
//    result->at(0)->printShapeInfo("Output shape");
    NDArray<float>* res = result->at(0);
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));
    int numOfCases = 100;
    auto timeStart = std::chrono::system_clock::now();
    
    for (int i = 0; i < numOfCases; i++) {
       op.execute({&indices0, &indices1, &indices2, &data0, &data1, &data2}, {res}, {}, {});
    }

    auto timeEnd = std::chrono::system_clock::now();
    auto outerTime = std::chrono::duration_cast<std::chrono::microseconds> (timeEnd - timeStart).count();
    //nd4j_printf("dynamic_stitch: Process with %i iterations was load: %lld us.\n", numOfCases, outerTime / numOfCases);

    delete result;
}

////////////////////////////////////////////////////////////////////////////////

TEST_F(DeclarableOpsTests7, Test_Dynamic_Stitch_119_1) {
    NDArray<float> indices0('c', {2}, {1.0f, 10.f});
    NDArray<float> indices1('c', {2, 3}, {0,7,9, 5,8,3});
    NDArray<float> indices2('c', {3, 1}, {6, 4, 2});

    NDArray<float> data0('c', {2,5,4});
    NDArray<float> data1('c', {2,3,5,4});
    NDArray<float> data2('c', {3,1,5,4});

    nd4j::ops::dynamic_stitch<float> op;
    auto result = op.execute({&indices0, &indices1, &indices2, &data0, &data1, &data2}, {}, {});

    ASSERT_EQ(Status::OK(), result->status());

    delete result;
}


TEST_F(DeclarableOpsTests7, Test_Dynamic_Partition_119) {
    NDArray<float> x('c', {5, 4, 11});
    NDArray<float> y('c', {5, 4}, {0,1,2,3, 1,0,2,3, 2,3,1,0, 2,1,0,3, 0,1,2,3});
    NDArray<float> e('c', {5, 11});
    x.assign(1.f);
    e.assign(1.f);
    nd4j::ops::dynamic_partition<float> op;
    auto result = op.execute({&x, &y}, {}, {4});
    ASSERT_EQ(Status::OK(), result->status());
    ASSERT_EQ(4, result->size());
    auto z = result->at(0);
//    z->printShapeInfo("Output shape info");
//    z->printIndexedBuffer("Output1");
//    result->at(1)->printIndexedBuffer("Output2");
//    result->at(2)->printIndexedBuffer("Output3");
//    result->at(3)->printIndexedBuffer("Output4");
    ASSERT_TRUE(e.isSameShape(z));

    delete result;
}

TEST_F(DeclarableOpsTests7, Test_Dynamic_Partition_119_1) {
    NDArray<float> x('c', {3, 4, 2}, {10, 20,11, 21,12, 22,13, 23,14, 24,15, 25,16, 26,17, 27,18, 28,19, 29,20, 30,21, 31});

    NDArray<float> y('c', {3, 4}, {0,0,0,0, 2,2,2,2, 2,1,1,1});
    NDArray<float> e('c', {4, 2}, {10, 20, 11, 21, 12, 22, 13, 23});

//    x.assign(1.f);
//    e.assign(1.f);
    nd4j::ops::dynamic_partition<float> op;
    auto result = op.execute({&x, &y}, {}, {3});
    ASSERT_EQ(Status::OK(), result->status());
    ASSERT_EQ(3, result->size());
    auto z = result->at(0);
//    z->printShapeInfo("Output shape info");
//    result->at(1)->printShapeInfo("Shape2");
//    result->at(2)->printShapeInfo("Shape3");
//    result->at(3)->printShapeInfo("Shape4");
//    z->printIndexedBuffer("Output1");
//    result->at(1)->printIndexedBuffer("Output2");
//    result->at(2)->printIndexedBuffer("Output3");
//    result->at(3)->printIndexedBuffer("Output4");
    ASSERT_TRUE(e.isSameShape(z));

    delete result;
}


TEST_F(DeclarableOpsTests7, Test_Gather_Vector_Case_119) {
    NDArray<float> input('c', {4}, {2.f, 3.f, 4.f, 5.f});
    NDArray<float> indices('c', {2}, {0.f, 2.f});
    NDArray<float> exp('c', {2}, {2.f, 4.f});

    nd4j::ops::gather<float> op;
    auto result = op.execute({&input, &indices}, {}, {});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(0);

    ASSERT_TRUE(exp.isSameShape(z));
    ASSERT_TRUE(exp.equalsTo(z));

    delete result;
}

TEST_F(DeclarableOpsTests7, Test_SequenceMask_1) {
    NDArray<float> input('c', {4, 4},   {1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f, 9.f, 10.f, 11.f, 12.f, 13.f, 14.f, 15.f, 16.f});
    NDArray<float> exp('c', {4, 4, 16}, {1.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,1.f, 1.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,
                                        1.f, 1.f, 1.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,1.f, 1.f, 1.f, 1.f, 0.f, 0.f, 0.f, 0.f, 0.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,
                                        1.f, 1.f, 1.f, 1.f, 1.f, 0.f, 0.f, 0.f, 0.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 0.f, 0.f, 0.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,
                                        1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 0.f, 0.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 0.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,
                                        1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f,  0.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f,  1.f,  0.f,  0.f,  0.f,  0.f,  0.f, 0.f,
                                        1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f,  1.f,  1.f,  0.f,  0.f,  0.f,  0.f, 0.f,1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f,  1.f,  1.f,  1.f,  0.f,  0.f,  0.f, 0.f,
                                        1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f,  1.f,  1.f,  1.f,  1.f,  0.f,  0.f, 0.f,1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f,  1.f,  1.f,  1.f,  1.f,  1.f,  0.f, 0.f,
                                        1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f,  1.f,  1.f,  1.f,  1.f,  1.f,  1.f, 0.f,1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f,  1.f,  1.f,  1.f,  1.f,  1.f,  1.f, 1.f });

    nd4j::ops::sequence_mask<float> op;
    auto result = op.execute({&input}, {}, {});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(0);
//    z->printIndexedBuffer("Output");
//    z->printShapeInfo("Shape");
    ASSERT_TRUE(exp.isSameShape(z));
    ASSERT_TRUE(exp.equalsTo(z));

    delete result;

}

TEST_F(DeclarableOpsTests7, Test_SequenceMask_2) {
    NDArray<double> input('c', {2, 2, 2},   {10., 20., 30., 4., 0., 6., 7., 8.});
    NDArray<double> exp('c', {2, 2, 2, 30}, {   1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
    1., 1., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,    0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
    1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,    1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
    1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.});

    nd4j::ops::sequence_mask<double> op;
    auto result = op.execute({&input}, {}, {});
    ASSERT_EQ(Status::OK(), result->status());

    auto z = result->at(0);
//    z->printIndexedBuffer("Output");
//    z->printShapeInfo("Shape");
    ASSERT_TRUE(exp.isSameShape(z));
    ASSERT_TRUE(exp.equalsTo(z));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMax_1) {
    NDArray<double> x({1.8, 2.5,4.,  9., 2.1, 2.4,3.,9., 2.1, 2.1,0.7, 0.1, 3., 4.2, 2.2, 1.
    });
    NDArray<double> idx({0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0});
    NDArray<double> exp({2.5, 9.0, 3.0, 9.0, 4.2});

    nd4j::ops::segment_max<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMax_2) {
    NDArray<double> x('c', {4, 4}, {1.8, 2.5,  4.,  9.,2.1, 2.4,  3.,  9.,2.1, 2.1, 0.7, 0.1,3., 4.2, 2.2, 1.  });
    NDArray<double> idx({0.0, 0.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4}, {2.1, 2.5, 4.0, 9.0,2.1, 2.1, 0.7, 0.1,3., 4.2, 2.2, 1.});

    //{ 2.1, 2.5,  4.,  9., 2.1, 2.1, 0.7, 0.1, 3.,  4.2, 2.2, 1.}

    nd4j::ops::segment_max<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_EQ(result->size(), 1);
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMax_3) {
    NDArray<double> x('c', {4, 4, 4}, {
     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,   24.,15.1,  56.4,  93. ,   28.,
    109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,31. ,  22. ,  87.,   44. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,
     91. ,  82. ,  37.,   64. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

// ----------------------------------------------------------------

    NDArray<double> idx({0.0, 1.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4, 4}, {91. , 82. , 37. , 64.,55.1, 46.4, 73. , 28.,119.1, 12.1,112.7, 13.1,14. ,114.2, 16.2,117.,51. , 42. , 87. , 44.,
                     55.1, 56.4, 93. , 28.,119.1, 82.1,112.7,113.1,114. ,114.2,116.2,117.,91. , 82. , 37. , 64.,55.1, 46.4, 73. , 28., 119.1, 12.1,112.7, 13.1,14. ,114.2, 16.2,117. });

    //{ 2.1, 2.5,  4.,  9., 2.1, 2.1, 0.7, 0.1, 3.,  4.2, 2.2, 1.}

    nd4j::ops::segment_max<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
//    result->at(0)->printIndexedBuffer("Output");
//    result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMax_4) {
    NDArray<double> x('c', {4, 4, 4}, {91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,   24.,
                                        15.1,  56.4,  93. ,   28.,109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,31. ,  22. ,  87.,   44. ,55.1,  46.4,  73.,   28. ,
                                        119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,91. ,  82. ,  37.,   64. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

    NDArray<double> idx({0.0, 1.0, 3.0, 7.0});
    NDArray<double> exp('c', {8, 4, 4}, {
                     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,  24. ,15.1,  56.4,  93. ,  28. ,
                    109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                     31. ,  22. ,  87. ,  44. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                      0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                      0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,
                    119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

    nd4j::ops::segment_max<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    //result->at(0)->printIndexedBuffer("Output");
    //result->at(0)->printShapeInfo("Out Shape");
    //exp.printIndexedBuffer("Expect");
    //exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMin_1) {
    NDArray<double> x({1.8, 2.5,4.,  9., 2.1, 2.4,3.,9., 2.1, 2.1,0.7, 0.1, 3., 4.2, 2.2, 1.});
    NDArray<double> idx({0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0});
    NDArray<double> exp({1.8, 2.1, 3.,  2.1, 0.1});

    nd4j::ops::segment_min<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMin_2) {
    NDArray<double> x('c', {4, 4}, {1.8, 2.5,  4.,  9.,2.1, 2.4,  3.,  9.,2.1, 2.1, 0.7, 0.1,3., 4.2, 2.2, 1.});
    NDArray<double> idx({0.0, 0.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4}, {1.8, 2.4, 3. , 9.,2.1, 2.1, 0.7, 0.1,3. , 4.2, 2.2, 1.});

    //{ 2.1, 2.5,  4.,  9., 2.1, 2.1, 0.7, 0.1, 3.,  4.2, 2.2, 1.}

    nd4j::ops::segment_min<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_EQ(result->size(), 1);
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMin_3) {
    NDArray<double> x('c', {4, 4, 4}, {
     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,   24.,15.1,  56.4,  93. ,   28.,109.1,  82.1,  12.7, 113.1,
    114. ,  14.2, 116.2,  11. ,31. ,  22. ,  87.,   44. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,91. ,  82. ,  37.,   64. ,55.1,  46.4,  73.,   28. ,
    119.1,  12.1, 112.7,  13.1,    14. , 114.2,  16.2, 117. });

// ----------------------------------------------------------------

    NDArray<double> idx({0.0, 1.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4, 4}, {91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,31. ,  22. ,  67. ,  24. ,
                 15.1,  46.4,  73. ,  28. ,109.1,  12.1,  12.7,  13.1,14. ,  14.2,  16.2,  11. ,91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

    nd4j::ops::segment_min<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
//    result->at(0)->printIndexedBuffer("Output");
//    result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMin_4) {
    NDArray<double> x('c', {4, 4, 4}, {
     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,   24.,15.1,  56.4,  93. ,   28.,
    109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,31. ,  22. ,  87.,   44. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,
     91. ,  82. ,  37.,   64. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

// ----------------------------------------------------------------

    NDArray<double> idx({0.0, 1.0, 3.0, 7.0});
    NDArray<double> exp('c', {8, 4, 4}, {
                     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,  24. ,15.1,  56.4,  93. ,  28. ,
                    109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                     31. ,  22. ,  87. ,  44. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                      0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                      0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

    nd4j::ops::segment_min<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    //result->at(0)->printIndexedBuffer("Output");
    //result->at(0)->printShapeInfo("Out Shape");
    //exp.printIndexedBuffer("Expect");
    //exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMean_1) {
    NDArray<double> x({1.8, 2.5,4.,  9., 2.1, 2.4,3.,9., 2.1, 2.1,0.7, 0.1, 3., 4.2, 2.2, 1.});
    NDArray<double> idx({0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0});
    NDArray<double> exp({2.15,      4.375,     3.,        4.4,       1.8666667});

    nd4j::ops::segment_mean<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMean_2) {
    NDArray<double> x('c', {4, 4}, {1.8, 2.5,  4.,  9.,2.1, 2.4,  3.,  9.,2.1, 2.1, 0.7, 0.1,3., 4.2, 2.2, 1.});
    NDArray<double> idx({0.0, 0.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4}, {    1.95,     2.45,       3.5,       9.,    2.1,       2.1,       0.7,      0.1,    3. ,       4.2,       2.2,      1.});

    nd4j::ops::segment_mean<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_EQ(result->size(), 1);
//    exp.printIndexedBuffer("Expect");
//    result->at(0)->printIndexedBuffer("Output");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMean_3) {
    NDArray<double> x('c', {4, 4, 4}, {
     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,   24.,15.1,  56.4,  93. ,   28.,
    109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,31. ,  22. ,  87.,   44. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,
     91. ,  82. ,  37.,   64. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

// ----------------------------------------------------------------

    NDArray<double> idx({0.0, 1.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4, 4}, {
             91.  ,      82.  ,      37.  ,      64. ,55.1 ,      46.4 ,      73.  ,      28. ,119.1 ,      12.1 ,     112.7 ,      13.1,14.  ,     114.2 ,      16.2 ,     117. ,
             41.  ,      32.  ,      77.  ,      34. ,35.1 ,      51.4 ,      83.  ,      28. ,114.1 ,      47.1 ,      62.7,      63.1,64.  ,      64.2 ,      66.2 ,      64. ,
             91.  ,      82.  ,      37.  ,      64. ,55.1 ,      46.4 ,      73.  ,      28. ,119.1 ,      12.1 ,     112.7 ,      13.1,14.  ,     114.2 ,      16.2 ,     117. });

    nd4j::ops::segment_mean<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
//    result->at(0)->printIndexedBuffer("Output");
//    result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentMean_4) {
    NDArray<double> x('c', {4, 4, 4}, {
     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,   24.,15.1,  56.4,  93. ,   28.,
    109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,31. ,  22. ,  87.,   44. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,
     91. ,  82. ,  37.,   64. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

// ----------------------------------------------------------------

    NDArray<double> idx({0.0, 1.0, 3.0, 7.0});
    NDArray<double> exp('c', {8, 4, 4}, {
             91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,  24. ,15.1,  56.4,  93. ,  28. ,
            109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
             31. ,  22. ,  87. ,  44. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
              0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
              0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,
            119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

    nd4j::ops::segment_mean<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    //result->at(0)->printIndexedBuffer("Output");
    //result->at(0)->printShapeInfo("Out Shape");
    //exp.printIndexedBuffer("Expect");
    //exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentSum_1) {
    NDArray<double> x({1.8, 2.5,4.,  9., 2.1, 2.4,3.,9., 2.1, 2.1,0.7, 0.1, 3., 4.2, 2.2, 1.    });
    NDArray<double> idx({0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0});
    NDArray<double> exp({4.3,  17.5,  3.,  13.2,  11.2});

    nd4j::ops::segment_sum<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentSum_2) {
    NDArray<double> x('c', {4, 4}, {1.8, 2.5,  4.,  9.,2.1, 2.4,  3.,  9.,2.1, 2.1, 0.7, 0.1,3., 4.2, 2.2, 1.    });
    NDArray<double> idx({0.0, 0.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4}, {3.9 ,       4.9,        7. ,       18.,2.1 ,       2.1,        0.7,        0.1,3.  ,       4.2,        2.2,        1.});

    nd4j::ops::segment_sum<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_EQ(result->size(), 1);
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentSum_3) {
    NDArray<double> x('c', {4, 4, 4}, {
     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,   24.,15.1,  56.4,  93. ,   28.,
    109.1,  82.1,  12.7, 113.1,    114. ,  14.2, 116.2,  11. ,31. ,  22. ,  87.,   44. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,
     91. ,  82. ,  37.,   64. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,     14. , 114.2,  16.2, 117. });

// ----------------------------------------------------------------

    NDArray<double> idx({0.0, 1.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4, 4}, {
                91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,82. ,       64. ,      154. ,       68.  ,
             70.2,      102.8,      166. ,       56.  ,228.2,       94.2,      125.4,     126.2 ,128. ,      128.4,      132.4,      128.  ,91. ,  82. ,  37. ,  64. ,
                  55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

    nd4j::ops::segment_sum<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
//    result->at(0)->printIndexedBuffer("Output");
//    result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentSum_4) {
    NDArray<double> x('c', {4, 4, 4}, {
     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,   24.,15.1,  56.4,  93. ,   28.,
    109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,31. ,  22. ,  87.,   44. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,
     91. ,  82. ,  37.,   64. ,55.1,  46.4,  73.,   28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

// ----------------------------------------------------------------

    NDArray<double> idx({0.0, 1.0, 3.0, 7.0});
    NDArray<double> exp('c', {8, 4, 4}, {
                     91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,51. ,  42. ,  67. ,  24. ,15.1,  56.4,  93. ,  28. ,
                    109.1,  82.1,  12.7, 113.1,114. ,  14.2, 116.2,  11. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                     31. ,  22. ,  87. ,  44. ,55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                      0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,
                      0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,0. ,   0. ,   0. ,   0. ,91. ,  82. ,  37. ,  64. ,55.1,  46.4,  73. ,  28. ,
                    119.1,  12.1, 112.7,  13.1,14. , 114.2,  16.2, 117. });

    nd4j::ops::segment_sum<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    //result->at(0)->printIndexedBuffer("Output");
    //result->at(0)->printShapeInfo("Out Shape");
    //exp.printIndexedBuffer("Expect");
    //exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentProd_1) {
    NDArray<double> x({1.8, 2.5,4.,  9., 2.1, 2.4,3.,9., 2.1, 2.1,0.7, 0.1, 3., 4.2, 2.2, 1.});
    NDArray<double> idx({0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0});
    NDArray<double> exp({4.5,    181.44,     3.,      39.69,     1.9404});

    nd4j::ops::segment_prod<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentProd_2) {
    NDArray<double> x('c', {4, 4}, {
        1.8, 2.5,  4.,  9.,        2.1, 2.4,  3.,  9.,        2.1, 2.1, 0.7, 0.1,         3., 4.2, 2.2, 1.    });
    NDArray<double> idx({0.0, 0.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4}, {        3.78,       6. ,       12.  ,      81.,        2.1 ,       2.1,        0.7 ,       0.1,        3.  ,       4.2,        2.2 ,       1.});

    //{ 2.1, 2.5,  4.,  9., 2.1, 2.1, 0.7, 0.1, 3.,  4.2, 2.2, 1.}

    nd4j::ops::segment_prod<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_EQ(result->size(), 1);
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestSegmentProd_3) {
    NDArray<double> x('c', {4, 4, 4}, {
     91. ,  82. ,  37. ,  64. ,     55.1,  46.4,  73. ,  28. ,    119.1,  12.1, 112.7,  13.1,     14. , 114.2,  16.2, 117. ,     51. ,  42. ,  67. ,   24.,
     15.1,  56.4,  93. ,   28.,    109.1,  82.1,  12.7, 113.1,    114. ,  14.2, 116.2,  11. ,     31. ,  22. ,  87.,   44. ,     55.1,  46.4,  73.,   28. ,
    119.1,  12.1, 112.7,  13.1,     14. , 114.2,  16.2, 117. ,     91. ,  82. ,  37.,   64. ,     55.1,  46.4,  73.,   28. ,    119.1,  12.1, 112.7,  13.1,     14. , 114.2,  16.2, 117. });

// ----------------------------------------------------------------

    NDArray<double> idx({0.0, 1.0, 1.0, 2.0});
    NDArray<double> exp('c', {3, 4, 4}, {
                 91. ,  82. ,  37. ,  64. , 55.1,  46.4,  73. ,  28. ,  119.1,  12.1, 112.7,  13.1, 14. , 114.2,  16.2, 117. ,
                1581.0, 924.0, 5829.0, 1056.0,832.01001, 2616.9602, 6789.0, 784.0, 12993.810, 993.41003, 1431.2899, 1481.61, 1596.0000, 1621.6399, 1882.4401, 1287.0,
                 91. ,  82. ,  37. ,  64. ,   55.1,  46.4,  73. ,  28. ,119.1,  12.1, 112.7,  13.1, 14. , 114.2,  16.2, 117. });

    nd4j::ops::segment_prod<double> op;

    auto result = op.execute({&x, &idx}, {}, {});
    ASSERT_EQ(result->status(), Status::OK());
//    result->at(0)->printIndexedBuffer("Output");
//    result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
//    exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestExtractImagePatches_1) {
    NDArray<double> x('c', {2,4, 4, 4}, {
     91.,  82.,  37.,  64.,     55.,  46.,  73.,  28.,   119.,  12., 112.,  13.,     14., 114.,  16., 117.,
     51.,  42.,  67.,  24.,     15.,  56.,  93.,  28.,   109.,  82.,  12., 113.,    114.,  14., 116.,  11.,
     31.,  22.,  87.,  44.,     55.,  46.,  73.,  28.,   119.,  12., 112.,  13.,     14., 114.,  16., 117.,
     91.,  82.,  37.,  64.,    55.1, 46.4,  73.,  28.,   119.,  12., 112.,  13.,     14., 114., 16.2, 117.,
     91.,  82.,  37.,  64.,     55.,  46.,  73.,  28.,   119.,  12., 112.,  13.,     14., 114.,  16., 117.,
     51.,  42.,  67.,  24.,     15.,  56.,  93.,  28.,   109.,  82.,  12., 113.,    114.,  14., 116.,  11.,
     31.,  22.,  87.,  44.,     55.,  46.,  73.,  28.,   119.,  12., 112.,  13.,     14., 114.,  16., 117.,
     91.,  82.,  37.,  64.,    55.1, 46.4,  73.,  28.,   119.,  12., 112.,  13.,    140., 110., 160.,  107.});

// ----------------------------------------------------------------


    NDArray<double> exp('c', {2, 4, 4, 4}, {
     91.,  82.,  37.,  64.,     55.,  46.,  73.,  28.,    119.,  12., 112.,  13.,     14., 114.,  16., 117.,
     51.,  42.,  67.,  24.,     15.,  56.,  93.,  28.,    109.,  82.,  12., 113.,    114.,  14., 116.,  11.,
     31.,  22.,  87.,  44.,     55.,  46.,  73.,  28.,    119.,  12., 112.,  13.,     14., 114.,  16., 117.,
     91.,  82.,  37.,  64.,    55.1, 46.4,  73.,  28.,    119.,  12., 112.,  13.,     14., 114., 16.2, 117.,
     91.,  82.,  37.,  64.,     55.,  46.,  73.,  28.,    119.,  12., 112.,  13.,     14., 114.,  16., 117.,
     51.,  42.,  67.,  24.,     15.,  56.,  93.,  28.,    109.,  82.,  12., 113.,    114.,  14., 116.,  11.,
     31.,  22.,  87.,  44.,     55.,  46.,  73.,  28.,    119.,  12., 112.,  13.,     14., 114.,  16., 117.,
     91.,  82.,  37.,  64.,    55.1,  46.4, 73.,  28.,    119.,  12., 112.,  13.,    140., 110., 160., 107.});

    nd4j::ops::extract_image_patches<double> op;

    auto result = op.execute({&x}, {}, {1,1,1,1,1,1,0});
    ASSERT_EQ(result->status(), Status::OK());
//    result->at(0)->printIndexedBuffer("Output");
    //result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
    //exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestExtractImagePatches_2) {
    NDArray<double> x('c', {3, 3, 4, 3}, {
     11.,  12.,  13.,     12.,  13.,  14.,     15.,  16.,  17.,     18.,  19.,  10.,
      1.,   2.,   3.,      2.,   3.,   4.,     21.,  22.,  23.,     22.,  23.,  24.,
      5.,   6.,   7.,      8.,   9.,   0.,     35.,  36.,  37.,     38.,  39.,  40.,
      9.,   8.,   7.,      6.,   5.,   4.,     49.,  48.,  47.,     46.,  45.,  44.,
      3.,   2.,   1.,      0.,   1.,   2.,     53.,  52.,  51.,     50.,  51.,  52.,
     15.,  16.,  17.,     18.,  19.,  10.,    135., 136., 137.,    138., 139., 140.,
    211.,  12.,  13.,     12., 213.,  14.,     15., 216.,  17.,    128.,  19.,  10.,
     21.,   2.,   3.,      2.,   3.,  24.,     21.,  22., 223.,     22., 223.,  24.,
     25.,   6.,   7.,      8.,   9.,  20.,     35.,  36., 327.,     38., 239.,  40.});

//Images shape is  (3, 3, 4, 3)
//[1, 1, 1, 1]
//[1, 3, 2, 1]
NDArray<double> exp('c', {3, 1, 1, 12}, {
     11.,  12.,  13.,  12.,  13.,  14.,   1.,   2.,   3.,   2.,   3.,   4.,
      9.,   8.,   7.,   6.,   5.,   4.,   3.,   2.,   1.,   0.,   1.,   2.,
    211.,  12.,  13.,  12., 213.,  14.,  21.,   2.,   3.,   2.,   3.,  24.
 });
// ----------------------------------------------------------------
    nd4j::ops::extract_image_patches<double> op;

    auto result = op.execute({&x}, {}, {2,2, 3,3, 1,1,0});
    ASSERT_EQ(result->status(), Status::OK());

    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestExtractImagePatches_3) {
    NDArray<double> x('c', {3, 3, 4, 3}, {
     11.,  12.,  13.,     12.,  13.,  14.,     15.,  16.,  17.,     18.,  19.,  10.,
      1.,   2.,   3.,      2.,   3.,   4.,     21.,  22.,  23.,     22.,  23.,  24.,
      5.,   6.,   7.,      8.,   9.,   0.,     35.,  36.,  37.,     38.,  39.,  40.,
      9.,   8.,   7.,      6.,   5.,   4.,     49.,  48.,  47.,     46.,  45.,  44.,
      3.,   2.,   1.,      0.,   1.,   2.,     53.,  52.,  51.,     50.,  51.,  52.,
     15.,  16.,  17.,     18.,  19.,  10.,    135., 136., 137.,    138., 139., 140.,
    211.,  12.,  13.,     12., 213.,  14.,     15., 216.,  17.,    128.,  19.,  10.,
     21.,   2.,   3.,      2.,   3.,  24.,     21.,  22., 223.,     22., 223.,  24.,
     25.,   6.,   7.,      8.,   9.,  20.,     35.,  36., 327.,     38., 239.,  40.});

//Images shape is  (3, 3, 4, 3)
//[1, 1, 1, 1]
//[1, 3, 2, 1]
NDArray<double> exp('c', {3, 1, 2, 6}, {
     11.,  12.,  13.,   5.,   6.,   7.,
     15.,  16.,  17.,  35.,  36.,  37.,

      9.,   8.,   7.,  15.,  16.,  17.,
     49.,  48.,  47., 135., 136., 137.,

    211.,  12.,  13.,  25.,   6.,   7.,
     15., 216.,  17.,  35.,  36., 327.
 });
// ----------------------------------------------------------------
    nd4j::ops::extract_image_patches<double> op;

    auto result = op.execute({&x}, {}, {2,1,3,2,2,2,0});
    ASSERT_EQ(result->status(), Status::OK());
//    x.printIndexedBuffer("images");
//    nd4j_printf("input params: ksize = [1, 2, 1, 1], strides = [1, 3, 2, 1], rates = [1, 2, 2, 1]\n", "");
//    result->at(0)->printIndexedBuffer("Output");
    //result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
    //exp.printShapeInfo("Exp Shape");

    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestExtractImagePatches_4) {
    NDArray<double> x('c', {3, 3, 4, 3}, {
     11.,  12.,  13.,     12.,  13.,  14.,     15.,  16.,  17.,     18.,  19.,  10.,
      1.,   2.,   3.,      2.,   3.,   4.,     21.,  22.,  23.,     22.,  23.,  24.,
      5.,   6.,   7.,      8.,   9.,   0.,     35.,  36.,  37.,     38.,  39.,  40.,
      9.,   8.,   7.,      6.,   5.,   4.,     49.,  48.,  47.,     46.,  45.,  44.,
      3.,   2.,   1.,      0.,   1.,   2.,     53.,  52.,  51.,     50.,  51.,  52.,
     15.,  16.,  17.,     18.,  19.,  10.,    135., 136., 137.,    138., 139., 140.,
    211.,  12.,  13.,     12., 213.,  14.,     15., 216.,  17.,    128.,  19.,  10.,
     21.,   2.,   3.,      2.,   3.,  24.,     21.,  22., 223.,     22., 223.,  24.,
     25.,   6.,   7.,      8.,   9.,  20.,     35.,  36., 327.,     38., 239.,  40.});

//Images shape is  (3, 3, 4, 3)
//[1, 1, 1, 1]
//[1, 3, 2, 1]
NDArray<double> exp('c', {3, 3, 4, 3}, {
     11.,  12.,  13.,     12.,  13.,  14.,     15.,  16.,  17.,     18.,   19.,  10.,
      1.,   2.,   3.,      2.,   3.,   4.,     21.,  22.,  23.,     22.,  23.,  24.,
      5.,   6.,   7.,      8.,   9.,   0.,     35.,  36.,  37.,     38.,  39.,  40.,
      9.,   8.,   7.,      6.,   5.,   4.,     49.,  48.,  47.,     46.,  45.,  44.,
      3.,   2.,   1.,      0.,   1.,   2.,     53.,  52.,  51.,     50.,  51.,  52.,
     15.,  16.,  17.,     18.,  19.,  10.,    135., 136., 137.,    138., 139., 140.,
    211.,  12.,  13.,     12., 213.,  14.,     15., 216.,  17.,    128.,  19.,  10.,
     21.,   2.,   3.,      2.,   3.,  24.,     21.,  22., 223.,     22., 223.,  24.,
     25.,   6.,   7.,      8.,   9.,  20.,     35.,  36., 327.,     38., 239.,  40.});
// ----------------------------------------------------------------
    nd4j::ops::extract_image_patches<double> op;

    auto result = op.execute({&x}, {}, {1,1,1,1,1,1,0});
    ASSERT_EQ(result->status(), Status::OK());
//    result->at(0)->printIndexedBuffer("Output");
    //result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
    //exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestExtractImagePatches_5) {
    NDArray<double> x('c', {3, 3, 4, 3}, {
 11.,  12.,  13.,   12.,  13.,  14.,   15.,  16.,  17.,    18.,  19.,  10.,
  1.,   2.,   3.,    2.,   3.,   4.,   21.,  22.,  23.,    22.,  23.,  24.,
  5.,   6.,   7.,    8.,   9.,   0.,   35.,  36.,  37.,   38.,  39.,  40.,
  9.,   8.,   7.,    6.,   5.,   4.,   49.,  48.,  47.,   46.,  45.,  44.,
  3.,   2.,   1.,    0.,   1.,   2.,   53.,  52.,  51.,   50.,  51.,  52.,
 15.,  16.,  17.,   18.,  19.,  10.,  135., 136., 137.,  138., 139., 140.,
211.,  12.,  13.,   12., 213.,  14.,   15., 216.,  17.,  128.,  19.,  10.,
 21.,   2.,   3.,    2.,   3.,  24.,   21.,  22., 223.,   22., 223.,  24.,
 25.,   6.,   7.,    8.,   9.,  20.,   35.,  36., 327.,   38., 239.,  40.});

//Images shape is  (3, 3, 4, 3)
//[1, 1, 1, 1]
//[1, 3, 2, 1]
NDArray<double> exp('c', {3, 1, 1, 18}, {
  11.,  12.,  13.,  15.,  16.,  17.,   1.,   2.,   3.,  21.,  22.,  23.,   5.,  6.,   7.,  35.,  36.,  37.,
   9.,   8.,   7.,  49.,  48.,  47.,   3.,   2.,   1.,  53.,  52.,  51.,  15., 16.,  17., 135., 136., 137.,
 211.,  12.,  13.,  15., 216.,  17.,  21.,   2.,   3.,  21.,  22., 223.,  25.,  6.,   7.,  35.,  36., 327.

//Patch shape is (3, 1, 2, 18)

 });
// ----------------------------------------------------------------
    nd4j::ops::extract_image_patches<double> op;

    auto result = op.execute({&x}, {}, {3,2,3,2,1,2,0});
    ASSERT_EQ(result->status(), Status::OK());
//    result->at(0)->printIndexedBuffer("Output");
    //result->at(0)->printShapeInfo("Out Shape");
//    exp.printIndexedBuffer("Expect");
    //exp.printShapeInfo("Exp Shape");
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestExtractImagePatches_6) {
    NDArray<double> x('c', {2, 2, 4, 2}, {
    11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,     12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42,
    21.11, 21.12, 21.21, 21.22, 21.31, 21.32, 21.41, 21.42,     22.11, 22.12, 22.21, 22.22, 22.31, 22.32, 22.41, 22.42
});

//Images shape is  (3, 3, 4, 3)
//[1, 1, 1, 1]
//[1, 3, 2, 1]
NDArray<double> exp('c', {2, 1, 4, 4}, {
    11.11, 11.12, 12.11, 12.12,     11.21, 11.22, 12.21, 12.22,     11.31, 11.32, 12.31, 12.32,     11.41, 11.42, 12.41, 12.42,
    21.11, 21.12, 22.11, 22.12, 21.21, 21.22, 22.21, 22.22,    21.31, 21.32, 22.31, 22.32,     21.41, 21.42, 22.41, 22.42
 });
// ----------------------------------------------------------------
    nd4j::ops::extract_image_patches<double> op;

    auto result = op.execute({&x}, {}, {2,1, 1,1, 1,1,0});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(exp.isSameShape(result->at(0)));
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_1) {
    NDArray<double> x('c', {2, 2, 4, 2}, {
    11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,     12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42,
    21.11, 21.12, 21.21, 21.22, 21.31, 21.32, 21.41, 21.42,     22.11, 22.12, 22.21, 22.22, 22.31, 22.32, 22.41, 22.42
});

NDArray<double> exp('c', {2, 2, 4, 2}, {
    22.21, 22.22, 22.31, 22.32, 22.41, 22.42, 11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,
    12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42, 21.11, 21.12, 21.21, 21.22, 21.31, 21.32,
    21.41, 21.42, 22.11, 22.12
 });
// ----------------------------------------------------------------
    nd4j::ops::roll<double> op;

    auto result = op.execute({&x}, {}, {6});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_2) {
    NDArray<double> x('c', {2, 2, 4, 2}, {
    11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,     12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42,
    21.11, 21.12, 21.21, 21.22, 21.31, 21.32, 21.41, 21.42,     22.11, 22.12, 22.21, 22.22, 22.31, 22.32, 22.41, 22.42
});

NDArray<double> exp('c', {2, 2, 4, 2}, {
         12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42,    21.11, 21.12, 21.21, 21.22, 21.31, 21.32, 21.41, 21.42,
         22.11, 22.12, 22.21, 22.22, 22.31, 22.32, 22.41, 22.42,    11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42
 });
// ----------------------------------------------------------------
    nd4j::ops::roll<double> op;

    auto result = op.execute({&x}, {}, {-8});
    ASSERT_EQ(result->status(), Status::OK());
    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_3) {
    NDArray<double> x('c', {2, 2, 4, 2}, {
    11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,     12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42,
    21.11, 21.12, 21.21, 21.22, 21.31, 21.32, 21.41, 21.42,     22.11, 22.12, 22.21, 22.22, 22.31, 22.32, 22.41, 22.42
});

NDArray<double> exp('c', {2, 2, 4, 2}, {
         12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42,    21.11, 21.12, 21.21, 21.22, 21.31, 21.32, 21.41, 21.42,
         22.11, 22.12, 22.21, 22.22, 22.31, 22.32, 22.41, 22.42,    11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42
 });
// ----------------------------------------------------------------
    nd4j::ops::roll<double> op;

    auto result = op.execute({&x}, {}, {-40});
    ASSERT_EQ(result->status(), Status::OK());

    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_4) {
    NDArray<double> x('c', {2, 2, 4, 2}, {
    11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,     12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42,
    21.11, 21.12, 21.21, 21.22, 21.31, 21.32, 21.41, 21.42,     22.11, 22.12, 22.21, 22.22, 22.31, 22.32, 22.41, 22.42
});

NDArray<double> exp('c', {2, 2, 4, 2}, {
    22.21, 22.22, 22.31, 22.32, 22.41, 22.42, 11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,
    12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42, 21.11, 21.12, 21.21, 21.22, 21.31, 21.32,
    21.41, 21.42, 22.11, 22.12
 });

//    22.21, 22.22, 22.31, 22.32, 22.41, 22.42, 11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,
//    12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42, 21.11, 21.12, 21.21, 21.22, 21.31, 21.32
//    21.41, 21.42, 22.11, 22.12
// ----------------------------------------------------------------
    nd4j::ops::roll<double> op;

    auto result = op.execute({&x}, {}, {38});
    ASSERT_EQ(result->status(), Status::OK());
    //result->at(0)->printIndexedBuffer("Output 4");
    //exp.printIndexedBuffer("Expect 4");

    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_4_inplace) {
    NDArray<double> x('c', {2, 2, 4, 2}, {
    11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,     12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42,
    21.11, 21.12, 21.21, 21.22, 21.31, 21.32, 21.41, 21.42,     22.11, 22.12, 22.21, 22.22, 22.31, 22.32, 22.41, 22.42
});

NDArray<double> exp('c', {2, 2, 4, 2}, {
    22.21, 22.22, 22.31, 22.32, 22.41, 22.42, 11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,
    12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42, 21.11, 21.12, 21.21, 21.22, 21.31, 21.32,
    21.41, 21.42, 22.11, 22.12
 });

//    22.21, 22.22, 22.31, 22.32, 22.41, 22.42, 11.11, 11.12, 11.21, 11.22, 11.31, 11.32, 11.41, 11.42,
//    12.11, 12.12, 12.21, 12.22, 12.31, 12.32, 12.41, 12.42, 21.11, 21.12, 21.21, 21.22, 21.31, 21.32
//    21.41, 21.42, 22.11, 22.12
// ----------------------------------------------------------------
    nd4j::ops::roll<double> op;
    NDArray<double>* y;
    auto result = op.execute({&x}, {y}, {}, {38}, true);
    ASSERT_EQ(result, Status::OK());
    //x.printIndexedBuffer("Output 4 inplace");
    //exp.printIndexedBuffer("Expect 4 inplace");

    ASSERT_TRUE(exp.equalsTo(&x));

//    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_5) {
    NDArray<float> x('c', {3, 4}, {
    0., 1., 2., 3., 4, 5., 6., 7., 8., 9., 10., 11.
});

NDArray<float> exp('c', {3, 4}, {
    2., 3., 0., 1., 6., 7., 4., 5., 10., 11., 8., 9.
//     4,  5,  6,  7, 8,  9, 10, 11, 0,  1,  2,  3
});
// ----------------------------------------------------------------
    nd4j::ops::roll<float> op;

    auto result = op.execute({&x}, {}, {2, 1});
    ASSERT_EQ(result->status(), Status::OK());

    //result->at(0)->printIndexedBuffer("Output");
    //exp.printIndexedBuffer("Expect");

    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_6) {
    NDArray<float> x('c', {2, 3, 2}, {
    0., 1., 2., 3., 4, 5., 6., 7., 8., 9., 10., 11.
});

NDArray<float> exp('c', {2, 3, 2}, {
    1., 0., 3., 2., 5., 4., 7., 6., 9., 8., 11., 10.
});
// ----------------------------------------------------------------
    nd4j::ops::roll<float> op;

    auto result = op.execute({&x}, {}, {1, 2});
    ASSERT_EQ(result->status(), Status::OK());

    //result->at(0)->printIndexedBuffer("Output");
    //exp.printIndexedBuffer("Expect");

    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_7) {
    NDArray<float> x('c', {2, 3, 2}, {
    0., 1., 2., 3.,  4.,  5., 6., 7., 8., 9., 10., 11.
});

NDArray<float> exp('c', {2, 3, 2}, {
    11., 10., 7., 6., 9., 8., 5.,  4., 1., 0., 3., 2.
});
// ----------------------------------------------------------------
    nd4j::ops::roll<float> op;

    auto result = op.execute({&x}, {}, {1, 2, 1, 0});
    ASSERT_EQ(result->status(), Status::OK());

    //result->at(0)->printIndexedBuffer("Output");
    //exp.printIndexedBuffer("Expect");

    ASSERT_TRUE(exp.equalsTo(result->at(0)));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_8) {
    NDArray<float> x('c', {2, 3, 2}, {
    0., 1., 2., 3.,  4.,  5., 6., 7., 8., 9., 10., 11.
});

NDArray<float> exp('c', {2, 3, 2}, {
    11., 10., 7., 6., 9., 8., 5.,  4., 1., 0., 3., 2.
});
// ----------------------------------------------------------------
    nd4j::ops::roll<float> op;
    NDArray<float>* y;
    auto result = op.execute({&x}, {y}, {}, {1, 2, 1, 0}, true);
    ASSERT_EQ(result, Status::OK());

    //x.printIndexedBuffer("Output");
    //exp.printIndexedBuffer("Expect");

    ASSERT_TRUE(exp.equalsTo(&x));

//    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, TestRoll_9) {
    NDArray<float> x('c', {2, 3, 3}, {
    0., 1., 2., 3.,  4.,  5., 6., 7., 8., 9., 10., 11., 12., 13., 14., 15., 16., 17.
});

NDArray<float> exp('c', {2, 3, 3}, {
    6.,  7.,  8., 0., 1., 2., 3., 4., 5., 15., 16., 17., 9., 10., 11., 12., 13., 14.
});
// ----------------------------------------------------------------
    nd4j::ops::roll<float> op;
    NDArray<float>* y;
    auto result = op.execute({&x}, {y}, {}, {1, 1}, true);
    ASSERT_EQ(result, Status::OK());

    //x.printIndexedBuffer("Output");
    //exp.printIndexedBuffer("Expect");

    ASSERT_TRUE(exp.equalsTo(&x));

//    delete result;
}

//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, maxpool2d_bp_test1) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,  pH=0,pW=0,  dH=1,dW=1;
    int oH=2,oW=2;
    int paddingMode = 0;             // 1-SAME,  0-VALID
    int dataFormat  = 0;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iC, iH, iW});
    NDArray<double> gradO   ('c', {bS, iC, oH, oW});
    NDArray<double> expected('c', {bS, iC, iH, iW}, {0. , 0. , 0. ,0. , 0. , 0. ,0. , 0.1, 0.2,0. , 0.3, 0.4,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0.5, 0.6,0. , 0.7, 0.8,
                                                     0. , 0. , 0. ,0. , 0. , 0. ,0. , 0.9, 1. ,0. , 1.1, 1.2,0. , 0. , 0. ,0. , 0. , 0. ,0. , 1.3, 1.4,0. , 1.5, 1.6,
                                                     0. , 0. , 0. ,0. , 0. , 0. ,0. , 1.7, 1.8,0. , 1.9, 2. ,0. , 0. , 0. ,0. , 0. , 0. ,0. , 2.1, 2.2,0. , 2.3, 2.4});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::maxpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, 1, dataFormat});
    NDArray<double>* output = results->at(0);    

    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}


//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, maxpool2d_bp_test2) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,  pH=1,pW=1,  dH=1,dW=1;
    int oH=4,oW=4;
    int paddingMode = 0;             // 1-SAME,  0-VALID
    int dataFormat  = 0;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iC, iH, iW});
    NDArray<double> gradO   ('c', {bS, iC, oH, oW});
    NDArray<double> expected('c', {bS, iC, iH, iW}, {0. ,  0. ,  0. , 0.1,  0.2,  0.7, 0.5,  0.6,  1.5, 2.2,  2.4,  5.4, 0. ,  0. ,  0. , 1.7,  1.8,  3.9, 2.1,  2.2,  4.7, 5.4,  5.6, 11.8,
                                                     0. ,  0. ,  0. , 3.3,  3.4,  7.1, 3.7,  3.8,  7.9, 8.6,  8.8, 18.2, 0. ,  0. ,  0. , 4.9,  5. , 10.3, 5.3,  5.4, 11.1,11.8, 12. , 24.6,
                                                     0. ,  0. ,  0. , 6.5,  6.6, 13.5, 6.9,  7. , 14.3,15. , 15.2, 31. , 0. ,  0. ,  0. , 8.1,  8.2, 16.7, 8.5,  8.6, 17.5,18.2, 18.4, 37.4});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::maxpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, 1, dataFormat});
    NDArray<double>* output = results->at(0);    

    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}


//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, maxpool2d_bp_test3) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,   pH=0,pW=0,   dH=1,dW=1;
    int oH=4,oW=3;
    int paddingMode = 1;             // 1-SAME,  0-VALID
    int dataFormat  = 1;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iH, iW, iC});
    NDArray<double> gradO   ('c', {bS, oH, oW, iC});
    NDArray<double> expected('c', {bS, iH, iW, iC}, {0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0.1, 0.2, 0.3, 1.1, 1.3, 1.5, 0. , 0. , 0. , 1. , 1.1, 1.2, 2.9, 3.1, 3.3,
                                                     0. , 0. , 0. , 4.7, 4.9, 5.1,11.2,11.6,12. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 0. , 3.7, 3.8, 3.9, 8.3, 8.5, 8.7,
                                                     0. , 0. , 0. , 4.6, 4.7, 4.8,10.1,10.3,10.5, 0. , 0. , 0. ,11.9,12.1,12.3,25.6,26. ,26.4});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::maxpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, 1, dataFormat});
    NDArray<double>* output = results->at(0);    
    
    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}


//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, maxpool2d_bp_test4) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,   pH=0,pW=0,   dH=1,dW=1;
    int oH=2,oW=2;
    int paddingMode = 0;             // 1-SAME,  0-VALID
    int dataFormat  = 1;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iH, iW, iC});
    NDArray<double> gradO   ('c', {bS, oH, oW, iC});
    NDArray<double> expected('c', {bS, iH, iW, iC}, {0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,0.1, 0.2, 0.3,0.4, 0.5, 0.6,
                                                     0. , 0. , 0. ,0.7, 0.8, 0.9,1. , 1.1, 1.2,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,0. , 0. , 0. ,
                                                     0. , 0. , 0. ,1.3, 1.4, 1.5,1.6, 1.7, 1.8,0. , 0. , 0. ,1.9, 2. , 2.1,2.2, 2.3, 2.4});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::maxpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, 1, dataFormat});
    NDArray<double>* output = results->at(0);    
    
    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}
 
 
//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, pnormpool2d_bp_test1) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,  pH=0,pW=0,  dH=1,dW=1;
    int oH=2,oW=2;
    int pnorm = 3;
    double eps = 0.;

    int paddingMode = 0;             // 1-SAME,  0-VALID
    int dataFormat  = 0;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iC, iH, iW});
    NDArray<double> gradO   ('c', {bS, iC, oH, oW});
    NDArray<double> expected('c', {bS, iC, iH, iW}, {9.661570e-04,9.671602e-03,1.306569e-02,3.679184e-02,1.297220e-01,1.040181e-01,1.126750e-01,3.320884e-01,2.340406e-01,1.333333e-01,3.352886e-01,2.070211e-01,
                                                     8.991618e-02,2.160601e-01,1.283173e-01,2.744226e-01,6.364498e-01,3.662123e-01,3.869788e-01,8.808994e-01,4.984556e-01,2.613189e-01,5.818475e-01,3.225517e-01,
                                                     2.065654e-01,4.553546e-01,2.501175e-01,5.190718e-01,1.131343e+00,6.148388e-01,6.362602e-01,1.377521e+00,7.439550e-01,3.833026e-01,8.227519e-01,4.407146e-01,
                                                     3.261206e-01,6.969233e-01,3.717564e-01,7.627507e-01,1.620991e+00,8.600952e-01,8.814538e-01,1.866888e+00,9.873542e-01,5.046682e-01,1.064004e+00,5.602558e-01,
                                                     4.464697e-01,9.389536e-01,4.932274e-01,1.005908e+00,2.108550e+00,1.104095e+00,1.125322e+00,2.354009e+00,1.230180e+00,6.258913e-01,1.305581e+00,6.804127e-01,
                                                     5.671396e-01,1.181128e+00,6.145977e-01,1.248783e+00,2.595083e+00,1.347494e+00,1.368600e+00,2.840157e+00,1.472778e+00,7.470673e-01,1.547362e+00,8.008900e-01});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::pnormpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {eps}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, pnorm, dataFormat});
    NDArray<double>* output = results->at(0);        

    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}


//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, pnormpool2d_bp_test2) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,  pH=0,pW=0,  dH=1,dW=1;
    int oH=2,oW=2;
    int pnorm = 2;
    double eps = 0.;

    int paddingMode = 0;             // 1-SAME,  0-VALID
    int dataFormat  = 0;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iC, iH, iW});
    NDArray<double> gradO   ('c', {bS, iC, oH, oW});
    NDArray<double> expected('c', {bS, iC, iH, iW}, {0.007931,0.042891,0.040544,0.09369 ,0.276841,0.191675,0.163957,0.442946,0.287512,0.154919,0.373153,0.221172,
                                                     0.15901 ,0.365232,0.207846,0.428282,0.959455,0.534076,0.508585,1.128771,0.623089,0.319794,0.698063,0.379547,
                                                     0.321068,0.692438,0.372316,0.757521,1.620323,0.864566,0.838684,1.787943,0.951023,0.483194,1.023434,0.541058,
                                                     0.483937,1.019414,0.536145,1.085348,2.276996,1.192917,1.166749,2.443606,1.278126,0.646499,1.349361,0.703463,
                                                     0.647021,1.346249,0.699745,1.412654,2.932174,1.520512,1.494153,3.098146,1.604985,0.809791,1.675544,0.866229,
                                                     0.810192,1.673009,0.863237,1.739711,3.58665 ,1.847753,1.82126 ,3.752188,1.931741,0.973081,2.001861,1.029173});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::pnormpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {eps}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, pnorm, dataFormat});
    NDArray<double>* output = results->at(0);        

    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}


//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, avgpool2d_bp_test1) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,  pH=0,pW=0,  dH=1,dW=1;
    int oH=2,oW=2;
    int paddingMode = 0;             // 1-SAME,  0-VALID
    int dataFormat  = 0;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iC, iH, iW});
    NDArray<double> gradO   ('c', {bS, iC, oH, oW});
    NDArray<double> expected('c', {bS, iC, iH, iW}, {0.016667,0.05    ,0.033333,0.066667,0.166667,0.1     ,0.066667,0.166667,0.1     ,0.05    ,0.116667,0.066667,
                                                     0.083333,0.183333,0.1     ,0.2     ,0.433333,0.233333,0.2     ,0.433333,0.233333,0.116667,0.25    ,0.133333,
                                                     0.15    ,0.316667,0.166667,0.333333,0.7     ,0.366667,0.333333,0.7     ,0.366667,0.183333,0.383333,0.2     ,
                                                     0.216667,0.45    ,0.233333,0.466667,0.966667,0.5     ,0.466667,0.966667,0.5     ,0.25    ,0.516667,0.266667,
                                                     0.283333,0.583333,0.3     ,0.6     ,1.233333,0.633333,0.6     ,1.233333,0.633333,0.316667,0.65    ,0.333333,
                                                     0.35    ,0.716667,0.366667,0.733333,1.5     ,0.766667,0.733333,1.5     ,0.766667,0.383333,0.783333,0.4     });
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::avgpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, 1, dataFormat});
    NDArray<double>* output = results->at(0);    

    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}


//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, avgpool2d_bp_test2) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,  pH=1,pW=1,  dH=1,dW=1;
    int oH=4,oW=4;
    int paddingMode = 0;             // 1-SAME,  0-VALID
    int dataFormat  = 0;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iC, iH, iW});
    NDArray<double> gradO   ('c', {bS, iC, oH, oW});
    NDArray<double> expected('c', {bS, iC, iH, iW}, {0.233333,0.3     ,0.366667,0.55    ,0.65    ,0.75    ,0.95    ,1.05    ,1.15    ,0.766667,0.833333,0.9     ,
                                                     1.3     ,1.366667,1.433333,2.15    ,2.25    ,2.35    ,2.55    ,2.65    ,2.75    ,1.833333,1.9     ,1.966667,
                                                     2.366667,2.433333,2.5     ,3.75    ,3.85    ,3.95    ,4.15    ,4.25    ,4.35    ,2.9     ,2.966667,3.033333,
                                                     3.433333,3.5     ,3.566667,5.35    ,5.45    ,5.55    ,5.75    ,5.85    ,5.95    ,3.966667,4.033333,4.1     ,
                                                     4.5     ,4.566667,4.633333,6.95    ,7.05    ,7.15    ,7.35    ,7.45    ,7.55    ,5.033333,5.1     ,5.166667,
                                                     5.566667,5.633333,5.7     ,8.549999,8.65    ,8.75    ,8.95    ,9.05    ,9.150001,6.1     ,6.166667,6.233334});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::avgpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, 1, dataFormat});
    NDArray<double>* output = results->at(0);    

    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}


////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, avgpool2d_bp_test3) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,   pH=0,pW=0,   dH=1,dW=1;
    int oH=4,oW=3;
    int paddingMode = 1;             // 1-SAME,  0-VALID
    int dataFormat  = 1;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iH, iW, iC});
    NDArray<double> gradO   ('c', {bS, oH, oW, iC});
    NDArray<double> expected('c', {bS, iH, iW, iC}, {0.19167, 0.23333, 0.275, 0.50833, 0.59167, 0.675, 1.2  , 1.325, 1.45 ,0.50833,0.56667, 0.625, 1.19167,1.30833, 1.425, 2.4  ,2.575, 2.75 ,
                                                     1.18333, 1.24167, 1.3  , 2.54167, 2.65833, 2.775, 4.425, 4.6  , 4.775,1.01667,1.05833, 1.1  , 2.15833,2.24167, 2.325, 3.675,3.8  , 3.925,
                                                     1.69167, 1.73333, 1.775, 3.50833, 3.59167, 3.675, 5.7  , 5.825, 5.95 ,2.60833,2.66667, 2.725, 5.39167,5.50833, 5.625, 8.7  ,8.875, 9.05 ,
                                                     3.28333, 3.34167, 3.4  , 6.74167, 6.85833, 6.975,10.725,10.9  ,11.075,2.51667,2.55833, 2.6  , 5.15833,5.24167, 5.325, 8.175,8.3  , 8.425});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::avgpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, 0, dataFormat});
    NDArray<double>* output = results->at(0);    
    
    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}


//////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, avgpool2d_bp_test4) {

    int bS=2, iH=4,iW=3,  iC=3,  kH=3,kW=2,  sH=1,sW=1,   pH=0,pW=0,   dH=1,dW=1;
    int oH=2,oW=2;
    int paddingMode = 0;             // 1-SAME,  0-VALID
    int dataFormat  = 1;             // 1-NDHWC, 0-NCDHW

    NDArray<double> input   ('c', {bS, iH, iW, iC});
    NDArray<double> gradO   ('c', {bS, oH, oW, iC});
    NDArray<double> expected('c', {bS, iH, iW, iC}, {0.01667,0.03333,0.05,0.08333,0.11667,0.15,0.06667,0.08333,0.1,0.13333,0.16667,0.2 ,0.36667,0.43333,0.5 ,0.23333,0.26667,0.3,
                                                     0.13333,0.16667,0.2 ,0.36667,0.43333,0.5 ,0.23333,0.26667,0.3,0.11667,0.13333,0.15,0.28333,0.31667,0.35,0.16667,0.18333,0.2,
                                                     0.21667,0.23333,0.25,0.48333,0.51667,0.55,0.26667,0.28333,0.3,0.53333,0.56667,0.6 ,1.16667,1.23333,1.3 ,0.63333,0.66667,0.7,
                                                     0.53333,0.56667,0.6 ,1.16667,1.23333,1.3 ,0.63333,0.66667,0.7,0.31667,0.33333,0.35,0.68333,0.71667,0.75,0.36667,0.38333,0.4});
    input.linspace(1.);
    gradO.linspace(0.1, 0.1);
    
    nd4j::ops::avgpool2d_bp<double> op;
    ResultSet<double>* results = op.execute({&input, &gradO}, {}, {kH,kW,  sH,sW,  pH,pW,  dH,dW,  paddingMode, 1, dataFormat});
    NDArray<double>* output = results->at(0);        
    
    ASSERT_EQ(Status::OK(), results->status());
    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));    
    
    delete results;
}

 
////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test1) {

    const int dim0=5, dim1=5, dim2=4;

    NDArray<float> input('c', {dim0, dim1, dim2}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                    23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                    41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                    63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                    82., 90.,  91., 89., 92., 34.,  35., 33., 36.});
    NDArray<float> expected(50.);

    nd4j::ops::percentile<float> op;

    auto result = op.execute({&input}, {50.}, {});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test2) {

    const int dim0=5, dim1=5, dim2=4;

    NDArray<float> input('c', {dim0, dim1, dim2}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});
    NDArray<float> expected('c', {1,1,1}, {11.});

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  2,             1}, {});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test3) {

    const int dim0=5, dim1=5, dim2=4;

    NDArray<float> input('c', {dim0, dim1, dim2}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});
    NDArray<float> expected('c', {1,1,1}, {10.});

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  0,             1}, {});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test4) {

    const int dim0=5, dim1=5, dim2=4;

    NDArray<float> input('c', {dim0, dim1, dim2}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});
    NDArray<float> expected('c', {1,1,1}, {11.});

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  1,             1}, {});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test5) {

    const int dim0=5, dim1=5, dim2=4;

    NDArray<float> input('c', {dim0, dim1, dim2}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});

    NDArray<float> expected('c', {1,1,4}, {12., 7., 11., 10.});

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  0,             1}, {0,1});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test6) {

    const int dim0=5, dim1=5, dim2=4;

    NDArray<float> input('c', {dim0, dim1, dim2}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});

    NDArray<float> expected('c', {1,1,4}, {16., 14., 15., 13.});

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  1,             1}, {0,1});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test7) {

    const int dim0=5, dim1=5, dim2=4;

    NDArray<float> input('c', {dim0, dim1, dim2}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});

    NDArray<float> expected('c', {1,1,4}, {12., 7., 11., 10.});

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  2,             1}, {0,1});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test8) {

    const int dim0=5, dim1=5, dim2=4;

    NDArray<float> input('c', {dim0, dim1, dim2}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});

    NDArray<float> expected('c', {4}, {12., 7., 11., 10.});

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  2,             0}, {0,1});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test9) {

    const int dim0=100;

    NDArray<double> input('c', {dim0}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});

    NDArray<double> expected(11.);

    nd4j::ops::percentile<double> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  2,             0}, {0});
    auto output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test10) {

    const int dim0=100;

    NDArray<double> input('c', {dim0}, {6.,   7.,  83., 81., 84., 86.,  87., 85., 88.,  5.,  8., 78.,  79., 77., 80., 10.,  16., 18.,  19., 17., 20., 22.,
                                                   23., 21., 24., 26.,  27., 25., 28., 30.,  31., 29., 32., 38., 11.,  9., 12., 14.,  15., 13., 39., 37., 40., 42.,  43.,
                                                   41., 44., 46.,  47., 45., 48., 50.,  51., 49., 52., 54.,  55., 53., 56., 58.,  59., 57., 60., 98.,  99., 97.,100., 62.,
                                                   63., 61., 64., 66.,  67., 65., 68., 70.,  71., 69., 72., 74.,  75., 73., 76., 2.,   3.,  1.,  4., 94.,  95., 93., 96.,
                                                   82., 90.,  91., 89., 92., 34.,  35., 33., 36.});

    NDArray<double> expected('c', {1}, {11.});

    nd4j::ops::percentile<double> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  2,             1}, {0});
    auto output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test11) {

    const int dim0=1;

    NDArray<float> input('c', {dim0}, {100.});

    NDArray<float> expected('c', {1}, {100.});

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  2,             1}, {0});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, percentile_test12) {

    const int dim0=1;

    NDArray<float> input('c', {dim0}, {100.});

    NDArray<float> expected(100.);

    nd4j::ops::percentile<float> op;
                                       //q,  interpolation, keepDims
    auto result = op.execute({&input}, {10,  2,             0}, {});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(expected.isSameShape(output));
    ASSERT_TRUE(expected.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, transpose_test3) {

    NDArray<float> input('c', {5, 3},   {1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f, 9.f, 10.f, 11.f, 12.f, 13.f, 14.f, 15.f});
    NDArray<float> exp('c', {3, 5},   {1.f, 4.f, 7.f, 10.f, 13.f, 2.f, 5.f, 8.f, 11.f, 14.f, 3.f, 6.f, 9.f, 12.f, 15.f});

    nd4j::ops::transpose<float> op;
    auto result = op.execute({&input}, {}, {});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, fill_test2) {

    NDArray<float> x('c', {1,2},  {2.f, 2.f});
    NDArray<float> exp('c', {2, 2},{42.f, 42.f, 42.f, 42.f});
    
    nd4j::ops::fill<float> op;
    auto result = op.execute({&x}, {42.f}, {});

    ASSERT_EQ(ND4J_STATUS_OK, result->status());

    auto z = result->at(0);    

    ASSERT_TRUE(exp.isSameShape(z));
    ASSERT_TRUE(exp.equalsTo(z));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, fill_test3) {

    NDArray<float> x('c', {2},  {2.f, 2.f});
    NDArray<float> exp('c', {2, 2},{42.f, 42.f, 42.f, 42.f});
        
    nd4j::ops::fill<float> op;
    auto result = op.execute({&x}, {42.f}, {});
    auto output = result->at(0);    

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, clipbynorm_test3) {
    
    NDArray<double> x('c', {3, 5});    
    NDArray<double> unities('c', {3, 1}, {1., 1., 1.});
    NDArray<double> scale('c', {3, 1}, {1.1, 1., 0.9});     

    x.linspace(100.);

    NDArray<double> xNorm1 = x.template reduceAlongDims<simdOps::Norm2<double>>({1}, true);
    x /= xNorm1;
    xNorm1 = x.template reduceAlongDims<simdOps::Norm2<double>>({1}, true);

    ASSERT_TRUE(unities.isSameShape(xNorm1));
    ASSERT_TRUE(unities.equalsTo(xNorm1));

    x *= scale;
    xNorm1 = x.template reduceAlongDims<simdOps::Norm2<double>>({1}, true);

    nd4j::ops::clipbynorm<double> op;
    auto result = op.execute({&x}, {1.0}, {1});
    auto z = result->at(0);

    NDArray<double> zNorm1 = z->template reduceAlongDims<simdOps::Norm2<double>>({1}, true);
    NDArray<double> exp('c', {3, 1}, {1., 1., xNorm1(2)});
        
    ASSERT_TRUE(exp.isSameShape(&zNorm1));
    ASSERT_TRUE(exp.equalsTo(&zNorm1));

    delete result;
}


////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, cumsum_test1) {
    
    NDArray<float> inputC('c', {3, 5},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12., 13., 14., 15.});    
    NDArray<float> axis(1.);

    NDArray<float> expFF('c', {3, 5}, {1.,  3.,  6., 10., 15., 6., 13., 21., 30., 40., 11., 23., 36., 50., 65.});
    NDArray<float> expTF('c', {3, 5}, {0., 1., 3.,  6., 10., 0.,  6., 13., 21., 30., 0., 11., 23., 36., 50.});

    NDArray<float> expFT('c', {3, 5}, {15, 14, 12, 9, 5,40, 34, 27, 19, 10,65, 54, 42, 29, 15});    //+++
    NDArray<float> expTT('c', {3, 5}, {14, 12, 9, 5, 0,34, 27, 19, 10, 0,54, 42, 29, 15, 0});

    int exclusive, reverse;    

    //************************************//
    exclusive = 0; reverse = 0;

    nd4j::ops::cumsum<float> op;
    auto result = op.execute({&inputC, &axis}, {}, {exclusive, reverse});
    ASSERT_EQ(Status::OK(), result->status());    
    auto z = result->at(0);    
    ASSERT_TRUE(expFF.equalsTo(z));
    delete result;

    //************************************//
    exclusive = 1; reverse = 0;

    result = op.execute({&inputC, &axis}, {}, {exclusive, reverse});
    ASSERT_EQ(Status::OK(), result->status());    
    z = result->at(0);    
    ASSERT_TRUE(expTF.equalsTo(z));
    delete result;

    //************************************//
    exclusive = 0; reverse = 1;

    result = op.execute({&inputC, &axis}, {}, {exclusive, reverse});
    ASSERT_EQ(Status::OK(), result->status());    
    z = result->at(0);    
    ASSERT_TRUE(expFT.equalsTo(z));
    delete result;

    //************************************//
    exclusive = 1; reverse = 1;

    result = op.execute({&inputC, &axis}, {}, {exclusive, reverse});
    ASSERT_EQ(Status::OK(), result->status());    
    z = result->at(0);    
    ASSERT_TRUE(expTT.equalsTo(z));
    delete result;   
   
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, cumprod_test1) {
    
    NDArray<float> inputC('c', {3, 5},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12., 13., 14., 15.});    
    NDArray<float> axis(1.);

    NDArray<float> expFF('c', {3, 5}, {1.,   2.,   6.,    24.,   120., 6.,  42., 336.,  3024., 30240.,11., 132.,1716., 24024.,360360.});
    NDArray<float> expTF('c', {3, 5}, {1, 1, 2, 6, 24,1, 6, 42, 336, 3024,1, 11, 132, 1716, 24024});

    NDArray<float> expFT('c', {3, 5}, {120, 120, 60, 20, 5,30240, 5040, 720, 90, 10,360360, 32760, 2730, 210, 15});    //+++
    NDArray<float> expTT('c', {3, 5}, {120, 60, 20, 5, 1,5040, 720, 90, 10, 1,32760, 2730, 210, 15, 1});

    int exclusive, reverse;    

    //************************************//
    exclusive = 0; reverse = 0;

    nd4j::ops::cumprod<float> op;
    auto result = op.execute({&inputC, &axis}, {}, {exclusive, reverse});
    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
    ASSERT_TRUE(expFF.equalsTo(z));
    delete result;

    //************************************//
    exclusive = 1; reverse = 0;

    result = op.execute({&inputC, &axis}, {}, {exclusive, reverse});
    ASSERT_EQ(Status::OK(), result->status());    
    z = result->at(0);    
    ASSERT_TRUE(expTF.equalsTo(z));
    delete result;

    //************************************//
    exclusive = 0; reverse = 1;

    result = op.execute({&inputC, &axis}, {}, {exclusive, reverse});
    ASSERT_EQ(Status::OK(), result->status());    
    z = result->at(0);    
    ASSERT_TRUE(expFT.equalsTo(z));
    delete result;

    //************************************//
    exclusive = 1; reverse = 1;

    result = op.execute({&inputC, &axis}, {}, {exclusive, reverse});
    ASSERT_EQ(Status::OK(), result->status());    
    z = result->at(0);    
    ASSERT_TRUE(expTT.equalsTo(z));
    delete result;   
   
}
 
////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test1) {

    NDArray<float> input('c', {2, 3},    {1., 2., 3., 4., 5., 6.});
    NDArray<float> paddings('c', {2, 2}, {1, 1, 2, 2});

    NDArray<float> exp('c', {4, 7}, {2, 1, 1, 2, 3, 3, 2, 2, 1, 1, 2, 3, 3, 2, 5, 4, 4, 5, 6, 6, 5, 5, 4, 4, 5, 6, 6, 5});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test2) {

    NDArray<float> input('c', {2, 3},    {1., 2., 3., 4., 5., 6.});
    NDArray<float> paddings('c', {2, 2}, {1, 1, 2, 2});

    NDArray<float> exp('c', {4, 7}, {6, 5, 4, 5, 6, 5, 4, 3, 2, 1, 2, 3, 2, 1, 6, 5, 4, 5, 6, 5, 4, 3, 2, 1, 2, 3, 2, 1});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {0});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test3) {

    NDArray<float> input('c', {3},  {1., 2., 3.});
    NDArray<float> paddings('c', {1,2}, {2, 2});

    NDArray<float> exp('c', {7}, {2, 1, 1, 2, 3, 3, 2});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test4) {

    NDArray<float> input('c', {3},  {1., 2., 3.});
    NDArray<float> paddings('c', {2}, {2, 3});

    NDArray<float> exp('c', {8}, {2, 1, 1, 2, 3, 3, 2, 1});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test5) {

    NDArray<float> input('c', {3},  {1., 2., 3.});
    NDArray<float> paddings('c', {2}, {2, 2});

    NDArray<float> exp('c', {7}, {3, 2, 1, 2, 3, 2, 1});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {0});
    NDArray<float>* output = result->at(0);    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test6) {

    NDArray<float> input(1.);
    NDArray<float> paddings('c', {1,2,1,1}, {1, 1});

    NDArray<float> exp('c', {3}, {1,1,1});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test7) {

    NDArray<float> input(1.);
    NDArray<float> paddings('c', {2}, {1, 1});

    NDArray<float> exp('c', {3}, {1,1,1});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test8) {

    NDArray<float> input('c', {1,3},  {1., 2., 3.});
    NDArray<float> paddings('c', {2, 2}, {1, 1, 3, 3});

    NDArray<float> exp('c', {3,9}, {3, 2, 1, 1, 2, 3, 3, 2, 1, 3, 2, 1, 1, 2, 3, 3, 2, 1, 3, 2, 1, 1, 2, 3, 3, 2, 1});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test9) {

    NDArray<float> input('c', {2, 3},    {1., 2., 3., 4., 5., 6.});
    NDArray<float> paddings('c', {2, 2}, {2, 2, 3, 3});

    NDArray<float> exp('c', {6, 9}, {6, 5, 4, 4, 5, 6, 6, 5, 4, 3, 2, 1, 1, 2, 3, 3, 2, 1, 3, 2, 1, 1, 2, 3, 3, 2, 1, 6, 5, 4, 4, 5, 6, 6, 5, 4, 6, 5, 4, 4, 5, 6, 6, 5, 4, 3, 2, 1, 1, 2, 3, 3, 2, 1});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test10) {

    NDArray<float> input('c', {1,3},  {1., 2., 3.});
    NDArray<float> paddings('c', {2, 2}, {0, 0, 0, 0});

    NDArray<float> exp('c', {1,3}, {1., 2., 3.});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test11) {

    NDArray<float> input('c', {1,3},  {1., 2., 3.});
    NDArray<float> paddings('c', {2, 2}, {0, 0, 0, 0});

    NDArray<float> exp('c', {1,3}, {1., 2., 3.});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {0});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test12) {

    NDArray<float> input('c', {3},  {1., 2., 3.});
    NDArray<float> paddings('c', {2,1}, {0, 0});

    NDArray<float> exp('c', {3}, {1., 2., 3.});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {0});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test13) {

    NDArray<float> input('c', {2, 3},    {1., 2., 3., 4., 5., 6.});
    NDArray<float> paddings('c', {2, 2}, {0, 0, 0, 0});

    NDArray<float> exp('c', {2, 3},    {1., 2., 3., 4., 5., 6.});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {0});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test14) {

    NDArray<float> input('c', {2, 3},    {1., 2., 3., 4., 5., 6.});
    NDArray<float> paddings('c', {2, 2}, {1, 0, 0, 1});

    NDArray<float> exp('c', {3, 4},    {4, 5, 6, 5, 1, 2, 3, 2, 4, 5, 6, 5});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {0});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test15) {

    NDArray<float> input('c', {2, 3},    {1., 2., 3., 4., 5., 6.});
    NDArray<float> paddings('c', {2, 2}, {1, 1, 0, 0});

    NDArray<float> exp('c', {4, 3},  {1, 2, 3, 1, 2, 3, 4, 5, 6, 4, 5, 6});

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {1});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, mirrorPad_test16) {

    NDArray<float> input('c', {4,3,2});
    NDArray<float> paddings('c', {3,2}, {3,3,2,2,1,1});

    NDArray<float> exp('c', {10,7,4},  {24., 23., 24., 23.,22., 21., 22., 21.,20., 19., 20., 19.,22., 21., 22., 21.,24., 23., 24., 23.,22., 21., 22., 21.,20., 19., 20., 19.,18., 17., 18., 17.,16., 15., 16., 15.,14., 13., 14., 13.,16., 15., 16., 15.,18., 17., 18., 17.,16., 15., 16., 15.,14., 13., 14., 13.,
            12., 11., 12., 11.,10.,  9., 10.,  9., 8.,  7.,  8.,  7.,10.,  9., 10.,  9.,12., 11., 12., 11.,10.,  9., 10.,  9., 8.,  7.,  8.,  7., 6.,  5.,  6.,  5., 4.,  3.,  4.,  3., 2.,  1.,  2.,  1., 4.,  3.,  4.,  3., 6.,  5.,  6.,  5., 4.,  3.,  4.,  3., 2.,  1.,  2.,  1.,
            12., 11., 12., 11.,10.,  9., 10.,  9., 8.,  7.,  8.,  7.,10.,  9., 10.,  9.,12., 11., 12., 11.,10.,  9., 10.,  9., 8.,  7.,  8.,  7.,18., 17., 18., 17.,16., 15., 16., 15.,14., 13., 14., 13.,16., 15., 16., 15.,18., 17., 18., 17.,16., 15., 16., 15.,14., 13., 14., 13.,
            24., 23., 24., 23.,22., 21., 22., 21.,20., 19., 20., 19.,22., 21., 22., 21.,24., 23., 24., 23.,22., 21., 22., 21.,20., 19., 20., 19.,18., 17., 18., 17.,16., 15., 16., 15.,14., 13., 14., 13.,16., 15., 16., 15.,18., 17., 18., 17.,16., 15., 16., 15.,14., 13., 14., 13.,
            12., 11., 12., 11.,10.,  9., 10.,  9., 8.,  7.,  8.,  7.,10.,  9., 10.,  9.,12., 11., 12., 11.,10.,  9., 10.,  9., 8.,  7.,  8.,  7., 6.,  5.,  6.,  5., 4.,  3.,  4.,  3., 2.,  1.,  2.,  1., 4.,  3.,  4.,  3., 6.,  5.,  6.,  5., 4.,  3.,  4.,  3., 2.,  1.,  2.,  1.});
    input.linspace(1.);

    nd4j::ops::mirror_pad<float> op;
    auto result = op.execute({&input, &paddings}, {}, {0});
    NDArray<float>* output = result->at(0);

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_1) {
    
    NDArray<float> input('c', {3, 5},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12., 13., 14., 15.});    
    NDArray<float> exp(120.f);
    //************************************//

    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&input}, {}, {});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
    //z->printIndexedBuffer("Result is ");
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_2) {
    
    NDArray<float> input('c', {3, 5},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12., 13., 14., 15.});    
    NDArray<float> exp({15.f, 40.f, 65.f});
    //************************************//

    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&input}, {}, {1});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_1) {
    
    NDArray<float> input('c', {3, 5},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12., 13., 14., 15.});    
    NDArray<float> exp(1307674368000.f);
    //************************************//

    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&input}, {}, {});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
    //z->printIndexedBuffer("Result is ");
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_2) {
    
    NDArray<float> input('c', {3, 5},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12., 13., 14., 15.});    
    NDArray<float> exp({120.f, 30240.f, 360360.f});
    //************************************//

    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&input}, {}, {1});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_01) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp('c', {4}, {66.f, 72.f, 78.f, 84.f});
    x.linspace(1);

    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&x}, {}, {0,1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_02) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp('c', {1,1,4}, {66.f, 72.f, 78.f, 84.f});
    x.linspace(1);

    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&x}, {1.}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_3) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp('c', {3}, {68.f, 100.f, 132.f});
    x.linspace(1);

    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&x}, {}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_4) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp('c', {1,3,1}, {68.f, 100.f, 132.f});
    x.linspace(1);

    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&x}, {1.}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_5) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp(300.f);
    x.linspace(1);

    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&x}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_6) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp(300.f);
    x.linspace(1);
           
    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&x}, {}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_7) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp('c', {1,1,1}, {300.f});
    x.linspace(1);
//    x.printIndexedBuffer("Input with shape (2, 3, 4) is");       
    nd4j::ops::reduce_sum<float> op;
    auto result = op.execute({&x}, {1.}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_01) {

    NDArray<float> x('c', {2,3,2});
    NDArray<float> exp('c', {2}, {10395.f, 46080.f});
    x.linspace(1);

    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&x}, {}, {0,1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_02) {

    NDArray<float> x('c', {2,3,2});
    NDArray<float> exp('c', {1,1,2}, {10395.f, 46080.f});
    x.linspace(1);

    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&x}, {1.}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_3) {

    NDArray<float> x('c', {2,3,2});
    NDArray<float> exp('c', {3}, {112.f, 1080.f, 3960.f});
    x.linspace(1);

    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&x}, {}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_4) {

    NDArray<float> x('c', {2,3,2});
    NDArray<float> exp('c', {1,3,1}, {112.f, 1080.f, 3960.f});
    x.linspace(1);

    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&x}, {1.}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_5) {

    NDArray<float> x('c', {2,3,2});
    NDArray<float> exp(479001600.f);
    x.linspace(1);
    
    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&x}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_6) {

    NDArray<float> x('c', {2,3,2});
    NDArray<float> exp(479001600.f);
    x.linspace(1);
           
    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&x}, {}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_7) {

    NDArray<float> x('c', {2,3,2});
    NDArray<float> exp('c', {1, 1, 1}, {479001600.f});
    x.linspace(1);
//    x.printIndexedBuffer("Input with shape (2, 3, 4) is");       
    nd4j::ops::reduce_prod<float> op;
    auto result = op.execute({&x}, {1.}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

TEST_F(DeclarableOpsTests7, Test_Matmul_Once_Again) {
    NDArray<float> x('c', {1, 2}, {2.0f, 2.0f});
    NDArray<float> y('c', {2, 1}, {2.0f, 2.0f});
    NDArray<float> exp('c', {1, 1}, {8.0f});

    nd4j::ops::matmul<float> op;
    auto result = op.execute({&x, &y}, {}, {});
    ASSERT_EQ(Status::OK(), result->status());

    ASSERT_EQ(exp, *result->at(0));

    delete result;
}

TEST_F(DeclarableOpsTests7, Test_Pnorm_Once_Again) {
    NDArray<double> input('c', {1, 1, 5, 5}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0});
    NDArray<double> exp('c', {1, 1, 5, 5}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0});

    nd4j::ops::pnormpool2d<double> op;
    auto result = op.execute({&input}, {}, {1,1,  1,1,  0,0,  1,1,1,  3,  0});
    ASSERT_EQ(Status::OK(), result->status());

    ASSERT_EQ(exp, *result->at(0));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {4}, {1.f, 2.f, 3.f, 4.f});
    x.linspace(1);

    nd4j::ops::reduce_min<float> op;
    auto result = op.execute({&x}, {}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1,1,4}, {1.f, 2.f, 3.f, 4.f});
    x.linspace(1);

    nd4j::ops::reduce_min<float> op;
    auto result = op.execute({&x}, {1.}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {3}, {1.f, 5.f, 9.f});
    x.linspace(1);

    nd4j::ops::reduce_min<float> op;
    auto result = op.execute({&x}, {}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_4) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1,3,1}, {1.f, 5.f, 9.f});
    x.linspace(1);

    nd4j::ops::reduce_min<float> op;
    auto result = op.execute({&x}, {1.}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_5) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(1.f);
    x.linspace(1);
    
    nd4j::ops::reduce_min<float> op;
    auto result = op.execute({&x}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_6) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(1.f);
    x.linspace(1);
           
    nd4j::ops::reduce_min<float> op;
    auto result = op.execute({&x}, {}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_7) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1, 1, 1}, {1.f});
    x.linspace(1);
//    x.printIndexedBuffer("Input with shape (2, 3, 4) is");
    nd4j::ops::reduce_min<float> op;
    auto result = op.execute({&x}, {1.}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {4}, {21.f, 22.f, 23.f, 24.f});
    x.linspace(1);

    nd4j::ops::reduce_max<float> op;
    auto result = op.execute({&x}, {}, {0,1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
//    output->printShapeInfo("Output shape");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_2) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp('c', {1,1,4}, {21.f, 22.f, 23.f, 24.f});
    x.linspace(1);

    nd4j::ops::reduce_max<float> op;
    auto result = op.execute({&x}, {1.}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {3}, {16.f, 20.f, 24.f});
    x.linspace(1);

    nd4j::ops::reduce_max<float> op;
    auto result = op.execute({&x}, {}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_4) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1,3,1}, {16.f, 20.f, 24.f});
    x.linspace(1);

    nd4j::ops::reduce_max<float> op;
    auto result = op.execute({&x}, {1.}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_5) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(24.f);
    x.linspace(1);
    
    nd4j::ops::reduce_max<float> op;
    auto result = op.execute({&x}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_6) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(24.f);
    x.linspace(1);
           
    nd4j::ops::reduce_max<float> op;
    auto result = op.execute({&x}, {}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_7) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1, 1, 1}, {24.f});
    x.linspace(1);
//    x.printIndexedBuffer("Input with shape (2, 3, 4) is");       
    nd4j::ops::reduce_max<float> op;
    auto result = op.execute({&x}, {1.}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {4}, {66.f, 72.f, 78.f, 84.f});
    x.linspace(1);

    nd4j::ops::reduce_norm1<float> op;
    auto result = op.execute({&x}, {}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_2) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp('c', {1,1,4}, {66.f, 72.f, 78.f, 84.f});
    x.linspace(1);

    nd4j::ops::reduce_norm1<float> op;
    auto result = op.execute({&x}, {1.}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {3}, {68.f, 100.f, 132.f});
    x.linspace(1);

    nd4j::ops::reduce_norm1<float> op;
    auto result = op.execute({&x}, {}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_4) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1,3,1}, {68.f, 100.f, 132.f});
    x.linspace(1);

    nd4j::ops::reduce_norm1<float> op;
    auto result = op.execute({&x}, {1.}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_5) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(300.f);
    x.linspace(1);
    
    nd4j::ops::reduce_norm1<float> op;
    auto result = op.execute({&x}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_6) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(300.f);
    x.linspace(1);
           
    nd4j::ops::reduce_norm1<float> op;
    auto result = op.execute({&x}, {}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_7) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1, 1, 1}, {300.f});
    x.linspace(1);
//    x.printIndexedBuffer("Input with shape (2, 3, 4) is");       
    nd4j::ops::reduce_norm1<float> op;
    auto result = op.execute({&x}, {1.}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {4}, {31.7175f, 33.823071f, 35.97221f, 38.15757f});
    x.linspace(1);

    nd4j::ops::reduce_norm2<float> op;
    auto result = op.execute({&x}, {}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_2) {

    NDArray<float> x('c', {2,3,4});
    NDArray<float> exp('c', {1,1,4}, {31.7175f, 33.823071f, 35.97221f, 38.15757f});
    x.linspace(1);

    nd4j::ops::reduce_norm2<float> op;
    auto result = op.execute({&x}, {1.}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {3}, {29.597298f, 39.344631f, 49.759422f});
    x.linspace(1);

    nd4j::ops::reduce_norm2<float> op;
    auto result = op.execute({&x}, {}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_4) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1,3,1}, {29.597298f, 39.344631f, 49.759422f});
    x.linspace(1);

    nd4j::ops::reduce_norm2<float> op;
    auto result = op.execute({&x}, {1.}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_5) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(70.f);
    x.linspace(1);
    
    nd4j::ops::reduce_norm2<float> op;
    auto result = op.execute({&x}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_6) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(70.f);
    x.linspace(1);
           
    nd4j::ops::reduce_norm2<float> op;
    auto result = op.execute({&x}, {}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_7) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1, 1, 1}, {70.f});
    x.linspace(1);
//    x.printIndexedBuffer("Input with shape (2, 3, 4) is");       
    nd4j::ops::reduce_norm2<float> op;
    auto result = op.execute({&x}, {1.}, {0,1,2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {4}, {21.f, 22.f, 23.f, 24.f});
    x.linspace(1);

    nd4j::ops::reduce_norm_max<float> op;
    auto result = op.execute({&x}, {}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1,1,4}, {21.f, 22.f, 23.f, 24.f});
    x.linspace(1);

    nd4j::ops::reduce_norm_max<float> op;
    auto result = op.execute({&x}, {1.f}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {3}, {16.f, 20.f, 24.f});
    x.linspace(1);

    nd4j::ops::reduce_norm_max<float> op;
    auto result = op.execute({&x}, {}, {0,2});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_4) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1, 3, 1}, {16.f, 20.f, 24.f});
    x.linspace(1);

    nd4j::ops::reduce_norm_max<float> op;
    auto result = op.execute({&x}, {1.f}, {0,2});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_5) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(24.f);
    x.linspace(1);
    
    nd4j::ops::reduce_norm_max<float> op;
    auto result = op.execute({&x}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_6) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(24.f);
    x.linspace(1);
    
    nd4j::ops::reduce_norm_max<float> op;
    auto result = op.execute({&x}, {}, {0, 1, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_7) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1, 1, 1}, {24.f});
    x.linspace(1);
    
    nd4j::ops::reduce_norm_max<float> op;
    auto result = op.execute({&x}, {1.f}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_SquaredNorm_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {4}, {1006.f, 1144.f, 1294.f, 1456.f});
    x.linspace(1);

    nd4j::ops::reduce_sqnorm<float> op;
    auto result = op.execute({&x}, {}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_SquaredNorm_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1,1,4}, {1006.f, 1144.f, 1294.f, 1456.f});
    x.linspace(1);

    nd4j::ops::reduce_sqnorm<float> op;
    auto result = op.execute({&x}, {1.f}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_SquaredNorm_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {3}, {876.f, 1548.f, 2476.f});
    x.linspace(1);

    nd4j::ops::reduce_sqnorm<float> op;
    auto result = op.execute({&x}, {}, {0,2});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_SquaredNorm_4) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1, 3, 1}, {876.f, 1548.f, 2476.f});
    x.linspace(1);

    nd4j::ops::reduce_sqnorm<float> op;
    auto result = op.execute({&x}, {1.f}, {0,2});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_SquaredNorm_5) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(4900.f);
    x.linspace(1);
    
    nd4j::ops::reduce_sqnorm<float> op;
    auto result = op.execute({&x}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_SquaredNorm_6) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp(4900.f);
    x.linspace(1);
    
    nd4j::ops::reduce_sqnorm<float> op;
    auto result = op.execute({&x}, {}, {0, 1, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_SquaredNorm_7) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> exp('c', {1, 1, 1}, {4900.f});
    x.linspace(1);
    
    nd4j::ops::reduce_sqnorm<float> op;
    auto result = op.execute({&x}, {1.f}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_BP_1) {
    
    NDArray<float> input('c', {3, 4},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12.});    
    NDArray<float> eps(0.5f);
    NDArray<float> exp('c', {3, 4}, {0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f,0.5f});
    //************************************//

    nd4j::ops::reduce_sum_bp<float> op;
    auto result = op.execute({&input, &eps}, {}, {});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
//    z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_BP_2) {
    
    NDArray<float> input('c', {3, 4},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12.});    
    NDArray<float> eps('c', {1, 1}, {0.5f});
    NDArray<float> exp('c', {3, 4}, {0.5f, 0.5f, 0.5f, 0.5f, 
                                     0.5f, 0.5f, 0.5f, 0.5f, 
                                     0.5f, 0.5f, 0.5f,0.5f});
    //************************************//

    nd4j::ops::reduce_sum_bp<float> op;
    auto result = op.execute({&input, &eps}, {1.f}, {});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//  z->printIndexedBuffer("Result is ");
//  z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_BP_3) {
    
    NDArray<float> input('c', {3, 4},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12.});    
    NDArray<float> eps('c', {4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {3, 4}, {1.f, 2.f, 3.f, 4.f, 
                                     1.f, 2.f, 3.f, 4.f, 
                                     1.f, 2.f, 3.f, 4.f});
    //************************************//

    nd4j::ops::reduce_sum_bp<float> op;
    auto result = op.execute({&input, &eps}, {}, {0});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
//    z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Sum_BP_4) {
    
    NDArray<float> input('c', {3, 4},   {1., 2., 3., 4., 5., 6., 7., 8., 9., 10., 11., 12.});    
    NDArray<float> eps('c', {1, 4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {3, 4}, {1.f, 2.f, 3.f, 4.f, 
                                     1.f, 2.f, 3.f, 4.f, 
                                     1.f, 2.f, 3.f, 4.f});
    //************************************//

    nd4j::ops::reduce_sum_bp<float> op;
    auto result = op.execute({&input, &eps}, {1.f}, {0});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
//    z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_BP_1) {
    
    NDArray<float> input('c', {3, 5},   {1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f, 9.f, 10.f, 11.f, 12.f, 13.f, 14.f, 15.f});    
    NDArray<float> eps(1307674368000.f);
    //************************************//
//    NDArray<float> exp('c', {3, 4}, {0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f,0.5f});
    //************************************//
    NDArray<float> exp('c', {3, 5},   {1710012166826558903812096.f, 855006083413279451906048.f, 570004067618451974258688.f, 
                                       427503041706639725953024.f, 342002454982589992140800.f, 285002033809225987129344.f, 
                                       244287457550765131825152.f, 213751520853319862976512.f, 190001355872817324752896.f, 
                                       171001227491294996070400.f, 155455648254341989531648.f, 142501016904612993564672.f, 
                                       131539399526781282156544.f, 122143728775382565912576.f, 114000815325130245799936.f});    

    nd4j::ops::reduce_prod_bp<float> op;
    auto result = op.execute({&input, &eps}, {}, {});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
//    z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_BP_2) {
    
    NDArray<float> input('c', {3, 4},   {1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f, 9.f, 10.f, 11.f, 12.f});    
    NDArray<float> eps(0.5f);
    //************************************//
//    NDArray<float> exp('c', {3, 4}, {0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f,0.5f});
    //************************************//
    NDArray<float> exp('c', {3, 4}); 
    
    nd4j::ops::reduce_prod_bp<float> op;
    nd4j::ops::reduce_prod<float> op_exp;
    auto res = op_exp.execute({&input}, {}, {});
    auto result = op.execute({&input, &eps}, {}, {});
    exp.assign(res->at(0)->getScalar(0));
    exp /= input;
    exp *= eps.getScalar(0);
    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
    //z->printIndexedBuffer("Result is ");
    //exp.printIndexedBuffer("Expected");
//    z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
    delete res;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_BP_3) {
    
    NDArray<float> input('c', {3, 4},   {1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f, 9.f, 10.f, 11.f, 12.f});    
    NDArray<float> eps('c', {1, 4}, {1.f, 2.f, 3.f, 4.f});
    //************************************//
    NDArray<float> exp('c', {3, 4}, {45.f, 120.f, 231.f, 384.f, 9.f, 40.f, 99.f, 192.f, 5.f, 24.f, 63.f, 128.f});
    
    nd4j::ops::reduce_prod_bp<float> op;
    nd4j::ops::reduce_prod<float> op_exp;
    auto result = op.execute({&input, &eps}, {1.f}, {0});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
//    exp.printIndexedBuffer("Expected");
//    z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_BP_4) {
    
    NDArray<float> input('c', {3, 4},   {1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f, 9.f, 10.f, 11.f, 12.f});    
    NDArray<float> eps('c', {4}, {1.f, 2.f, 3.f, 4.f});
    //************************************//
    NDArray<float> exp('c', {3, 4}, {45.f, 120.f, 231.f, 384.f, 9.f, 40.f, 99.f, 192.f, 5.f, 24.f, 63.f, 128.f});
    
    nd4j::ops::reduce_prod_bp<float> op;
    nd4j::ops::reduce_prod<float> op_exp;
//    auto res = op_exp.execute({&input}, {}, {});
    auto result = op.execute({&input, &eps}, {0.f}, {0});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
//    exp.printIndexedBuffer("Expected");
//    z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
//    delete res;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Prod_BP_5) {
    
    NDArray<float> input('c', {3, 4},   {1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f, 9.f, 10.f, 11.f, 12.f});    
    NDArray<float> eps('c', {3}, {1.f, 2.f, 3.f});
    //************************************//
    NDArray<float> exp('c', {3, 4}, {24.f, 12.f, 8.f, 6.f, 672.f, 560.f, 480.f, 420.f, 3960.f, 3564.f, 3240.f, 2970.f});
    
    nd4j::ops::reduce_prod_bp<float> op;
    nd4j::ops::reduce_prod<float> op_exp;
//    auto res = op_exp.execute({&input}, {}, {});
    auto result = op.execute({&input, &eps}, {0.f}, {1});

    ASSERT_EQ(Status::OK(), result->status());
    auto z = result->at(0);    
//    z->printIndexedBuffer("Result is ");
//    exp.printIndexedBuffer("Expected");
//    z->printShapeInfo();
    ASSERT_TRUE(exp.equalsTo(z));
    delete result;
//    delete res;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_BP_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {2, 3, 4});
    exp(0) = eps(0);
    exp(1) = eps(1);
    exp(2) = eps(2);
    exp(3) = eps(3);
    x.linspace(1);
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_min_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_BP_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {1, 1, 4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {2, 3, 4});
    exp(0) = eps(0);
    exp(1) = eps(1);
    exp(2) = eps(2);
    exp(3) = eps(3);
    x.linspace(1);
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_min_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_BP_3) {

    NDArray<float> x('c', {3, 4});
    NDArray<float> eps('c', {1, 1}, {0.5f});
    NDArray<float> exp('c', {3, 4});
    x.linspace(1);
    x(2,2) = -1.f;
    exp(2,2) = 0.5f;
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_min_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_BP_4) {

    NDArray<float> x('c', {3, 4});
    NDArray<float> eps(0.5f);
    NDArray<float> exp('c', {3, 4});
    x.linspace(1);
    x(2,2) = -1.f;
    exp(2,2) = 0.5f;
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_min_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_BP_5) {

    NDArray<float> x('c', {4, 4});
    NDArray<float> eps('c', {4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {4, 4});
    x.linspace(1);
    x(0,0) = -1.f;
    x(1,1) = -2.f;
    x(2,2) = -3.f;
    x(3,3) = -4.f;
    exp(0,0) = 1.f;
    exp(1,1) = 2.f;
    exp(2,2) = 3.f;
    exp(3,3) = 4.f;
//    exp(2,2) = 0.5f;
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_min_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Min_BP_6) {

    NDArray<float> x('c', {4, 4});
    NDArray<float> eps('c', {1,4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {4, 4});
    x.linspace(1);
    x(0,0) = -1.f;
    x(1,1) = -2.f;
    x(2,2) = -3.f;
    x(3,3) = -4.f;
    exp(0,0) = 1.f;
    exp(1,1) = 2.f;
    exp(2,2) = 3.f;
    exp(3,3) = 4.f;
//    exp(2,2) = 0.5f;
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_min_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_BP_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {4}, {21.f, 22.f, 23.f, 24.f});
    NDArray<float> exp('c', {2, 3, 4});
    exp(20) = eps(0);
    exp(21) = eps(1);
    exp(22) = eps(2);
    exp(23) = eps(3);
    x.linspace(1);
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_BP_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {1, 1, 4}, {21.f, 22.f, 23.f, 24.f});
    NDArray<float> exp('c', {2, 3, 4});
    exp(20) = eps(0);
    exp(21) = eps(1);
    exp(22) = eps(2);
    exp(23) = eps(3);
    x.linspace(1);
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0, 1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_BP_3) {

    NDArray<float> x('c', {4, 4});
    NDArray<float> eps('c', {4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {4, 4});
    x.linspace(1);
    x(0,0) = 21.f;
    x(1,1) = 22.f;
    x(2,2) = 23.f;
    x(3,3) = 24.f;
    exp(0,0) = 1.f;
    exp(1,1) = 2.f;
    exp(2,2) = 3.f;
    exp(3,3) = 4.f;
//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Max_BP_4) {

    NDArray<float> x('c', {4, 4});
    NDArray<float> eps('c', {1,4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {4, 4});
    x.linspace(1);
    x(0,0) = 21.f;
    x(1,1) = 22.f;
    x(2,2) = 23.f;
    x(3,3) = 24.f;
    exp(0,0) = 1.f;
    exp(1,1) = 2.f;
    exp(2,2) = 3.f;
    exp(3,3) = 4.f;

//    x.printIndexedBuffer("Input is");
//    exp.printIndexedBuffer("Expected ");
    nd4j::ops::reduce_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_BP_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps(5.f);
    x.linspace(1);
    NDArray<float> exp('c', {2, 3, 4});
    x(12) = -2.f;
    x(20) = -3.f;
    exp.assign(5.f);
    exp(12) = -exp(12);
    exp(20) = -exp(20);
    nd4j::ops::reduce_norm1_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_BP_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps({1.f, 2.f, 3.f, 4.f});
    x.linspace(1);
    NDArray<float> exp('c', {2, 3, 4}, {1.f, 2.f, 3.f, 4.f, 1.f, 2.f, 3.f, 4.f, 1.f, 2.f, 3.f, 4.f, 1.f, 2.f, 3.f, 4.f,1.f, 2.f, 3.f, 4.f,1.f, 2.f, 3.f, 4.f});
    nd4j::ops::reduce_norm1_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm1_BP_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {1, 1, 4}, {1.f, 2.f, 3.f, 4.f});
    x.linspace(1);
    NDArray<float> exp('c', {2, 3, 4}, {1.f, 2.f, 3.f, 4.f, 1.f, 2.f, 3.f, 4.f, 1.f, 2.f, 3.f, 4.f, 1.f, 2.f, 3.f, 4.f,1.f, 2.f, 3.f, 4.f,1.f, 2.f, 3.f, 4.f});
    nd4j::ops::reduce_norm1_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_BP_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {4}, {31.7175f, 33.823071f, 35.97221f, 38.15757f});
    x.linspace(1);

    nd4j::ops::reduce_norm2_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(x.isSameShape(output));
    ASSERT_TRUE(x.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_BP_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {1, 1, 4}, {31.7175f, 33.823071f, 35.97221f, 38.15757f});
    x.linspace(1);

    nd4j::ops::reduce_norm2_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(x.isSameShape(output));
    ASSERT_TRUE(x.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_BP_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {3}, {29.597298f, 39.344631f, 49.759422f});
    x.linspace(1);

    nd4j::ops::reduce_norm2_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(x.isSameShape(output));
    ASSERT_TRUE(x.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Norm2_BP_4) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {1,3,1}, {29.597298f, 39.344631f, 49.759422f});
    x.linspace(1);

    nd4j::ops::reduce_norm2_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(x.isSameShape(output));
    ASSERT_TRUE(x.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_SquaredNorm_BP_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {2, 3, 4}, { 2.f,  8.f, 18.f, 32.f, 
                                        10.f, 24.f, 42.f, 64.f, 
                                        18.f, 40.f, 66.f, 96.f, 
                                            26.f, 56.f, 90.f, 128.f, 
                                            34.f, 72.f, 114.f, 160.f, 
                                            42.f, 88.f, 138.f, 192.f});
    x.linspace(1);

    nd4j::ops::reduce_sqnorm_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0,1});

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");

//    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_BP_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    exp(20) = 1.f;
    exp(21) = 2.f;
    exp(22) = 3.f;
    exp(23) = 4.f;

    nd4j::ops::reduce_norm_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_BP_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {1,1,4}, {1.f, 2.f, 3.f, 4.f});
    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    exp(20) = 1.f;
    exp(21) = 2.f;
    exp(22) = 3.f;
    exp(23) = 4.f;

    nd4j::ops::reduce_norm_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0,1});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_BP_3) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {3}, {1.f, 2.f, 3.f});
    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);

    exp(15) = 1.f;
    exp(19) = 2.f;
    exp(23) = 3.f;

    nd4j::ops::reduce_norm_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0,2});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_BP_4) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {1, 3, 1}, {1.f, 2.f, 3.f});
    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    exp(15) = 1.f;
    exp(19) = 2.f;
    exp(23) = 3.f;
    nd4j::ops::reduce_norm_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {0,2});
    auto output = result->at(0);
//    output->printIndexedBuffer("Result is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_BP_5) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps(1.f);
    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    exp(23) = 1.f;
    nd4j::ops::reduce_norm_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_BP_6) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps(1.f);
    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    exp(23) = 1.f;
    
    nd4j::ops::reduce_norm_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0, 1, 2});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_NormMax_BP_7) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> eps('c', {1, 1, 1}, {1.f});
    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    exp(23) = 1.f;
    nd4j::ops::reduce_norm_max_bp<float> op;
    auto result = op.execute({&x, &eps}, {1.f}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Dot_BP_1) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> y('c', {2, 3, 4});
    NDArray<float>* z; //('c', {4});
    NDArray<float> eps(1.f);
//    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    y.linspace(2);


    nd4j::ops::reduce_dot_bp<float> op;
    auto result = op.execute({&x, &y, &eps}, {}, {});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

//    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

//    ASSERT_TRUE(y.isSameShape(output));
    ASSERT_TRUE(y.equalsTo(output));

    delete result;
//    delete z;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Dot_BP_2) {

    NDArray<float> x('c', {2, 3, 4});
    NDArray<float> y('c', {2, 3, 4});
//    NDArray<float>* z; //('c', {4});
    NDArray<float> eps('c', {2, 4});
//    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    eps.linspace(1);
    y.assign(2.f);
    
    nd4j::ops::reduce_dot_bp<float> op;
    auto result = op.execute({&x, &y, &eps}, {}, {1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
//    z->printShapeInfo("Result shape is");
    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

//    ASSERT_TRUE(exp.isSameShape(output));
//    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
//    delete z;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_Dot_BP_3) {

    NDArray<float> x('c', {3, 4});
    NDArray<float> y('c', {3, 4});
    NDArray<float> eps('c', {3});
//    NDArray<float> exp('c', {2, 3, 4});
    x.linspace(1);
    eps.linspace(1);
    y.assign(2.f);

    nd4j::ops::reduce_dot_bp<float> op;
    auto result = op.execute({&x,&y, &eps}, {}, {1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

//    ASSERT_TRUE(exp.isSameShape(output));
//    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
//    delete z;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_CumSum_BP_1) {

    NDArray<float> x('c', {3, 4});
//    NDArray<float> y('c', {3, 4});
//    NDArray<float>* z; //('c', {4});
    NDArray<float> eps('c', {3, 4});
    NDArray<float> exp('c', {3, 4}, {12.f, 11.f, 10.f, 9.f, 8.f, 7.f, 
                                      6.f,  5.f,  4.f, 3.f, 2.f, 1.f});
    x.linspace(1);
    eps.assign(1.f);

//    z = x.applyReduce3<simdOps::Dot<float>>(&y, {0}, nullptr);
    nd4j::ops::cumsum_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {0,0});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
//    output->printShapeInfo("Result shape is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;
//    delete z;
}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_CumSum_BP_2) {
    NDArray<float> x('c', {3, 4});
//    NDArray<float> y('c', {3, 4});
//    NDArray<float>* z; //('c', {4});
    NDArray<float> eps('c', {3, 4});
    NDArray<float> exp('c', {3, 4}, { 11.f, 10.f, 9.f, 8.f, 7.f, 6.f,  
                                      5.f,  4.f, 3.f, 2.f, 1.f, 0.f});
    x.linspace(1);
//    exp.linspace(1);
    eps.assign(1.f);

//    z = x.applyReduce3<simdOps::Dot<float>>(&y, {0}, nullptr);
    nd4j::ops::cumsum_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {1,0});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
//    output->printShapeInfo("Result shape is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;

}

////////////////////////////////////////////////////////////////////////////////
TEST_F(DeclarableOpsTests7, Test_Reduce_CumSum_BP_3) {
    NDArray<float> x('c', {3, 4});
//    NDArray<float> y('c', {3, 4});
//    NDArray<float>* z; //('c', {4});
    NDArray<float> eps('c', {3, 4});
    NDArray<float> exp('c', {3, 4});
                                    
    x.linspace(1);
    exp.linspace(0);
    eps.assign(1.f);

//    z = x.applyReduce3<simdOps::Dot<float>>(&y, {0}, nullptr);
    nd4j::ops::cumsum_bp<float> op;
    auto result = op.execute({&x, &eps}, {}, {1,1});
    auto output = result->at(0);    
//    output->printIndexedBuffer("Result is");
//    output->printShapeInfo("Result shape is");

    ASSERT_EQ(ND4J_STATUS_OK, result->status());    

//    ASSERT_TRUE(exp.isSameShape(output));
    ASSERT_TRUE(exp.equalsTo(output));

    delete result;

}

