/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class HardTanhDerivative
extends BaseTransformOp {
    public HardTanhDerivative() {
    }

    public HardTanhDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public HardTanhDerivative(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public HardTanhDerivative(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public HardTanhDerivative(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 25;
    }

    @Override
    public String name() {
        return "hardtanhderivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        double r = origin.realComponent().doubleValue();
        return r >= -1.0 && r <= 1.0 ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(0.0, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        double r = origin.realComponent().doubleValue();
        return r >= -1.0 && r <= 1.0 ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(0.0, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        double r = origin.realComponent().doubleValue();
        return r >= -1.0 && r <= 1.0 ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(0.0, 0.0);
    }

    @Override
    public float op(float origin, float other) {
        return HardTanhDerivative.hardTanhDeriv(origin);
    }

    @Override
    public double op(double origin, double other) {
        return HardTanhDerivative.hardTanhDeriv(origin);
    }

    @Override
    public double op(double origin) {
        return HardTanhDerivative.hardTanhDeriv(origin);
    }

    @Override
    public float op(float origin) {
        return HardTanhDerivative.hardTanhDeriv(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        double r = origin.realComponent().doubleValue();
        return r >= -1.0 && r <= 1.0 ? Nd4j.createDouble(1.0, 0.0) : Nd4j.createDouble(0.0, 0.0);
    }

    private static float hardTanhDeriv(float num) {
        return num >= -1.0f && num <= 1.0f ? 1.0f : 0.0f;
    }

    private static double hardTanhDeriv(double num) {
        return num >= -1.0 && num <= 1.0 ? 1.0 : 0.0;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new HardTanhDerivative(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new HardTanhDerivative(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new HardTanhDerivative(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new HardTanhDerivative(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

