/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape;

import java.util.Arrays;

public class ShapeDescriptor {
    private char order;
    private int offset;
    private int ews;
    private long hashShape = 0L;
    private long hashStride = 0L;
    private int[] shape;
    private int[] stride;

    public ShapeDescriptor(int[] shape, int[] stride, int offset, int ews, char order) {
        this.shape = Arrays.copyOf(shape, shape.length);
        this.stride = Arrays.copyOf(stride, stride.length);
        this.offset = offset;
        this.ews = ews;
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeDescriptor that = (ShapeDescriptor)o;
        if (this.order != that.order) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.ews != that.ews) {
            return false;
        }
        if (!Arrays.equals(this.shape, that.shape)) {
            return false;
        }
        return Arrays.equals(this.stride, that.stride);
    }

    public int hashCode() {
        int result = this.order;
        result = 31 * result + this.offset;
        result = 31 * result + this.ews;
        result = 31 * result + Arrays.hashCode(this.shape);
        result = 31 * result + Arrays.hashCode(this.stride);
        return result;
    }
}

