/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape;

import java.beans.ConstructorProperties;

public class StridePermutation
implements Comparable<StridePermutation> {
    private int permutation;
    private int stride;

    @Override
    public int compareTo(StridePermutation o) {
        int astride = this.stride;
        int bstride = o.getStride();
        if (astride < 0) {
            astride = -astride;
        }
        if (bstride < 0) {
            bstride = -bstride;
        }
        if (astride == bstride) {
            int aperm = this.permutation;
            int bperm = o.getPermutation();
            return aperm < bperm ? -1 : 1;
        }
        if (astride > bstride) {
            return -1;
        }
        return 1;
    }

    public static StridePermutation[] create(int[] stride) {
        StridePermutation[] ret = new StridePermutation[stride.length];
        for (int i = 0; i < stride.length; ++i) {
            ret[i] = new StridePermutation(i, stride[i]);
        }
        return ret;
    }

    public int getPermutation() {
        return this.permutation;
    }

    public int getStride() {
        return this.stride;
    }

    public void setPermutation(int permutation) {
        this.permutation = permutation;
    }

    public void setStride(int stride) {
        this.stride = stride;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StridePermutation)) {
            return false;
        }
        StridePermutation other = (StridePermutation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPermutation() != other.getPermutation()) {
            return false;
        }
        return this.getStride() == other.getStride();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StridePermutation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPermutation();
        result = result * 59 + this.getStride();
        return result;
    }

    public String toString() {
        return "StridePermutation(permutation=" + this.getPermutation() + ", stride=" + this.getStride() + ")";
    }

    @ConstructorProperties(value={"permutation", "stride"})
    public StridePermutation(int permutation, int stride) {
        this.permutation = permutation;
        this.stride = stride;
    }

    public StridePermutation() {
    }
}

