/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.convolution;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.convolution.Col2Im;
import org.nd4j.linalg.api.ops.impl.transforms.convolution.Im2col;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Convolution {
    private static Logger log = LoggerFactory.getLogger(Convolution.class);

    private Convolution() {
    }

    public static INDArray col2im(INDArray col, int[] stride, int[] padding, int height, int width) {
        return Convolution.col2im(col, stride[0], stride[1], padding[0], padding[1], height, width);
    }

    public static INDArray col2im(INDArray col, int sy, int sx, int ph, int pw, int h, int w) {
        if (col.rank() != 6) {
            throw new IllegalArgumentException("col2im input array must be rank 6");
        }
        Col2Im col2Im = new Col2Im(col, sy, sx, ph, pw, h, w);
        return Nd4j.getExecutioner().exec(col2Im).z();
    }

    public static INDArray col2im(INDArray col, INDArray z, int sy, int sx, int ph, int pw, int h, int w) {
        if (col.rank() != 6) {
            throw new IllegalArgumentException("col2im input array must be rank 6");
        }
        if (z.rank() != 4) {
            throw new IllegalArgumentException("col2im output array must be rank 4");
        }
        Col2Im col2Im = new Col2Im(col, sy, sx, ph, pw, h, w, z);
        Nd4j.getExecutioner().exec(col2Im);
        return z;
    }

    public static INDArray im2col(INDArray img, int[] kernel, int[] stride, int[] padding) {
        return Convolution.im2col(img, kernel[0], kernel[1], stride[0], stride[1], padding[0], padding[1], 0, false);
    }

    public static INDArray im2col(INDArray img, int kh, int kw, int sy, int sx, int ph, int pw, boolean coverAll) {
        Im2col im2col = new Im2col(img, kh, kw, sy, sx, ph, pw, coverAll);
        return Nd4j.getExecutioner().exec(im2col).z();
    }

    public static INDArray im2col(INDArray img, int kh, int kw, int sy, int sx, int ph, int pw, boolean coverAll, INDArray out) {
        Im2col im2col = new Im2col(img, kh, kw, sy, sx, ph, pw, coverAll, out);
        return Nd4j.getExecutioner().exec(im2col).z();
    }

    public static INDArray im2col(INDArray img, int kh, int kw, int sy, int sx, int ph, int pw, int pval, boolean coverAll) {
        Im2col im2col = new Im2col(img, kh, kw, sy, sx, ph, pw, coverAll);
        return Nd4j.getExecutioner().exec(im2col).z();
    }

    public static int outSize(int size, int k, int s, int p, boolean coverAll) {
        if (coverAll) {
            return (size + p * 2 - k + s - 1) / s + 1;
        }
        return (size + p * 2 - k) / s + 1;
    }

    public static INDArray conv2d(INDArray input, INDArray kernel, Type type) {
        return Nd4j.getConvolution().conv2d(input, kernel, type);
    }

    public static INDArray conv2d(IComplexNDArray input, IComplexNDArray kernel, Type type) {
        return Nd4j.getConvolution().conv2d(input, kernel, type);
    }

    public static INDArray convn(INDArray input, INDArray kernel, Type type, int[] axes) {
        return Nd4j.getConvolution().convn(input, kernel, type, axes);
    }

    public static IComplexNDArray convn(IComplexNDArray input, IComplexNDArray kernel, Type type, int[] axes) {
        return Nd4j.getConvolution().convn(input, kernel, type, axes);
    }

    public static INDArray convn(INDArray input, INDArray kernel, Type type) {
        return Nd4j.getConvolution().convn(input, kernel, type);
    }

    public static IComplexNDArray convn(IComplexNDArray input, IComplexNDArray kernel, Type type) {
        return Nd4j.getConvolution().convn(input, kernel, type);
    }

    public static enum Type {
        FULL,
        VALID,
        SAME;

    }
}

