/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class AMax
extends BaseAccumulation {
    public AMax() {
    }

    public AMax(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public AMax(INDArray x) {
        super(x);
    }

    public AMax(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public double op(double origin, double other) {
        return Math.abs(origin);
    }

    @Override
    public float op(float origin, float other) {
        return Math.abs(origin);
    }

    @Override
    public double update(double accum, double x) {
        return FastMath.max((double)Math.abs(accum), (double)Math.abs(x));
    }

    @Override
    public double update(double accum, double x, double y) {
        return FastMath.max((double)Math.abs(accum), (double)Math.abs(x));
    }

    @Override
    public float update(float accum, float x) {
        return FastMath.max((float)accum, (float)x);
    }

    @Override
    public float update(float accum, float x, float y) {
        return FastMath.max((float)accum, (float)x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.absoluteValue().doubleValue() > x ? accum : Nd4j.createComplexNumber(x, 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.absoluteValue().doubleValue() > x ? accum : Nd4j.createComplexNumber(x, 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.absoluteValue().doubleValue() > x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.absoluteValue().doubleValue() > x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.absoluteValue().doubleValue() > x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public int opNum() {
        return 13;
    }

    @Override
    public String name() {
        return "amax";
    }

    @Override
    public double zeroDouble() {
        return 0.0;
    }

    @Override
    public float zeroHalf() {
        return 0.0f;
    }

    @Override
    public float zeroFloat() {
        return 0.0f;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new AMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new AMax(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new AMax(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new AMax(this.x.tensorAlongDimension(index, dimension));
    }
}

