/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.ASum;

public class AMean
extends ASum {
    public AMean() {
    }

    public AMean(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public AMean(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public AMean(INDArray x) {
        super(x);
    }

    public AMean(INDArray x, INDArray y) {
        super(x, y);
    }

    public AMean(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    @Override
    public int opNum() {
        return 15;
    }

    @Override
    public String name() {
        return "amean";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        AMean ret = this.y() != null ? new AMean(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length()) : new AMean(this.x.vectorAlongDimension(index, dimension));
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        AMean ret = this.y() != null ? new AMean(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length()) : new AMean(this.x.tensorAlongDimension(index, dimension));
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        double result;
        if (this.applyFinalTransform()) {
            result = accum / (double)this.n();
            this.finalResult = result;
        } else {
            result = accum;
            this.finalResult = result;
        }
        return result;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        if (this.applyFinalTransform()) {
            float f = accum / (float)this.n();
            this.finalResult = Float.valueOf(f);
            return f;
        }
        this.finalResult = Float.valueOf(accum);
        return accum;
    }

    @Override
    public double calculateFinalResult(double accum, long n) {
        if (this.applyFinalTransform()) {
            return accum / (double)n;
        }
        return accum;
    }

    @Override
    public float calculateFinalResult(float accum, long n) {
        if (this.applyFinalTransform()) {
            return accum / (float)n;
        }
        return accum;
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = accum.div((Number)this.n());
        return this.finalResultComplex;
    }
}

