/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class ShannonEntropy
extends BaseAccumulation {
    public ShannonEntropy() {
    }

    public ShannonEntropy(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public ShannonEntropy(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public ShannonEntropy(INDArray x) {
        super(x);
    }

    public ShannonEntropy(INDArray x, INDArray y) {
        super(x, y);
    }

    public ShannonEntropy(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    @Override
    public double update(double accum, double x) {
        return accum + x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double op(double origin) {
        return FastMath.pow((double)origin, (int)2) * FastMath.log((double)FastMath.pow((double)origin, (int)2));
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.pow((double)origin, (int)2) * (float)FastMath.log((double)FastMath.pow((double)origin, (int)2));
    }

    @Override
    public double calculateFinalResult(double accum, long n) {
        return -accum;
    }

    @Override
    public float calculateFinalResult(float accum, long n) {
        return -accum;
    }

    @Override
    public int opNum() {
        return 18;
    }

    @Override
    public String name() {
        return "shannonentropy";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ShannonEntropy(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ShannonEntropy(xAlongDimension);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ShannonEntropy(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ShannonEntropy(xAlongDimension);
    }
}

