/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class EuclideanDistance
extends BaseAccumulation {
    public EuclideanDistance() {
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public EuclideanDistance(INDArray x, INDArray y, long n) {
        super(x, y, n);
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public EuclideanDistance(INDArray x) {
        super(x);
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public EuclideanDistance(INDArray x, INDArray y) {
        super(x, y);
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public EuclideanDistance(INDArray x, INDArray y, boolean allDistances) {
        this(x, y);
        this.isComplex = allDistances;
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, boolean allDistances) {
        this(x, y, z, x.lengthLong());
        this.isComplex = allDistances;
    }

    @Override
    public double update(double accum, double x) {
        return accum + x * x;
    }

    @Override
    public double update(double accum, double x, double y) {
        double d = x - y;
        return accum + d * d;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x * x;
    }

    @Override
    public float update(float accum, float x, float y) {
        float f = x - y;
        return accum + f * f;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        double d = x - y;
        return accum.add((Number)(d * d));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        IComplexNumber c = x.sub(y);
        return accum.add(c.mul(c));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        IComplexNumber c = x.sub((Number)y);
        return accum.add(c.mul(c));
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    @Override
    public int opNum() {
        return 1;
    }

    @Override
    public String name() {
        return "euclidean";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.sub((Number)other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.sub((Number)Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.sub(other);
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin - other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin - other;
    }

    @Override
    public double op(double origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xForDimension = this.x.vectorAlongDimension(index, dimension);
        EuclideanDistance ret = this.y() != null ? new EuclideanDistance(xForDimension, this.y.vectorAlongDimension(index, dimension), xForDimension.length()) : new EuclideanDistance(this.x.vectorAlongDimension(index, dimension));
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xForDimension = this.x.tensorAlongDimension(index, dimension);
        EuclideanDistance ret = this.y() != null ? new EuclideanDistance(xForDimension, this.y.tensorAlongDimension(index, dimension), xForDimension.length()) : new EuclideanDistance(this.x.tensorAlongDimension(index, dimension));
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        if (this.applyFinalTransform()) {
            double d = FastMath.sqrt((double)accum);
            this.finalResult = d;
            return d;
        }
        this.finalResult = accum;
        return accum;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        if (this.applyFinalTransform) {
            float f = (float)FastMath.sqrt((double)accum);
            this.finalResult = Float.valueOf(f);
            return f;
        }
        this.finalResult = Float.valueOf(accum);
        return accum;
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = accum.sqrt();
        return this.finalResultComplex;
    }

    @Override
    public double calculateFinalResult(double accum, long n) {
        return FastMath.sqrt((double)accum);
    }

    @Override
    public float calculateFinalResult(float accum, long n) {
        return (float)FastMath.sqrt((double)accum);
    }
}

