/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.api.ops.Op;

public class ScalarMin
extends BaseScalarOp {
    public ScalarMin() {
    }

    public ScalarMin(INDArray x, INDArray y, INDArray z, long n, Number num) {
        super(x, y, z, n, num);
    }

    public ScalarMin(INDArray x, Number num) {
        super(x, num);
    }

    public ScalarMin(INDArray x, INDArray y, INDArray z, long n, IComplexNumber num) {
        super(x, y, z, n, num);
    }

    public ScalarMin(INDArray x, IComplexNumber num) {
        super(x, num);
    }

    @Override
    public int opNum() {
        return 12;
    }

    @Override
    public String name() {
        return "min_scalar";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (origin.absoluteValue().doubleValue() < this.complexNumber.absoluteValue().doubleValue()) {
            return origin;
        }
        return this.complexNumber;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (origin.absoluteValue().doubleValue() < this.complexNumber.absoluteValue().doubleValue()) {
            return origin;
        }
        return this.complexNumber;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        if (origin.absoluteValue().doubleValue() < this.complexNumber.absoluteValue().doubleValue()) {
            return origin;
        }
        return this.complexNumber;
    }

    @Override
    public float op(float origin, float other) {
        return FastMath.min((float)origin, (float)this.num.floatValue());
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.min((double)origin, (double)this.num.doubleValue());
    }

    @Override
    public double op(double origin) {
        return FastMath.min((double)origin, (double)this.num.doubleValue());
    }

    @Override
    public float op(float origin) {
        return FastMath.min((float)origin, (float)this.num.floatValue());
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        if (origin.absoluteValue().doubleValue() < this.complexNumber.absoluteValue().doubleValue()) {
            return origin;
        }
        return this.complexNumber;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.num != null) {
            return new ScalarMin(this.x.vectorAlongDimension(index, dimension), this.num);
        }
        return new ScalarMin(this.x.vectorAlongDimension(index, dimension), this.complexNumber);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        if (this.num != null) {
            return new ScalarMin(this.x.tensorAlongDimension(index, dimension), this.num);
        }
        return new ScalarMin(this.x.tensorAlongDimension(index, dimension), this.complexNumber);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = this.num != null ? new Object[]{this.num} : new Object[]{this.complexNumber};
    }
}

