/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.comparison;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.indexing.conditions.Condition;

public class CompareAndSet
extends BaseTransformOp {
    private double compare;
    private double set;
    private double eps;
    private int mode;

    public CompareAndSet() {
    }

    public CompareAndSet(INDArray x, double compare, double set, double eps) {
        this(x, compare, set, eps, null);
    }

    public CompareAndSet(INDArray x, double compare, double set, double eps, Condition condition) {
        super(x);
        this.compare = compare;
        this.set = set;
        this.eps = eps;
        this.mode = condition == null ? 0 : condition.condtionNum();
        this.init(x, null, x, x.length());
    }

    public CompareAndSet(INDArray x, double set, Condition condition) {
        this(x, x, set, condition);
    }

    public CompareAndSet(INDArray x, INDArray z, double set, Condition condition) {
        super(x, null, z, x.lengthLong());
        this.compare = condition.getValue();
        this.set = set;
        this.mode = condition.condtionNum();
        this.init(x, null, z, x.lengthLong());
    }

    public CompareAndSet(INDArray x, INDArray y, Condition condition) {
        this(x, y, x, condition);
    }

    public CompareAndSet(INDArray x, INDArray y, INDArray z, Condition condition) {
        super(x, y, z, x.lengthLong());
        this.compare = condition.getValue();
        this.set = 0.0;
        this.mode = condition.condtionNum();
        this.init(x, y, z, x.lengthLong());
    }

    public CompareAndSet(INDArray x, INDArray z, double compare, double set, double eps) {
        super(x, z);
        this.compare = compare;
        this.set = set;
        this.eps = eps;
        this.mode = 0;
        this.init(x, null, z, x.length());
    }

    public CompareAndSet(INDArray x, INDArray z, double compare, double set, double eps, long n) {
        super(x, z, n);
        this.compare = compare;
        this.set = set;
        this.eps = eps;
        this.mode = 0;
        this.init(x, null, x, n);
    }

    @Override
    public int opNum() {
        return 45;
    }

    @Override
    public String name() {
        return "cas";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return null;
    }

    @Override
    public float op(float origin, float other) {
        return 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return 0.0;
    }

    @Override
    public double op(double origin) {
        return 0.0;
    }

    @Override
    public float op(float origin) {
        return 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new CompareAndSet(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.compare, this.set, this.eps, xAlongDimension.length());
        }
        return new CompareAndSet(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.compare, this.set, this.eps, xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new CompareAndSet(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.compare, this.set, this.eps, xAlongDimension.length());
        }
        return new CompareAndSet(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.compare, this.set, this.eps, xAlongDimension.length());
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.compare, this.set, this.eps, (double)this.mode};
    }
}

