/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.convolution;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Col2Im
extends BaseTransformOp {
    private int sy = 0;
    private int sx = 0;
    private int ph = 0;
    private int pw = 0;
    private int h = 0;
    private int w = 0;
    private boolean isSameMode = false;

    public Col2Im() {
    }

    public Col2Im(INDArray x, int sy, int sx, int ph, int pw, int h, int w) {
        this(x, sy, sx, ph, pw, h, w, false, Col2Im.getNewOutputArray(x, h, w));
    }

    public Col2Im(INDArray x, int sy, int sx, int ph, int pw, int h, int w, boolean isSameMode, INDArray z) {
        super(x);
        this.sy = sy;
        this.sx = sx;
        this.ph = ph;
        this.pw = pw;
        this.h = h;
        this.w = w;
        this.z = z;
        this.isSameMode = isSameMode;
        this.extraArgs = this.extraArgs();
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public Object[] extraArgs() {
        return new Object[]{this.sx, this.sy, this.pw, this.ph, this.h, this.w, this.isSameMode ? 1.0 : 0.0};
    }

    @Override
    public int opNum() {
        return 36;
    }

    @Override
    public String name() {
        return "col2im";
    }

    private static INDArray getNewOutputArray(INDArray x, int imgHeight, int imgWidth) {
        int n = x.size(0);
        int c = x.size(1);
        return Nd4j.create(n, c, imgHeight, imgWidth);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return null;
    }

    @Override
    public float op(float origin, float other) {
        return 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return 0.0;
    }

    @Override
    public double op(double origin) {
        return 0.0;
    }

    @Override
    public float op(float origin) {
        return 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        return null;
    }
}

