/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;

public class BinomialDistributionEx
extends BaseRandomOp {
    private int trials;
    private double probability;

    public BinomialDistributionEx() {
    }

    public BinomialDistributionEx(@NonNull INDArray z, int trials, double probability) {
        if (z == null) {
            throw new NullPointerException("z");
        }
        this.init(z, z, z, z.lengthLong());
        this.trials = trials;
        this.probability = probability;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistributionEx(@NonNull INDArray z, int trials, @NonNull INDArray probabilities) {
        if (z == null) {
            throw new NullPointerException("z");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities");
        }
        if (z.lengthLong() != probabilities.lengthLong()) {
            throw new IllegalStateException("Length of probabilities array should match length of target array");
        }
        if (probabilities.elementWiseStride() < 1) {
            throw new IllegalStateException("Probabilities array shouldn't have negative elementWiseStride");
        }
        this.init(z, probabilities, z, z.lengthLong());
        this.trials = trials;
        this.probability = 0.0;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistributionEx(@NonNull INDArray z, @NonNull INDArray probabilities) {
        this(z, probabilities.length(), probabilities);
        if (z == null) {
            throw new NullPointerException("z");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities");
        }
    }

    @Override
    public int opNum() {
        return 9;
    }

    @Override
    public String name() {
        return "distribution_binomial_ex";
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }
}

