/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.base.Function;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.accum.MatchCondition;
import org.nd4j.linalg.api.ops.impl.indexaccum.FirstIndex;
import org.nd4j.linalg.api.ops.impl.indexaccum.LastIndex;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndReplace;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndSet;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.loop.coordinatefunction.CoordinateFunction;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.BaseCondition;
import org.nd4j.linalg.indexing.conditions.Condition;

public class BooleanIndexing {
    public static boolean and(IComplexNDArray n, Condition cond) {
        boolean ret = true;
        IComplexNDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret = ret && cond.apply(linear.getComplex(i)) != false;
        }
        return ret;
    }

    public static boolean or(IComplexNDArray n, Condition cond) {
        boolean ret = false;
        IComplexNDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret = ret || cond.apply(linear.getComplex(i)) != false;
        }
        return ret;
    }

    public static boolean and(final INDArray n, final Condition cond) {
        if (cond instanceof BaseCondition) {
            long val = (long)Nd4j.getExecutioner().exec(new MatchCondition(n, cond), Integer.MAX_VALUE).getDouble(0);
            return val == n.lengthLong();
        }
        boolean ret = true;
        final AtomicBoolean a = new AtomicBoolean(ret);
        Shape.iterate(n, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                if (a.get()) {
                    a.compareAndSet(true, a.get() && cond.apply(n.getDouble(coord[0])) != false);
                }
            }
        });
        return a.get();
    }

    public static boolean[] and(INDArray n, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        MatchCondition op = new MatchCondition(n, condition);
        INDArray arr = Nd4j.getExecutioner().exec(op, dimension);
        boolean[] result = new boolean[arr.length()];
        long tadLength = Shape.getTADLength(n.shape(), dimension);
        for (int i = 0; i < arr.length(); ++i) {
            result[i] = arr.getDouble(i) == (double)tadLength;
        }
        return result;
    }

    public static boolean[] or(INDArray n, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        MatchCondition op = new MatchCondition(n, condition);
        INDArray arr = Nd4j.getExecutioner().exec(op, dimension);
        boolean[] result = new boolean[arr.length()];
        for (int i = 0; i < arr.length(); ++i) {
            result[i] = arr.getDouble(i) > 0.0;
        }
        return result;
    }

    public static boolean or(final INDArray n, final Condition cond) {
        if (cond instanceof BaseCondition) {
            long val = (long)Nd4j.getExecutioner().exec(new MatchCondition(n, cond), Integer.MAX_VALUE).getDouble(0);
            return val > 0L;
        }
        boolean ret = false;
        final AtomicBoolean a = new AtomicBoolean(ret);
        Shape.iterate(n, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                if (!a.get()) {
                    a.compareAndSet(false, a.get() || cond.apply(n.getDouble(coord[0])) != false);
                }
            }
        });
        return a.get();
    }

    public static void applyWhere(final INDArray to, final Condition condition, final Function<Number, Number> function) {
        Shape.iterate(to, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                if (condition.apply(to.getDouble(coord[0])).booleanValue()) {
                    to.putScalar(coord[0], ((Number)function.apply((Object)to.getDouble(coord[0]))).doubleValue());
                }
            }
        });
    }

    public static void applyWhere(final INDArray to, final Condition condition, Number number) {
        if (condition instanceof BaseCondition) {
            Nd4j.getExecutioner().exec(new CompareAndSet(to, number.doubleValue(), condition));
        } else {
            final double value = number.doubleValue();
            Function<Number, Number> dynamic = new Function<Number, Number>(){

                public Number apply(Number number) {
                    return value;
                }
            };
            Shape.iterate(to, new CoordinateFunction((Function)dynamic){
                final /* synthetic */ Function val$dynamic;
                {
                    this.val$dynamic = function;
                }

                @Override
                public void process(int[] ... coord) {
                    if (condition.apply(to.getDouble(coord[0])).booleanValue()) {
                        to.putScalar(coord[0], ((Number)this.val$dynamic.apply((Object)to.getDouble(coord[0]))).doubleValue());
                    }
                }
            });
        }
    }

    public static void assignIf(@NonNull INDArray to, @NonNull INDArray from, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        if (to.lengthLong() != from.lengthLong()) {
            throw new IllegalStateException("Mis matched length for to and from");
        }
        Nd4j.getExecutioner().exec(new CompareAndSet(to, from, condition));
    }

    public static void replaceWhere(@NonNull INDArray to, @NonNull INDArray from, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        if (to.lengthLong() != from.lengthLong()) {
            throw new IllegalStateException("Mis matched length for to and from");
        }
        Nd4j.getExecutioner().exec(new CompareAndReplace(to, from, condition));
    }

    public static void replaceWhere(@NonNull INDArray to, @NonNull Number set, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        if (set == null) {
            throw new NullPointerException("set");
        }
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        Nd4j.getExecutioner().exec(new CompareAndSet(to, set.doubleValue(), condition));
    }

    public static void applyWhere(final INDArray to, final Condition condition, final Function<Number, Number> function, final Function<Number, Number> alternativeFunction) {
        Shape.iterate(to, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                if (condition.apply(to.getDouble(coord[0])).booleanValue()) {
                    to.putScalar(coord[0], ((Number)function.apply((Object)to.getDouble(coord[0]))).doubleValue());
                } else {
                    to.putScalar(coord[0], ((Number)alternativeFunction.apply((Object)to.getDouble(coord[0]))).doubleValue());
                }
            }
        });
    }

    public static void applyWhere(IComplexNDArray to, Condition condition, Function<IComplexNumber, IComplexNumber> function) {
        IComplexNDArray linear = to.linearView();
        for (int i = 0; i < linear.linearView().length(); ++i) {
            if (!condition.apply(linear.getDouble(i)).booleanValue()) continue;
            linear.putScalar(i, (IComplexNumber)function.apply((Object)linear.getComplex(i)));
        }
    }

    public static INDArray firstIndex(INDArray array, Condition condition) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        FirstIndex idx = new FirstIndex(array, condition);
        Nd4j.getExecutioner().exec(idx);
        return Nd4j.scalar((double)idx.getFinalResult());
    }

    public static INDArray firstIndex(INDArray array, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        return Nd4j.getExecutioner().exec(new FirstIndex(array, condition), dimension);
    }

    public static INDArray lastIndex(INDArray array, Condition condition) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        LastIndex idx = new LastIndex(array, condition);
        Nd4j.getExecutioner().exec(idx);
        return Nd4j.scalar((double)idx.getFinalResult());
    }

    public static INDArray lastIndex(INDArray array, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        return Nd4j.getExecutioner().exec(new LastIndex(array, condition), dimension);
    }
}

