/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;
import net.ericaro.neoitertools.Itertools;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.util.LongUtils;

public class SpecifiedIndex
implements INDArrayIndex {
    private long[] indexes;
    private int counter = 0;

    public SpecifiedIndex(int ... indexes) {
        this.indexes = LongUtils.toLongs(indexes);
    }

    public SpecifiedIndex(long ... indexes) {
        this.indexes = indexes;
    }

    @Override
    public long end() {
        return this.indexes[this.indexes.length - 1];
    }

    @Override
    public long offset() {
        return this.indexes[0];
    }

    @Override
    public long length() {
        return this.indexes.length;
    }

    @Override
    public long stride() {
        return 1L;
    }

    @Override
    public long current() {
        return this.indexes[this.counter - 1];
    }

    @Override
    public boolean hasNext() {
        return this.counter < this.indexes.length;
    }

    @Override
    public long next() {
        return this.indexes[this.counter++];
    }

    @Override
    public void reverse() {
    }

    @Override
    public boolean isInterval() {
        return false;
    }

    @Override
    public void setInterval(boolean isInterval) {
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
    }

    @Override
    public void init(INDArray arr, int dimension) {
    }

    @Override
    public void init(long begin, long end) {
    }

    @Override
    public void reset() {
        this.counter = 0;
    }

    public static Generator<List<List<Long>>> iterate(INDArrayIndex ... indexes) {
        Generator gen = Itertools.product((Generator)new SpecifiedIndexesGenerator(indexes));
        return gen;
    }

    public Generator<List<Long>> generator() {
        return new SingleGenerator();
    }

    public long[] getIndexes() {
        return this.indexes;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setIndexes(long[] indexes) {
        this.indexes = indexes;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecifiedIndex)) {
            return false;
        }
        SpecifiedIndex other = (SpecifiedIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getIndexes(), other.getIndexes())) {
            return false;
        }
        return this.getCounter() == other.getCounter();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpecifiedIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getIndexes());
        result = result * 59 + this.getCounter();
        return result;
    }

    public String toString() {
        return "SpecifiedIndex(indexes=" + Arrays.toString(this.getIndexes()) + ", counter=" + this.getCounter() + ")";
    }

    public class SingleGenerator
    implements Generator<List<Long>> {
        public List<Long> next() throws NoSuchElementException {
            if (!SpecifiedIndex.this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Longs.asList((long[])new long[]{SpecifiedIndex.this.next()});
        }
    }

    public static class SpecifiedIndexesGenerator
    implements Generator<Generator<List<Long>>> {
        private int index = 0;
        private INDArrayIndex[] indexes;

        public SpecifiedIndexesGenerator(INDArrayIndex[] indexes) {
            this.indexes = indexes;
        }

        public Generator<List<Long>> next() throws NoSuchElementException {
            if (this.index >= this.indexes.length) {
                throw new NoSuchElementException("Done");
            }
            SpecifiedIndex specifiedIndex = (SpecifiedIndex)this.indexes[this.index++];
            Generator<List<Long>> ret = specifiedIndex.generator();
            return ret;
        }
    }
}

