/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions.impl;

import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossUtil;
import org.nd4j.linalg.lossfunctions.serde.RowVectorDeserializer;
import org.nd4j.linalg.lossfunctions.serde.RowVectorSerializer;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LossMCXENT
implements ILossFunction {
    private static final double DEFAULT_SOFTMAX_CLIPPING_EPSILON = 1.0E-10;
    @JsonSerialize(using=RowVectorSerializer.class)
    @JsonDeserialize(using=RowVectorDeserializer.class)
    private INDArray weights;
    private double softmaxClipEps;

    public LossMCXENT() {
        this(null);
    }

    public LossMCXENT(INDArray weights) {
        this(1.0E-10, weights);
    }

    public LossMCXENT(@JsonProperty(value="softmaxClipEps") double softmaxClipEps, @JsonProperty(value="weights") INDArray weights) {
        if (weights != null && !weights.isRowVector()) {
            throw new IllegalArgumentException("Weights array must be a row vector");
        }
        if (softmaxClipEps < 0.0 || softmaxClipEps > 0.5) {
            throw new IllegalArgumentException("Invalid clipping epsilon: epsilon should be >= 0 (but near zero). Got: " + softmaxClipEps);
        }
        this.weights = weights;
        this.softmaxClipEps = softmaxClipEps;
    }

    private INDArray scoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        if (labels.size(1) != preOutput.size(1)) {
            throw new IllegalArgumentException("Labels array numColumns (size(1) = " + labels.size(1) + ") does not match output layer number of outputs (nOut = " + preOutput.size(1) + ") ");
        }
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        if (activationFn instanceof ActivationSoftmax && this.softmaxClipEps > 0.0) {
            BooleanIndexing.replaceWhere(output, this.softmaxClipEps, Conditions.lessThan(this.softmaxClipEps));
            BooleanIndexing.replaceWhere(output, 1.0 - this.softmaxClipEps, Conditions.greaterThan(1.0 - this.softmaxClipEps));
        }
        INDArray scoreArr = Transforms.log(output, false).muli(labels);
        if (this.weights != null) {
            if (this.weights.length() != scoreArr.size(1)) {
                throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + preOutput.size(1));
            }
            scoreArr.muliRowVector(this.weights);
        }
        if (mask != null) {
            LossUtil.applyMask(scoreArr, mask);
        }
        return scoreArr;
    }

    @Override
    public double computeScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        double score = -scoreArr.sumNumber().doubleValue();
        if (average) {
            score /= (double)scoreArr.size(0);
        }
        return score;
    }

    @Override
    public INDArray computeScoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        return scoreArr.sum(1).muli(-1);
    }

    @Override
    public INDArray computeGradient(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray grad;
        if (labels.size(1) != preOutput.size(1)) {
            throw new IllegalArgumentException("Labels array numColumns (size(1) = " + labels.size(1) + ") does not match output layer number of outputs (nOut = " + preOutput.size(1) + ") ");
        }
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        if (activationFn instanceof ActivationSoftmax) {
            if (mask != null && LossUtil.isPerOutputMasking(output, mask)) {
                throw new UnsupportedOperationException("Per output masking for MCXENT + softmax: not supported");
            }
            if (this.weights != null) {
                if (this.weights.length() != output.size(1)) {
                    throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + output.size(1));
                }
                INDArray temp = labels.mulRowVector(this.weights);
                INDArray col = temp.sum(1);
                grad = output.mulColumnVector(col).sub(temp);
            } else {
                grad = output.subi(labels);
            }
        } else {
            INDArray dLda = output.rdivi(labels).negi();
            grad = (INDArray)activationFn.backprop(preOutput, dLda).getFirst();
            if (this.weights != null) {
                if (this.weights.length() != output.size(1)) {
                    throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + output.size(1));
                }
                grad.muliRowVector(this.weights);
            }
        }
        if (mask != null) {
            LossUtil.applyMask(grad, mask);
        }
        return grad;
    }

    @Override
    public Pair<Double, INDArray> computeGradientAndScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        return new Pair((Object)this.computeScore(labels, preOutput, activationFn, mask, average), (Object)this.computeGradient(labels, preOutput, activationFn, mask));
    }

    @Override
    public String name() {
        return this.toString();
    }

    public String toString() {
        if (this.weights == null) {
            return "LossMCXENT()";
        }
        return "LossMCXENT(weights=" + this.weights + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LossMCXENT)) {
            return false;
        }
        LossMCXENT other = (LossMCXENT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$weights = this.getWeights();
        INDArray other$weights = other.getWeights();
        if (this$weights == null ? other$weights != null : !this$weights.equals(other$weights)) {
            return false;
        }
        return Double.compare(this.getSoftmaxClipEps(), other.getSoftmaxClipEps()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LossMCXENT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : $weights.hashCode());
        long $softmaxClipEps = Double.doubleToLongBits(this.getSoftmaxClipEps());
        result = result * 59 + (int)($softmaxClipEps >>> 32 ^ $softmaxClipEps);
        return result;
    }

    public INDArray getWeights() {
        return this.weights;
    }

    public double getSoftmaxClipEps() {
        return this.softmaxClipEps;
    }

    public void setWeights(INDArray weights) {
        this.weights = weights;
    }

    public void setSoftmaxClipEps(double softmaxClipEps) {
        this.softmaxClipEps = softmaxClipEps;
    }
}

