/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce3;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.util.SameDiffUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.reduce3.BaseReduce3Op;
import org.nd4j.linalg.factory.Nd4j;

public class ManhattanDistance
extends BaseReduce3Op {
    public static final String OP_NAME = "manhattan";

    public ManhattanDistance(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public ManhattanDistance(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int ... dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public ManhattanDistance() {
    }

    public ManhattanDistance(INDArray x, INDArray y, int ... dimensions) {
        this(x, y, false, dimensions);
    }

    public ManhattanDistance(INDArray x, INDArray y, boolean allDistances, int ... dimensions) {
        this(x, y, null, false, allDistances, dimensions);
        this.isComplex = allDistances;
    }

    public ManhattanDistance(INDArray x, INDArray y, INDArray z) {
        this(x, y, z, false, null);
    }

    public ManhattanDistance(INDArray x, INDArray y, INDArray z, boolean allDistances, int ... dimensions) {
        this(x, y, z, false, allDistances, dimensions);
    }

    public ManhattanDistance(INDArray x, INDArray y, INDArray z, boolean keepDims, boolean allDistances, int ... dimensions) {
        super(x, y, z, keepDims, allDistances, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    @Override
    public int opNum() {
        return 0;
    }

    @Override
    public String opName() {
        return OP_NAME;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        SDVariable difference = this.larg().sub(this.rarg());
        SDVariable gradBroadcastable = this.keepDims || this.dimensions == null || this.dimensions.length == 0 || this.dimensions.length == 1 && this.dimensions[0] == Integer.MAX_VALUE ? i_v1.get(0) : SameDiffUtils.reductionBroadcastableWithOrigShape(this.arg(), this.sameDiff.constant(Nd4j.createFromArray(this.dimensions)), i_v1.get(0));
        SDVariable gradX = this.sameDiff.math().sign(difference).mul(gradBroadcastable);
        SDVariable gradY = this.sameDiff.math().neg(gradX);
        return Arrays.asList(gradX, gradY);
    }
}

