/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.shape.bp.ConcatBp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Concat
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Concat.class);
    private int concatDimension = -1;
    private boolean isDynamicAxis = false;

    public Concat() {
    }

    public Concat(int concatDimension, INDArray ... arrays) {
        super(null, arrays, null);
        this.concatDimension = concatDimension;
        this.addIArgument(concatDimension);
    }

    public Concat(INDArray[] arrays, int concatDimension) {
        this(concatDimension, arrays);
    }

    public Concat(SameDiff sameDiff, SDVariable[] inputs, int concatDimension) {
        this(sameDiff, concatDimension, inputs);
    }

    public Concat(SameDiff sameDiff, int concatDimension, SDVariable ... inputs) {
        super(null, sameDiff, inputs);
        this.addIArgument(concatDimension);
        this.concatDimension = concatDimension;
    }

    @Override
    public String opName() {
        return "concat";
    }

    @Override
    public void assertValidForExecution() {
        CustomOpDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            throw new NoOpNameFoundException("No descriptor found for op name " + this.opName());
        }
        if (descriptor.getNumInputs() > 0 && this.numInputArguments() < 2) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numInputArguments() + " but should be " + descriptor.getNumInputs());
        }
        if (descriptor.getNumOutputs() > 0 && this.numOutputArguments() != descriptor.getNumOutputs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of outputs is invalid for execution. Specified " + this.numOutputArguments() + " but should be " + descriptor.getNumOutputs());
        }
        if (descriptor.getNumIArgs() >= 0 && this.numIArguments() != descriptor.getNumIArgs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of integer arguments is invalid for execution. Specified " + this.numIArguments() + " but should be " + descriptor.getNumIArgs());
        }
        if (descriptor.getNumTArgs() >= 0 && this.numTArguments() != descriptor.getNumTArgs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numTArguments() + " but should be " + descriptor.getNumTArgs());
        }
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.addBArgument(true);
        this.isDynamicAxis = true;
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("concatDimension", this.concatDimension);
        return ret;
    }

    @Override
    public String onnxName() {
        return "Concat";
    }

    @Override
    public String tensorflowName() {
        return "Concat";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Concat", "ConcatV2"};
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable[] args = this.args();
        if (this.isDynamicAxis) {
            SDVariable[] bpArgs = Arrays.copyOf(args, args.length + 2);
            bpArgs[bpArgs.length - 1] = bpArgs[bpArgs.length - 3];
            bpArgs[bpArgs.length - 2] = i_v.get(0);
            return Arrays.asList(new ConcatBp(this.sameDiff, this.concatDimension, bpArgs).outputVariables());
        }
        SDVariable[] bpArgs = Arrays.copyOf(args, args.length + 1);
        bpArgs[bpArgs.length - 1] = i_v.get(0);
        return Arrays.asList(new ConcatBp(this.sameDiff, this.concatDimension, bpArgs).outputVariables());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        if (!this.dArguments.isEmpty()) {
            return Collections.singletonList(this.dArguments.get(0));
        }
        DataType first = dataTypes.get(0);
        for (int i = 1; i < dataTypes.size() - (this.isDynamicAxis ? 1 : 0); ++i) {
            DataType dt = dataTypes.get(i);
            Preconditions.checkState((first == dt ? 1 : 0) != 0, (String)"All inputs must have same datatype - got %s and %s for inputs 0 and %s respectively", (Object)((Object)first), (Object)((Object)dt), (Object)i);
        }
        if (this.isDynamicAxis) {
            Preconditions.checkState((boolean)dataTypes.get(dataTypes.size() - 1).isIntType(), (String)"For dynamic axis case, last datatype must be an integer type, got input types %s");
        }
        return Collections.singletonList(first);
    }
}

