/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape.tensorops;

import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public abstract class BaseTensorOp
extends DynamicCustomOp {
    public BaseTensorOp(String name, SameDiff sameDiff, SDVariable[] args) {
        super(name, sameDiff, args);
    }

    public BaseTensorOp(SameDiff sameDiff, SDVariable[] args) {
        super(null, sameDiff, args);
    }

    public BaseTensorOp() {
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String inputOne = nodeDef.getInput(1);
        SDVariable varFor = initWith.getVariable(inputOne);
        NodeDef nodeWithIndex = TFGraphMapper.getNodeWithNameFromGraph(graph, inputOne);
        INDArray var = TFGraphMapper.getArrayFrom(nodeWithIndex, graph);
        if (var != null) {
            int idx = var.getInt(0);
            this.addIArgument(idx);
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Differentiation not yet implemented for " + this.getClass().getName());
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op name found for " + this.opName());
    }

    @Override
    public String toString() {
        return this.opName();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        throw new UnsupportedOperationException("calculateOutputShape() is not supported for tensor ops.");
    }

    @Override
    public int getNumOutputs() {
        return 1;
    }
}

