/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.summarystats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.reduce.bp.StandardDeviationBp;
import org.nd4j.linalg.api.ops.impl.summarystats.Variance;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;

public class StandardDeviation
extends Variance {
    public StandardDeviation(SameDiff sameDiff, SDVariable i_v, boolean biasCorrected, boolean keepDims, int[] dimensions) {
        super(sameDiff, i_v, biasCorrected, keepDims, dimensions);
    }

    public StandardDeviation(INDArray x, boolean biasCorrected, boolean keepDims, int ... dimension) {
        super(x, biasCorrected, dimension);
        this.keepDims = keepDims;
    }

    public StandardDeviation(INDArray x, boolean biasCorrected, int ... dimension) {
        super(x, biasCorrected, dimension);
    }

    public StandardDeviation() {
    }

    public StandardDeviation(INDArray x) {
        super(x, new int[0]);
    }

    public StandardDeviation(INDArray x, INDArray z, boolean biasCorrected, int ... dimension) {
        super(x, z, biasCorrected, dimension);
    }

    public StandardDeviation(INDArray x, INDArray z, boolean newFormat, boolean keepDims, int[] dimensions) {
        super(x, z, newFormat, keepDims, dimensions);
    }

    @Override
    public int opNum() {
        return 1;
    }

    @Override
    public String opName() {
        return "std";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.SUMMARYSTATS;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.SUMMARYSTATS;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return new StandardDeviationBp(this.sameDiff, this.arg(), grad.get(0), this.biasCorrected, this.keepDims, this.dimensions).outputs();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.args().length < 1) {
            throw new ND4JIllegalStateException("Unable to compute input shape. No arguments found.");
        }
        long[] argShape = this.arg().getShape();
        if (argShape == null && this.x() == null) {
            return Collections.emptyList();
        }
        long[] inputShape = argShape == null || Shape.isPlaceholderShape(argShape) ? this.x().shape() : argShape;
        ArrayList<LongShapeDescriptor> ret = new ArrayList<LongShapeDescriptor>(1);
        long[] reducedShape = Shape.getReducedShape(inputShape, this.dimensions, this.isKeepDims());
        ret.add(LongShapeDescriptor.fromShape(reducedShape, this.resultType()));
        return ret;
    }
}

