/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CReluBp;

public class CReLU
extends DynamicCustomOp {
    public CReLU(SameDiff sd, SDVariable input) {
        super(sd, new SDVariable[]{input});
    }

    public CReLU(@NonNull INDArray input) {
        super(new INDArray[]{input}, null);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
    }

    @Override
    public String opName() {
        return "crelu";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkArgument((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatypes, got %s", dataTypes);
        Preconditions.checkArgument((boolean)dataTypes.get(0).isFPType(), (String)"Input datatype must be floating point, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Collections.singletonList(new CReluBp(this.sameDiff, this.arg(), i_v.get(0)).outputVariable());
    }

    public CReLU() {
    }
}

