/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class VarScalingNormalFanAvgInitScheme
extends BaseWeightInitScheme {
    private double fanIn;
    private double fanOut;

    public VarScalingNormalFanAvgInitScheme(char order, double fanIn, double fanOut) {
        super(order);
        this.fanIn = fanIn;
        this.fanOut = fanOut;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        return Nd4j.randn(dataType, this.order(), shape).divi(FastMath.sqrt((double)((this.fanIn + this.fanOut) / 2.0)));
    }

    @Override
    public WeightInit type() {
        return WeightInit.VAR_SCALING_NORMAL_FAN_AVG;
    }

    public static VarScalingNormalFanAvgInitSchemeBuilder builder() {
        return new VarScalingNormalFanAvgInitSchemeBuilder();
    }

    public static class VarScalingNormalFanAvgInitSchemeBuilder {
        private char order;
        private double fanIn;
        private double fanOut;

        VarScalingNormalFanAvgInitSchemeBuilder() {
        }

        public VarScalingNormalFanAvgInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public VarScalingNormalFanAvgInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public VarScalingNormalFanAvgInitSchemeBuilder fanOut(double fanOut) {
            this.fanOut = fanOut;
            return this;
        }

        public VarScalingNormalFanAvgInitScheme build() {
            return new VarScalingNormalFanAvgInitScheme(this.order, this.fanIn, this.fanOut);
        }

        public String toString() {
            return "VarScalingNormalFanAvgInitScheme.VarScalingNormalFanAvgInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ", fanOut=" + this.fanOut + ")";
        }
    }
}

