/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseReduceOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.ReduceFloatOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseReduceFloatOp
extends BaseReduceOp
implements ReduceFloatOp {
    public BaseReduceFloatOp(INDArray x, INDArray y, INDArray z, boolean keepDims, int ... dimensions) {
        super(x, y, z, keepDims, dimensions);
    }

    protected BaseReduceFloatOp(SameDiff sameDiff, SDVariable i_v, boolean keepDims, int[] dimensions) {
        super(sameDiff, i_v, dimensions, keepDims);
    }

    protected BaseReduceFloatOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    protected BaseReduceFloatOp(SameDiff sameDiff, SDVariable input, int[] dimensions, boolean keepDims) {
        super(sameDiff, input, dimensions, keepDims);
    }

    protected BaseReduceFloatOp(SameDiff sameDiff, SDVariable input, int ... dimensions) {
        super(sameDiff, input, dimensions);
    }

    public BaseReduceFloatOp(INDArray input, INDArray output, boolean keepDims, int ... dimensions) {
        super(input, null, output, dimensions);
        this.keepDims = keepDims;
        this.dimensions = dimensions;
    }

    public BaseReduceFloatOp(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        super(x, y, z, dimensions);
    }

    public BaseReduceFloatOp(INDArray x, INDArray z, int ... dimensions) {
        super(x, null, z, dimensions);
    }

    public BaseReduceFloatOp(INDArray x, boolean keepDims, int ... dimensions) {
        super(x, keepDims, dimensions);
    }

    public BaseReduceFloatOp(INDArray x, int ... dimensions) {
        super(x, dimensions);
    }

    protected BaseReduceFloatOp() {
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE_FLOAT;
    }

    @Override
    public Op.Type getOpType() {
        return this.opType();
    }

    @Override
    public DataType resultType() {
        return this.resultType(null);
    }

    @Override
    public DataType resultType(OpContext oc) {
        INDArray x;
        INDArray iNDArray = x = oc != null ? oc.getInputArray(0) : this.x();
        if (x != null && x.isR()) {
            return x.dataType();
        }
        return Nd4j.defaultFloatingPointType();
    }

    @Override
    public boolean validateDataTypes(OpContext oc) {
        INDArray z;
        INDArray y;
        INDArray x = oc != null ? oc.getInputArray(0) : this.x();
        INDArray iNDArray = y = oc != null ? oc.getInputArray(1) : this.y();
        if (y != null) {
            Preconditions.checkArgument((x.dataType() == y.dataType() ? 1 : 0) != 0, (String)"Op.X [%s] type must be the same as Op.Y [%s] for op %s: x.shape=%ndShape, y.shape=%ndShape", (Object)((Object)x.dataType()), (Object)((Object)y.dataType()), (Object)this.getClass().getName(), (Object)x, (Object)y);
        }
        INDArray iNDArray2 = z = oc != null ? oc.getOutputArray(0) : this.z();
        if (z != null) {
            Preconditions.checkArgument((boolean)z.isR(), (String)"Op.Z (result array) must be one of floating types: z datatype = %s", (Object)((Object)z.dataType()));
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        return this.calculateOutputShape(null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        INDArray x;
        INDArray iNDArray = x = oc != null ? oc.getInputArray(0) : this.x();
        if (x == null) {
            return Collections.emptyList();
        }
        long[] reducedShape = x.rank() == 0 ? x.shape() : Shape.getReducedShape(x.shape(), this.dimensions, this.isKeepDims());
        DataType retType = this.arg().dataType();
        if (!retType.isFPType()) {
            retType = Nd4j.defaultFloatingPointType();
        }
        return Collections.singletonList(LongShapeDescriptor.fromShape(reducedShape, retType));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or 2 input datatype for %s, got input %s", this.getClass(), dataTypes);
        Preconditions.checkState((dataTypes.size() == 1 || dataTypes.get(1).isIntType() ? 1 : 0) != 0, (String)"When executing reductionswith 2 inputs, second input (axis) must be an integer datatype for %s, got %s", this.getClass(), dataTypes);
        if (dataTypes.get(0).isFPType()) {
            return Collections.singletonList(dataTypes.get(0));
        }
        return Collections.singletonList(Nd4j.defaultFloatingPointType());
    }
}

