/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class MaxPooling2D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(MaxPooling2D.class);
    protected Pooling2DConfig config;

    public MaxPooling2D() {
    }

    public MaxPooling2D(SameDiff sameDiff, SDVariable input, Pooling2DConfig config) {
        super(null, sameDiff, new SDVariable[]{input}, false);
        config.setType(Pooling2D.Pooling2DType.MAX);
        this.config = config;
        this.addArgs();
    }

    public MaxPooling2D(INDArray input, INDArray output, @NonNull Pooling2DConfig config) {
        super(null, new INDArray[]{input}, MaxPooling2D.wrapOrNull(output));
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        config.setType(Pooling2D.Pooling2DType.MAX);
        this.config = config;
        this.addArgs();
    }

    public MaxPooling2D(INDArray input, @NonNull Pooling2DConfig config) {
        this(input, null, config);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = Pooling2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).isSameMode((Long)this.iArguments.get(8) == 1L).extra(((Long)this.iArguments.get(9)).longValue()).isNHWC((Long)this.iArguments.get(10) == 1L).type(Pooling2D.Pooling2DType.MAX).build();
        }
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKH(), this.config.getKW(), this.config.getSH(), this.config.getSW(), this.config.getPH(), this.config.getPW(), this.config.getDH(), this.config.getDW(), ArrayUtil.fromBoolean((boolean)this.config.isSameMode()), (int)this.config.getExtra(), ArrayUtil.fromBoolean((boolean)this.config.isNHWC()));
    }

    public String getPoolingPrefix() {
        return "max";
    }

    @Override
    public String opName() {
        return this.getPoolingPrefix() + "pool2d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Pooling2DDerivative pooling2DDerivative = Pooling2DDerivative.derivativeBuilder().inputs(inputs.toArray(new SDVariable[inputs.size()])).sameDiff(this.sameDiff).config(this.config).build();
        ret.addAll(Arrays.asList(pooling2DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        Pooling2DConfig pooling2DConfig;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        List<Long> tfStrides = aStrides.getList().getIList();
        AttrValue aKernels = nodeDef.getAttrOrThrow("ksize");
        List<Long> tfKernels = aKernels.getList().getIList();
        int sH = 0;
        int sW = 0;
        int pH = 0;
        int pW = 0;
        int kH = 0;
        int kW = 0;
        AttrValue aPadding = nodeDef.getAttrOrThrow("padding");
        List<Long> padding = aPadding.getList().getIList();
        String paddingMode = aPadding.getS().toStringUtf8().replaceAll("\"", "");
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        String data_format = "nhwc";
        if (nodeDef.containsAttr("data_format")) {
            AttrValue attr = nodeDef.getAttrOrThrow("data_format");
            data_format = attr.getS().toStringUtf8().toLowerCase();
        }
        if (data_format.equalsIgnoreCase("nhwc")) {
            sH = tfStrides.get(1).intValue();
            sW = tfStrides.get(2).intValue();
            kH = tfKernels.get(1).intValue();
            kW = tfKernels.get(2).intValue();
            pH = padding.size() > 0 ? padding.get(1).intValue() : 0;
            pW = padding.size() > 0 ? padding.get(2).intValue() : 0;
        } else {
            sH = tfStrides.get(2).intValue();
            sW = tfStrides.get(3).intValue();
            kH = tfKernels.get(2).intValue();
            kW = tfKernels.get(3).intValue();
            pH = padding.size() > 0 ? padding.get(2).intValue() : 0;
            pW = padding.size() > 0 ? padding.get(3).intValue() : 0;
        }
        this.config = pooling2DConfig = Pooling2DConfig.builder().sH(sH).sW(sW).type(Pooling2D.Pooling2DType.MAX).isSameMode(isSameMode).kH(kH).kW(kW).pH(pH).pW(pW).isNHWC(data_format.equalsIgnoreCase("nhwc")).extra(1.0).build();
        this.addArgs();
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        Pooling2DConfig pooling2DConfig;
        String paddingVal = !attributesForNode.containsKey("auto_pad") ? "VALID" : attributesForNode.get("auto_pad").getS().toStringUtf8();
        boolean isSameNode = paddingVal.equals("SAME");
        List<Long> kernelShape = attributesForNode.get("kernel_shape").getIntsList();
        List<Long> padding = attributesForNode.get("pads").getIntsList();
        List<Long> strides = attributesForNode.get("strides").getIntsList();
        this.config = pooling2DConfig = Pooling2DConfig.builder().sH(strides.get(0).intValue()).sW(strides.size() < 2 ? (long)strides.get(0).intValue() : (long)strides.get(1).intValue()).type(Pooling2D.Pooling2DType.MAX).isSameMode(isSameNode).kH(kernelShape.get(0).intValue()).kW(kernelShape.size() < 2 ? (long)kernelShape.get(0).intValue() : (long)kernelShape.get(1).intValue()).pH(padding.get(0).intValue()).pW(padding.size() < 2 ? (long)padding.get(0).intValue() : (long)padding.get(1).intValue()).build();
        this.addArgs();
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"sW", "sH"}).build();
        PropertyMapping paddingMapping = PropertyMapping.builder().onnxAttrName("padding").tfAttrName("padding").propertyNames(new String[]{"pH", "pW"}).build();
        PropertyMapping kernelMapping = PropertyMapping.builder().propertyNames(new String[]{"kH", "kW"}).tfInputPosition(1).onnxAttrName("ksize").build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dW", "dH"}).tfAttrName("rates").build();
        PropertyMapping dataFormatMapping = PropertyMapping.builder().propertyNames(new String[]{"isNHWC"}).tfAttrName("data_format").build();
        map.put("sW", strideMapping);
        map.put("sH", strideMapping);
        map.put("kH", kernelMapping);
        map.put("kW", kernelMapping);
        map.put("dW", dilationMapping);
        map.put("dH", dilationMapping);
        map.put("pH", paddingMapping);
        map.put("pW", paddingMapping);
        map.put("isNHWC", dataFormatMapping);
        ret.put(this.onnxName(), map);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public String onnxName() {
        return "MaxPool";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"MaxPool", "MaxPoolV2"};
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && !inputDataTypes.isEmpty() ? 1 : 0) != 0, (String)"Expected at least 1 input data type for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static MaxPooling2DBuilder sameDiffBuilder() {
        return new MaxPooling2DBuilder();
    }

    public Pooling2DConfig getConfig() {
        return this.config;
    }

    public static class MaxPooling2DBuilder {
        private SameDiff sameDiff;
        private SDVariable input;
        private Pooling2DConfig config;

        MaxPooling2DBuilder() {
        }

        public MaxPooling2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public MaxPooling2DBuilder input(SDVariable input) {
            this.input = input;
            return this;
        }

        public MaxPooling2DBuilder config(Pooling2DConfig config) {
            this.config = config;
            return this;
        }

        public MaxPooling2D build() {
            return new MaxPooling2D(this.sameDiff, this.input, this.config);
        }

        public String toString() {
            return "MaxPooling2D.MaxPooling2DBuilder(sameDiff=" + this.sameDiff + ", input=" + this.input + ", config=" + this.config + ")";
        }
    }
}

