/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.execution.conf;

import com.google.flatbuffers.FlatBufferBuilder;
import org.nd4j.autodiff.execution.conf.ExecutionMode;
import org.nd4j.autodiff.execution.conf.OutputMode;
import org.nd4j.graph.FlatConfiguration;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ExecutorConfiguration.class);
    private OpExecutioner.ProfilingMode profilingMode;
    private ExecutionMode executionMode;
    private OutputMode outputMode;
    boolean gatherTimings;
    private long footprintForward;
    private long footprintBackward;

    public int getFlatConfiguration(FlatBufferBuilder builder) {
        byte outp;
        byte exec;
        byte prof;
        byte by = this.profilingMode == OpExecutioner.ProfilingMode.INF_PANIC ? (byte)2 : (this.profilingMode == OpExecutioner.ProfilingMode.NAN_PANIC ? (byte)1 : (prof = this.profilingMode == OpExecutioner.ProfilingMode.ANY_PANIC ? (byte)3 : 0));
        byte by2 = this.executionMode == ExecutionMode.SEQUENTIAL ? (byte)0 : (this.executionMode == ExecutionMode.AUTO ? (byte)2 : (exec = this.executionMode == ExecutionMode.STRICT ? (byte)1 : -1));
        byte by3 = this.outputMode == OutputMode.IMPLICIT ? (byte)0 : (this.outputMode == OutputMode.EXPLICIT ? (byte)1 : (this.outputMode == OutputMode.EXPLICIT_AND_IMPLICIT ? (byte)2 : (outp = this.outputMode == OutputMode.VARIABLE_SPACE ? (byte)3 : -1)));
        if (exec == -1) {
            throw new UnsupportedOperationException("Unknown values were passed into configuration as ExecutionMode: [" + this.executionMode + "]");
        }
        if (outp == -1) {
            throw new UnsupportedOperationException("Unknown values were passed into configuration as OutputMode: [" + this.outputMode + "]");
        }
        return FlatConfiguration.createFlatConfiguration(builder, -1L, prof, exec, outp, this.gatherTimings, this.footprintForward, this.footprintBackward, (byte)0);
    }

    private static OpExecutioner.ProfilingMode $default$profilingMode() {
        return OpExecutioner.ProfilingMode.DISABLED;
    }

    private static ExecutionMode $default$executionMode() {
        return ExecutionMode.SEQUENTIAL;
    }

    private static OutputMode $default$outputMode() {
        return OutputMode.IMPLICIT;
    }

    private static boolean $default$gatherTimings() {
        return true;
    }

    private static long $default$footprintForward() {
        return 0L;
    }

    private static long $default$footprintBackward() {
        return 0L;
    }

    public static ExecutorConfigurationBuilder builder() {
        return new ExecutorConfigurationBuilder();
    }

    public OpExecutioner.ProfilingMode getProfilingMode() {
        return this.profilingMode;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public boolean isGatherTimings() {
        return this.gatherTimings;
    }

    public long getFootprintForward() {
        return this.footprintForward;
    }

    public long getFootprintBackward() {
        return this.footprintBackward;
    }

    public void setProfilingMode(OpExecutioner.ProfilingMode profilingMode) {
        this.profilingMode = profilingMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public void setOutputMode(OutputMode outputMode) {
        this.outputMode = outputMode;
    }

    public void setGatherTimings(boolean gatherTimings) {
        this.gatherTimings = gatherTimings;
    }

    public void setFootprintForward(long footprintForward) {
        this.footprintForward = footprintForward;
    }

    public void setFootprintBackward(long footprintBackward) {
        this.footprintBackward = footprintBackward;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutorConfiguration)) {
            return false;
        }
        ExecutorConfiguration other = (ExecutorConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGatherTimings() != other.isGatherTimings()) {
            return false;
        }
        if (this.getFootprintForward() != other.getFootprintForward()) {
            return false;
        }
        if (this.getFootprintBackward() != other.getFootprintBackward()) {
            return false;
        }
        OpExecutioner.ProfilingMode this$profilingMode = this.getProfilingMode();
        OpExecutioner.ProfilingMode other$profilingMode = other.getProfilingMode();
        if (this$profilingMode == null ? other$profilingMode != null : !((Object)((Object)this$profilingMode)).equals((Object)other$profilingMode)) {
            return false;
        }
        ExecutionMode this$executionMode = this.getExecutionMode();
        ExecutionMode other$executionMode = other.getExecutionMode();
        if (this$executionMode == null ? other$executionMode != null : !((Object)((Object)this$executionMode)).equals((Object)other$executionMode)) {
            return false;
        }
        OutputMode this$outputMode = this.getOutputMode();
        OutputMode other$outputMode = other.getOutputMode();
        return !(this$outputMode == null ? other$outputMode != null : !((Object)((Object)this$outputMode)).equals((Object)other$outputMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutorConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGatherTimings() ? 79 : 97);
        long $footprintForward = this.getFootprintForward();
        result = result * 59 + (int)($footprintForward >>> 32 ^ $footprintForward);
        long $footprintBackward = this.getFootprintBackward();
        result = result * 59 + (int)($footprintBackward >>> 32 ^ $footprintBackward);
        OpExecutioner.ProfilingMode $profilingMode = this.getProfilingMode();
        result = result * 59 + ($profilingMode == null ? 43 : ((Object)((Object)$profilingMode)).hashCode());
        ExecutionMode $executionMode = this.getExecutionMode();
        result = result * 59 + ($executionMode == null ? 43 : ((Object)((Object)$executionMode)).hashCode());
        OutputMode $outputMode = this.getOutputMode();
        result = result * 59 + ($outputMode == null ? 43 : ((Object)((Object)$outputMode)).hashCode());
        return result;
    }

    public String toString() {
        return "ExecutorConfiguration(profilingMode=" + this.getProfilingMode() + ", executionMode=" + this.getExecutionMode() + ", outputMode=" + this.getOutputMode() + ", gatherTimings=" + this.isGatherTimings() + ", footprintForward=" + this.getFootprintForward() + ", footprintBackward=" + this.getFootprintBackward() + ")";
    }

    public ExecutorConfiguration() {
        this.profilingMode = ExecutorConfiguration.$default$profilingMode();
        this.executionMode = ExecutorConfiguration.$default$executionMode();
        this.outputMode = ExecutorConfiguration.$default$outputMode();
        this.gatherTimings = ExecutorConfiguration.$default$gatherTimings();
        this.footprintForward = ExecutorConfiguration.$default$footprintForward();
        this.footprintBackward = ExecutorConfiguration.$default$footprintBackward();
    }

    public ExecutorConfiguration(OpExecutioner.ProfilingMode profilingMode, ExecutionMode executionMode, OutputMode outputMode, boolean gatherTimings, long footprintForward, long footprintBackward) {
        this.profilingMode = profilingMode;
        this.executionMode = executionMode;
        this.outputMode = outputMode;
        this.gatherTimings = gatherTimings;
        this.footprintForward = footprintForward;
        this.footprintBackward = footprintBackward;
    }

    public static class ExecutorConfigurationBuilder {
        private boolean profilingMode$set;
        private OpExecutioner.ProfilingMode profilingMode$value;
        private boolean executionMode$set;
        private ExecutionMode executionMode$value;
        private boolean outputMode$set;
        private OutputMode outputMode$value;
        private boolean gatherTimings$set;
        private boolean gatherTimings$value;
        private boolean footprintForward$set;
        private long footprintForward$value;
        private boolean footprintBackward$set;
        private long footprintBackward$value;

        ExecutorConfigurationBuilder() {
        }

        public ExecutorConfigurationBuilder profilingMode(OpExecutioner.ProfilingMode profilingMode) {
            this.profilingMode$value = profilingMode;
            this.profilingMode$set = true;
            return this;
        }

        public ExecutorConfigurationBuilder executionMode(ExecutionMode executionMode) {
            this.executionMode$value = executionMode;
            this.executionMode$set = true;
            return this;
        }

        public ExecutorConfigurationBuilder outputMode(OutputMode outputMode) {
            this.outputMode$value = outputMode;
            this.outputMode$set = true;
            return this;
        }

        public ExecutorConfigurationBuilder gatherTimings(boolean gatherTimings) {
            this.gatherTimings$value = gatherTimings;
            this.gatherTimings$set = true;
            return this;
        }

        public ExecutorConfigurationBuilder footprintForward(long footprintForward) {
            this.footprintForward$value = footprintForward;
            this.footprintForward$set = true;
            return this;
        }

        public ExecutorConfigurationBuilder footprintBackward(long footprintBackward) {
            this.footprintBackward$value = footprintBackward;
            this.footprintBackward$set = true;
            return this;
        }

        public ExecutorConfiguration build() {
            OpExecutioner.ProfilingMode profilingMode$value = this.profilingMode$value;
            if (!this.profilingMode$set) {
                profilingMode$value = ExecutorConfiguration.$default$profilingMode();
            }
            ExecutionMode executionMode$value = this.executionMode$value;
            if (!this.executionMode$set) {
                executionMode$value = ExecutorConfiguration.$default$executionMode();
            }
            OutputMode outputMode$value = this.outputMode$value;
            if (!this.outputMode$set) {
                outputMode$value = ExecutorConfiguration.$default$outputMode();
            }
            boolean gatherTimings$value = this.gatherTimings$value;
            if (!this.gatherTimings$set) {
                gatherTimings$value = ExecutorConfiguration.$default$gatherTimings();
            }
            long footprintForward$value = this.footprintForward$value;
            if (!this.footprintForward$set) {
                footprintForward$value = ExecutorConfiguration.$default$footprintForward();
            }
            long footprintBackward$value = this.footprintBackward$value;
            if (!this.footprintBackward$set) {
                footprintBackward$value = ExecutorConfiguration.$default$footprintBackward();
            }
            return new ExecutorConfiguration(profilingMode$value, executionMode$value, outputMode$value, gatherTimings$value, footprintForward$value, footprintBackward$value);
        }

        public String toString() {
            return "ExecutorConfiguration.ExecutorConfigurationBuilder(profilingMode$value=" + this.profilingMode$value + ", executionMode$value=" + this.executionMode$value + ", outputMode$value=" + this.outputMode$value + ", gatherTimings$value=" + this.gatherTimings$value + ", footprintForward$value=" + this.footprintForward$value + ", footprintBackward$value=" + this.footprintBackward$value + ")";
        }
    }
}

