/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.listeners.Listener;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.config.SDValue;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;

public class BatchOutputConfig {
    private SameDiff sd;
    @NonNull
    private List<String> outputs = new ArrayList<String>();
    private Map<String, INDArray> placeholders = new HashMap<String, INDArray>();
    private Map<String, SDValue> sequenceInputs = new HashMap<String, SDValue>();
    @NonNull
    private List<Listener> listeners = new ArrayList<Listener>();

    public BatchOutputConfig(@NonNull SameDiff sd) {
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        this.sd = sd;
    }

    public BatchOutputConfig output(String ... outputs) {
        if (outputs == null) {
            throw new NullPointerException("outputs is marked non-null but is null");
        }
        this.outputs.addAll(Arrays.asList(outputs));
        return this;
    }

    public BatchOutputConfig output(SDVariable ... outputs) {
        if (outputs == null) {
            throw new NullPointerException("outputs is marked non-null but is null");
        }
        String[] outNames = new String[outputs.length];
        for (int i = 0; i < outputs.length; ++i) {
            outNames[i] = outputs[i].name();
        }
        return this.output(outNames);
    }

    public BatchOutputConfig outputAll() {
        return this.output(this.sd.variables().toArray(new SDVariable[0]));
    }

    public BatchOutputConfig input(@NonNull String variable, @NonNull INDArray placeholder) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        Preconditions.checkState((!this.placeholders.containsKey(variable) ? 1 : 0) != 0, (String)"Placeholder for variable %s already specified", (Object)variable);
        Preconditions.checkNotNull((Object)this.sd.getVariable(variable), (String)"Variable %s does not exist in this SameDiff graph", (Object)variable);
        this.placeholders.put(variable, placeholder);
        return this;
    }

    public BatchOutputConfig valueInput(@NonNull String variable, @NonNull SDValue placeholder) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        Preconditions.checkState((!this.sequenceInputs.containsKey(variable) ? 1 : 0) != 0, (String)"Placeholder for variable %s already specified", (Object)variable);
        Preconditions.checkNotNull((Object)this.sd.getVariable(variable), (String)"Variable %s does not exist in this SameDiff graph", (Object)variable);
        this.sequenceInputs.put(variable, placeholder);
        return this;
    }

    public BatchOutputConfig input(@NonNull SDVariable variable, @NonNull INDArray placeholder) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        return this.input(variable.name(), placeholder);
    }

    public BatchOutputConfig valueInputs(Map<String, SDValue> placeholders) {
        if (placeholders == null) {
            this.placeholders = null;
            return this;
        }
        for (Map.Entry<String, SDValue> e : placeholders.entrySet()) {
            this.valueInput(e.getKey(), e.getValue());
        }
        return this;
    }

    public BatchOutputConfig inputs(Map<String, INDArray> placeholders) {
        if (placeholders == null) {
            this.placeholders = null;
            return this;
        }
        for (Map.Entry<String, INDArray> e : placeholders.entrySet()) {
            this.input(e.getKey(), e.getValue());
        }
        return this;
    }

    public BatchOutputConfig listeners(Listener ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.listeners.addAll(Arrays.asList(listeners));
        return this;
    }

    @Deprecated
    public Map<String, INDArray> exec() {
        return this.output();
    }

    public Map<String, SDValue> outputValue() {
        return this.sd.outputValues(this.sequenceInputs, this.listeners, this.outputs);
    }

    public Map<String, INDArray> output() {
        return this.sd.output(this.placeholders, this.listeners, this.outputs.toArray(new String[0]));
    }

    @Deprecated
    public INDArray execSingle() {
        return this.outputSingle();
    }

    public INDArray outputSingle() {
        Preconditions.checkState((this.outputs.size() == 1 ? 1 : 0) != 0, (String)"Can only use execSingle() when exactly one output is specified, there were %s", (int)this.outputs.size());
        return this.exec().get(this.outputs.get(0));
    }

    public SameDiff getSd() {
        return this.sd;
    }

    @NonNull
    public List<String> getOutputs() {
        return this.outputs;
    }

    public Map<String, INDArray> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, SDValue> getSequenceInputs() {
        return this.sequenceInputs;
    }

    @NonNull
    public List<Listener> getListeners() {
        return this.listeners;
    }

    public void setOutputs(@NonNull List<String> outputs) {
        if (outputs == null) {
            throw new NullPointerException("outputs is marked non-null but is null");
        }
        this.outputs = outputs;
    }

    public void setPlaceholders(Map<String, INDArray> placeholders) {
        this.placeholders = placeholders;
    }

    public void setSequenceInputs(Map<String, SDValue> sequenceInputs) {
        this.sequenceInputs = sequenceInputs;
    }

    public void setListeners(@NonNull List<Listener> listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.listeners = listeners;
    }
}

