/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.ImageResizeMethod;
import org.nd4j.enums.Mode;
import org.nd4j.linalg.api.ops.custom.AdjustContrast;
import org.nd4j.linalg.api.ops.custom.AdjustHue;
import org.nd4j.linalg.api.ops.custom.AdjustSaturation;
import org.nd4j.linalg.api.ops.custom.HsvToRgb;
import org.nd4j.linalg.api.ops.custom.RandomCrop;
import org.nd4j.linalg.api.ops.custom.RgbToHsv;
import org.nd4j.linalg.api.ops.custom.RgbToYiq;
import org.nd4j.linalg.api.ops.custom.RgbToYuv;
import org.nd4j.linalg.api.ops.custom.YiqToRgb;
import org.nd4j.linalg.api.ops.custom.YuvToRgb;
import org.nd4j.linalg.api.ops.impl.image.CropAndResize;
import org.nd4j.linalg.api.ops.impl.image.ExtractImagePatches;
import org.nd4j.linalg.api.ops.impl.image.ImageResize;
import org.nd4j.linalg.api.ops.impl.image.NonMaxSuppression;
import org.nd4j.linalg.api.ops.impl.image.ResizeBicubic;
import org.nd4j.linalg.api.ops.impl.image.ResizeBilinear;
import org.nd4j.linalg.api.ops.impl.transforms.Pad;

public class SDImage
extends SDOps {
    public SDImage(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable cropAndResize(SDVariable image, SDVariable cropBoxes, SDVariable boxIndices, SDVariable cropOutSize, double extrapolationValue) {
        SDValidation.validateNumerical("CropAndResize", "image", image);
        SDValidation.validateNumerical("CropAndResize", "cropBoxes", cropBoxes);
        SDValidation.validateNumerical("CropAndResize", "boxIndices", boxIndices);
        SDValidation.validateInteger("CropAndResize", "cropOutSize", cropOutSize);
        return new CropAndResize(this.sd, image, cropBoxes, boxIndices, cropOutSize, extrapolationValue).outputVariable();
    }

    public SDVariable cropAndResize(String name, SDVariable image, SDVariable cropBoxes, SDVariable boxIndices, SDVariable cropOutSize, double extrapolationValue) {
        SDValidation.validateNumerical("CropAndResize", "image", image);
        SDValidation.validateNumerical("CropAndResize", "cropBoxes", cropBoxes);
        SDValidation.validateNumerical("CropAndResize", "boxIndices", boxIndices);
        SDValidation.validateInteger("CropAndResize", "cropOutSize", cropOutSize);
        SDVariable out = new CropAndResize(this.sd, image, cropBoxes, boxIndices, cropOutSize, extrapolationValue).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable cropAndResize(SDVariable image, SDVariable cropBoxes, SDVariable boxIndices, SDVariable cropOutSize) {
        SDValidation.validateNumerical("CropAndResize", "image", image);
        SDValidation.validateNumerical("CropAndResize", "cropBoxes", cropBoxes);
        SDValidation.validateNumerical("CropAndResize", "boxIndices", boxIndices);
        SDValidation.validateInteger("CropAndResize", "cropOutSize", cropOutSize);
        return new CropAndResize(this.sd, image, cropBoxes, boxIndices, cropOutSize, 0.0).outputVariable();
    }

    public SDVariable cropAndResize(String name, SDVariable image, SDVariable cropBoxes, SDVariable boxIndices, SDVariable cropOutSize) {
        SDValidation.validateNumerical("CropAndResize", "image", image);
        SDValidation.validateNumerical("CropAndResize", "cropBoxes", cropBoxes);
        SDValidation.validateNumerical("CropAndResize", "boxIndices", boxIndices);
        SDValidation.validateInteger("CropAndResize", "cropOutSize", cropOutSize);
        SDVariable out = new CropAndResize(this.sd, image, cropBoxes, boxIndices, cropOutSize, 0.0).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable adjustContrast(SDVariable in, double factor) {
        SDValidation.validateNumerical("adjustContrast", "in", in);
        return new AdjustContrast(this.sd, in, factor).outputVariable();
    }

    public SDVariable adjustContrast(String name, SDVariable in, double factor) {
        SDValidation.validateNumerical("adjustContrast", "in", in);
        SDVariable out = new AdjustContrast(this.sd, in, factor).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable adjustHue(SDVariable in, double delta) {
        SDValidation.validateNumerical("adjustHue", "in", in);
        return new AdjustHue(this.sd, in, delta).outputVariable();
    }

    public SDVariable adjustHue(String name, SDVariable in, double delta) {
        SDValidation.validateNumerical("adjustHue", "in", in);
        SDVariable out = new AdjustHue(this.sd, in, delta).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable adjustSaturation(SDVariable in, double factor) {
        SDValidation.validateNumerical("adjustSaturation", "in", in);
        return new AdjustSaturation(this.sd, in, factor).outputVariable();
    }

    public SDVariable adjustSaturation(String name, SDVariable in, double factor) {
        SDValidation.validateNumerical("adjustSaturation", "in", in);
        SDVariable out = new AdjustSaturation(this.sd, in, factor).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable extractImagePatches(SDVariable image, int[] kSizes, int[] strides, int[] rates, boolean sameMode) {
        SDValidation.validateNumerical("extractImagePatches", "image", image);
        Preconditions.checkArgument((kSizes.length == 2 ? 1 : 0) != 0, (String)"kSizes has incorrect size/length. Expected: kSizes.length == 2, got %s", (int)kSizes.length);
        Preconditions.checkArgument((strides.length == 2 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length == 2, got %s", (int)strides.length);
        Preconditions.checkArgument((rates.length >= 0 ? 1 : 0) != 0, (String)"rates has incorrect size/length. Expected: rates.length >= 0, got %s", (int)rates.length);
        return new ExtractImagePatches(this.sd, image, kSizes, strides, rates, sameMode).outputVariable();
    }

    public SDVariable extractImagePatches(String name, SDVariable image, int[] kSizes, int[] strides, int[] rates, boolean sameMode) {
        SDValidation.validateNumerical("extractImagePatches", "image", image);
        Preconditions.checkArgument((kSizes.length == 2 ? 1 : 0) != 0, (String)"kSizes has incorrect size/length. Expected: kSizes.length == 2, got %s", (int)kSizes.length);
        Preconditions.checkArgument((strides.length == 2 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length == 2, got %s", (int)strides.length);
        Preconditions.checkArgument((rates.length >= 0 ? 1 : 0) != 0, (String)"rates has incorrect size/length. Expected: rates.length >= 0, got %s", (int)rates.length);
        SDVariable out = new ExtractImagePatches(this.sd, image, kSizes, strides, rates, sameMode).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable hsvToRgb(SDVariable input) {
        SDValidation.validateNumerical("hsvToRgb", "input", input);
        return new HsvToRgb(this.sd, input).outputVariable();
    }

    public SDVariable hsvToRgb(String name, SDVariable input) {
        SDValidation.validateNumerical("hsvToRgb", "input", input);
        SDVariable out = new HsvToRgb(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable imageResize(SDVariable input, SDVariable size, boolean preserveAspectRatio, boolean antialias, ImageResizeMethod ImageResizeMethod2) {
        SDValidation.validateNumerical("imageResize", "input", input);
        SDValidation.validateInteger("imageResize", "size", size);
        return new ImageResize(this.sd, input, size, preserveAspectRatio, antialias, ImageResizeMethod2).outputVariable();
    }

    public SDVariable imageResize(String name, SDVariable input, SDVariable size, boolean preserveAspectRatio, boolean antialias, ImageResizeMethod ImageResizeMethod2) {
        SDValidation.validateNumerical("imageResize", "input", input);
        SDValidation.validateInteger("imageResize", "size", size);
        SDVariable out = new ImageResize(this.sd, input, size, preserveAspectRatio, antialias, ImageResizeMethod2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable imageResize(SDVariable input, SDVariable size, ImageResizeMethod ImageResizeMethod2) {
        SDValidation.validateNumerical("imageResize", "input", input);
        SDValidation.validateInteger("imageResize", "size", size);
        return new ImageResize(this.sd, input, size, false, false, ImageResizeMethod2).outputVariable();
    }

    public SDVariable imageResize(String name, SDVariable input, SDVariable size, ImageResizeMethod ImageResizeMethod2) {
        SDValidation.validateNumerical("imageResize", "input", input);
        SDValidation.validateInteger("imageResize", "size", size);
        SDVariable out = new ImageResize(this.sd, input, size, false, false, ImageResizeMethod2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable nonMaxSuppression(SDVariable boxes, SDVariable scores, int maxOutSize, double iouThreshold, double scoreThreshold) {
        SDValidation.validateNumerical("nonMaxSuppression", "boxes", boxes);
        SDValidation.validateNumerical("nonMaxSuppression", "scores", scores);
        return new NonMaxSuppression(this.sd, boxes, scores, maxOutSize, iouThreshold, scoreThreshold).outputVariable();
    }

    public SDVariable nonMaxSuppression(String name, SDVariable boxes, SDVariable scores, int maxOutSize, double iouThreshold, double scoreThreshold) {
        SDValidation.validateNumerical("nonMaxSuppression", "boxes", boxes);
        SDValidation.validateNumerical("nonMaxSuppression", "scores", scores);
        SDVariable out = new NonMaxSuppression(this.sd, boxes, scores, maxOutSize, iouThreshold, scoreThreshold).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable pad(SDVariable input, SDVariable padding, Mode Mode2, double padValue) {
        SDValidation.validateNumerical("pad", "input", input);
        SDValidation.validateNumerical("pad", "padding", padding);
        return new Pad(this.sd, input, padding, Mode2, padValue).outputVariable();
    }

    public SDVariable pad(String name, SDVariable input, SDVariable padding, Mode Mode2, double padValue) {
        SDValidation.validateNumerical("pad", "input", input);
        SDValidation.validateNumerical("pad", "padding", padding);
        SDVariable out = new Pad(this.sd, input, padding, Mode2, padValue).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable randomCrop(SDVariable input, SDVariable shape) {
        SDValidation.validateNumerical("randomCrop", "input", input);
        SDValidation.validateInteger("randomCrop", "shape", shape);
        return new RandomCrop(this.sd, input, shape).outputVariable();
    }

    public SDVariable randomCrop(String name, SDVariable input, SDVariable shape) {
        SDValidation.validateNumerical("randomCrop", "input", input);
        SDValidation.validateInteger("randomCrop", "shape", shape);
        SDVariable out = new RandomCrop(this.sd, input, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable resizeBiCubic(SDVariable input, SDVariable size, boolean alignCorners, boolean alignPixelCenters) {
        SDValidation.validateNumerical("resizeBiCubic", "input", input);
        SDValidation.validateInteger("resizeBiCubic", "size", size);
        return new ResizeBicubic(this.sd, input, size, alignCorners, alignPixelCenters).outputVariable();
    }

    public SDVariable resizeBiCubic(String name, SDVariable input, SDVariable size, boolean alignCorners, boolean alignPixelCenters) {
        SDValidation.validateNumerical("resizeBiCubic", "input", input);
        SDValidation.validateInteger("resizeBiCubic", "size", size);
        SDVariable out = new ResizeBicubic(this.sd, input, size, alignCorners, alignPixelCenters).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable resizeBiLinear(SDVariable input, int height, int width, boolean alignCorners, boolean halfPixelCenters) {
        SDValidation.validateNumerical("resizeBiLinear", "input", input);
        return new ResizeBilinear(this.sd, input, height, width, alignCorners, halfPixelCenters).outputVariable();
    }

    public SDVariable resizeBiLinear(String name, SDVariable input, int height, int width, boolean alignCorners, boolean halfPixelCenters) {
        SDValidation.validateNumerical("resizeBiLinear", "input", input);
        SDVariable out = new ResizeBilinear(this.sd, input, height, width, alignCorners, halfPixelCenters).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable rgbToHsv(SDVariable input) {
        SDValidation.validateNumerical("rgbToHsv", "input", input);
        return new RgbToHsv(this.sd, input).outputVariable();
    }

    public SDVariable rgbToHsv(String name, SDVariable input) {
        SDValidation.validateNumerical("rgbToHsv", "input", input);
        SDVariable out = new RgbToHsv(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable rgbToYiq(SDVariable input) {
        SDValidation.validateNumerical("rgbToYiq", "input", input);
        return new RgbToYiq(this.sd, input).outputVariable();
    }

    public SDVariable rgbToYiq(String name, SDVariable input) {
        SDValidation.validateNumerical("rgbToYiq", "input", input);
        SDVariable out = new RgbToYiq(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable rgbToYuv(SDVariable input) {
        SDValidation.validateNumerical("rgbToYuv", "input", input);
        return new RgbToYuv(this.sd, input).outputVariable();
    }

    public SDVariable rgbToYuv(String name, SDVariable input) {
        SDValidation.validateNumerical("rgbToYuv", "input", input);
        SDVariable out = new RgbToYuv(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable yiqToRgb(SDVariable input) {
        SDValidation.validateNumerical("yiqToRgb", "input", input);
        return new YiqToRgb(this.sd, input).outputVariable();
    }

    public SDVariable yiqToRgb(String name, SDVariable input) {
        SDValidation.validateNumerical("yiqToRgb", "input", input);
        SDVariable out = new YiqToRgb(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable yuvToRgb(SDVariable input) {
        SDValidation.validateNumerical("yuvToRgb", "input", input);
        return new YuvToRgb(this.sd, input).outputVariable();
    }

    public SDVariable yuvToRgb(String name, SDVariable input) {
        SDValidation.validateNumerical("yuvToRgb", "input", input);
        SDVariable out = new YuvToRgb(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }
}

