/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.List;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.loss.BaseLoss;
import org.nd4j.linalg.api.ops.impl.loss.bp.SigmoidCrossEntropyLossBp;

public class SigmoidCrossEntropyLoss
extends BaseLoss {
    public static final double DEFAULT_LABEL_SMOOTHING = 0.0;
    protected double labelSmoothing;

    public SigmoidCrossEntropyLoss(SameDiff sameDiff, SDVariable labels, SDVariable logits, SDVariable weights, LossReduce lossReduce, double labelSmoothing) {
        this(sameDiff, lossReduce, logits, weights, labels, labelSmoothing);
    }

    public SigmoidCrossEntropyLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable logits, SDVariable weights, SDVariable labels, double labelSmoothing) {
        super(sameDiff, lossReduce, logits, weights, labels);
        this.labelSmoothing = labelSmoothing;
        this.tArguments.add(labelSmoothing);
    }

    public SigmoidCrossEntropyLoss(SameDiff sameDiff, LossReduce reductionMode, SDVariable logits, SDVariable weights, SDVariable labels) {
        this(sameDiff, reductionMode, logits, weights, labels, 0.0);
    }

    public SigmoidCrossEntropyLoss(INDArray labels, INDArray predictions, INDArray weights, LossReduce lossReduce, double labelSmoothing) {
        super(lossReduce, predictions, weights, labels);
        this.labelSmoothing = labelSmoothing;
        this.tArguments.add(labelSmoothing);
    }

    @Override
    public String opName() {
        return "sigm_cross_entropy_loss";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        if (this.tArguments.size() > 0) {
            this.labelSmoothing = (Double)this.tArguments.get(this.tArguments.size() - 1);
        }
        return new SigmoidCrossEntropyLossBp(this.sameDiff, this.lossReduce, this.arg(0), this.arg(1), this.arg(2), this.labelSmoothing).outputs();
    }

    public SigmoidCrossEntropyLoss() {
    }

    public double getLabelSmoothing() {
        return this.labelSmoothing;
    }

    public void setLabelSmoothing(double labelSmoothing) {
        this.labelSmoothing = labelSmoothing;
    }
}

