/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.reduce.TensorMmulBp;
import org.nd4j.shade.guava.primitives.Ints;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class TensorMmul
extends DynamicCustomOp {
    private int[][] axes;
    protected boolean addedEdges;
    protected MMulTranspose mMulTranspose;

    public TensorMmul(INDArray x, INDArray y, int[][] axes) {
        this(x, y, axes[0], axes[1], false, false, false);
    }

    public TensorMmul(INDArray x, INDArray y, INDArray z, int[][] axes) {
        this(x, y, axes[0], axes[1], false, false, false);
    }

    public TensorMmul(INDArray x, INDArray y, int[] dimensionsX, int[] dimensionsY, boolean transposeX, boolean transposeY, boolean transposeZ) {
        super(null, new INDArray[]{x, y}, null);
        this.axes = new int[][]{dimensionsX, dimensionsY};
        this.addIArgument(dimensionsX.length);
        this.addIArgument(dimensionsX);
        this.addIArgument(dimensionsY.length);
        this.addIArgument(dimensionsY);
        this.addBArgument(transposeX, transposeY, transposeZ);
    }

    public TensorMmul(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[][] dimensions) {
        this(sameDiff, i_v1, i_v2, dimensions, MMulTranspose.allFalse());
    }

    public TensorMmul(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[][] dimensions, MMulTranspose mMulTranspose) {
        super(null, sameDiff, new SDVariable[]{i_v1, i_v2});
        this.sameDiff = sameDiff;
        this.mMulTranspose = mMulTranspose;
        this.axes = dimensions;
        if (!this.addedEdges && sameDiff.getOutputsForOp(this) == null) {
            this.addedEdges = true;
        }
        this.addIArgument(dimensions[0].length);
        this.addIArgument(dimensions[0]);
        this.addIArgument(dimensions[1].length);
        this.addIArgument(dimensions[1]);
    }

    public TensorMmul(SameDiff sameDiff, SDVariable x, SDVariable y, int[] dimensionsX, int[] dimensionsY, boolean transposeX, boolean transposeY, boolean transposeZ) {
        super(null, sameDiff, new SDVariable[]{x, y});
        this.sameDiff = sameDiff;
        this.axes = new int[][]{dimensionsX, dimensionsY};
        this.addIArgument(dimensionsX.length);
        this.addIArgument(dimensionsX[0]);
        this.addIArgument(dimensionsY.length);
        this.addIArgument(dimensionsY[0]);
        this.addBArgument(transposeX, transposeY, transposeZ);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Arrays.asList(new TensorMmulBp(this.sameDiff, this.larg(), this.rarg(), gradients.get(0), this.axes).outputVariables());
    }

    @Override
    public String opName() {
        return "tensordot";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        MMulTranspose mMulTranspose;
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        boolean isTransposeA = attributesForNode.get("transpose_a").getB();
        boolean isTransposeB = attributesForNode.get("transpose_b").getB();
        this.mMulTranspose = mMulTranspose = MMulTranspose.builder().transposeA(isTransposeA).transposeB(isTransposeB).build();
        SDVariable[] args = this.args();
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        MMulTranspose mMulTranspose;
        boolean isTransposeA;
        boolean bl = !attributesForNode.containsKey("transA") ? false : (isTransposeA = attributesForNode.get("transA").getI() > 0L);
        boolean isTransposeB = !attributesForNode.containsKey("transB") ? false : attributesForNode.get("transB").getI() > 0L;
        this.mMulTranspose = mMulTranspose = MMulTranspose.builder().transposeA(isTransposeA).transposeB(isTransposeB).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorMmul that = (TensorMmul)o;
        if (this.addedEdges != that.addedEdges) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.axes, (Object[])that.axes)) {
            return false;
        }
        return this.mMulTranspose != null ? this.mMulTranspose.equals(that.mMulTranspose) : that.mMulTranspose == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.deepHashCode((Object[])this.axes);
        result = 31 * result + (this.addedEdges ? 1 : 0);
        result = 31 * result + (this.mMulTranspose != null ? this.mMulTranspose.hashCode() : 0);
        return result;
    }

    @Override
    public void configureFromArguments() {
        MMulTranspose.MMulTransposeBuilder mMulTransposeBuilder = MMulTranspose.builder();
        if (!this.iArguments.isEmpty()) {
            long numDimensionsX = (Long)this.iArguments.get(0);
            ArrayList<Long> xDims = new ArrayList<Long>();
            ArrayList<Long> yDims = new ArrayList<Long>();
            int i = 0;
            while ((long)i < numDimensionsX) {
                xDims.add((Long)this.iArguments.get(i));
                ++i;
            }
            long numDimensionsY = (Long)this.iArguments.get((int)numDimensionsX + 1);
            int i2 = 0;
            while ((long)i2 < numDimensionsY) {
                yDims.add((long)i2 + numDimensionsX + 1L);
                ++i2;
            }
            this.axes = new int[][]{Ints.toArray(xDims), Ints.toArray(yDims)};
        }
        if (!this.bArguments.isEmpty()) {
            mMulTransposeBuilder.transposeA((Boolean)this.bArguments.get(0)).transposeB((Boolean)this.bArguments.get(1)).transposeResult((Boolean)this.bArguments.get(2));
        }
        this.mMulTranspose = mMulTransposeBuilder.build();
        this.addedEdges = true;
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        MMulTranspose.MMulTransposeBuilder mMulTransposeBuilder = MMulTranspose.builder();
        if (properties.containsKey("transposeX")) {
            Boolean transposeX = this.getBooleanFromProperty("transposeX", properties);
            mMulTransposeBuilder.transposeA(transposeX);
        }
        if (properties.containsKey("transposeZ")) {
            Boolean transposeZ = this.getBooleanFromProperty("transposeZ", properties);
            mMulTransposeBuilder.transposeResult(transposeZ);
        }
        if (properties.containsKey("transposeY")) {
            Boolean transposeY = this.getBooleanFromProperty("transposeY", properties);
            mMulTransposeBuilder.transposeB(transposeY);
        }
        this.mMulTranspose = mMulTransposeBuilder.build();
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public String onnxName() {
        return "Gemm";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly 2 input data types for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public TensorMmul() {
    }
}

