/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.bool;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformBoolOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.Conditions;

public class MatchConditionTransform
extends BaseTransformBoolOp {
    private Condition condition;
    private double compare;
    private double eps;
    private Conditions.ConditionMode mode;

    public MatchConditionTransform(SameDiff sameDiff, SDVariable in, Condition condition) {
        super(sameDiff, in, false);
        this.condition = condition;
        this.compare = condition.getValue();
        this.mode = condition.conditionType();
        this.eps = Nd4j.EPS_THRESHOLD;
        this.extraArgs = new Object[]{this.compare, this.eps, this.mode.index};
    }

    public MatchConditionTransform() {
    }

    public MatchConditionTransform(@NonNull INDArray x, @NonNull INDArray y, @NonNull INDArray z, @NonNull Condition condition) {
        this(x, z, Nd4j.EPS_THRESHOLD, condition);
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        this.y = y;
    }

    public MatchConditionTransform(@NonNull INDArray x, @NonNull INDArray z, @NonNull Condition condition) {
        this(x, z, Nd4j.EPS_THRESHOLD, condition);
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
    }

    public MatchConditionTransform(INDArray x, @NonNull Condition condition) {
        this(x, null, Nd4j.EPS_THRESHOLD, condition);
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
    }

    public MatchConditionTransform(INDArray x, INDArray z, double eps, @NonNull Condition condition) {
        super(x, null, z);
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        this.compare = condition.getValue();
        this.mode = condition.conditionType();
        this.eps = eps;
        this.extraArgs = new Object[]{this.compare, eps, this.mode.index};
    }

    public MatchConditionTransform(INDArray x, double eps, @NonNull Condition condition) {
        this(x, null, eps, condition);
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
    }

    @Override
    public int opNum() {
        return 5;
    }

    @Override
    public String opName() {
        return "match_condition_transform";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public Op.Type getOpType() {
        if (this.y == null) {
            return Op.Type.TRANSFORM_BOOL;
        }
        return Op.Type.PAIRWISE_BOOL;
    }

    @Override
    public Op.Type opType() {
        if (this.y == null) {
            return Op.Type.TRANSFORM_BOOL;
        }
        return Op.Type.PAIRWISE_BOOL;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }
}

