/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.IntervalIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDArrayIndexAll
extends IntervalIndex {
    private static final Logger log = LoggerFactory.getLogger(NDArrayIndexAll.class);

    public NDArrayIndexAll() {
        super(true, 1L);
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
        this.initialized = true;
        this.inclusive = false;
        this.begin = 0L;
        this.end = arr.size(dimension);
        this.length = (this.end - begin) / this.stride + 1L;
    }

    @Override
    public INDArrayIndex dup() {
        NDArrayIndexAll all = new NDArrayIndexAll();
        all.inclusive = this.inclusive;
        all.begin = this.begin;
        all.end = this.begin;
        all.initialized = this.initialized;
        all.index = this.index;
        all.length = this.length;
        all.stride = this.stride;
        return all;
    }

    @Override
    public String toString() {
        return "all()";
    }
}

