/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.Nadam;

public class NadamUpdater
implements GradientUpdater<Nadam> {
    public static final String M_STATE = "M";
    public static final String V_STATE = "V";
    private Nadam config;
    private INDArray m;
    private INDArray v;
    private char gradientReshapeOrder;

    public NadamUpdater(Nadam config) {
        this.config = config;
    }

    @Override
    public void setState(@NonNull Map<String, INDArray> stateMap, boolean initialize) {
        if (stateMap == null) {
            throw new NullPointerException("stateMap is marked non-null but is null");
        }
        if (!stateMap.containsKey(M_STATE) || !stateMap.containsKey(V_STATE) || stateMap.size() != 2) {
            throw new IllegalStateException("State map should contain only keys [M,V] but has keys " + stateMap.keySet());
        }
        this.m = stateMap.get(M_STATE);
        this.v = stateMap.get(V_STATE);
    }

    @Override
    public Map<String, INDArray> getState() {
        HashMap<String, INDArray> r = new HashMap<String, INDArray>();
        r.put(M_STATE, this.m);
        r.put(V_STATE, this.v);
        return r;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, long[] gradientShape, char gradientOrder, boolean initialize) {
        viewArray = viewArray.reshape(viewArray.length());
        if (initialize) {
            viewArray.assign(0);
        }
        long length = viewArray.length();
        this.m = viewArray.get(NDArrayIndex.interval(0L, length / 2L));
        this.v = viewArray.get(NDArrayIndex.interval(length / 2L, length));
        this.m = Shape.newShapeNoCopy(this.m, gradientShape, gradientOrder == 'f');
        this.v = Shape.newShapeNoCopy(this.v, gradientShape, gradientOrder == 'f');
        if (this.m == null || this.v == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view arrays");
        }
        this.gradientReshapeOrder = gradientOrder;
    }

    @Override
    public void applyUpdater(INDArray gradient, int iteration, int epoch) {
        if (this.m == null || this.v == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        double beta1 = this.config.getBeta1();
        double beta2 = this.config.getBeta2();
        double learningRate = this.config.getLearningRate(iteration, epoch);
        double epsilon = this.config.getEpsilon();
        Nd4j.exec(new org.nd4j.linalg.api.ops.impl.updaters.NadamUpdater(gradient.reshape(this.v.shape()), this.v, this.m, learningRate, beta1, beta2, epsilon, iteration));
    }

    @Override
    public Nadam getConfig() {
        return this.config;
    }

    public INDArray getM() {
        return this.m;
    }

    public INDArray getV() {
        return this.v;
    }

    public char getGradientReshapeOrder() {
        return this.gradientReshapeOrder;
    }

    public void setConfig(Nadam config) {
        this.config = config;
    }

    public void setM(INDArray m) {
        this.m = m;
    }

    public void setV(INDArray v) {
        this.v = v;
    }

    public void setGradientReshapeOrder(char gradientReshapeOrder) {
        this.gradientReshapeOrder = gradientReshapeOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NadamUpdater)) {
            return false;
        }
        NadamUpdater other = (NadamUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGradientReshapeOrder() != other.getGradientReshapeOrder()) {
            return false;
        }
        Nadam this$config = this.getConfig();
        Nadam other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        INDArray this$m = this.getM();
        INDArray other$m = other.getM();
        if (this$m == null ? other$m != null : !this$m.equals(other$m)) {
            return false;
        }
        INDArray this$v = this.getV();
        INDArray other$v = other.getV();
        return !(this$v == null ? other$v != null : !this$v.equals(other$v));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NadamUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGradientReshapeOrder();
        Nadam $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        INDArray $m = this.getM();
        result = result * 59 + ($m == null ? 43 : $m.hashCode());
        INDArray $v = this.getV();
        result = result * 59 + ($v == null ? 43 : $v.hashCode());
        return result;
    }

    public String toString() {
        return "NadamUpdater(config=" + this.getConfig() + ", m=" + this.getM() + ", v=" + this.getV() + ", gradientReshapeOrder=" + this.getGradientReshapeOrder() + ")";
    }
}

