/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.internal.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.VariableType;
import org.nd4j.autodiff.samediff.internal.AbstractDependencyTracker;
import org.nd4j.autodiff.samediff.internal.DependencyList;
import org.nd4j.autodiff.samediff.internal.InferenceSession;
import org.nd4j.autodiff.samediff.internal.SessionMemMgr;
import org.nd4j.autodiff.samediff.internal.memory.AbstractMemoryMgr;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseValidationMemoryMgr
extends AbstractMemoryMgr
implements SessionMemMgr {
    private static final Logger log = LoggerFactory.getLogger(CloseValidationMemoryMgr.class);
    private final SameDiff sd;
    private final SessionMemMgr underlying;
    private final Map<INDArray, Boolean> released = new IdentityHashMap<INDArray, Boolean>();

    public CloseValidationMemoryMgr(SameDiff sd, SessionMemMgr underlying) {
        this.sd = sd;
        this.underlying = underlying;
    }

    @Override
    public INDArray allocate(boolean detached, DataType dataType, long ... shape) {
        INDArray out = this.underlying.allocate(detached, dataType, shape);
        this.released.put(out, false);
        return out;
    }

    @Override
    public INDArray allocate(boolean detached, LongShapeDescriptor descriptor) {
        INDArray out = this.underlying.allocate(detached, descriptor);
        this.released.put(out, false);
        return out;
    }

    @Override
    public void release(INDArray array) {
        Preconditions.checkState((boolean)this.released.containsKey(array), (String)"Attempting to release an array that was not allocated by this memory manager: id=%s", (long)array.getId());
        if (this.released.get(array).booleanValue()) {
            InferenceSession is = this.sd.getSessions().get(Thread.currentThread().getId());
            AbstractDependencyTracker<INDArray, InferenceSession.Dep> arrayUseTracker = is.getArrayUseTracker();
            DependencyList<INDArray, InferenceSession.Dep> dl = arrayUseTracker.getDependencies(array);
            System.out.println(dl);
            if (dl.getDependencies() != null) {
                for (InferenceSession.Dep dep : dl.getDependencies()) {
                    System.out.println(dep + ": " + arrayUseTracker.isSatisfied(dep));
                }
            }
            if (dl.getOrDependencies() != null) {
                for (Pair pair : dl.getOrDependencies()) {
                    System.out.println(pair + " - (" + arrayUseTracker.isSatisfied((InferenceSession.Dep)pair.getFirst()) + "," + arrayUseTracker.isSatisfied((InferenceSession.Dep)pair.getSecond()));
                }
            }
        }
        Preconditions.checkState((this.released.get(array) == false ? 1 : 0) != 0, (String)"Attempting to release an array that was already deallocated by an earlier release call to this memory manager: id=%s", (long)array.getId());
        log.trace("Released array: id = {}", (Object)array.getId());
        this.released.put(array, true);
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    public void assertAllReleasedExcept(@NonNull Collection<INDArray> except) {
        if (except == null) {
            throw new NullPointerException("except is marked non-null but is null");
        }
        Set<INDArray> allVarPhConst = null;
        for (INDArray arr : except) {
            if (!this.released.containsKey(arr)) {
                if (allVarPhConst == null) {
                    allVarPhConst = this.identitySetAllConstPhVar();
                }
                if (allVarPhConst.contains(arr)) continue;
                throw new IllegalStateException("Array " + arr.getId() + " was not originally allocated by the memory manager");
            }
            boolean released = this.released.get(arr);
            if (!released) continue;
            throw new IllegalStateException("Specified output array (id=" + arr.getId() + ") should not have been deallocated but was");
        }
        Set exceptSet = Collections.newSetFromMap(new IdentityHashMap());
        exceptSet.addAll(except);
        int numNotClosed = 0;
        Set notReleased = Collections.newSetFromMap(new IdentityHashMap());
        InferenceSession is = this.sd.getSessions().get(Thread.currentThread().getId());
        AbstractDependencyTracker<INDArray, InferenceSession.Dep> arrayUseTracker = is.getArrayUseTracker();
        for (Map.Entry<INDArray, Boolean> e : this.released.entrySet()) {
            boolean b;
            INDArray a = e.getKey();
            if (exceptSet.contains(a) || (b = e.getValue().booleanValue())) continue;
            notReleased.add(a);
            ++numNotClosed;
            log.info("Not released: array id {}", (Object)a.getId());
            DependencyList<INDArray, InferenceSession.Dep> list = arrayUseTracker.getDependencies(a);
            List<InferenceSession.Dep> l = list.getDependencies();
            List<Pair<InferenceSession.Dep, InferenceSession.Dep>> l2 = list.getOrDependencies();
            if (l != null) {
                for (InferenceSession.Dep dep : l) {
                    if (arrayUseTracker.isSatisfied(dep)) continue;
                    log.info("  Not satisfied: {}", (Object)dep);
                }
            }
            if (l2 == null) continue;
            for (Pair pair : l2) {
                if (arrayUseTracker.isSatisfied((InferenceSession.Dep)pair.getFirst()) || arrayUseTracker.isSatisfied((InferenceSession.Dep)pair.getSecond())) continue;
                log.info("   Not satisfied: {}", (Object)pair);
            }
        }
        if (numNotClosed > 0) {
            System.out.println(this.sd.summary());
            throw new IllegalStateException(numNotClosed + " arrays were not released but should have been");
        }
    }

    protected Set<INDArray> identitySetAllConstPhVar() {
        Set<INDArray> set = Collections.newSetFromMap(new IdentityHashMap());
        for (SDVariable v : this.sd.variables()) {
            if (v.getVariableType() != VariableType.VARIABLE && v.getVariableType() != VariableType.CONSTANT && v.getVariableType() != VariableType.PLACEHOLDER) continue;
            set.add(v.getArr());
        }
        return set;
    }
}

