/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations.impl;

import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.BaseActivationFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.EluBp;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ELU;
import org.nd4j.linalg.factory.Nd4j;

public class ActivationELU
extends BaseActivationFunction {
    public static final double DEFAULT_ALPHA = 1.0;
    private double alpha;

    public ActivationELU() {
        this(1.0);
    }

    public ActivationELU(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public INDArray getActivation(INDArray in, boolean training) {
        return Nd4j.exec(new ELU(in, in, this.alpha))[0];
    }

    @Override
    public Pair<INDArray, INDArray> backprop(INDArray in, INDArray epsilon) {
        this.assertShape(in, epsilon);
        Nd4j.getExecutioner().execAndReturn(new EluBp(in, epsilon, in));
        return new Pair((Object)in, null);
    }

    public String toString() {
        return "elu(alpha=" + this.alpha + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationELU)) {
            return false;
        }
        ActivationELU other = (ActivationELU)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getAlpha(), other.getAlpha()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivationELU;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $alpha = Double.doubleToLongBits(this.getAlpha());
        result = result * 59 + (int)($alpha >>> 32 ^ $alpha);
        return result;
    }

    public double getAlpha() {
        return this.alpha;
    }
}

