/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseReduceOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.ReduceBoolOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;

public abstract class BaseReduceBoolOp
extends BaseReduceOp
implements ReduceBoolOp {
    public BaseReduceBoolOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public BaseReduceBoolOp(SameDiff sameDiff, SDVariable i_v, boolean keepDims) {
        super(sameDiff, i_v, keepDims);
    }

    public BaseReduceBoolOp(SameDiff sameDiff, SDVariable i_v, SDVariable dimensions, boolean keepDims) {
        super(sameDiff, i_v, dimensions, keepDims);
    }

    public BaseReduceBoolOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2) {
        super(sameDiff, i_v, i_v2);
    }

    protected BaseReduceBoolOp(SameDiff sameDiff, SDVariable input, int[] dimensions, boolean keepDims) {
        super(sameDiff, input, dimensions, keepDims);
    }

    public BaseReduceBoolOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions, boolean keepDims) {
        super(sameDiff, i_v, i_v2, dimensions, keepDims);
    }

    public BaseReduceBoolOp(SameDiff sameDiff, SDVariable i_v) {
        super(sameDiff, i_v);
    }

    protected BaseReduceBoolOp(SameDiff sameDiff, SDVariable input, int ... dimensions) {
        super(sameDiff, input, dimensions);
    }

    public BaseReduceBoolOp(INDArray x, INDArray z, boolean keepDims, int[] dimensions) {
        super(x, null, z, keepDims, dimensions);
    }

    public BaseReduceBoolOp(INDArray x, int ... dimensions) {
        this(x, null, false, dimensions);
    }

    public BaseReduceBoolOp(INDArray x, boolean keepDims, int ... dimensions) {
        super(x, keepDims, dimensions);
    }

    public BaseReduceBoolOp(INDArray x, INDArray z, int ... dimensions) {
        this(x, z, false, dimensions);
    }

    public BaseReduceBoolOp(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        super(x, y, z, dimensions);
    }

    public BaseReduceBoolOp(SameDiff sameDiff) {
        super(sameDiff);
    }

    public BaseReduceBoolOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, SDVariable dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    protected BaseReduceBoolOp() {
    }

    public BaseReduceBoolOp(INDArray x, INDArray y, INDArray z, boolean keepDims, int[] dimensions) {
        super(x, y, z, keepDims, dimensions);
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE_BOOL;
    }

    @Override
    public Op.Type getOpType() {
        return this.opType();
    }

    @Override
    public DataType resultType() {
        return DataType.BOOL;
    }

    @Override
    public DataType resultType(OpContext oc) {
        return DataType.BOOL;
    }

    @Override
    public boolean validateDataTypes(OpContext oc) {
        INDArray z;
        INDArray y;
        INDArray x = oc != null ? oc.getInputArray(0) : this.x();
        INDArray iNDArray = y = oc != null ? oc.getInputArray(1) : this.y();
        if (y != null) {
            Preconditions.checkArgument((x.dataType() == y.dataType() ? 1 : 0) != 0, (String)"Op.X type must be the same as Op.Y: x.dataType=%s, y.dataType=%s, op=%s", (Object)((Object)x.dataType()), (Object)((Object)y.dataType()), (Object)this.getClass().getName());
        }
        INDArray iNDArray2 = z = oc != null ? oc.getOutputArray(0) : this.z();
        if (z != null) {
            Preconditions.checkArgument((boolean)z.isB(), (String)"Op.Z type must be bool: got type %s for op %s", (Object)((Object)z.dataType()), this.getClass());
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        return this.calculateOutputShape(null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        INDArray x;
        INDArray iNDArray = x = oc != null ? oc.getInputArray(0) : this.x();
        if (x == null) {
            return Collections.emptyList();
        }
        long[] reducedShape = x.rank() == 0 ? x.shape() : Shape.getReducedShape(x.shape(), this.dimensions, this.isKeepDims());
        return Collections.singletonList(LongShapeDescriptor.fromShape(reducedShape, DataType.BOOL));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or input datatype for %s, got input %s", this.getClass(), dataTypes);
        Preconditions.checkState((dataTypes.size() == 1 || dataTypes.get(1).isIntType() ? 1 : 0) != 0, (String)"When executing reductionswith 2 inputs, second input (axis) must be an integer datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(DataType.BOOL);
    }

    public abstract boolean emptyValue();
}

