/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class AdjustContrast
extends DynamicCustomOp {
    public AdjustContrast() {
    }

    public AdjustContrast(@NonNull INDArray in, double factor, INDArray out) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        Preconditions.checkArgument((in.rank() >= 3 ? 1 : 0) != 0, (String)"AdjustContrast: op expects rank of input array to be >= 3, but got %s instead", (int)in.rank());
        this.inputArguments.add(in);
        this.outputArguments.add(out);
        this.addTArgument(factor);
    }

    public AdjustContrast(@NonNull INDArray in, double factor) {
        this(in, factor, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
    }

    public AdjustContrast(@NonNull SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable factor) {
        super(sameDiff, new SDVariable[]{in, factor});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (factor == null) {
            throw new NullPointerException("factor is marked non-null but is null");
        }
    }

    public AdjustContrast(@NonNull SameDiff sameDiff, @NonNull SDVariable in, double factor) {
        super(sameDiff, new SDVariable[]{in});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        this.addTArgument(factor);
    }

    @Override
    public String opName() {
        return "adjust_contrast_v2";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"AdjustContrast", "AdjustContrastv2"};
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

