/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;

public class Im2colBp
extends DynamicCustomOp {
    protected Conv2DConfig conv2DConfig;

    public Im2colBp(SameDiff sameDiff, SDVariable i2cInput, SDVariable gradAtOutput, Conv2DConfig conv2DConfig) {
        super(null, sameDiff, new SDVariable[]{i2cInput, gradAtOutput});
        this.conv2DConfig = conv2DConfig;
        this.addArgs();
    }

    public Im2colBp(SameDiff sd, SDVariable input, Conv2DConfig config) {
        super(null, sd, new SDVariable[]{input});
        this.conv2DConfig = config;
        this.addArgs();
    }

    public Im2colBp() {
    }

    protected void addArgs() {
        this.addIArgument(this.conv2DConfig.getKH());
        this.addIArgument(this.conv2DConfig.getKW());
        this.addIArgument(this.conv2DConfig.getSH());
        this.addIArgument(this.conv2DConfig.getSW());
        this.addIArgument(this.conv2DConfig.getPH());
        this.addIArgument(this.conv2DConfig.getPW());
        this.addIArgument(this.conv2DConfig.getDH());
        this.addIArgument(this.conv2DConfig.getDW());
        this.addIArgument(this.conv2DConfig.getPaddingMode().index);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.conv2DConfig.toProperties();
    }

    @Override
    public String opName() {
        return "im2col_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Differentiation not supported for this op: " + this.getClass().getSimpleName());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 input data types for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

