/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.WeightsFormat;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.PaddingMode;
import org.nd4j.linalg.util.ConvConfigUtil;

public class Conv2DConfig
extends BaseConvolutionConfig {
    public static final String NCHW = "NCHW";
    public static final String NHWC = "NHWC";
    public static final int VALID = 0;
    public static final int SAME = 1;
    public static final int CAUSAL = 2;
    private long kH;
    private long kW;
    private long sH;
    private long sW;
    private long pH;
    private long pW;
    private long dH;
    private long dW;
    private PaddingMode paddingMode = PaddingMode.VALID;
    private String dataFormat;
    private WeightsFormat weightsFormat;

    public Conv2DConfig(long kH, long kW, long sH, long sW, long pH, long pW, long dH, long dW, PaddingMode paddingMode, String dataFormat, WeightsFormat weightsFormat) {
        this.kH = kH;
        this.kW = kW;
        this.sH = sH;
        this.sW = sW;
        this.pH = pH;
        this.pW = pW;
        this.dH = dH;
        this.dW = dW;
        if (paddingMode != null) {
            this.paddingMode = paddingMode;
        }
        if (dataFormat != null) {
            this.dataFormat = dataFormat;
        }
        if (weightsFormat != null) {
            this.weightsFormat = weightsFormat;
        }
        this.validate();
    }

    public boolean isNHWC() {
        Preconditions.checkState((this.dataFormat.equalsIgnoreCase(NCHW) || this.dataFormat.equalsIgnoreCase(NHWC) ? 1 : 0) != 0, (String)"Data format must be one of %s or %s, got %s", (Object)NCHW, (Object)NHWC, (Object)this.dataFormat);
        return this.dataFormat.equalsIgnoreCase(NHWC);
    }

    public void isNHWC(boolean isNHWC) {
        this.dataFormat = isNHWC ? NHWC : NCHW;
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("kH", this.kH);
        ret.put("kW", this.kW);
        ret.put("sH", this.sH);
        ret.put("sW", this.sW);
        ret.put("pH", this.pH);
        ret.put("pW", this.pW);
        ret.put("dH", this.dH);
        ret.put("dW", this.dW);
        ret.put("paddingMode", (Object)this.paddingMode);
        ret.put("dataFormat", this.dataFormat);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validate2D(this.kH, this.kW, this.sH, this.sW, this.pH, this.pW, this.dH, this.dW);
        Preconditions.checkArgument((this.dataFormat != null ? 1 : 0) != 0, (String)"Data format can't be null");
        Preconditions.checkArgument((this.paddingMode != null ? 1 : 0) != 0, (String)"Padding mode can't be null");
    }

    private static long $default$kH() {
        return -1L;
    }

    private static long $default$kW() {
        return -1L;
    }

    private static long $default$sH() {
        return 1L;
    }

    private static long $default$sW() {
        return 1L;
    }

    private static long $default$pH() {
        return 0L;
    }

    private static long $default$pW() {
        return 0L;
    }

    private static long $default$dH() {
        return 1L;
    }

    private static long $default$dW() {
        return 1L;
    }

    private static String $default$dataFormat() {
        return NCHW;
    }

    private static WeightsFormat $default$weightsFormat() {
        return WeightsFormat.YXIO;
    }

    public static Conv2DConfigBuilder builder() {
        return new Conv2DConfigBuilder();
    }

    public long getKH() {
        return this.kH;
    }

    public long getKW() {
        return this.kW;
    }

    public long getSH() {
        return this.sH;
    }

    public long getSW() {
        return this.sW;
    }

    public long getPH() {
        return this.pH;
    }

    public long getPW() {
        return this.pW;
    }

    public long getDH() {
        return this.dH;
    }

    public long getDW() {
        return this.dW;
    }

    public PaddingMode getPaddingMode() {
        return this.paddingMode;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public WeightsFormat getWeightsFormat() {
        return this.weightsFormat;
    }

    public void setKH(long kH) {
        this.kH = kH;
    }

    public void setKW(long kW) {
        this.kW = kW;
    }

    public void setSH(long sH) {
        this.sH = sH;
    }

    public void setSW(long sW) {
        this.sW = sW;
    }

    public void setPH(long pH) {
        this.pH = pH;
    }

    public void setPW(long pW) {
        this.pW = pW;
    }

    public void setDH(long dH) {
        this.dH = dH;
    }

    public void setDW(long dW) {
        this.dW = dW;
    }

    public void setPaddingMode(PaddingMode paddingMode) {
        this.paddingMode = paddingMode;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setWeightsFormat(WeightsFormat weightsFormat) {
        this.weightsFormat = weightsFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conv2DConfig)) {
            return false;
        }
        Conv2DConfig other = (Conv2DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKH() != other.getKH()) {
            return false;
        }
        if (this.getKW() != other.getKW()) {
            return false;
        }
        if (this.getSH() != other.getSH()) {
            return false;
        }
        if (this.getSW() != other.getSW()) {
            return false;
        }
        if (this.getPH() != other.getPH()) {
            return false;
        }
        if (this.getPW() != other.getPW()) {
            return false;
        }
        if (this.getDH() != other.getDH()) {
            return false;
        }
        if (this.getDW() != other.getDW()) {
            return false;
        }
        PaddingMode this$paddingMode = this.getPaddingMode();
        PaddingMode other$paddingMode = other.getPaddingMode();
        if (this$paddingMode == null ? other$paddingMode != null : !((Object)((Object)this$paddingMode)).equals((Object)other$paddingMode)) {
            return false;
        }
        String this$dataFormat = this.getDataFormat();
        String other$dataFormat = other.getDataFormat();
        if (this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat)) {
            return false;
        }
        WeightsFormat this$weightsFormat = this.getWeightsFormat();
        WeightsFormat other$weightsFormat = other.getWeightsFormat();
        return !(this$weightsFormat == null ? other$weightsFormat != null : !((Object)((Object)this$weightsFormat)).equals((Object)other$weightsFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Conv2DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $kH = this.getKH();
        result = result * 59 + (int)($kH >>> 32 ^ $kH);
        long $kW = this.getKW();
        result = result * 59 + (int)($kW >>> 32 ^ $kW);
        long $sH = this.getSH();
        result = result * 59 + (int)($sH >>> 32 ^ $sH);
        long $sW = this.getSW();
        result = result * 59 + (int)($sW >>> 32 ^ $sW);
        long $pH = this.getPH();
        result = result * 59 + (int)($pH >>> 32 ^ $pH);
        long $pW = this.getPW();
        result = result * 59 + (int)($pW >>> 32 ^ $pW);
        long $dH = this.getDH();
        result = result * 59 + (int)($dH >>> 32 ^ $dH);
        long $dW = this.getDW();
        result = result * 59 + (int)($dW >>> 32 ^ $dW);
        PaddingMode $paddingMode = this.getPaddingMode();
        result = result * 59 + ($paddingMode == null ? 43 : ((Object)((Object)$paddingMode)).hashCode());
        String $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        WeightsFormat $weightsFormat = this.getWeightsFormat();
        result = result * 59 + ($weightsFormat == null ? 43 : ((Object)((Object)$weightsFormat)).hashCode());
        return result;
    }

    public String toString() {
        return "Conv2DConfig(kH=" + this.getKH() + ", kW=" + this.getKW() + ", sH=" + this.getSH() + ", sW=" + this.getSW() + ", pH=" + this.getPH() + ", pW=" + this.getPW() + ", dH=" + this.getDH() + ", dW=" + this.getDW() + ", paddingMode=" + (Object)((Object)this.getPaddingMode()) + ", dataFormat=" + this.getDataFormat() + ", weightsFormat=" + (Object)((Object)this.getWeightsFormat()) + ")";
    }

    public Conv2DConfig() {
        this.kH = Conv2DConfig.$default$kH();
        this.kW = Conv2DConfig.$default$kW();
        this.sH = Conv2DConfig.$default$sH();
        this.sW = Conv2DConfig.$default$sW();
        this.pH = Conv2DConfig.$default$pH();
        this.pW = Conv2DConfig.$default$pW();
        this.dH = Conv2DConfig.$default$dH();
        this.dW = Conv2DConfig.$default$dW();
        this.dataFormat = Conv2DConfig.$default$dataFormat();
        this.weightsFormat = Conv2DConfig.$default$weightsFormat();
    }

    public static class Conv2DConfigBuilder {
        private boolean kH$set;
        private long kH$value;
        private boolean kW$set;
        private long kW$value;
        private boolean sH$set;
        private long sH$value;
        private boolean sW$set;
        private long sW$value;
        private boolean pH$set;
        private long pH$value;
        private boolean pW$set;
        private long pW$value;
        private boolean dH$set;
        private long dH$value;
        private boolean dW$set;
        private long dW$value;
        private PaddingMode paddingMode;
        private boolean dataFormat$set;
        private String dataFormat$value;
        private boolean weightsFormat$set;
        private WeightsFormat weightsFormat$value;

        Conv2DConfigBuilder() {
        }

        public Conv2DConfigBuilder kH(long kH) {
            this.kH$value = kH;
            this.kH$set = true;
            return this;
        }

        public Conv2DConfigBuilder kW(long kW) {
            this.kW$value = kW;
            this.kW$set = true;
            return this;
        }

        public Conv2DConfigBuilder sH(long sH) {
            this.sH$value = sH;
            this.sH$set = true;
            return this;
        }

        public Conv2DConfigBuilder sW(long sW) {
            this.sW$value = sW;
            this.sW$set = true;
            return this;
        }

        public Conv2DConfigBuilder pH(long pH) {
            this.pH$value = pH;
            this.pH$set = true;
            return this;
        }

        public Conv2DConfigBuilder pW(long pW) {
            this.pW$value = pW;
            this.pW$set = true;
            return this;
        }

        public Conv2DConfigBuilder dH(long dH) {
            this.dH$value = dH;
            this.dH$set = true;
            return this;
        }

        public Conv2DConfigBuilder dW(long dW) {
            this.dW$value = dW;
            this.dW$set = true;
            return this;
        }

        public Conv2DConfigBuilder paddingMode(PaddingMode paddingMode) {
            this.paddingMode = paddingMode;
            return this;
        }

        public Conv2DConfigBuilder dataFormat(String dataFormat) {
            this.dataFormat$value = dataFormat;
            this.dataFormat$set = true;
            return this;
        }

        public Conv2DConfigBuilder weightsFormat(WeightsFormat weightsFormat) {
            this.weightsFormat$value = weightsFormat;
            this.weightsFormat$set = true;
            return this;
        }

        public Conv2DConfig build() {
            long kH$value = this.kH$value;
            if (!this.kH$set) {
                kH$value = Conv2DConfig.$default$kH();
            }
            long kW$value = this.kW$value;
            if (!this.kW$set) {
                kW$value = Conv2DConfig.$default$kW();
            }
            long sH$value = this.sH$value;
            if (!this.sH$set) {
                sH$value = Conv2DConfig.$default$sH();
            }
            long sW$value = this.sW$value;
            if (!this.sW$set) {
                sW$value = Conv2DConfig.$default$sW();
            }
            long pH$value = this.pH$value;
            if (!this.pH$set) {
                pH$value = Conv2DConfig.$default$pH();
            }
            long pW$value = this.pW$value;
            if (!this.pW$set) {
                pW$value = Conv2DConfig.$default$pW();
            }
            long dH$value = this.dH$value;
            if (!this.dH$set) {
                dH$value = Conv2DConfig.$default$dH();
            }
            long dW$value = this.dW$value;
            if (!this.dW$set) {
                dW$value = Conv2DConfig.$default$dW();
            }
            String dataFormat$value = this.dataFormat$value;
            if (!this.dataFormat$set) {
                dataFormat$value = Conv2DConfig.$default$dataFormat();
            }
            WeightsFormat weightsFormat$value = this.weightsFormat$value;
            if (!this.weightsFormat$set) {
                weightsFormat$value = Conv2DConfig.$default$weightsFormat();
            }
            return new Conv2DConfig(kH$value, kW$value, sH$value, sW$value, pH$value, pW$value, dH$value, dW$value, this.paddingMode, dataFormat$value, weightsFormat$value);
        }

        public String toString() {
            return "Conv2DConfig.Conv2DConfigBuilder(kH$value=" + this.kH$value + ", kW$value=" + this.kW$value + ", sH$value=" + this.sH$value + ", sW$value=" + this.sW$value + ", pH$value=" + this.pH$value + ", pW$value=" + this.pW$value + ", dH$value=" + this.dH$value + ", dW$value=" + this.dW$value + ", paddingMode=" + (Object)((Object)this.paddingMode) + ", dataFormat$value=" + this.dataFormat$value + ", weightsFormat$value=" + (Object)((Object)this.weightsFormat$value) + ")";
        }
    }
}

