/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.shape.bp.StridedSliceBp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class StridedSlice
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(StridedSlice.class);
    private long[] begin;
    private long[] end;
    private long[] strides;
    private int beginMask;
    private int endMask;
    private int ellipsisMask;
    private int newAxisMask;
    private int shrinkAxisMask;

    public StridedSlice() {
    }

    public StridedSlice(SameDiff sameDiff, SDVariable in, int[] begin, int[] end, int[] strides) {
        this(sameDiff, in, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public StridedSlice(SameDiff sameDiff, SDVariable in, long[] begin, long[] end, long[] strides) {
        this(sameDiff, in, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public StridedSlice(SameDiff sameDiff, SDVariable in, @NonNull long[] begin, @NonNull long[] end, @NonNull long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        super(null, sameDiff, new SDVariable[]{in});
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked non-null but is null");
        }
        this.begin = begin;
        this.end = end;
        this.strides = strides;
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    public StridedSlice(SameDiff sameDiff, SDVariable in, @NonNull int[] begin, @NonNull int[] end, @NonNull int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        super(null, sameDiff, new SDVariable[]{in});
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked non-null but is null");
        }
        this.begin = ArrayUtil.toLongArray((int[])begin);
        this.end = ArrayUtil.toLongArray((int[])end);
        this.strides = ArrayUtil.toLongArray((int[])strides);
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    public StridedSlice(INDArray in, int[] begin, int[] end, int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        this(in, ArrayUtil.toLongArray((int[])begin), ArrayUtil.toLongArray((int[])end), ArrayUtil.toLongArray((int[])strides), beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
    }

    public StridedSlice(INDArray in, long[] begin, long[] end, long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        this.addInputArgument(in);
        this.begin = begin;
        this.end = end;
        this.strides = strides;
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    public StridedSlice(SameDiff sd, SDVariable in, SDVariable begin, SDVariable end, SDVariable strides) {
        this(sd, in, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public StridedSlice(SameDiff sd, SDVariable in, SDVariable begin, SDVariable end, SDVariable strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        super(sd, new SDVariable[]{in, begin, end, strides});
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    public StridedSlice(INDArray in, INDArray begin, INDArray end, INDArray strides) {
        super(new INDArray[]{in, begin, end, strides}, null);
        this.addArguments();
    }

    public StridedSlice(INDArray in, INDArray begin, INDArray end, INDArray strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        super(new INDArray[]{in, begin, end, strides}, null);
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    private void addArguments() {
        this.addIArgument(this.beginMask);
        this.addIArgument(this.ellipsisMask);
        this.addIArgument(this.endMask);
        this.addIArgument(this.newAxisMask);
        this.addIArgument(this.shrinkAxisMask);
        if (this.begin != null) {
            this.addIArgument(this.begin);
        }
        if (this.end != null) {
            this.addIArgument(this.end);
        }
        if (this.strides != null) {
            this.addIArgument(this.strides);
        }
    }

    @Override
    public String opName() {
        return "strided_slice";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "StridedSlice";
    }

    @Override
    public void assertValidForExecution() {
        if (this.numInputArguments() != 1 && this.numInputArguments() != 3 && this.numInputArguments() != 4) {
            throw new ND4JIllegalStateException("Num input arguments must be 1 3 or 4.");
        }
        if (this.numIArguments() < 5) {
            throw new ND4JIllegalStateException("Number of integer arguments must >= 5");
        }
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String inputBegin = nodeDef.getInput(1);
        String inputEnd = nodeDef.getInput(2);
        String inputStrides = nodeDef.getInput(3);
        AttrValue bm = nodeDef.getAttrOrThrow("begin_mask");
        AttrValue xm = nodeDef.getAttrOrThrow("ellipsis_mask");
        AttrValue em = nodeDef.getAttrOrThrow("end_mask");
        AttrValue nm = nodeDef.getAttrOrThrow("new_axis_mask");
        AttrValue sm = nodeDef.getAttrOrThrow("shrink_axis_mask");
        this.beginMask = (int)bm.getI();
        this.ellipsisMask = (int)xm.getI();
        this.endMask = (int)em.getI();
        this.newAxisMask = (int)nm.getI();
        this.shrinkAxisMask = (int)sm.getI();
        this.addIArgument(this.beginMask);
        this.addIArgument(this.ellipsisMask);
        this.addIArgument(this.endMask);
        this.addIArgument(this.newAxisMask);
        this.addIArgument(this.shrinkAxisMask);
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping beginMapping = PropertyMapping.builder().tfInputPosition(1).propertyNames(new String[]{"begin"}).build();
        PropertyMapping end = PropertyMapping.builder().tfInputPosition(2).propertyNames(new String[]{"end"}).build();
        PropertyMapping strides = PropertyMapping.builder().tfInputPosition(3).propertyNames(new String[]{"strides"}).build();
        PropertyMapping beginMask = PropertyMapping.builder().tfAttrName("begin_mask").propertyNames(new String[]{"beginMask"}).build();
        PropertyMapping ellipsisMask = PropertyMapping.builder().tfAttrName("ellipsis_mask").propertyNames(new String[]{"ellipsisMask"}).build();
        PropertyMapping endMask = PropertyMapping.builder().tfAttrName("end_mask").propertyNames(new String[]{"endMask"}).build();
        PropertyMapping newAxisMask = PropertyMapping.builder().tfAttrName("new_axis_mask").propertyNames(new String[]{"newAxisMask"}).build();
        PropertyMapping shrinkAxisMask = PropertyMapping.builder().tfAttrName("shrink_axis_mask").propertyNames(new String[]{"shrinkAxisMask"}).build();
        map.put("begin", beginMapping);
        map.put("end", end);
        map.put("strides", strides);
        map.put("beginMask", beginMask);
        map.put("ellipsisMask", ellipsisMask);
        map.put("endMask", endMask);
        map.put("newAxisMask", newAxisMask);
        map.put("shrinkAxisMask", shrinkAxisMask);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void configureFromArguments() {
        if (!this.iArguments.isEmpty()) {
            this.beginMask = ((Long)this.iArguments.get(0)).intValue();
            this.ellipsisMask = ((Long)this.iArguments.get(1)).intValue();
            this.endMask = ((Long)this.iArguments.get(2)).intValue();
            this.newAxisMask = ((Long)this.iArguments.get(3)).intValue();
            this.shrinkAxisMask = ((Long)this.iArguments.get(4)).intValue();
            int rankOfBeginEndStrides = (this.iArguments.size() - 5) / 3;
            this.begin = new long[rankOfBeginEndStrides];
            this.end = new long[rankOfBeginEndStrides];
            this.strides = new long[rankOfBeginEndStrides];
            for (int i = 0; i < rankOfBeginEndStrides; ++i) {
                this.begin[i] = (Long)this.iArguments.get(i + 5);
                this.end[i] = (Long)this.iArguments.get(i + rankOfBeginEndStrides + 5);
                this.strides[i] = (Long)this.iArguments.get(i + rankOfBeginEndStrides * 2 + 5);
            }
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        Long value;
        if (properties.containsKey("begin_mask")) {
            value = (Long)properties.get("begin_mask");
            this.beginMask = value.intValue();
        }
        if (properties.containsKey("ellipsis_mask")) {
            value = (Long)properties.get("ellipsis_mask");
            this.ellipsisMask = value.intValue();
        }
        if (properties.containsKey("end_mask")) {
            value = (Long)properties.get("end_mask");
            this.endMask = value.intValue();
        }
        if (properties.containsKey("shrink_axis_mask")) {
            value = (Long)properties.get("shrink_axis_mask");
            this.shrinkAxisMask = value.intValue();
        }
        if (properties.containsKey("new_axis_mask")) {
            value = (Long)properties.get("new_axis_mask");
            this.newAxisMask = value.intValue();
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        if (this.args().length == 1) {
            return new StridedSliceBp(this.sameDiff, this.arg(), i_v.get(0), this.begin, this.end, this.strides, this.beginMask, this.endMask, this.ellipsisMask, this.newAxisMask, this.shrinkAxisMask).outputs();
        }
        return new StridedSliceBp(this.sameDiff, this.arg(), i_v.get(0), this.arg(1), this.arg(2), this.arg(3), this.beginMask, this.endMask, this.ellipsisMask, this.newAxisMask, this.shrinkAxisMask).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 4) ? 1 : 0) != 0, (String)"Expected 1 or 4 input datatypes for %s, got %s", this.getClass(), dataTypes);
        if (!this.dArguments.isEmpty()) {
            return Arrays.asList((DataType)((Object)this.dArguments.get(0)));
        }
        return Collections.singletonList(dataTypes.get(0));
    }
}

