/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape.tensorops;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.impl.shape.tensorops.BaseTensorOp;
import org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorArray;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class TensorArrayRead
extends BaseTensorOp {
    protected DataType importDataType;

    public TensorArrayRead(String name, SameDiff sameDiff, SDVariable[] args) {
        super(name, sameDiff, args);
    }

    public TensorArrayRead(SameDiff sameDiff, SDVariable[] args) {
        super(null, sameDiff, args);
    }

    public TensorArrayRead() {
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"TensorArrayRead", "TensorArrayReadV2", "TensorArrayReadV3"};
    }

    @Override
    public String opName() {
        return "read_list";
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        this.importDataType = TFGraphMapper.convertType(attributesForNode.get("dtype").getType());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataType) {
        DataType dt = null;
        if (this.importDataType != null) {
            dt = this.importDataType;
        } else {
            for (int i = 0; i < this.args().length; ++i) {
                SDVariable tArr = this.arg(i);
                DifferentialFunction op = this.sameDiff.getVariableOutputOp(tArr.name());
                if (!(op instanceof TensorArray)) continue;
                TensorArray t3 = (TensorArray)op;
                dt = t3.getTensorArrayDataType();
                break;
            }
        }
        return Collections.singletonList(dt);
    }
}

