/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.reduce.bp.PowBp;

public class Pow
extends DynamicCustomOp {
    public Pow(SameDiff sameDiff, SDVariable x, SDVariable y) {
        super(sameDiff, new SDVariable[]{x, y});
    }

    public Pow() {
    }

    public Pow(@NonNull INDArray x, @NonNull INDArray y) {
        super(new INDArray[]{x, y}, null);
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
    }

    @Override
    public String opName() {
        return "Pow";
    }

    @Override
    public String tensorflowName() {
        return "Pow";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return new PowBp(this.sameDiff, this.arg(0), this.arg(1), f1.get(0)).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

