/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;

public class Max
extends BaseAccumulation {
    public Max(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Max(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public Max() {
    }

    public Max(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Max(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Max(INDArray x) {
        super(x);
    }

    public Max(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public int opNum() {
        return 3;
    }

    @Override
    public String opName() {
        return "max";
    }

    @Override
    public double zeroDouble() {
        return -1.7976931348623157E308;
    }

    @Override
    public float zeroHalf() {
        return -65503.0f;
    }

    @Override
    public float zeroFloat() {
        return -3.4028235E38f;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        SDVariable out = this.outputVariables()[0];
        int origRank = Shape.rankFromShape(this.arg().getShape());
        SDVariable expandedOut = this.sameDiff.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, out);
        expandedOut = this.sameDiff.onesLike(this.arg()).mul(expandedOut);
        SDVariable expandedGrad = this.sameDiff.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, i_v1.get(0));
        SDVariable eq = this.sameDiff.eq(this.arg(), expandedOut);
        SDVariable ret = eq.mul(expandedGrad);
        return Arrays.asList(ret);
    }

    @Override
    public String onnxName() {
        return "ReduceMax";
    }

    @Override
    public String tensorflowName() {
        return "Max";
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE;
    }
}

