/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.arithmetic;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;

public class Axpy
extends BaseTransformOp {
    private double p;

    public Axpy(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, double p) {
        super(sameDiff, i_v1, i_v2);
        this.p = p;
    }

    public Axpy(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace, double p) {
        super(sameDiff, i_v1, i_v2, inPlace);
        this.p = p;
    }

    public Axpy(SameDiff sameDiff, double p) {
        super(sameDiff);
        this.p = p;
    }

    public Axpy(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, Object[] extraArgs, double p) {
        super(sameDiff, i_v1, i_v2, extraArgs);
        this.p = p;
    }

    public Axpy(SameDiff sameDiff, SDVariable i_v, boolean inPlace, double p) {
        super(sameDiff, i_v, inPlace);
        this.p = p;
    }

    public Axpy(SameDiff sameDiff, SDVariable i_v, int[] shape, boolean inPlace, Object[] extraArgs, double p) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
        this.p = p;
    }

    public Axpy(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs, double p) {
        super(sameDiff, i_v, extraArgs);
        this.p = p;
    }

    public Axpy() {
    }

    public Axpy(INDArray x, INDArray z, double p) {
        this.p = p;
        this.init(x, z, z, x.length());
    }

    public Axpy(INDArray x, INDArray z, double p, long n) {
        this.p = p;
        this.init(x, z, z, n);
    }

    public Axpy(INDArray x, INDArray y, INDArray z, double p, long n) {
        this.p = p;
        this.init(x, y, z, x.length());
    }

    @Override
    public int opNum() {
        return 17;
    }

    @Override
    public String opName() {
        return "axpy";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("p", this.p);
        return ret;
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        if (x.lengthLong() < n || y.lengthLong() < n || z.lengthLong() < n) {
            throw new IllegalStateException("Mis matched lengths: X: [" + x.lengthLong() + "], Y: [" + y.lengthLong() + "], Z: [" + z.lengthLong() + "], N: [" + n + "]");
        }
        this.extraArgs = new Object[]{this.p, (double)n};
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return null;
    }
}

