/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff;

import org.nd4j.linalg.exception.ND4JIllegalArgumentException;

public class SDIndex {
    private IndexType indexType = IndexType.ALL;
    private long pointIndex;
    private Long intervalBegin = null;
    private Long intervalEnd = null;
    private Long intervalStrides = 1L;

    public static SDIndex all() {
        return new SDIndex();
    }

    public static SDIndex point(long i) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.POINT;
        sdIndex.pointIndex = i;
        return sdIndex;
    }

    public static SDIndex interval(Long begin, Long end) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL;
        sdIndex.intervalBegin = begin;
        sdIndex.intervalEnd = end;
        return sdIndex;
    }

    public static SDIndex interval(Integer begin, Integer end) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL;
        if (begin != null) {
            sdIndex.intervalBegin = begin.longValue();
        }
        if (end != null) {
            sdIndex.intervalEnd = end.longValue();
        }
        return sdIndex;
    }

    public static SDIndex interval(Long begin, Long strides, Long end) {
        if (strides == 0L) {
            throw new ND4JIllegalArgumentException("Invalid index : strides can not be 0.");
        }
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL;
        sdIndex.intervalBegin = begin;
        sdIndex.intervalEnd = end;
        sdIndex.intervalStrides = strides;
        return sdIndex;
    }

    public static SDIndex interval(Integer begin, Integer strides, Integer end) {
        if (strides == 0) {
            throw new ND4JIllegalArgumentException("Invalid index : strides can not be 0.");
        }
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL;
        if (begin != null) {
            sdIndex.intervalBegin = begin.longValue();
        }
        if (end != null) {
            sdIndex.intervalEnd = end.longValue();
        }
        if (strides != null) {
            sdIndex.intervalStrides = strides.longValue();
        }
        return sdIndex;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public long getPointIndex() {
        return this.pointIndex;
    }

    public Long getIntervalBegin() {
        return this.intervalBegin;
    }

    public Long getIntervalEnd() {
        return this.intervalEnd;
    }

    public Long getIntervalStrides() {
        return this.intervalStrides;
    }

    public static enum IndexType {
        ALL,
        POINT,
        INTERVAL;

    }
}

