/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.temp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ExternalErrorsFunction
extends DifferentialFunction {
    private static final List<long[]> OUT_SHAPE = Collections.singletonList(new long[]{1L});
    private Map<String, INDArray> gradients;
    private Map<String, SDVariable> gradVariables;
    private SDVariable out;

    public ExternalErrorsFunction(SameDiff sd, List<SDVariable> inputs, Map<String, INDArray> gradients) {
        super(sd, inputs.toArray(new SDVariable[inputs.size()]));
        if (gradients == null) {
            gradients = new HashMap<String, INDArray>();
        }
        this.gradients = gradients;
    }

    public ExternalErrorsFunction() {
    }

    public void updateVariable(String str, INDArray gradient) {
        this.gradients.put(str, gradient);
        if (this.gradVariables != null) {
            this.gradVariables.get(str).setArray(gradient);
        }
    }

    @Override
    public SDVariable[] outputVariables(String baseName) {
        if (this.out == null) {
            this.out = this.sameDiff.zero("dummyOutput", new long[]{1L});
        }
        return new SDVariable[]{this.out};
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> out = new ArrayList<SDVariable>();
        if (this.gradVariables == null) {
            this.gradVariables = new HashMap<String, SDVariable>();
            for (SDVariable arg : this.args()) {
                INDArray gradArr = this.gradients.get(arg.getVarName());
                SDVariable grad = gradArr != null ? this.sameDiff.var(arg.getVarName() + "-externalGrad", gradArr) : this.sameDiff.var(arg.getVarName() + "-externalGrad", arg.getShape());
                this.gradVariables.put(arg.getVarName(), grad);
                out.add(grad);
            }
        }
        return out;
    }

    public void updateBeforeExecution() {
        Preconditions.checkState((this.gradVariables != null ? 1 : 0) != 0, (String)"Variables list is null - doDiff has not been called?");
        for (Map.Entry<String, SDVariable> e : this.gradVariables.entrySet()) {
            INDArray extGradArray = this.gradients.get(e.getKey());
            if (extGradArray == null) {
                throw new IllegalStateException("Cannot execute SameDiff instance with external errors: external gradient for variable " + e.getKey() + " has not been defined");
            }
            this.gradVariables.get(e.getKey()).setArray(extGradArray);
        }
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("Not supported: " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("Not supported: " + this.opName());
    }

    @Override
    public String opName() {
        return "ExternalErrorsFn";
    }

    @Override
    public String toString() {
        return "ExternalErrorsFunction(" + (this.gradVariables != null ? this.gradVariables.keySet() : "") + ")";
    }

    @Override
    public List<long[]> calculateOutputShape() {
        return OUT_SHAPE;
    }
}

