/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.flow;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.flow.FrameState;
import org.nd4j.autodiff.samediff.flow.NodeState;

public class FlowPath {
    protected Map<String, NodeState> states = new HashMap<String, NodeState>();
    protected Map<String, FrameState> frames = new HashMap<String, FrameState>();

    public void ensureNodeStateExists(@NonNull String nodeName) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked @NonNull but is null");
        }
        if (!this.states.containsKey(nodeName)) {
            this.states.put(nodeName, new NodeState(nodeName));
        }
    }

    public boolean isActive(@NonNull String nodeName) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked @NonNull but is null");
        }
        this.ensureNodeStateExists(nodeName);
        return this.states.get(nodeName).isActive();
    }

    public void markActive(@NonNull String nodeName, boolean active) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked @NonNull but is null");
        }
        this.ensureNodeStateExists(nodeName);
        this.states.get(nodeName).setActive(active);
    }

    public void setActiveBranch(@NonNull String nodeName, int branchIdx) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked @NonNull but is null");
        }
        this.states.get(nodeName).setActiveBranch(branchIdx);
    }

    public int getActiveBranch(@NonNull String nodeName) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked @NonNull but is null");
        }
        return this.states.get(nodeName).getActiveBranch();
    }

    public boolean wasExecuted(@NonNull String nodeName) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked @NonNull but is null");
        }
        this.ensureNodeStateExists(nodeName);
        return this.states.get(nodeName).isExecuted();
    }

    public void markExecuted(@NonNull String nodeName, boolean executed) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked @NonNull but is null");
        }
        this.states.get(nodeName).setExecuted(executed);
    }

    public void incrementNumberOfCycles(@NonNull String frameName) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        this.frames.get(frameName).incrementNumberOfCycles();
    }

    public long getNumberOfCycles(@NonNull String frameName) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        return this.states.get(frameName).getNumberOfCycles();
    }

    public void registerFrame(@NonNull String frame_name) {
        if (frame_name == null) {
            throw new NullPointerException("frame_name is marked @NonNull but is null");
        }
        if (!this.frames.containsKey(frame_name)) {
            this.frames.put(frame_name, new FrameState(frame_name));
        }
    }

    public void forgetFrame(@NonNull String frame_name) {
        if (frame_name == null) {
            throw new NullPointerException("frame_name is marked @NonNull but is null");
        }
        this.frames.remove(frame_name);
    }

    public boolean isRegisteredFrame(@NonNull String frame_name) {
        if (frame_name == null) {
            throw new NullPointerException("frame_name is marked @NonNull but is null");
        }
        return this.frames.containsKey(frame_name);
    }

    public boolean isRewindPlanned(@NonNull String frameName) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        return this.frames.get(frameName).isRewindPlanned();
    }

    public boolean isRewindPossible(@NonNull String frameName) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        return this.isRewindPlanned(frameName) && this.getRewindPosition(frameName) >= 0;
    }

    public void planRewind(@NonNull String frameName, boolean reallyPlan) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        this.frames.get(frameName).setRewindPlanned(reallyPlan);
    }

    public int getRewindPosition(@NonNull String frameName) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        return this.frames.get(frameName).getRewindPosition();
    }

    public void setRewindPosition(@NonNull String frameName, int position) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        this.frames.get(frameName).setRewindPosition(position);
    }

    public void setRewindPositionOnce(@NonNull String frameName, int position) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        if (this.getRewindPosition(frameName) >= 0) {
            return;
        }
        this.frames.get(frameName).setRewindPosition(position);
    }

    public void activateFrame(@NonNull String frameName, boolean reallyActivate) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        this.frames.get(frameName).setActive(reallyActivate);
    }

    public boolean isFrameActive(@NonNull String frameName) {
        if (frameName == null) {
            throw new NullPointerException("frameName is marked @NonNull but is null");
        }
        return this.frames.get(frameName).isActive();
    }
}

