/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import java.util.Arrays;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.linalg.api.buffer.DataType;

public class SDValidation {
    private SDValidation() {
    }

    protected static void validateNumerical(String opName, SDVariable v) {
        if (v == null) {
            return;
        }
        if (v.dataType() == DataType.BOOL || v.dataType() == DataType.UTF8) {
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to variable \"" + v.getVarName() + "\" with non-numerical data type " + v.dataType());
        }
    }

    protected static void validateNumerical(String opName, String inputName, SDVariable v) {
        if (v == null) {
            return;
        }
        if (v.dataType() == DataType.BOOL || v.dataType() == DataType.UTF8) {
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an numerical type type; got variable \"" + v.getVarName() + "\" with non-integer data type " + v.dataType());
        }
    }

    protected static void validateNumerical(String opName, SDVariable v1, SDVariable v2) {
        if (v1.dataType() == DataType.BOOL || v1.dataType() == DataType.UTF8 || v2.dataType() == DataType.BOOL || v2.dataType() == DataType.UTF8) {
            throw new IllegalStateException("Cannot perform operation \"" + opName + "\" on variables  \"" + v1.getVarName() + "\" and \"" + v2.getVarName() + "\" if one or both variables are non-numerical: " + v1.dataType() + " and " + v2.dataType());
        }
    }

    protected static void validateInteger(String opName, SDVariable v) {
        if (v == null) {
            return;
        }
        if (!v.dataType().isIntType()) {
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to variable \"" + v.getVarName() + "\" with non-integer data type " + v.dataType());
        }
    }

    protected static void validateInteger(String opName, String inputName, SDVariable v) {
        if (v == null) {
            return;
        }
        if (!v.dataType().isIntType()) {
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an integer type; got variable \"" + v.getVarName() + "\" with non-integer data type " + v.dataType());
        }
    }

    protected static void validateFloatingPoint(String opName, SDVariable v) {
        if (v == null) {
            return;
        }
        if (!v.dataType().isFPType()) {
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to variable \"" + v.getVarName() + "\" with non-floating point data type " + v.dataType());
        }
    }

    protected static void validateFloatingPoint(String opName, String inputName, SDVariable v) {
        if (v == null) {
            return;
        }
        if (!v.dataType().isFPType()) {
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an floating point type; got variable \"" + v.getVarName() + "\" with non-floating point data type " + v.dataType());
        }
    }

    protected static void validateBool(String opName, SDVariable v) {
        if (v == null) {
            return;
        }
        if (v.dataType() != DataType.BOOL) {
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to variable \"" + v.getVarName() + "\" with non-boolean point data type " + v.dataType());
        }
    }

    protected static void validateBool(String opName, String inputName, SDVariable v) {
        if (v == null) {
            return;
        }
        if (v.dataType() != DataType.BOOL) {
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an boolean variable; got variable \"" + v.getVarName() + "\" with non-boolean data type " + v.dataType());
        }
    }

    protected static void validateBool(String opName, SDVariable v1, SDVariable v2) {
        if (v1.dataType() != DataType.BOOL || v2.dataType() != DataType.BOOL) {
            throw new IllegalStateException("Cannot perform operation \"" + opName + "\" on variables  \"" + v1.getVarName() + "\" and \"" + v2.getVarName() + "\" if one or both variables are non-boolean: " + v1.dataType() + " and " + v2.dataType());
        }
    }

    protected static void validateSameType(String opName, boolean numericalOnly, SDVariable ... vars) {
        if (vars.length == 0) {
            return;
        }
        if (vars.length == 1) {
            if (numericalOnly) {
                SDValidation.validateNumerical(opName, vars[0]);
            }
        } else {
            DataType first = vars[0].dataType();
            if (numericalOnly) {
                SDValidation.validateNumerical(opName, vars[0]);
            }
            for (int i = 1; i < vars.length; ++i) {
                if (first == vars[i].dataType()) continue;
                Object[] names = new String[vars.length];
                Object[] dtypes = new DataType[vars.length];
                for (int j = 0; j < vars.length; ++j) {
                    names[j] = vars[j].getVarName();
                    dtypes[j] = vars[j].dataType();
                }
                throw new IllegalStateException("Cannot perform operation \"" + opName + "\" to variables with different datatypes: Variable names " + Arrays.toString(names) + ", datatypes " + Arrays.toString(dtypes));
            }
        }
    }
}

