/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIndexAccumulation
extends BaseOp
implements IndexAccumulation {
    private static final Logger log = LoggerFactory.getLogger(BaseIndexAccumulation.class);
    protected boolean keepDims = false;

    public BaseIndexAccumulation(SameDiff sameDiff, SDVariable i_v, boolean keepDims, int[] dimensions) {
        super(sameDiff, new Object[]{dimensions});
        if (i_v != null) {
            this.dimensions = dimensions;
            this.f().validateDifferentialFunctionsameDiff(i_v);
            sameDiff.addArgsFor(new SDVariable[]{i_v}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.xVertexId = i_v.getVarName();
        this.keepDims = keepDims;
        this.defineDimensions(dimensions);
    }

    public BaseIndexAccumulation(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, boolean keepDims, int[] dimensions) {
        super(sameDiff, new Object[]{dimensions});
        if (i_v != null) {
            this.dimensions = dimensions;
            this.f().validateDifferentialFunctionsameDiff(i_v);
            this.f().validateDifferentialFunctionsameDiff(i_v2);
            this.xVertexId = i_v.getVarName();
            this.yVertexId = i_v2.getVarName();
            sameDiff.addArgsFor(new SDVariable[]{i_v, i_v2}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
            if (Shape.isPlaceholderShape(i_v2.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v2.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.keepDims = keepDims;
        this.defineDimensions(dimensions);
    }

    public BaseIndexAccumulation() {
    }

    public BaseIndexAccumulation(INDArray x, int[] dimensions) {
        this(x, null, dimensions);
    }

    public BaseIndexAccumulation(INDArray x, INDArray z, int[] dimensions) {
        super(x, z);
        this.defineDimensions(dimensions);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null) {
            return Collections.emptyList();
        }
        long[] reducedShape = Shape.getReducedShape(this.x.shape(), this.dimensions, this.keepDims);
        return Collections.singletonList(LongShapeDescriptor.fromShape(reducedShape, DataType.LONG));
    }

    @Override
    public Op.Type opType() {
        return Op.Type.INDEXREDUCE;
    }

    @Override
    public boolean validateDataTypes() {
        if (this.z() != null) {
            Preconditions.checkArgument((this.z().dataType() == DataType.LONG ? 1 : 0) != 0, (String)"IndexReduce operations require LONG output: got result array of type %s for op %s", (Object)this.z.dataType(), this.getClass());
        }
        return true;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got input %s", this.getClass(), dataTypes);
        return Collections.singletonList(DataType.LONG);
    }

    @Override
    public boolean isKeepDims() {
        return this.keepDims;
    }

    public void setKeepDims(boolean keepDims) {
        this.keepDims = keepDims;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseIndexAccumulation)) {
            return false;
        }
        BaseIndexAccumulation other = (BaseIndexAccumulation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isKeepDims() == other.isKeepDims();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseIndexAccumulation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKeepDims() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "BaseIndexAccumulation(keepDims=" + this.isKeepDims() + ")";
    }
}

