/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Tile
extends DynamicCustomOp {
    private int[] jaxis;
    private boolean is_static_reps = false;

    public Tile(SameDiff sameDiff, SDVariable i_v, int[] axis) {
        super(null, sameDiff, new SDVariable[]{i_v}, false);
        this.jaxis = axis;
        this.addArguments();
    }

    public Tile(INDArray[] inputs, INDArray[] outputs, int[] axis, boolean is_static_reps) {
        super(null, inputs, outputs);
        this.jaxis = axis;
        this.is_static_reps = is_static_reps;
        this.addArguments();
    }

    public Tile(INDArray[] inputs, INDArray[] outputs, int[] axis) {
        this(inputs, outputs, axis, false);
    }

    public Tile() {
    }

    private void addArguments() {
        this.is_static_reps = true;
        this.addIArgument(this.jaxis);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        NodeDef lastNode = TFGraphMapper.getInstance().getNodeWithNameFromGraph(graph, nodeDef.getInput(nodeDef.getInputCount() - 1));
        INDArray arr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", lastNode, graph);
        if (arr != null) {
            this.jaxis = arr.data().asInt();
            this.addArguments();
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping axisMapping = PropertyMapping.builder().onnxAttrName("axis").tfInputPosition(-1).propertyNames(new String[]{"axis"}).build();
        map.put("axis", axisMapping);
        ret.put(this.tensorflowName(), map);
        ret.put(this.onnxName(), map);
        return ret;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.inputArguments.size() == 0) {
            return Collections.emptyList();
        }
        if (this.is_static_reps) {
            return Nd4j.getExecutioner().calculateOutputShape(this);
        }
        if (this.inputArguments().length < 2) {
            return Collections.emptyList();
        }
        INDArray array = this.inputArguments()[1];
        long[] reps = new long[(int)array.length()];
        for (int e = 0; e < reps.length; ++e) {
            reps[e] = (int)array.getDouble((long)e);
        }
        if (ArrayUtil.prodLong((long[])reps) == 0L) {
            return Collections.emptyList();
        }
        return Nd4j.getExecutioner().calculateOutputShape(this);
    }

    @Override
    public String opName() {
        return "tile";
    }

    @Override
    public String onnxName() {
        return "Tile";
    }

    @Override
    public String tensorflowName() {
        return "Tile";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Collections.singletonList(this.f().tileBp(this.arg(), i_v.get(0), this.jaxis));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

