/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDynamicTransformOp
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(BaseDynamicTransformOp.class);

    public BaseDynamicTransformOp() {
    }

    public BaseDynamicTransformOp(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(null, sameDiff, args, inPlace);
    }

    public BaseDynamicTransformOp(INDArray[] inputs, INDArray[] outputs) {
        super(null, inputs, outputs);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        long[] secondArgShape;
        long[] firstArgShape;
        if (this.numInputArguments() == 2) {
            return super.calculateOutputShape();
        }
        SDVariable[] args = this.args();
        if (args.length < 2) {
            if (args[0] == null || this.inputArguments.isEmpty() && args[0].getShape() == null) {
                return Collections.emptyList();
            }
            DataType dtypeX = !this.inputArguments.isEmpty() ? ((INDArray)this.inputArguments.get(0)).dataType() : args[0].dataType();
            long[] shape = !this.inputArguments.isEmpty() ? ((INDArray)this.inputArguments.get(0)).shape() : args[0].getShape();
            return Collections.singletonList(LongShapeDescriptor.fromShape(shape, dtypeX));
        }
        if (this.inputArguments.size() == 2 && this.inputArguments.get(0) != null && this.inputArguments.get(1) != null) {
            firstArgShape = ((INDArray)this.inputArguments.get(0)).shape();
            secondArgShape = ((INDArray)this.inputArguments.get(1)).shape();
        } else {
            firstArgShape = args[0].getShape();
            secondArgShape = args[1].getShape();
        }
        if (args[0] == null || args[0].getShape() == null) {
            return Collections.emptyList();
        }
        if (args[1] == null || args[1].getShape() == null) {
            return Collections.emptyList();
        }
        DataType dtypeX = this.inputArguments.size() > 0 ? ((INDArray)this.inputArguments.get(0)).dataType() : args[0].dataType();
        DataType dtypeY = this.inputArguments.size() > 1 ? ((INDArray)this.inputArguments.get(1)).dataType() : args[1].dataType();
        DataType dtypeZ = Shape.pickPairwiseDataType(dtypeX, dtypeY);
        if (Arrays.equals(firstArgShape, secondArgShape)) {
            try {
                return Collections.singletonList(LongShapeDescriptor.fromShape(firstArgShape, dtypeZ));
            }
            catch (Throwable e) {
                throw new RuntimeException("calculateOutputShape() failed for [" + this.opName() + "]", e);
            }
        }
        Shape.assertBroadcastable(firstArgShape, secondArgShape, this.getClass());
        long[] outShape = Shape.broadcastOutputShape(firstArgShape, secondArgShape);
        return Collections.singletonList(LongShapeDescriptor.fromShape(outShape, dtypeZ));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly 2 input datatypes for %s, got input %s", this.getClass(), dataTypes);
        DataType z = Shape.pickPairwiseDataType(dataTypes.get(0), dataTypes.get(1));
        return Collections.singletonList(z);
    }
}

